/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.psi.FtlStringLiteral;
import com.intellij.freemarker.psi.directives.FtlFileReferenceDirective;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class FtlFileReferencesInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FtlFileReferencesInspection.$$$reportNull$$$0(0);
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof FtlStringLiteral && !((FtlStringLiteral)element).isOptionalTemplateReference()) {
                    ArrayList<FileReference> fileRefs = new ArrayList<FileReference>();
                    for (PsiReference reference : element.getReferences()) {
                        if (reference instanceof FtlFileReferenceDirective.FtlCustomFileReference && reference.resolve() != null) {
                            return;
                        }
                        if (!(reference instanceof FileReference)) continue;
                        fileRefs.add((FileReference)reference);
                    }
                    if (!fileRefs.isEmpty()) {
                        boolean resolvesCorrectly = true;
                        PsiDirectory parent = null;
                        ResolveResult[] results = ((FileReference)fileRefs.get(fileRefs.size() - 1)).multiResolve(false);
                        for (ResolveResult result : results) {
                            PsiElement psiElement = result.getElement();
                            if (psiElement instanceof FtlFile) {
                                PsiDirectory currentParent = ((PsiFile)psiElement).getContainingDirectory();
                                if (parent == null) {
                                    parent = currentParent;
                                    continue;
                                }
                                if (parent.equals(currentParent)) continue;
                                resolvesCorrectly = false;
                                break;
                            }
                            resolvesCorrectly = false;
                            break;
                        }
                        if (!resolvesCorrectly || parent == null) {
                            for (FileReference reference : fileRefs) {
                                if (reference.resolve() != null) continue;
                                holder.registerProblem((PsiReference)reference);
                                return;
                            }
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/inspections/FtlFileReferencesInspection$1", "visitElement"));
            }
        };
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = FreeMarkerBundle.message("freemarker.inspections.group", new Object[0]);
        if (string == null) {
            FtlFileReferencesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            FtlFileReferencesInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "FtlFileReferencesInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/inspections/FtlFileReferencesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/inspections/FtlFileReferencesInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

