/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlNameValuePair;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlAssignDirective;
import com.intellij.freemarker.psi.directives.FtlLoopVariableType;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlCompositeType;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FtlAssignmentDeclaration
extends RenameableFakePsiElement
implements FtlVariable {
    private final FtlNameValuePair myNameValuePair;
    private String myName;
    private final FtlExpression myNamespaceExpression;

    public FtlAssignmentDeclaration(FtlNameValuePair declaration) {
        super((PsiElement)declaration.getContainingFile());
        this.myNameValuePair = declaration;
        this.myName = StringUtil.notNullize((String)this.myNameValuePair.getName());
        this.myNamespaceExpression = this.getDirective().getNamespaceExpression();
    }

    public FtlAssignDirective getDirective() {
        return (FtlAssignDirective)this.myNameValuePair.getParent();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        FtlNameValuePair ftlNameValuePair = this.myNameValuePair;
        if (ftlNameValuePair == null) {
            FtlAssignmentDeclaration.$$$reportNull$$$0(0);
        }
        return ftlNameValuePair;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            FtlAssignmentDeclaration.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)super.getUseScope()), (FileType[])new FileType[]{FtlFileType.INSTANCE});
        if (globalSearchScope == null) {
            FtlAssignmentDeclaration.$$$reportNull$$$0(2);
        }
        return globalSearchScope;
    }

    @Override
    public FtlType getType() {
        if (!this.myNameValuePair.isAssignment()) {
            return FtlPsiType.wrap((PsiType)PsiType.getJavaLangString((PsiManager)this.getManager(), (GlobalSearchScope)this.getResolveScope()));
        }
        PsiElement valueElement = this.myNameValuePair.getValueElement();
        if (valueElement instanceof FtlExpression) {
            FtlType type = ((FtlExpression)valueElement).getType();
            List<FtlType> ftlTypes = FtlPsiUtil.getAllTypeComponents(type, FtlType.class);
            List filtered = ContainerUtil.findAll(ftlTypes, ftlType -> !(ftlType instanceof FtlCallableType) && !(ftlType instanceof FtlLoopVariableType));
            if (!filtered.isEmpty()) {
                if (filtered.size() == 1) {
                    return (FtlType)filtered.get(0);
                }
                return new FtlCompositeType(filtered.toArray(new FtlType[0]));
            }
            return type;
        }
        return null;
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (!(another instanceof FtlAssignmentDeclaration)) {
            return false;
        }
        FtlAssignmentDeclaration other = (FtlAssignmentDeclaration)another;
        String name = this.getName();
        return this.getTemplateFile().equals(other.getTemplateFile()) && name.equals(other.getName());
    }

    @NotNull
    private PsiFile getTemplateFile() {
        FtlFile ftlFile = this.getDirective().getTemplateFile();
        if (ftlFile != null) {
            FtlFile ftlFile2 = ftlFile;
            if (ftlFile2 == null) {
                FtlAssignmentDeclaration.$$$reportNull$$$0(3);
            }
            return ftlFile2;
        }
        PsiFile psiFile = this.getContainingFile();
        if (psiFile == null) {
            FtlAssignmentDeclaration.$$$reportNull$$$0(4);
        }
        return psiFile;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            FtlAssignmentDeclaration.$$$reportNull$$$0(5);
        }
        this.myNameValuePair.setPairName(name);
        this.myName = StringUtil.notNullize((String)this.myNameValuePair.getName());
        return this;
    }

    public PsiElement getParent() {
        return this.myNameValuePair;
    }

    public String getTypeName() {
        return FreeMarkerBundle.message("type.name.variable", new Object[0]);
    }

    public Icon getIcon() {
        return IconManager.getInstance().getPlatformIcon(PlatformIcons.Variable);
    }

    public FtlExpression getNamespaceExpression() {
        return this.myNamespaceExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/psi/directives/FtlAssignmentDeclaration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/psi/directives/FtlAssignmentDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5 -> new IllegalArgumentException(string);
        };
    }
}

