/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.psi.FtlArgumentList;
import com.intellij.freemarker.psi.FtlCompositeElementTypes;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlInterpolation;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlXmlTag;
import com.intellij.freemarker.psi.directives.FtlAssignmentType;
import com.intellij.freemarker.psi.directives.FtlSignatureCallableType;
import com.intellij.freemarker.psi.directives.FtlSignatureDirective;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlMacroLoopVariable;
import com.intellij.freemarker.psi.variables.FtlTemplateType;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlMacro
extends FtlXmlTag
implements PsiLanguageInjectionHost {
    static final Key<Set<FtlMacro>> MACRO_STACK = Key.create((String)"MACRO_STACK");

    public FtlMacro(@NotNull ASTNode node) {
        if (node == null) {
            FtlMacro.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @NotNull
    public String getName() {
        String string = "@" + this.getDirectiveName();
        if (string == null) {
            FtlMacro.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public PsiElement getStartTagNameElement() {
        PsiElement firstChild = this.getFirstChild();
        return firstChild == null ? null : firstChild.getNextSibling();
    }

    @Override
    @Nullable
    public PsiElement getEndTagNameElement() {
        PsiElement before = this.findChildByType((IElementType)FtlElementTypes.END_MACRO_START);
        PsiElement candidate = before == null ? null : before.getNextSibling();
        return candidate != null && candidate.textMatches((CharSequence)this.getDirectiveName()) ? candidate : null;
    }

    @NlsSafe
    public String getDirectiveName() {
        PsiElement element = this.getStartTagNameElement();
        return element == null ? "" : element.getText();
    }

    @Override
    public String getDirectiveTagName() {
        return "@" + this.getDirectiveName();
    }

    @Nullable
    public FtlCallableType getMacroType() {
        PsiElement element = this.getStartTagNameElement();
        return element instanceof FtlExpression ? FtlPsiUtil.asInstanceOf(((FtlExpression)element).getType(), FtlCallableType.class) : null;
    }

    @Nullable
    public FtlSignatureDirective resolveMacro() {
        return (FtlSignatureDirective)RecursionManager.doPreventingRecursion((Object)((Object)this), (boolean)true, () -> {
            FtlCallableType type = this.getMacroType();
            return type instanceof FtlSignatureCallableType ? ((FtlSignatureCallableType)type).getDirective() : null;
        });
    }

    @Override
    public boolean needsClosing() {
        if (this.findChildByType((IElementType)FtlElementTypes.EMPTY_MACRO_END) != null) {
            return false;
        }
        return super.needsClosing();
    }

    @NotNull
    public FtlArgumentList getArgumentList() {
        FtlArgumentList ftlArgumentList = (FtlArgumentList)((Object)this.findNotNullChildByClass(FtlArgumentList.class));
        if (ftlArgumentList == null) {
            FtlMacro.$$$reportNull$$$0(2);
        }
        return ftlArgumentList;
    }

    @Override
    public String toString() {
        return FtlCompositeElementTypes.USER_DIRECTIVE.toString();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        FtlMacroLoopVariable[] loopVars;
        int lvCount;
        if (processor == null) {
            FtlMacro.$$$reportNull$$$0(3);
        }
        if (state == null) {
            FtlMacro.$$$reportNull$$$0(4);
        }
        if (place == null) {
            FtlMacro.$$$reportNull$$$0(5);
        }
        if ((lvCount = (loopVars = this.getLoopVariables()).length) > 0 && lastParent != null && lastParent.getStartOffsetInParent() >= loopVars[lvCount - 1].getStartOffsetInParent()) {
            for (FtlMacroLoopVariable variable : loopVars) {
                if (processor.execute((PsiElement)variable, state)) continue;
                return false;
            }
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    public FtlMacroLoopVariable[] getLoopVariables() {
        return (FtlMacroLoopVariable[])this.findChildrenByClass(FtlMacroLoopVariable.class);
    }

    public FtlExpression[] getAllMacroReferences() {
        return (FtlExpression[])this.findChildrenByClass(FtlExpression.class);
    }

    @Nullable
    public FtlExpression getMacroReference() {
        PsiElement element = this.getStartTagNameElement();
        return element instanceof FtlExpression ? (FtlExpression)element : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processDirectiveDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, boolean honorAssigns) {
        FtlSignatureDirective directive;
        HashSet<FtlMacro> stack = (HashSet<FtlMacro>)state.get(MACRO_STACK);
        if (!(stack != null && stack.contains((Object)this) || lastParent != null || !honorAssigns || state.get(FtlQualifiedReference.RESOLVING_MACRO) == Boolean.TRUE || (directive = this.resolveMacro()) == null || directive.getContainingFile() != this.getContainingFile() && state.get(FtlTemplateType.PROCESSING_NAMESPACE) == null)) {
            ResolveState newState = FtlAssignmentType.allowAssignments(state, FtlAssignmentType.ASSIGN);
            if (stack == null) {
                stack = new HashSet<FtlMacro>();
                newState = newState.put(MACRO_STACK, stack);
            }
            stack.add(this);
            try {
                if (!directive.processDeclarationsInside(processor, newState, null, true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                stack.remove((Object)this);
            }
        }
        return super.processDirectiveDeclarations(processor, state, lastParent, honorAssigns);
    }

    public boolean isValidHost() {
        return !ContainerUtil.exists((Object[])this.getChildren(), e -> e instanceof FtlXmlTag || e instanceof FtlInterpolation) && this.findTemplateText() != null;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            FtlMacro.$$$reportNull$$$0(6);
        }
        ASTNode templateText = this.findTemplateText();
        assert (templateText != null);
        LeafElement newText = ASTFactory.leaf((IElementType)FtlElementTypes.TEMPLATE_TEXT, (CharSequence)text);
        CodeEditUtil.setNodeGenerated((ASTNode)newText, (boolean)true);
        this.getNode().replaceChild(templateText, (ASTNode)newText);
        return this;
    }

    private ASTNode findTemplateText() {
        return this.getNode().findChildByType((IElementType)FtlElementTypes.TEMPLATE_TEXT);
    }

    @Nullable
    public TextRange getInjectionRange() {
        if (!this.isValidHost()) {
            return null;
        }
        return this.findTemplateText().getTextRange().shiftLeft(this.getTextRange().getStartOffset());
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new LiteralTextEscaper<PsiLanguageInjectionHost>((PsiLanguageInjectionHost)this){

            public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
                if (rangeInsideHost == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outChars == null) {
                    1.$$$reportNull$$$0(1);
                }
                outChars.append(rangeInsideHost.substring(this.myHost.getText()));
                return true;
            }

            public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
                if (rangeInsideHost == null) {
                    1.$$$reportNull$$$0(2);
                }
                return offsetInDecoded + rangeInsideHost.getStartOffset();
            }

            public boolean isOneLine() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rangeInsideHost";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outChars";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/freemarker/psi/directives/FtlMacro$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "decode";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getOffsetInHost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/psi/directives/FtlMacro";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/psi/directives/FtlMacro";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

