/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.python;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.python.PythonBuildFileProvider;
import com.intellij.packageChecker.util.PsiHelperUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.packaging.management.ui.PythonPackageManagerUI;
import com.jetbrains.python.packaging.management.ui.PythonPackageManagerUiExtensionsKt;
import com.jetbrains.python.packaging.requirement.PyRequirementRelation;
import com.jetbrains.python.packaging.requirementsTxt.PythonRequirementsTxtManager;
import com.jetbrains.python.packaging.utils.PyPackageCoroutine;
import com.jetbrains.python.requirements.RequirementsFile;
import com.jetbrains.python.requirements.psi.VersionOne;
import com.jetbrains.python.requirements.psi.VersionStmt;
import com.jetbrains.python.requirements.psi.Versionspec;
import com.jetbrains.python.requirements.psi.impl.NameReqImpl;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/intellij/packageChecker/python/RequirementsTxtBuildFileProvider;", "Lcom/intellij/packageChecker/python/PythonBuildFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "id", "", "getId", "()Ljava/lang/String;", "moduleScript", "Lcom/intellij/psi/PsiFile;", "module", "Lcom/intellij/openapi/module/Module;", "getRequirementsFromFile", "", "Lcom/jetbrains/python/packaging/PyRequirement;", "file", "supports", "", "updatePackageDeclaration", "", "pkg", "Lcom/intellij/packageChecker/model/Package;", "version", "intellij.packageChecker.python"})
@SourceDebugExtension(value={"SMAP\nRequirementsTxtBuildFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequirementsTxtBuildFileProvider.kt\ncom/intellij/packageChecker/python/RequirementsTxtBuildFileProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n295#2,2:72\n*S KotlinDebug\n*F\n+ 1 RequirementsTxtBuildFileProvider.kt\ncom/intellij/packageChecker/python/RequirementsTxtBuildFileProvider\n*L\n58#1:72,2\n*E\n"})
public final class RequirementsTxtBuildFileProvider
extends PythonBuildFileProvider {
    @NotNull
    private final String id;

    public RequirementsTxtBuildFileProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.id = "python-requirements";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public PsiFile moduleScript(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Sdk sdk = PySdkExtKt.getPythonSdk((Module)module);
        if (sdk == null) {
            return null;
        }
        Sdk sdk2 = sdk;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PythonRequirementsTxtManager requirementsTxtManager = PythonRequirementsTxtManager.Companion.getInstance(project, sdk2);
        VirtualFile virtualFile = requirementsTxtManager.getDependenciesFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        return (PsiFile)ReadAction.compute(() -> RequirementsTxtBuildFileProvider.moduleScript$lambda$0(module, virtualFile2));
    }

    @Override
    @NotNull
    public List<PyRequirement> getRequirementsFromFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Sdk sdk = (Sdk)ActionsKt.runReadAction(() -> RequirementsTxtBuildFileProvider.getRequirementsFromFile$lambda$1(file));
        if (sdk == null) {
            return CollectionsKt.emptyList();
        }
        Sdk sdk2 = sdk;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PythonRequirementsTxtManager requirementsTxtManager = PythonRequirementsTxtManager.Companion.getInstance(project, sdk2);
        List list = requirementsTxtManager.getDependencies();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public boolean supports(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getName(), (Object)"requirements.txt");
    }

    @Override
    public void updatePackageDeclaration(@NotNull PsiFile file, @NotNull Package pkg, @NotNull String version) {
        Object v1;
        Sdk sdk;
        block6: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            if (!(file instanceof RequirementsFile)) {
                return;
            }
            Sdk sdk2 = (Sdk)ActionsKt.runReadAction(() -> RequirementsTxtBuildFileProvider.updatePackageDeclaration$lambda$2(file));
            if (sdk2 == null) {
                return;
            }
            sdk = sdk2;
            Iterable $this$firstOrNull$iv = this.declaredDependencies(file);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PackageDeclaration it = (PackageDeclaration)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getPkg(), (Object)pkg)) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        PackageDeclaration packageDeclaration = v1;
        PsiElement psiElement = packageDeclaration != null ? packageDeclaration.getPsiElement() : null;
        NameReqImpl nameReqImpl = psiElement instanceof NameReqImpl ? (NameReqImpl)psiElement : null;
        if (nameReqImpl == null) {
            return;
        }
        NameReqImpl declaration = nameReqImpl;
        Versionspec versionspec = declaration.getVersionspec();
        if (versionspec == null) {
            return;
        }
        Versionspec packageVersionDeclaration = versionspec;
        List list = packageVersionDeclaration.getVersionOneList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getVersionOneList(...)");
        VersionOne versionOne = (VersionOne)CollectionsKt.first((List)list);
        if (versionOne == null || (versionOne = versionOne.getVersionStmt()) == null) {
            return;
        }
        VersionOne versionStatement = versionOne;
        ApplicationManager.getApplication().runWriteAction(() -> RequirementsTxtBuildFileProvider.updatePackageDeclaration$lambda$4(version, this, (VersionStmt)versionStatement));
        PyPackageCoroutine.Companion.launch$default((PyPackageCoroutine.Companion)PyPackageCoroutine.Companion, (Project)this.getProject(), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(pkg, version, this, sdk, null){
            Object L$0;
            int label;
            final /* synthetic */ Package $pkg;
            final /* synthetic */ String $version;
            final /* synthetic */ RequirementsTxtBuildFileProvider this$0;
            final /* synthetic */ Sdk $sdk;
            {
                this.$pkg = $pkg;
                this.$version = $version;
                this.this$0 = $receiver;
                this.$sdk = $sdk;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        PyRequirement pyRequirement = PyRequirementsKt.pyRequirement((String)this.$pkg.getName(), (PyRequirementRelation)PyRequirementRelation.EQ, (String)this.$version);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)pyRequirement);
                        this.label = 1;
                        Object object2 = PythonPackageManagerUiExtensionsKt.installPyRequirementsBackground$default((PythonPackageManagerUI)PythonPackageManagerUI.Companion.forSdk$default((PythonPackageManagerUI.Companion)PythonPackageManagerUI.Companion, (Project)this.this$0.getProject(), (Sdk)this.$sdk, null, (int)4, null), (List)CollectionsKt.listOf((Object)pyRequirement), null, (Continuation)((Continuation)this), (int)2, null);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        PyRequirement pyRequirement = (PyRequirement)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private static final PsiFile moduleScript$lambda$0(Module $module, VirtualFile $virtualFile) {
        return PsiManager.getInstance((Project)$module.getProject()).findFile($virtualFile);
    }

    private static final Sdk getRequirementsFromFile$lambda$1(PsiFile $file) {
        return PythonSdkUtil.findPythonSdk((PsiElement)((PsiElement)$file));
    }

    private static final Sdk updatePackageDeclaration$lambda$2(PsiFile $file) {
        return PythonSdkUtil.findPythonSdk((PsiElement)((PsiElement)$file));
    }

    private static final void updatePackageDeclaration$lambda$4(String $version, RequirementsTxtBuildFileProvider this$0, VersionStmt $versionStatement) {
        PsiElement psiElement = PsiHelperUtil.INSTANCE.makePsiElementFromText($version, this$0.getProject());
        if (psiElement == null) {
            return;
        }
        PsiElement newVersionStatement = psiElement;
        $versionStatement.replace(newVersionStatement);
    }
}

