/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.references;

import com.intellij.beanValidation.constants.BvAnnoConstants;
import com.intellij.beanValidation.references.BvMessageReference;
import com.intellij.beanValidation.utils.BVUtils;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.UastInjectionHostReferenceProvider;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.text.PlaceholderTextRanges;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UExpression;

final class BvMessageReferenceContributor
extends PsiReferenceContributor {
    BvMessageReferenceContributor() {
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            BvMessageReferenceContributor.$$$reportNull$$$0(0);
        }
        PsiJavaElementPattern.Capture defaultValuePattern = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiLiteral().inside((ElementPattern)new ObjectPattern.Capture(PsiAnnotationMethod.class).with((PatternCondition)new PatternCondition<PsiAnnotationMethod>("beanvalidation.default.message"){

            public boolean accepts(@NotNull PsiAnnotationMethod annotationMethod, ProcessingContext context) {
                if (annotationMethod == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!"message".equals(annotationMethod.getName())) {
                    return false;
                }
                PsiElement annotationClass = annotationMethod.getParent();
                if (!(annotationClass instanceof PsiClass)) {
                    return false;
                }
                return BvAnnoConstants.CONSTRAINT.isAnnotated((PsiClass)annotationClass, 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationMethod", "com/intellij/beanValidation/references/BvMessageReferenceContributor$1", "accepts"));
            }
        }));
        registrar.registerReferenceProvider((ElementPattern)defaultValuePattern, new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                PsiReference[] psiReferenceArray = BvMessageReferenceContributor.createPlaceholderReferences(element);
                if (psiReferenceArray == null) {
                    2.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/beanValidation/references/BvMessageReferenceContributor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/beanValidation/references/BvMessageReferenceContributor$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        });
        ObjectPattern annotationPattern = new ObjectPattern.Capture(UAnnotation.class).with((PatternCondition)new PatternCondition<UAnnotation>("beanvalidation.message"){

            public boolean accepts(@NotNull UAnnotation annotation, ProcessingContext context) {
                String qualifiedName;
                if (annotation == null) {
                    3.$$$reportNull$$$0(0);
                }
                return (qualifiedName = annotation.getQualifiedName()) != null && BVUtils.isBeanValidationAnnotation(annotation);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/beanValidation/references/BvMessageReferenceContributor$3", "accepts"));
            }
        });
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)UastPatterns.injectionHostUExpression().annotationParam("message", (ElementPattern)annotationPattern), (UastReferenceProvider)new UastInjectionHostReferenceProvider(){

            public boolean acceptsTarget(@NotNull PsiElement target) {
                if (target == null) {
                    4.$$$reportNull$$$0(0);
                }
                return PropertyReferenceBase.isPropertyPsi((PsiElement)target);
            }

            public PsiReference @NotNull [] getReferencesForInjectionHost(@NotNull UExpression uExpression, @NotNull PsiLanguageInjectionHost host, @NotNull ProcessingContext context) {
                if (uExpression == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (host == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (context == null) {
                    4.$$$reportNull$$$0(3);
                }
                PsiReference[] psiReferenceArray = BvMessageReferenceContributor.createPlaceholderReferences((PsiElement)host);
                if (psiReferenceArray == null) {
                    4.$$$reportNull$$$0(4);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "uExpression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "host";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/beanValidation/references/BvMessageReferenceContributor$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/beanValidation/references/BvMessageReferenceContributor$4";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesForInjectionHost";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "acceptsTarget";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesForInjectionHost";
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 4 -> new IllegalStateException(string);
                };
            }
        }, (double)100.0);
    }

    private static PsiReference[] createPlaceholderReferences(@NotNull PsiElement element) {
        String text;
        Set textRanges;
        if (element == null) {
            BvMessageReferenceContributor.$$$reportNull$$$0(1);
        }
        if ((textRanges = PlaceholderTextRanges.getPlaceholderRanges((String)(text = element.getText()), (String)"{", (String)"}")).isEmpty()) {
            return PsiReference.EMPTY_ARRAY;
        }
        SmartList references = new SmartList();
        for (TextRange textRange : textRanges) {
            String key = textRange.substring(text);
            references.add((Object)new BvMessageReference(key, element, textRange));
        }
        return (PsiReference[])references.toArray((Object[])PsiReference.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/beanValidation/references/BvMessageReferenceContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createPlaceholderReferences";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

