/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.inspection;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.handler.LombokGetterHandler;
import de.plushnikov.intellij.plugin.inspection.LombokGetterOrSetterMayBeUsedInspection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class LombokGetterMayBeUsedInspection
extends LombokGetterOrSetterMayBeUsedInspection {
    @Override
    @NotNull
    protected String getTagName() {
        return "return";
    }

    @Override
    @NotNull
    protected String getJavaDocMethodMarkup() {
        return "GETTER";
    }

    @Override
    @NotNull
    @NonNls
    protected String getAnnotationName() {
        return "lombok.Getter";
    }

    @Override
    @NotNull
    @Nls
    protected String getFieldErrorMessage(String fieldName) {
        String string = LombokBundle.message("inspection.lombok.getter.may.be.used.display.field.message", fieldName);
        if (string == null) {
            LombokGetterMayBeUsedInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    @Nls
    protected String getClassErrorMessage(String className) {
        String string = LombokBundle.message("inspection.lombok.getter.may.be.used.display.class.message", className);
        if (string == null) {
            LombokGetterMayBeUsedInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean processMethod(@NotNull PsiMethod method, @NotNull List<Pair<PsiField, PsiMethod>> instanceCandidates, @NotNull List<Pair<PsiField, PsiMethod>> staticCandidates) {
        if (method == null) {
            LombokGetterMayBeUsedInspection.$$$reportNull$$$0(2);
        }
        if (instanceCandidates == null) {
            LombokGetterMayBeUsedInspection.$$$reportNull$$$0(3);
        }
        if (staticCandidates == null) {
            LombokGetterMayBeUsedInspection.$$$reportNull$$$0(4);
        }
        PsiType returnType = method.getReturnType();
        if (!method.hasModifierProperty("public") || method.isConstructor() || method.hasParameters() || method.getThrowsTypes().length != 0 || method.hasModifierProperty("final") || method.hasModifierProperty("abstract") || method.hasModifierProperty("synchronized") || method.hasModifierProperty("native") || method.hasModifierProperty("strictfp") || method.getAnnotations().length != 0 || PsiTypes.voidType().equals((Object)returnType) || returnType == null || returnType.getAnnotations().length != 0 || !method.isWritable()) {
            return false;
        }
        String methodName = method.getName();
        boolean isBooleanType = PsiTypes.booleanType().equals((Object)returnType);
        if (isBooleanType ? !methodName.startsWith("is") : !methodName.startsWith("get")) {
            return false;
        }
        PsiField field = LombokGetterHandler.findFieldIfMethodIsSimpleGetter(method);
        if (field == null) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            staticCandidates.add((Pair<PsiField, PsiMethod>)Pair.pair((Object)field, (Object)method));
        } else {
            instanceCandidates.add((Pair<PsiField, PsiMethod>)Pair.pair((Object)field, (Object)method));
        }
        return true;
    }

    @Override
    @NotNull
    @Nls
    protected String getFixName(String text) {
        String string = LombokBundle.message("inspection.lombok.getter.may.be.used.display.fix.name", text);
        if (string == null) {
            LombokGetterMayBeUsedInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    @Nls
    protected String getFixFamilyName() {
        String string = LombokBundle.message("inspection.lombok.getter.may.be.used.display.fix.family.name", new Object[0]);
        if (string == null) {
            LombokGetterMayBeUsedInspection.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/inspection/LombokGetterMayBeUsedInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceCandidates";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldErrorMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassErrorMessage";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/inspection/LombokGetterMayBeUsedInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

