/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.lombokconfig;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumDataDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import de.plushnikov.intellij.plugin.language.LombokConfigFileType;
import de.plushnikov.intellij.plugin.language.psi.LombokConfigCleaner;
import de.plushnikov.intellij.plugin.language.psi.LombokConfigFile;
import de.plushnikov.intellij.plugin.language.psi.LombokConfigProperty;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigValue;
import de.plushnikov.intellij.plugin.lombokconfig.LombokConfigChangeListener;
import de.plushnikov.intellij.plugin.lombokconfig.LombokConfigUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class LombokConfigIndex
extends FileBasedIndexExtension<ConfigKey, ConfigValue> {
    @NotNull
    private static final String LOMBOK_CONFIG_FILE_NAME = "lombok.config";
    @NonNls
    public static final ID<ConfigKey, ConfigValue> NAME = ID.create((String)"LombokConfigIndex");

    @NotNull
    public ID<ConfigKey, ConfigValue> getName() {
        ID<ConfigKey, ConfigValue> iD = NAME;
        if (iD == null) {
            LombokConfigIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<ConfigKey, ConfigValue, FileContent> getIndexer() {
        return new DataIndexer<ConfigKey, ConfigValue, FileContent>(){

            @NotNull
            public Map<ConfigKey, ConfigValue> map(@NotNull FileContent inputData) {
                String canonicalPath;
                VirtualFile directoryFile;
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (null != (directoryFile = inputData.getFile().getParent()) && null != (canonicalPath = PathUtil.toSystemIndependentName((String)directoryFile.getCanonicalPath()))) {
                    PsiFile psiFile = inputData.getPsiFile();
                    Map<ConfigKey, ConfigValue> map = LombokConfigIndex.createConfigMapResult(psiFile);
                    if (map == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map;
                }
                Map<ConfigKey, ConfigValue> map = Collections.emptyMap();
                if (map == null) {
                    1.$$$reportNull$$$0(2);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "de/plushnikov/intellij/plugin/lombokconfig/LombokConfigIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "de/plushnikov/intellij/plugin/lombokconfig/LombokConfigIndex$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static @Unmodifiable @NotNull Map<ConfigKey, ConfigValue> createConfigMapResult(@Nullable PsiFile psiFile) {
        if (!(psiFile instanceof LombokConfigFile)) {
            Map<ConfigKey, ConfigValue> map = Map.of();
            if (map == null) {
                LombokConfigIndex.$$$reportNull$$$0(1);
            }
            return map;
        }
        Map<String, String> configValues = LombokConfigIndex.extractValues((LombokConfigFile)psiFile);
        boolean stopBubblingValue = Boolean.parseBoolean(configValues.get(StringUtil.toLowerCase((String)ConfigKey.CONFIG_STOP_BUBBLING.getConfigKey())));
        Map map = ContainerUtil.map2Map((Object[])ConfigKey.values(), key -> Pair.create((Object)key, (Object)new ConfigValue((String)configValues.get(StringUtil.toLowerCase((String)key.getConfigKey())), stopBubblingValue)));
        if (map == null) {
            LombokConfigIndex.$$$reportNull$$$0(2);
        }
        return map;
    }

    private static Map<String, String> extractValues(LombokConfigFile configFile) {
        LombokConfigProperty[] configProperties;
        LombokConfigCleaner[] configCleaners;
        HashMap<String, String> result = new HashMap<String, String>();
        for (LombokConfigCleaner configCleaner : configCleaners = LombokConfigUtil.getLombokConfigCleaners(configFile)) {
            String key = StringUtil.toLowerCase((String)configCleaner.getKey());
            ConfigKey configKey = ConfigKey.fromConfigStringKey(key);
            if (null == configKey) continue;
            result.put(key, configKey.getConfigDefaultValue());
        }
        for (LombokConfigProperty configProperty : configProperties = LombokConfigUtil.getLombokConfigProperties(configFile)) {
            String key = StringUtil.toLowerCase((String)configProperty.getKey());
            String value = StringUtil.notNullize((String)configProperty.getValue());
            String sign = configProperty.getSign();
            if (null == sign) {
                result.put(key, value);
                continue;
            }
            String previousValue = result.getOrDefault(key, "");
            String combinedValue = previousValue + sign + value + ";";
            result.put(key, combinedValue);
        }
        return result;
    }

    @NotNull
    public KeyDescriptor<ConfigKey> getKeyDescriptor() {
        return new EnumDataDescriptor(ConfigKey.class);
    }

    @NotNull
    public DataExternalizer<ConfigValue> getValueExternalizer() {
        return new DataExternalizer<ConfigValue>(){

            public void save(@NotNull DataOutput out, ConfigValue configValue) throws IOException {
                if (out == null) {
                    2.$$$reportNull$$$0(0);
                }
                boolean isNotNullValue = configValue.getValue() != null;
                out.writeBoolean(isNotNullValue);
                if (isNotNullValue) {
                    EnumeratorStringDescriptor.INSTANCE.save(out, configValue.getValue());
                }
                out.writeBoolean(configValue.isStopBubbling());
            }

            public ConfigValue read(@NotNull DataInput in) throws IOException {
                boolean isNotNullValue;
                if (in == null) {
                    2.$$$reportNull$$$0(1);
                }
                return new ConfigValue((isNotNullValue = in.readBoolean()) ? EnumeratorStringDescriptor.INSTANCE.read(in) : null, in.readBoolean());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "de/plushnikov/intellij/plugin/lombokconfig/LombokConfigIndex$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{LombokConfigFileType.INSTANCE});
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 15;
    }

    @Nullable
    static ConfigValue readPropertyWithAlternativeResolver(@NotNull ConfigKey key, @NotNull Project project, @NotNull VirtualFile directory) {
        VirtualFile configVirtualFile;
        if (key == null) {
            LombokConfigIndex.$$$reportNull$$$0(3);
        }
        if (project == null) {
            LombokConfigIndex.$$$reportNull$$$0(4);
        }
        if (directory == null) {
            LombokConfigIndex.$$$reportNull$$$0(5);
        }
        if ((configVirtualFile = directory.findFileByRelativePath(LOMBOK_CONFIG_FILE_NAME)) == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(configVirtualFile);
        if (document == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return null;
        }
        Map values = (Map)CachedValuesManager.getCachedValue((PsiElement)psiFile, () -> {
            Map<ConfigKey, ConfigValue> result = LombokConfigIndex.createConfigMapResult(psiFile);
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{LombokConfigChangeListener.CONFIG_CHANGE_TRACKER});
        });
        return (ConfigValue)values.get((Object)key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/lombokconfig/LombokConfigIndex";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigMapResult";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/lombokconfig/LombokConfigIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readPropertyWithAlternativeResolver";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

