/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.LombokProcessorManager;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.processor.field.GetterFieldProcessor;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import de.plushnikov.intellij.plugin.util.PsiMethodUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GetterProcessor
extends AbstractClassProcessor {
    public GetterProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.Getter");
    }

    private static GetterFieldProcessor getGetterFieldProcessor() {
        return LombokProcessorManager.getInstance().getGetterFieldProcessor();
    }

    @Override
    protected boolean possibleToGenerateElementNamed(@NotNull String nameHint, @NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (nameHint == null) {
            GetterProcessor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            GetterProcessor.$$$reportNull$$$0(1);
        }
        if (psiAnnotation == null) {
            GetterProcessor.$$$reportNull$$$0(2);
        }
        AccessorsInfo.AccessorsValues classAccessorsValues = AccessorsInfo.getAccessorsValues(psiClass);
        for (PsiField psiField : PsiClassUtil.collectClassFieldsIntern(psiClass)) {
            AccessorsInfo accessorsInfo;
            if (!nameHint.equals(LombokUtils.getGetterName(psiField, accessorsInfo = AccessorsInfo.buildFor(psiField, classAccessorsValues)))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Collection<String> getNamesOfPossibleGeneratedElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            GetterProcessor.$$$reportNull$$$0(3);
        }
        if (psiAnnotation == null) {
            GetterProcessor.$$$reportNull$$$0(4);
        }
        ArrayList<String> result = new ArrayList<String>();
        AccessorsInfo.AccessorsValues classAccessorsValues = AccessorsInfo.getAccessorsValues(psiClass);
        for (PsiField psiField : PsiClassUtil.collectClassFieldsIntern(psiClass)) {
            AccessorsInfo accessorsInfo = AccessorsInfo.buildFor(psiField, classAccessorsValues);
            result.add(LombokUtils.getGetterName(psiField, accessorsInfo));
        }
        return result;
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            GetterProcessor.$$$reportNull$$$0(5);
        }
        if (psiClass == null) {
            GetterProcessor.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            GetterProcessor.$$$reportNull$$$0(7);
        }
        GetterProcessor.validateAnnotationOnRightType(psiClass, builder);
        GetterProcessor.validateVisibility(psiAnnotation, builder);
        if (builder.deepValidation() && PsiAnnotationUtil.getBooleanAnnotationValue(psiAnnotation, "lazy", false)) {
            builder.addWarningMessage("inspection.message.lazy.not.supported.for.getter.on.type", new Object[0]);
        }
        return builder.success();
    }

    private static void validateAnnotationOnRightType(@NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiClass == null) {
            GetterProcessor.$$$reportNull$$$0(8);
        }
        if (builder == null) {
            GetterProcessor.$$$reportNull$$$0(9);
        }
        if (psiClass.isAnnotationType() || psiClass.isInterface() || psiClass.isRecord()) {
            builder.addErrorMessage("inspection.message.getter.only.supported.on.class.enum.or.field.type", new Object[0]);
            builder.markFailed();
        }
    }

    private static void validateVisibility(@NotNull PsiAnnotation psiAnnotation, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            GetterProcessor.$$$reportNull$$$0(10);
        }
        if (builder == null) {
            GetterProcessor.$$$reportNull$$$0(11);
        }
        if (null == LombokProcessorUtil.getMethodModifier(psiAnnotation)) {
            builder.markFailed();
        }
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target, @Nullable String nameHint) {
        String methodVisibility;
        if (psiClass == null) {
            GetterProcessor.$$$reportNull$$$0(12);
        }
        if (psiAnnotation == null) {
            GetterProcessor.$$$reportNull$$$0(13);
        }
        if (target == null) {
            GetterProcessor.$$$reportNull$$$0(14);
        }
        if ((methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation)) != null) {
            target.addAll(this.createFieldGetters(psiClass, methodVisibility, nameHint));
        }
    }

    @NotNull
    public Collection<PsiMethod> createFieldGetters(@NotNull PsiClass psiClass, @NotNull String methodModifier, @Nullable String nameHint) {
        if (psiClass == null) {
            GetterProcessor.$$$reportNull$$$0(15);
        }
        if (methodModifier == null) {
            GetterProcessor.$$$reportNull$$$0(16);
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        Collection<PsiField> getterFields = this.filterGetterFields(psiClass);
        for (PsiField getterField : getterFields) {
            ContainerUtil.addIfNotNull(result, (Object)GetterFieldProcessor.createGetterMethod(getterField, psiClass, methodModifier, nameHint));
        }
        ArrayList<PsiMethod> arrayList = result;
        if (arrayList == null) {
            GetterProcessor.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    private Collection<PsiField> filterGetterFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            GetterProcessor.$$$reportNull$$$0(18);
        }
        ArrayList<PsiField> getterFields = new ArrayList<PsiField>();
        Collection<PsiMethod> classMethods = this.filterToleratedElements(PsiClassUtil.collectClassMethodsIntern(psiClass));
        GetterFieldProcessor fieldProcessor = GetterProcessor.getGetterFieldProcessor();
        AccessorsInfo.AccessorsValues classAccessorsValues = AccessorsInfo.getAccessorsValues(psiClass);
        for (PsiField psiField : psiClass.getFields()) {
            if (!GetterProcessor.shouldCreateGetter(psiField, fieldProcessor, classAccessorsValues, classMethods)) continue;
            getterFields.add(psiField);
        }
        ArrayList<PsiField> arrayList = getterFields;
        if (arrayList == null) {
            GetterProcessor.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    private static boolean shouldCreateGetter(@NotNull PsiField psiField, @NotNull GetterFieldProcessor fieldProcessor, @NotNull AccessorsInfo.AccessorsValues classAccessorsValues, @NotNull Collection<PsiMethod> classMethods) {
        if (psiField == null) {
            GetterProcessor.$$$reportNull$$$0(20);
        }
        if (fieldProcessor == null) {
            GetterProcessor.$$$reportNull$$$0(21);
        }
        if (classAccessorsValues == null) {
            GetterProcessor.$$$reportNull$$$0(22);
        }
        if (classMethods == null) {
            GetterProcessor.$$$reportNull$$$0(23);
        }
        boolean createGetter = true;
        PsiModifierList modifierList = psiField.getModifierList();
        if (null != modifierList) {
            createGetter = !modifierList.hasModifierProperty("static");
            createGetter &= PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiField, fieldProcessor.getSupportedAnnotationClasses());
            createGetter &= !psiField.getName().startsWith("$");
            AccessorsInfo accessorsInfo = AccessorsInfo.buildFor(psiField, classAccessorsValues);
            createGetter &= accessorsInfo.acceptsFieldName(psiField.getName());
            Collection<String> methodNames = LombokUtils.toAllGetterNames(accessorsInfo, psiField.getName(), PsiTypes.booleanType().equals((Object)psiField.getType()));
            for (String methodName : methodNames) {
                createGetter &= !PsiMethodUtil.hasSimilarMethod(classMethods, methodName, 0);
            }
        }
        return createGetter;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        PsiClass containingClass;
        if (psiField == null) {
            GetterProcessor.$$$reportNull$$$0(24);
        }
        if (psiAnnotation == null) {
            GetterProcessor.$$$reportNull$$$0(25);
        }
        if (null != (containingClass = psiField.getContainingClass())) {
            Collection<PsiMethod> classMethods = this.filterToleratedElements(PsiClassUtil.collectClassMethodsIntern(containingClass));
            AccessorsInfo.AccessorsValues classAccessorsValues = AccessorsInfo.getAccessorsValues(containingClass);
            GetterFieldProcessor fieldProcessor = GetterProcessor.getGetterFieldProcessor();
            if (GetterProcessor.shouldCreateGetter(psiField, fieldProcessor, classAccessorsValues, classMethods)) {
                return LombokPsiElementUsage.READ;
            }
        }
        return LombokPsiElementUsage.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameHint";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 13: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodModifier";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/GetterProcessor";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldProcessor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classAccessorsValues";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/GetterProcessor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldGetters";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "filterGetterFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "possibleToGenerateElementNamed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNamesOfPossibleGeneratedElements";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validateAnnotationOnRightType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validateVisibility";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createFieldGetters";
                break;
            }
            case 17: 
            case 19: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "filterGetterFields";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateGetter";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 19 -> new IllegalStateException(string);
        };
    }
}

