/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.LombokProcessorManager;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.processor.field.SetterFieldProcessor;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import de.plushnikov.intellij.plugin.util.PsiMethodUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SetterProcessor
extends AbstractClassProcessor {
    public SetterProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.Setter");
    }

    private static SetterFieldProcessor getSetterFieldProcessor() {
        return LombokProcessorManager.getInstance().getSetterFieldProcessor();
    }

    @Override
    protected boolean possibleToGenerateElementNamed(@NotNull String nameHint, @NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (nameHint == null) {
            SetterProcessor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            SetterProcessor.$$$reportNull$$$0(1);
        }
        if (psiAnnotation == null) {
            SetterProcessor.$$$reportNull$$$0(2);
        }
        AccessorsInfo.AccessorsValues classAccessorsValues = AccessorsInfo.getAccessorsValues(psiClass);
        for (PsiField psiField : PsiClassUtil.collectClassFieldsIntern(psiClass)) {
            AccessorsInfo accessorsInfo;
            if (!nameHint.equals(LombokUtils.getSetterName(psiField, accessorsInfo = AccessorsInfo.buildFor(psiField, classAccessorsValues)))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Collection<String> getNamesOfPossibleGeneratedElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            SetterProcessor.$$$reportNull$$$0(3);
        }
        if (psiAnnotation == null) {
            SetterProcessor.$$$reportNull$$$0(4);
        }
        ArrayList<String> result = new ArrayList<String>();
        AccessorsInfo.AccessorsValues classAccessorsValues = AccessorsInfo.getAccessorsValues(psiClass);
        for (PsiField psiField : PsiClassUtil.collectClassFieldsIntern(psiClass)) {
            AccessorsInfo accessorsInfo = AccessorsInfo.buildFor(psiField, classAccessorsValues);
            result.add(LombokUtils.getSetterName(psiField, accessorsInfo));
        }
        return result;
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            SetterProcessor.$$$reportNull$$$0(5);
        }
        if (psiClass == null) {
            SetterProcessor.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            SetterProcessor.$$$reportNull$$$0(7);
        }
        SetterProcessor.validateAnnotationOnRightType(psiAnnotation, psiClass, builder);
        SetterProcessor.validateVisibility(psiAnnotation, builder);
        return builder.success();
    }

    private static void validateAnnotationOnRightType(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            SetterProcessor.$$$reportNull$$$0(8);
        }
        if (psiClass == null) {
            SetterProcessor.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            SetterProcessor.$$$reportNull$$$0(10);
        }
        if (psiClass.isAnnotationType() || psiClass.isInterface() || psiClass.isEnum() || psiClass.isRecord()) {
            builder.addErrorMessage("inspection.message.setter.only.supported.on.class.or.field.type", new Object[0]);
            builder.markFailed();
        }
    }

    private static void validateVisibility(@NotNull PsiAnnotation psiAnnotation, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            SetterProcessor.$$$reportNull$$$0(11);
        }
        if (builder == null) {
            SetterProcessor.$$$reportNull$$$0(12);
        }
        if (null == LombokProcessorUtil.getMethodModifier(psiAnnotation)) {
            builder.markFailed();
        }
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target, @Nullable String nameHint) {
        String methodVisibility;
        if (psiClass == null) {
            SetterProcessor.$$$reportNull$$$0(13);
        }
        if (psiAnnotation == null) {
            SetterProcessor.$$$reportNull$$$0(14);
        }
        if (target == null) {
            SetterProcessor.$$$reportNull$$$0(15);
        }
        if ((methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation)) != null) {
            target.addAll(this.createFieldSetters(psiClass, methodVisibility, nameHint));
        }
    }

    public Collection<PsiMethod> createFieldSetters(@NotNull PsiClass psiClass, @NotNull String methodModifier, @Nullable String nameHint) {
        if (psiClass == null) {
            SetterProcessor.$$$reportNull$$$0(16);
        }
        if (methodModifier == null) {
            SetterProcessor.$$$reportNull$$$0(17);
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        Collection<PsiField> setterFields = this.filterSetterFields(psiClass);
        for (PsiField setterField : setterFields) {
            ContainerUtil.addIfNotNull(result, (Object)SetterFieldProcessor.createSetterMethod(setterField, psiClass, methodModifier, nameHint));
        }
        return result;
    }

    @NotNull
    private Collection<PsiField> filterSetterFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SetterProcessor.$$$reportNull$$$0(18);
        }
        Collection<PsiMethod> classMethods = this.filterToleratedElements(PsiClassUtil.collectClassMethodsIntern(psiClass));
        SetterFieldProcessor fieldProcessor = SetterProcessor.getSetterFieldProcessor();
        ArrayList<PsiField> setterFields = new ArrayList<PsiField>();
        for (PsiField psiField : psiClass.getFields()) {
            if (!SetterProcessor.shouldGenerateSetter(psiField, fieldProcessor, classMethods)) continue;
            setterFields.add(psiField);
        }
        ArrayList<PsiField> arrayList = setterFields;
        if (arrayList == null) {
            SetterProcessor.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    private static boolean shouldGenerateSetter(@NotNull PsiField psiField, @NotNull SetterFieldProcessor fieldProcessor, @NotNull Collection<PsiMethod> classMethods) {
        if (psiField == null) {
            SetterProcessor.$$$reportNull$$$0(20);
        }
        if (fieldProcessor == null) {
            SetterProcessor.$$$reportNull$$$0(21);
        }
        if (classMethods == null) {
            SetterProcessor.$$$reportNull$$$0(22);
        }
        boolean createSetter = true;
        PsiModifierList modifierList = psiField.getModifierList();
        if (null != modifierList) {
            createSetter = !modifierList.hasModifierProperty("final");
            createSetter &= !modifierList.hasModifierProperty("static");
            createSetter &= PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiField, fieldProcessor.getSupportedAnnotationClasses());
            createSetter &= !psiField.getName().startsWith("$");
            AccessorsInfo accessorsInfo = AccessorsInfo.buildFor(psiField);
            createSetter &= accessorsInfo.acceptsFieldName(psiField.getName());
            Collection<String> methodNames = LombokUtils.toAllSetterNames(accessorsInfo, psiField.getName(), PsiTypes.booleanType().equals((Object)psiField.getType()));
            for (String methodName : methodNames) {
                createSetter &= !PsiMethodUtil.hasSimilarMethod(classMethods, methodName, 1);
            }
        }
        return createSetter;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        PsiClass containingClass;
        if (psiField == null) {
            SetterProcessor.$$$reportNull$$$0(23);
        }
        if (psiAnnotation == null) {
            SetterProcessor.$$$reportNull$$$0(24);
        }
        if (null != (containingClass = psiField.getContainingClass())) {
            Collection<PsiMethod> classMethods = this.filterToleratedElements(PsiClassUtil.collectClassMethodsIntern(containingClass));
            SetterFieldProcessor fieldProcessor = SetterProcessor.getSetterFieldProcessor();
            if (SetterProcessor.shouldGenerateSetter(psiField, fieldProcessor, classMethods)) {
                return LombokPsiElementUsage.WRITE;
            }
        }
        return LombokPsiElementUsage.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameHint";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodModifier";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/SetterProcessor";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldProcessor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/SetterProcessor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSetterFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "possibleToGenerateElementNamed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNamesOfPossibleGeneratedElements";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validateAnnotationOnRightType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "validateVisibility";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createFieldSetters";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "filterSetterFields";
                break;
            }
            case 19: {
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "shouldGenerateSetter";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 19 -> new IllegalStateException(string);
        };
    }
}

