/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.handler;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.light.LightTypeParameterBuilder;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.problem.LombokProblem;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.handler.BuilderHandler;
import de.plushnikov.intellij.plugin.processor.handler.BuilderInfo;
import de.plushnikov.intellij.plugin.psi.LombokLightClassBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.quickfix.AddAbstractAndStaticModifiersFix;
import de.plushnikov.intellij.plugin.quickfix.PsiQuickFixFactory;
import de.plushnikov.intellij.plugin.thirdparty.LombokAddNullAnnotations;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class SuperBuilderHandler
extends BuilderHandler {
    private static final String SELF_METHOD = "self";
    private static final String TO_BUILDER_METHOD_NAME = "toBuilder";
    private static final String FILL_VALUES_METHOD_NAME = "$fillValuesFrom";
    private static final String STATIC_FILL_VALUES_METHOD_NAME = "$fillValuesFromInstanceIntoBuilder";
    private static final String INSTANCE_VARIABLE_NAME = "instance";
    private static final String BUILDER_VARIABLE_NAME = "b";

    @Override
    protected boolean validateBuilderConstructor(@NotNull PsiClass psiClass, Collection<BuilderInfo> builderInfos, @NotNull ProblemSink problemSink) {
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(0);
        }
        if (problemSink == null) {
            SuperBuilderHandler.$$$reportNull$$$0(1);
        }
        return true;
    }

    @Override
    boolean validateAnnotationOnRightType(@NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            SuperBuilderHandler.$$$reportNull$$$0(3);
        }
        if (SuperBuilderHandler.isNotSupported(psiClass) || psiClass.isRecord()) {
            builder.addErrorMessage("inspection.message.superbuilder.can.be.used.on.classes.only", new Object[0]);
            return false;
        }
        if (!psiClass.hasModifierProperty("static") && psiClass.getParent() instanceof PsiClass) {
            builder.addErrorMessage("inspection.message.superbuilder.can.be.used.on.static.inner.classes.only", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean validateExistingBuilderClass(@NotNull String builderClassName, @NotNull PsiClass psiClass, @NotNull ProblemSink problemSink) {
        Optional<PsiClass> existingInnerBuilderClassOptional;
        if (builderClassName == null) {
            SuperBuilderHandler.$$$reportNull$$$0(4);
        }
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(5);
        }
        if (problemSink == null) {
            SuperBuilderHandler.$$$reportNull$$$0(6);
        }
        if ((existingInnerBuilderClassOptional = PsiClassUtil.getInnerClassInternByName(psiClass, builderClassName)).isPresent()) {
            PsiClass existingInnerBuilderClass = existingInnerBuilderClassOptional.get();
            if (!this.validateInvalidAnnotationsOnBuilderClass(existingInnerBuilderClass, problemSink)) {
                return false;
            }
            boolean isStatic = existingInnerBuilderClass.hasModifierProperty("static");
            boolean isAbstract = existingInnerBuilderClass.hasModifierProperty("abstract");
            if (!isStatic || !isAbstract) {
                LombokProblem problem = problemSink.addErrorMessage("inspection.message.existing.builder.must.be.abstract.static.inner.class", new Object[0]);
                if (!isAbstract && !isStatic) {
                    problem.withLocalQuickFixes(() -> LocalQuickFix.from((ModCommandAction)new AddAbstractAndStaticModifiersFix(existingInnerBuilderClass)));
                } else if (!isAbstract) {
                    problem.withLocalQuickFixes(() -> PsiQuickFixFactory.createModifierListFix((PsiModifierListOwner)existingInnerBuilderClass, "abstract", true, false));
                } else {
                    problem.withLocalQuickFixes(() -> PsiQuickFixFactory.createModifierListFix((PsiModifierListOwner)existingInnerBuilderClass, "static", true, false));
                }
                return false;
            }
        }
        return true;
    }

    @NotNull
    public String getBuilderClassName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(7);
        }
        String string = SuperBuilderHandler.getBuilderClassName(psiClass, psiClass.getName());
        if (string == null) {
            SuperBuilderHandler.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getBuilderImplClassName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(9);
        }
        String string = this.getBuilderClassName(psiClass) + "Impl";
        if (string == null) {
            SuperBuilderHandler.$$$reportNull$$$0(10);
        }
        return string;
    }

    public Optional<PsiMethod> createBuilderBasedConstructor(@NotNull PsiClass psiClass, @NotNull PsiClass builderClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiClassType psiTypeBaseWithGenerics) {
        String className;
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(11);
        }
        if (builderClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(12);
        }
        if (psiAnnotation == null) {
            SuperBuilderHandler.$$$reportNull$$$0(13);
        }
        if (psiTypeBaseWithGenerics == null) {
            SuperBuilderHandler.$$$reportNull$$$0(14);
        }
        if (null == (className = psiClass.getName())) {
            return Optional.empty();
        }
        Collection<PsiMethod> existedConstructors = PsiClassUtil.collectClassConstructorIntern(psiClass);
        if (ContainerUtil.exists(existedConstructors, psiMethod -> psiMethod.getParameterList().getParametersCount() == 1)) {
            return Optional.empty();
        }
        LombokLightMethodBuilder constructorBuilderBased = new LombokLightMethodBuilder(psiClass.getManager(), className).withConstructor(true).withContainingClass(psiClass).withNavigationElement((PsiElement)psiAnnotation).withModifier("protected").withParameter(BUILDER_VARIABLE_NAME, (PsiType)psiTypeBaseWithGenerics);
        List<BuilderInfo> builderInfos = this.createBuilderInfos(psiClass, psiAnnotation, builderClass);
        String buildMethodPrepare = builderInfos.stream().map(BuilderInfo::renderSuperBuilderConstruction).collect(Collectors.joining());
        PsiClass superClass = psiClass.getSuperClass();
        Object codeBlock = null != superClass && !"Object".equals(superClass.getName()) ? "super(b);\n" + buildMethodPrepare : buildMethodPrepare;
        constructorBuilderBased.withBodyText((String)codeBlock);
        return Optional.of(constructorBuilderBased);
    }

    public Optional<PsiMethod> createBuilderMethodIfNecessary(@NotNull PsiClass containingClass, @NotNull PsiClass builderBaseClass, @NotNull PsiClass builderImplClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiClassType psiTypeBaseWithGenerics) {
        String builderMethodName;
        if (containingClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(15);
        }
        if (builderBaseClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(16);
        }
        if (builderImplClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(17);
        }
        if (psiAnnotation == null) {
            SuperBuilderHandler.$$$reportNull$$$0(18);
        }
        if (psiTypeBaseWithGenerics == null) {
            SuperBuilderHandler.$$$reportNull$$$0(19);
        }
        if ((builderMethodName = this.getBuilderMethodName(psiAnnotation)).isEmpty() || SuperBuilderHandler.hasStaticMethod(containingClass, builderMethodName)) {
            return Optional.empty();
        }
        LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(containingClass.getManager(), builderMethodName).withMethodReturnType((PsiType)psiTypeBaseWithGenerics).withContainingClass(containingClass).withNavigationElement((PsiElement)psiAnnotation).withModifier("public").withModifier("static");
        this.addTypeParameters(containingClass, null, methodBuilder);
        String blockText = String.format("return new %s();", PsiClassUtil.getTypeWithGenerics(builderImplClass).getCanonicalText(false));
        methodBuilder.withBodyText(blockText);
        LombokAddNullAnnotations.createRelevantNonNullAnnotation(containingClass, methodBuilder);
        return Optional.of(methodBuilder);
    }

    public static Optional<PsiMethod> createToBuilderMethodIfNecessary(@NotNull PsiClass containingClass, @NotNull PsiClass builderBaseClass, @NotNull PsiClass builderImplClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiClassType psiTypeBaseWithGenerics) {
        if (containingClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(20);
        }
        if (builderBaseClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(21);
        }
        if (builderImplClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(22);
        }
        if (psiAnnotation == null) {
            SuperBuilderHandler.$$$reportNull$$$0(23);
        }
        if (psiTypeBaseWithGenerics == null) {
            SuperBuilderHandler.$$$reportNull$$$0(24);
        }
        if (!SuperBuilderHandler.shouldGenerateToBuilderMethods(psiAnnotation) || SuperBuilderHandler.hasMethod(containingClass, TO_BUILDER_METHOD_NAME, 0)) {
            return Optional.empty();
        }
        LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(containingClass.getManager(), TO_BUILDER_METHOD_NAME).withMethodReturnType((PsiType)psiTypeBaseWithGenerics).withContainingClass(containingClass).withNavigationElement((PsiElement)psiAnnotation).withModifier("public");
        String blockText = String.format("return new %s().%s(this);", PsiClassUtil.getTypeWithGenerics(builderImplClass).getCanonicalText(false), FILL_VALUES_METHOD_NAME);
        methodBuilder.withBodyText(blockText);
        LombokAddNullAnnotations.createRelevantNonNullAnnotation(containingClass, methodBuilder);
        return Optional.of(methodBuilder);
    }

    private static boolean shouldGenerateToBuilderMethods(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            SuperBuilderHandler.$$$reportNull$$$0(25);
        }
        return PsiAnnotationUtil.getBooleanAnnotationValue(psiAnnotation, TO_BUILDER_METHOD_NAME, false);
    }

    private static String selectNonClashingNameFor(String classGenericName, Collection<String> typeParamStrings) {
        Object result = classGenericName;
        if (typeParamStrings.contains(classGenericName)) {
            int counter = 2;
            while (typeParamStrings.contains(result = classGenericName + counter++)) {
            }
        }
        return result;
    }

    @NotNull
    public PsiClass createBuilderBaseClass(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        PsiClass parentBuilderClass;
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(26);
        }
        if (psiAnnotation == null) {
            SuperBuilderHandler.$$$reportNull$$$0(27);
        }
        String builderClassName = this.getBuilderClassName(psiClass);
        String builderClassQualifiedName = psiClass.getQualifiedName() + "." + builderClassName;
        LombokLightClassBuilder baseClassBuilder = new LombokLightClassBuilder((PsiElement)psiClass, builderClassName, builderClassQualifiedName).withContainingClass(psiClass).withNavigationElement((PsiElement)psiAnnotation).withParameterTypes(psiClass.getTypeParameterList()).withModifier("public").withModifier("static").withModifier("abstract");
        List typeParamNames = ContainerUtil.map((Object[])psiClass.getTypeParameters(), PsiQualifiedNamedElement::getName);
        LightTypeParameterBuilder c = new LightTypeParameterBuilder(SuperBuilderHandler.selectNonClashingNameFor("C", typeParamNames), (PsiTypeParameterListOwner)baseClassBuilder, 0);
        c.getExtendsList().addReference(PsiClassUtil.getTypeWithGenerics(psiClass));
        baseClassBuilder.withParameterType((PsiTypeParameter)c);
        LightTypeParameterBuilder b = new LightTypeParameterBuilder(SuperBuilderHandler.selectNonClashingNameFor("B", typeParamNames), (PsiTypeParameterListOwner)baseClassBuilder, 1);
        baseClassBuilder.withParameterType((PsiTypeParameter)b);
        b.getExtendsList().addReference(PsiClassUtil.getTypeWithGenerics((PsiClass)baseClassBuilder));
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
        PsiClassType bType = factory.createType((PsiClass)b);
        PsiClassType cType = factory.createType((PsiClass)c);
        PsiClass superClass = psiClass.getSuperClass();
        if (null != superClass && !"Object".equals(superClass.getName()) && null != (parentBuilderClass = superClass.findInnerClassByName(this.getBuilderClassName(superClass), false))) {
            PsiType[] explicitTypes = (PsiType[])Stream.concat(Stream.of(psiClass.getExtendsListTypes()).map(PsiClassType::getParameters).flatMap(Stream::of), Stream.of(cType, bType)).toArray(PsiType[]::new);
            PsiClassType extendsType = SuperBuilderHandler.getTypeWithSpecificTypeParameters(parentBuilderClass, explicitTypes);
            baseClassBuilder.withExtends(extendsType);
        }
        baseClassBuilder.withFieldSupplier(thisPsiClass -> {
            List<BuilderInfo> builderInfos = this.createBuilderInfos(psiClass, psiAnnotation, (PsiClass)thisPsiClass);
            SuperBuilderHandler.initBuilderInfosBuilderClassType(builderInfos, bType);
            return builderInfos.stream().map(BuilderInfo::renderBuilderFields).flatMap(Collection::stream).collect(Collectors.toList());
        });
        baseClassBuilder.withMethodSupplier(thisPsiClass -> {
            List<BuilderInfo> builderInfos = this.createBuilderInfos(psiClass, psiAnnotation, (PsiClass)thisPsiClass);
            SuperBuilderHandler.initBuilderInfosBuilderClassType(builderInfos, bType);
            return this.addAllMethodsForBaseBuilderClass(psiClass, psiAnnotation, (PsiClass)thisPsiClass, builderInfos, bType, cType);
        });
        LombokLightClassBuilder lombokLightClassBuilder = baseClassBuilder;
        if (lombokLightClassBuilder == null) {
            SuperBuilderHandler.$$$reportNull$$$0(28);
        }
        return lombokLightClassBuilder;
    }

    @NotNull
    private List<BuilderInfo> createBuilderInfos(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass baseClassBuilder) {
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(29);
        }
        if (psiAnnotation == null) {
            SuperBuilderHandler.$$$reportNull$$$0(30);
        }
        if (baseClassBuilder == null) {
            SuperBuilderHandler.$$$reportNull$$$0(31);
        }
        List<BuilderInfo> builderInfos = this.createBuilderInfos(psiAnnotation, psiClass, null, baseClassBuilder);
        for (BuilderInfo builderInfo : builderInfos) {
            builderInfo.withBuilderChainResult("self()").withInstanceVariableName(INSTANCE_VARIABLE_NAME);
        }
        List<BuilderInfo> list = builderInfos;
        if (list == null) {
            SuperBuilderHandler.$$$reportNull$$$0(32);
        }
        return list;
    }

    private static void initBuilderInfosBuilderClassType(@NotNull List<BuilderInfo> builderInfos, @NotNull PsiClassType bType) {
        if (builderInfos == null) {
            SuperBuilderHandler.$$$reportNull$$$0(33);
        }
        if (bType == null) {
            SuperBuilderHandler.$$$reportNull$$$0(34);
        }
        for (BuilderInfo builderInfo : builderInfos) {
            builderInfo.withBuilderClassType(bType);
        }
    }

    public Collection<PsiMethod> createAllMethodsOfBaseBuilder(@NotNull PsiClass psiParentClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiBuilderClass) {
        PsiTypeParameter cTypeClass;
        PsiTypeParameter bTypeClass;
        PsiTypeParameter[] typeParameters;
        if (psiParentClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(35);
        }
        if (psiAnnotation == null) {
            SuperBuilderHandler.$$$reportNull$$$0(36);
        }
        if (psiBuilderClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(37);
        }
        if ((typeParameters = psiBuilderClass.getTypeParameters()).length >= 2) {
            bTypeClass = typeParameters[typeParameters.length - 1];
            cTypeClass = typeParameters[typeParameters.length - 2];
        } else {
            bTypeClass = new LightTypeParameterBuilder("B", (PsiTypeParameterListOwner)psiBuilderClass, 1);
            cTypeClass = new LightTypeParameterBuilder("C", (PsiTypeParameterListOwner)psiBuilderClass, 0);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiParentClass.getProject());
        PsiClassType bType = factory.createType((PsiClass)bTypeClass);
        PsiClassType cType = factory.createType((PsiClass)cTypeClass);
        List<BuilderInfo> builderInfos = this.createBuilderInfos(psiParentClass, psiAnnotation, psiBuilderClass);
        SuperBuilderHandler.initBuilderInfosBuilderClassType(builderInfos, bType);
        return this.addAllMethodsForBaseBuilderClass(psiParentClass, psiAnnotation, psiBuilderClass, builderInfos, bType, cType);
    }

    private Collection<PsiMethod> addAllMethodsForBaseBuilderClass(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass baseClassBuilder, List<BuilderInfo> builderInfos, @NotNull PsiClassType bType, @NotNull PsiClassType cType) {
        String buildMethodName;
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(38);
        }
        if (psiAnnotation == null) {
            SuperBuilderHandler.$$$reportNull$$$0(39);
        }
        if (baseClassBuilder == null) {
            SuperBuilderHandler.$$$reportNull$$$0(40);
        }
        if (bType == null) {
            SuperBuilderHandler.$$$reportNull$$$0(41);
        }
        if (cType == null) {
            SuperBuilderHandler.$$$reportNull$$$0(42);
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        Map<String, List<List<PsiType>>> existingMethodsWithParameters = BuilderHandler.getExistingMethodsWithParameterTypes(baseClassBuilder);
        for (BuilderInfo info : builderInfos) {
            result.addAll(info.renderBuilderMethods(existingMethodsWithParameters));
        }
        PsiManager psiManager = psiClass.getManager();
        boolean forceCallSuper = PsiClassUtil.hasSuperClass(psiClass);
        if (SuperBuilderHandler.shouldGenerateToBuilderMethods(psiAnnotation)) {
            LombokLightMethodBuilder methodBuilder;
            builderInfos.forEach(BuilderInfo::withObtainVia);
            PsiClassType typeWithGenerics = PsiClassUtil.getTypeWithGenerics(psiClass);
            PsiClassType typeWithWildcardsForSuperBuilderTypeParameters = SuperBuilderHandler.getTypeWithWildcardsForSuperBuilderTypeParameters(baseClassBuilder);
            if (!BuilderHandler.matchMethodWithParams(existingMethodsWithParameters, STATIC_FILL_VALUES_METHOD_NAME, List.of(typeWithGenerics, typeWithWildcardsForSuperBuilderTypeParameters))) {
                methodBuilder = new LombokLightMethodBuilder(psiManager, STATIC_FILL_VALUES_METHOD_NAME).withMethodReturnType((PsiType)PsiTypes.voidType()).withParameter(INSTANCE_VARIABLE_NAME, (PsiType)typeWithGenerics).withParameter(BUILDER_VARIABLE_NAME, (PsiType)typeWithWildcardsForSuperBuilderTypeParameters).withContainingClass(baseClassBuilder).withNavigationElement((PsiElement)psiClass).withModifier("private").withModifier("static");
                this.addTypeParameters(psiClass, null, methodBuilder);
                String toBuilderMethodCalls = builderInfos.stream().map(BuilderInfo::renderToBuilderCallWithoutPrependLogic).collect(Collectors.joining(";b.", "b.", ";\n"));
                methodBuilder.withBodyText(toBuilderMethodCalls);
                result.add((PsiMethod)methodBuilder);
            }
            if (!BuilderHandler.matchMethodWithParams(existingMethodsWithParameters, FILL_VALUES_METHOD_NAME, List.of(cType))) {
                methodBuilder = new LombokLightMethodBuilder(psiManager, FILL_VALUES_METHOD_NAME).withMethodReturnType((PsiType)bType).withParameter(INSTANCE_VARIABLE_NAME, (PsiType)cType).withContainingClass(baseClassBuilder).withNavigationElement((PsiElement)psiClass).withModifier("protected");
                String callSuperCode = "super.$fillValuesFrom(instance);\n";
                String codeBlockText = String.format("%s%s.%s(%s, this);\nreturn self();", forceCallSuper ? "super.$fillValuesFrom(instance);\n" : "", baseClassBuilder.getQualifiedName(), STATIC_FILL_VALUES_METHOD_NAME, INSTANCE_VARIABLE_NAME);
                methodBuilder.withBodyText(codeBlockText);
                result.add((PsiMethod)methodBuilder);
            }
        }
        if (!BuilderHandler.matchMethodWithParams(existingMethodsWithParameters, SELF_METHOD, Collections.emptyList())) {
            LombokLightMethodBuilder selfMethod = new LombokLightMethodBuilder(psiManager, SELF_METHOD).withMethodReturnType((PsiType)bType).withContainingClass(baseClassBuilder).withNavigationElement((PsiElement)psiClass).withModifier("abstract").withModifier("protected");
            result.add((PsiMethod)selfMethod);
        }
        if (!BuilderHandler.matchMethodWithParams(existingMethodsWithParameters, buildMethodName = SuperBuilderHandler.getBuildMethodName(psiAnnotation), Collections.emptyList())) {
            LombokLightMethodBuilder buildMethod = new LombokLightMethodBuilder(psiManager, buildMethodName).withMethodReturnType((PsiType)cType).withContainingClass(baseClassBuilder).withNavigationElement((PsiElement)psiClass).withModifier("abstract").withModifier("public");
            LombokAddNullAnnotations.createRelevantNonNullAnnotation(psiClass, buildMethod);
            result.add((PsiMethod)buildMethod);
        }
        if (!BuilderHandler.matchMethodWithParams(existingMethodsWithParameters, "toString", Collections.emptyList())) {
            result.add(this.createToStringMethod(psiAnnotation, baseClassBuilder, forceCallSuper));
        }
        return result;
    }

    @NotNull
    public PsiClass createBuilderImplClass(@NotNull PsiClass psiClass, @NotNull PsiClass psiBaseBuilderClass, PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(43);
        }
        if (psiBaseBuilderClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(44);
        }
        String builderClassName = this.getBuilderImplClassName(psiClass);
        String builderClassQualifiedName = psiClass.getQualifiedName() + "." + builderClassName;
        LombokLightClassBuilder implClassBuilder = new LombokLightClassBuilder((PsiElement)psiClass, builderClassName, builderClassQualifiedName).withContainingClass(psiClass).withNavigationElement((PsiElement)psiAnnotation).withParameterTypes(psiClass.getTypeParameterList()).withModifier("static").withModifier("final");
        PsiClassType extendsType = SuperBuilderHandler.getTypeWithSpecificTypeParameters(psiBaseBuilderClass, new PsiType[]{PsiClassUtil.getTypeWithGenerics(psiClass), PsiClassUtil.getTypeWithGenerics((PsiClass)implClassBuilder)});
        implClassBuilder.withExtends(extendsType);
        if (SuperBuilderHandler.hasValidJacksonizedAnnotation(psiClass, null)) {
            SuperBuilderHandler.handleJacksonized(psiClass, null, psiAnnotation, implClassBuilder);
        } else {
            implClassBuilder.withModifier("private");
        }
        implClassBuilder.withMethodSupplier(thisPsiClass -> this.createAllMethodsOfImplBuilder(psiClass, psiAnnotation, (PsiClass)thisPsiClass));
        LombokLightClassBuilder lombokLightClassBuilder = implClassBuilder;
        if (lombokLightClassBuilder == null) {
            SuperBuilderHandler.$$$reportNull$$$0(45);
        }
        return lombokLightClassBuilder;
    }

    public Collection<PsiMethod> createAllMethodsOfImplBuilder(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass implBuilderClass) {
        String buildMethodName;
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(46);
        }
        if (psiAnnotation == null) {
            SuperBuilderHandler.$$$reportNull$$$0(47);
        }
        if (implBuilderClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(48);
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        Set existedMethodNames = ContainerUtil.map2Set(PsiClassUtil.collectClassMethodsIntern(implBuilderClass), PsiMethod::getName);
        String builderImplClassName = StringUtil.notNullize((String)implBuilderClass.getName());
        PsiManager psiManager = psiClass.getManager();
        LombokLightMethodBuilder privateConstructor = new LombokLightMethodBuilder(psiManager, builderImplClassName).withConstructor(true).withContainingClass(implBuilderClass).withNavigationElement((PsiElement)psiClass).withModifier("private").withBodyText("");
        result.add((PsiMethod)privateConstructor);
        if (!existedMethodNames.contains(SELF_METHOD)) {
            LombokLightMethodBuilder selfMethod = new LombokLightMethodBuilder(psiManager, SELF_METHOD).withMethodReturnType((PsiType)PsiClassUtil.getTypeWithGenerics(implBuilderClass)).withContainingClass(implBuilderClass).withNavigationElement((PsiElement)psiClass).withModifier("protected").withBodyText("return this;");
            result.add((PsiMethod)selfMethod);
        }
        if (!existedMethodNames.contains(buildMethodName = SuperBuilderHandler.getBuildMethodName(psiAnnotation))) {
            PsiType builderType = this.getReturnTypeOfBuildMethod(psiClass, null);
            PsiSubstitutor builderSubstitutor = this.getBuilderSubstitutor((PsiTypeParameterListOwner)psiClass, implBuilderClass);
            PsiType returnType = builderSubstitutor.substitute(builderType);
            LombokLightMethodBuilder buildMethod = new LombokLightMethodBuilder(psiManager, buildMethodName).withMethodReturnType(returnType).withContainingClass(implBuilderClass).withNavigationElement((PsiElement)psiClass).withModifier("public");
            String buildCodeBlockText = String.format("return new %s(this);", PsiClassUtil.getTypeWithGenerics(psiClass).getCanonicalText(false));
            buildMethod.withBodyText(buildCodeBlockText);
            LombokAddNullAnnotations.createRelevantNonNullAnnotation(psiClass, buildMethod);
            result.add((PsiMethod)buildMethod);
        }
        return result;
    }

    @NotNull
    public static PsiClassType getTypeWithWildcardsForSuperBuilderTypeParameters(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(49);
        }
        PsiWildcardType wildcardType = PsiWildcardType.createUnbounded((PsiManager)psiClass.getManager());
        return SuperBuilderHandler.getTypeWithSpecificTypeParameters(psiClass, new PsiType[]{wildcardType, wildcardType});
    }

    @NotNull
    private static PsiClassType getTypeWithSpecificTypeParameters(@NotNull PsiClass psiClass, PsiType ... psiTypes) {
        int substituteTypesCount;
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(50);
        }
        if (psiTypes == null) {
            SuperBuilderHandler.$$$reportNull$$$0(51);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
        PsiTypeParameter[] classTypeParameters = psiClass.getTypeParameters();
        if (classTypeParameters.length >= (substituteTypesCount = psiTypes.length)) {
            int i;
            PsiSubstitutor newSubstitutor = PsiSubstitutor.EMPTY;
            int fromIndex = classTypeParameters.length - substituteTypesCount;
            for (i = 0; i < fromIndex; ++i) {
                newSubstitutor = newSubstitutor.put(classTypeParameters[i], (PsiType)elementFactory.createType((PsiClass)classTypeParameters[i]));
            }
            for (i = fromIndex; i < classTypeParameters.length; ++i) {
                newSubstitutor = newSubstitutor.put(classTypeParameters[i], psiTypes[i - fromIndex]);
            }
            PsiClassType psiClassType = elementFactory.createType(psiClass, newSubstitutor);
            if (psiClassType == null) {
                SuperBuilderHandler.$$$reportNull$$$0(52);
            }
            return psiClassType;
        }
        PsiClassType psiClassType = elementFactory.createType(psiClass);
        if (psiClassType == null) {
            SuperBuilderHandler.$$$reportNull$$$0(53);
        }
        return psiClassType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10, 28, 32, 45, 52, 53 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemSink";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderClassName";
                break;
            }
            case 8: 
            case 10: 
            case 28: 
            case 32: 
            case 45: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/handler/SuperBuilderHandler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderClass";
                break;
            }
            case 13: 
            case 18: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 36: 
            case 39: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 14: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiTypeBaseWithGenerics";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderBaseClass";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderImplClass";
                break;
            }
            case 31: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClassBuilder";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderInfos";
                break;
            }
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiParentClass";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiBuilderClass";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cType";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiBaseBuilderClass";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implBuilderClass";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/handler/SuperBuilderHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderClassName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderImplClassName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilderBaseClass";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilderInfos";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilderImplClass";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeWithSpecificTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validateBuilderConstructor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validateAnnotationOnRightType";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateExistingBuilderClass";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderClassName";
                break;
            }
            case 8: 
            case 10: 
            case 28: 
            case 32: 
            case 45: 
            case 52: 
            case 53: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderImplClassName";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderBasedConstructor";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderMethodIfNecessary";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createToBuilderMethodIfNecessary";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "shouldGenerateToBuilderMethods";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderBaseClass";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderInfos";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "initBuilderInfosBuilderClassType";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createAllMethodsOfBaseBuilder";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addAllMethodsForBaseBuilderClass";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderImplClass";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createAllMethodsOfImplBuilder";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithWildcardsForSuperBuilderTypeParameters";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithSpecificTypeParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10, 28, 32, 45, 52, 53 -> new IllegalStateException(string);
        };
    }
}

