/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.util;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IncompleteDependenciesService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import de.plushnikov.intellij.plugin.processor.LombokProcessorManager;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DumbIncompleteModeUtil {
    private DumbIncompleteModeUtil() {
    }

    public static boolean isIncompleteMode(@NotNull Project project) {
        if (project == null) {
            DumbIncompleteModeUtil.$$$reportNull$$$0(0);
        }
        return Registry.is((String)"lombok.incomplete.mode.enabled", (boolean)false) && !((IncompleteDependenciesService)project.getService(IncompleteDependenciesService.class)).getState().isComplete();
    }

    public static boolean isDumbOrIncompleteMode(@NotNull PsiElement context) {
        if (context == null) {
            DumbIncompleteModeUtil.$$$reportNull$$$0(1);
        }
        Project project = context.getProject();
        return DumbIncompleteModeUtil.isDumbOrIncompleteMode(project);
    }

    public static boolean isDumbOrIncompleteMode(@NotNull Project project) {
        if (project == null) {
            DumbIncompleteModeUtil.$$$reportNull$$$0(2);
        }
        return DumbService.isDumb((Project)project) && Registry.is((String)"lombok.dumb.mode.enabled", (boolean)false) || DumbIncompleteModeUtil.isIncompleteMode(project);
    }

    @Nullable
    static PsiAnnotation findAnnotationInDumbOrIncompleteMode(@NotNull PsiModifierListOwner owner, @NotNull String annotationFQN) {
        if (owner == null) {
            DumbIncompleteModeUtil.$$$reportNull$$$0(3);
        }
        if (annotationFQN == null) {
            DumbIncompleteModeUtil.$$$reportNull$$$0(4);
        }
        for (PsiAnnotation annotation : owner.getAnnotations()) {
            if (!DumbIncompleteModeUtil.hasQualifiedNameInDumbOrIncompleteMode(annotation, annotationFQN)) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    public static String findLombokAnnotationQualifiedNameInDumbIncompleteMode(@NotNull PsiAnnotation psiAnnotation) {
        String qualifiedName;
        if (psiAnnotation == null) {
            DumbIncompleteModeUtil.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)(qualifiedName = psiAnnotation.getQualifiedName()))) {
            return null;
        }
        if (qualifiedName.startsWith("lombok")) {
            return qualifiedName;
        }
        LombokProcessorManager instance = LombokProcessorManager.getInstance();
        MultiMap<String, String> names = instance.getOurSupportedShortNames();
        Collection fullQualifiedNames = names.get((Object)qualifiedName);
        for (String fullQualifiedName : fullQualifiedNames) {
            if (!DumbIncompleteModeUtil.hasQualifiedNameInDumbOrIncompleteMode(psiAnnotation, fullQualifiedName)) continue;
            return fullQualifiedName;
        }
        return qualifiedName;
    }

    static boolean hasQualifiedNameInDumbOrIncompleteMode(PsiAnnotation annotation, @NotNull String fqn) {
        PsiJavaCodeReferenceElement referenceElement;
        if (fqn == null) {
            DumbIncompleteModeUtil.$$$reportNull$$$0(6);
        }
        if ((referenceElement = annotation.getNameReferenceElement()) == null) {
            return false;
        }
        String annotationReferenceName = referenceElement.getReferenceName();
        if (annotationReferenceName == null) {
            return false;
        }
        if (annotationReferenceName.equals(fqn) || ("java.lang." + annotationReferenceName).equals(fqn)) {
            return true;
        }
        String referenceElementText = referenceElement.getText();
        if (!StringUtil.isShortNameOf((String)fqn, (String)annotationReferenceName)) {
            return false;
        }
        if (referenceElementText != null && referenceElementText.equals(fqn)) {
            return true;
        }
        PsiFile containingFile = annotation.getContainingFile();
        if (!(containingFile instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile javaFile = (PsiJavaFile)containingFile;
        String packageName = StringUtil.getPackageName((String)fqn);
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return false;
        }
        int indexMayByOuterClass = fqn.length() - annotationReferenceName.length() - 1;
        String mayBeOuterClass = indexMayByOuterClass > 0 ? fqn.substring(0, indexMayByOuterClass) : null;
        return importList.findOnDemandImportStatement(packageName) != null || importList.findSingleClassImportStatement(fqn) != null || mayBeOuterClass != null && importList.findSingleClassImportStatement(mayBeOuterClass) != null;
    }

    public static boolean isIncompleteModeWithLombokAnnotation(@NotNull PsiElement context) {
        PsiModifierList modifierList;
        if (context == null) {
            DumbIncompleteModeUtil.$$$reportNull$$$0(7);
        }
        if (!DumbIncompleteModeUtil.isIncompleteMode(context.getProject())) {
            return false;
        }
        if (context.getLanguage() != JavaLanguage.INSTANCE) {
            return false;
        }
        if (context instanceof PsiModifierList && DumbIncompleteModeUtil.hasAnyFullyQualifiedLombokAnnotation((modifierList = (PsiModifierList)context).getAnnotations())) {
            return true;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiClass.class});
        if (psiClass == null) {
            return false;
        }
        return (Boolean)CachedValuesManager.getProjectPsiDependentCache((PsiElement)psiClass, psiElement -> {
            PsiFile patt6538$temp = psiElement.getContainingFile();
            if (!(patt6538$temp instanceof PsiJavaFile)) {
                return false;
            }
            PsiJavaFile file = (PsiJavaFile)patt6538$temp;
            if (file.getImportList() != null && ContainerUtil.exists((Object[])file.getImportList().getAllImportStatements(), statement -> DumbIncompleteModeUtil.canBeLombokImport(statement))) {
                return true;
            }
            while (psiElement != null) {
                PsiExtensibleClass extensibleClass;
                if (psiElement instanceof PsiExtensibleClass && (DumbIncompleteModeUtil.hasAnyFullyQualifiedLombokAnnotation((extensibleClass = (PsiExtensibleClass)psiElement).getAnnotations()) || ContainerUtil.exists((Iterable)extensibleClass.getOwnFields(), field -> DumbIncompleteModeUtil.hasAnyFullyQualifiedLombokAnnotation(field.getAnnotations())) || ContainerUtil.exists((Iterable)extensibleClass.getOwnMethods(), method -> DumbIncompleteModeUtil.hasAnyFullyQualifiedLombokAnnotation(method.getAnnotations())) || file.getImportList() != null && ContainerUtil.exists((Object[])file.getImportList().getAllImportStatements(), statement -> DumbIncompleteModeUtil.canBeLombokImport(statement)))) {
                    return true;
                }
                psiElement = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
            }
            return false;
        });
    }

    private static boolean canBeLombokImport(@NotNull PsiImportStatementBase statement) {
        PsiJavaCodeReferenceElement reference;
        if (statement == null) {
            DumbIncompleteModeUtil.$$$reportNull$$$0(8);
        }
        return (reference = statement.getImportReference()) != null && reference.getText().startsWith("lombok");
    }

    private static boolean hasAnyFullyQualifiedLombokAnnotation(PsiAnnotation @NotNull [] annotations) {
        if (annotations == null) {
            DumbIncompleteModeUtil.$$$reportNull$$$0(9);
        }
        return ContainerUtil.exists((Object[])annotations, annotation -> {
            if (annotation == null) {
                return false;
            }
            String qualifiedName = annotation.getText();
            if (qualifiedName == null) {
                return false;
            }
            return qualifiedName.startsWith("@lombok.");
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/util/DumbIncompleteModeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isIncompleteMode";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isDumbOrIncompleteMode";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findAnnotationInDumbOrIncompleteMode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findLombokAnnotationQualifiedNameInDumbIncompleteMode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hasQualifiedNameInDumbOrIncompleteMode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isIncompleteModeWithLombokAnnotation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeLombokImport";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "hasAnyFullyQualifiedLombokAnnotation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

