/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.util.UriTemplateParser;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.constants.RSAnnotations;
import com.intellij.ws.rest.inspections.AbstractRestJavaInspection;
import com.intellij.ws.rest.inspections.fixes.AnnotateElementWithPathParamFix;
import com.intellij.ws.rest.inspections.fixes.CreateFieldWithPathParamFix;
import com.intellij.ws.rest.inspections.fixes.CreateMethodParamWithPathParamFix;
import com.intellij.ws.rest.utils.RSUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PathAnnotationInspection
extends AbstractRestJavaInspection {
    private static final String QS_RESTEASY_REACTIVE = "io.quarkus:quarkus-resteasy-reactive";

    @Override
    protected void checkMethod(@NotNull PsiMethod psiMethod, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (psiMethod == null) {
            PathAnnotationInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PathAnnotationInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            PathAnnotationInspection.$$$reportNull$$$0(2);
        }
        if (PathAnnotationInspection.hasResteasyReactive(module)) {
            return;
        }
        PathAnnotationInspection.checkPathSyntax((PsiTypeParameterListOwner)psiMethod, holder, JavaeeType.discover((Module)module, (JavaeeClass)RSAnnotations.PATH));
    }

    @Override
    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            PathAnnotationInspection.$$$reportNull$$$0(3);
        }
        PathAnnotationInspection.checkPathSyntax((PsiTypeParameterListOwner)aClass, holder, JavaeeType.discover((Module)module, (JavaeeClass)RSAnnotations.PATH));
        super.checkClass(aClass, holder, module);
    }

    private static void checkPathSyntax(@NotNull PsiTypeParameterListOwner c, @NotNull ProblemsHolder problemsHolder, @NotNull JavaeeType javaeeType) {
        PsiAnnotation pathAnno;
        if (c == null) {
            PathAnnotationInspection.$$$reportNull$$$0(4);
        }
        if (problemsHolder == null) {
            PathAnnotationInspection.$$$reportNull$$$0(5);
        }
        if (javaeeType == null) {
            PathAnnotationInspection.$$$reportNull$$$0(6);
        }
        if ((pathAnno = AnnotationUtil.findAnnotation((PsiModifierListOwner)c, (String[])new String[]{RSAnnotations.PATH.fqn(javaeeType)})) != null) {
            List names;
            String path = RSUtils.getAnnotationValue(pathAnno);
            if (StringUtil.isEmpty((String)path)) {
                return;
            }
            PsiNameValuePair[] attributes = pathAnno.getParameterList().getAttributes();
            if (attributes.length != 1 || attributes[0] == null) {
                return;
            }
            PsiNameValuePair valueAttr = attributes[0];
            try {
                UriTemplateParser parser = new UriTemplateParser(path);
                names = parser.getNames();
            }
            catch (Exception e) {
                problemsHolder.registerProblem((PsiElement)valueAttr, RSBundle.message("webservices.inspections.wrong.path.annotation.value.problem", new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                return;
            }
            if (!names.isEmpty()) {
                PathAnnotationInspection.checkPathNames((PsiElement)c, names, problemsHolder, pathAnno);
            }
        }
    }

    private static void checkPathNames(PsiElement c, final List<String> names, ProblemsHolder problemsHolder, PsiAnnotation pathAnno) {
        c.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof PsiAnnotation && RSAnnotations.PATH_PARAM.isFqn(((PsiAnnotation)element).getQualifiedName())) {
                    String param = RSUtils.getAnnotationValue((PsiAnnotation)element);
                    names.remove(param);
                } else {
                    super.visitElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/rest/inspections/PathAnnotationInspection$1", "visitElement"));
            }
        });
        for (String name : names) {
            PathAnnotationInspection.selectNotUsedPathTemplate(name, pathAnno, problemsHolder);
        }
    }

    private static void selectNotUsedPathTemplate(String name, PsiAnnotation pathAnno, ProblemsHolder problemsHolder) {
        PsiNameValuePair[] attributes = pathAnno.getParameterList().getAttributes();
        if (attributes.length == 1) {
            PsiClass context;
            PsiAnnotationMemberValue value = attributes[0].getValue();
            String problemText = "{" + name + "}";
            if (value instanceof PsiLiteralExpression && value.getText().contains(problemText)) {
                int start = value.getText().indexOf(problemText);
                int end = start + problemText.length();
                PsiClass context2 = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)pathAnno, PsiClass.class);
                if (context2 != null) {
                    PsiField field = null;
                    for (PsiField psiField : context2.getFields()) {
                        if (!name.equals(psiField.getName())) continue;
                        field = psiField;
                        break;
                    }
                    PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)value, PsiMethod.class);
                    problemsHolder.registerProblem((PsiElement)value, RSBundle.message("webservices.inspections.unused.path.template", name), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new TextRange(start, end), new LocalQuickFix[]{method != null ? new CreateMethodParamWithPathParamFix(name) : (field == null ? new CreateFieldWithPathParamFix(name, context2) : new AnnotateElementWithPathParamFix(field, name))});
                }
            } else if (value instanceof PsiReferenceExpression && (context = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)pathAnno, PsiClass.class)) != null) {
                PsiField field = null;
                for (PsiField psiField : context.getFields()) {
                    if (!name.equals(psiField.getName())) continue;
                    field = psiField;
                    break;
                }
                problemsHolder.registerProblem((PsiElement)value, RSBundle.message("webservices.inspections.unused.path.template", name), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{field == null ? new CreateFieldWithPathParamFix(name, context) : new AnnotateElementWithPathParamFix(field, name)});
            }
        }
    }

    private static boolean hasResteasyReactive(@NotNull Module module) {
        if (module == null) {
            PathAnnotationInspection.$$$reportNull$$$0(7);
        }
        return ContainerUtil.exists((Object[])ModuleRootManager.getInstance((Module)module).getOrderEntries(), entry -> entry.getPresentableName().contains(QS_RESTEASY_REACTIVE));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/rest/inspections/PathAnnotationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPathSyntax";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "hasResteasyReactive";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

