/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.oas.swagger;

import com.intellij.icons.AllIcons;
import com.intellij.microservices.oas.OasExportUtilsKt;
import com.intellij.microservices.oas.OpenApiSpecification;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.inlay.UrlPathInlayAction;
import com.intellij.microservices.url.inlay.UrlPathInlayHint;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.utils.MicroservicesUsageCollector;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.swagger.core.synthetic.OasSerializationUtilsKt;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.model.jam.RSApplicationPath;
import com.intellij.ws.rest.model.jam.RSHttpMappingInfo;
import com.intellij.ws.rest.model.jam.RSJamModel;
import com.intellij.ws.rest.model.jam.RsUrlPathSpecification;
import com.intellij.ws.rest.oas.RSServerOasConvertersKt;
import com.intellij.ws.rest.oas.swagger.RSGenerateOASUrlInlayActionKt;
import com.intellij.ws.rest.providers.RSUrlTargetInfo;
import com.intellij.ws.rest.utils.RSUtils;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001b2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020 H\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006("}, d2={"Lcom/intellij/ws/rest/oas/swagger/RSGenerateOASUrlInlayAction;", "Lcom/intellij/microservices/url/inlay/UrlPathInlayAction;", "<init>", "()V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "name", "", "getName", "()Ljava/lang/String;", "actionPerformed", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "urlPathContext", "Lcom/intellij/microservices/url/references/UrlPathContext;", "mouseEvent", "Ljava/awt/event/MouseEvent;", "isAvailable", "", "urlPathInlayHint", "Lcom/intellij/microservices/url/inlay/UrlPathInlayHint;", "getOpenAPISpecifications", "", "Lcom/intellij/microservices/oas/OpenApiSpecification;", "uMethod", "Lorg/jetbrains/uast/UMethod;", "getHttpMappingInfos", "Lcom/intellij/ws/rest/model/jam/RSHttpMappingInfo;", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "getUrlTargetInfo", "Lcom/intellij/ws/rest/providers/RSUrlTargetInfo;", "info", "getMappingElement", "Lorg/jetbrains/uast/UElement;", "intellij.javaee.jax.rs"})
@SourceDebugExtension(value={"SMAP\nRSGenerateOASUrlInlayAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RSGenerateOASUrlInlayAction.kt\ncom/intellij/ws/rest/oas/swagger/RSGenerateOASUrlInlayAction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n11228#2:94\n11563#2,3:95\n1617#3,9:98\n1869#3:107\n1870#3:109\n1626#3:110\n1374#3:111\n1460#3,5:112\n774#3:117\n865#3,2:118\n1#4:108\n*S KotlinDebug\n*F\n+ 1 RSGenerateOASUrlInlayAction.kt\ncom/intellij/ws/rest/oas/swagger/RSGenerateOASUrlInlayAction\n*L\n49#1:94\n49#1:95,3\n64#1:98,9\n64#1:107\n64#1:109\n64#1:110\n78#1:111\n78#1:112,5\n81#1:117\n81#1:118,2\n64#1:108\n*E\n"})
public final class RSGenerateOASUrlInlayAction
implements UrlPathInlayAction {
    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Webreferences.Openapi;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Openapi");
        return icon;
    }

    @NotNull
    public String getName() {
        String string = RSBundle.message("action.export.openapi.draft", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull PsiFile file, @NotNull Editor editor, @NotNull UrlPathContext urlPathContext, @NotNull MouseEvent mouseEvent) {
        List list;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)urlPathContext, (String)"urlPathContext");
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        MicroservicesUsageCollector.INSTANCE.getURL_INLAY_ACTION_TRIGGERED_EVENT().log(file.getProject(), (Object)"generate_openapi");
        UElement mappingUElement = this.getMappingElement(file, editor);
        if (mappingUElement instanceof UMethod) {
            list = this.getOpenAPISpecifications((UMethod)mappingUElement);
        } else if (mappingUElement instanceof UClass) {
            void $this$mapTo$iv$iv;
            UMethod[] $this$map$iv = ((UClass)mappingUElement).getMethods();
            boolean $i$f$map = false;
            UMethod[] uMethodArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var15_14 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.getOpenAPISpecifications((UMethod)it));
            }
            list = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        } else {
            return;
        }
        List openApiSpecifications = list;
        OpenApiSpecification openApiSpecification = OasExportUtilsKt.squashOpenApiSpecifications(openApiSpecifications);
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        OasSerializationUtilsKt.exportOasDraft((OpenApiSpecification)openApiSpecification, (Project)project);
    }

    public boolean isAvailable(@NotNull PsiFile file, @NotNull UrlPathInlayHint urlPathInlayHint) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)urlPathInlayHint, (String)"urlPathInlayHint");
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
        if (!RSUtils.hasRestLibrary(module)) {
            return false;
        }
        SmartPsiElementPointer smartPsiElementPointer = urlPathInlayHint.getAttachedTo();
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)(smartPsiElementPointer != null ? smartPsiElementPointer.getElement() : null), PsiClass.class);
        if (psiClass == null) {
            return false;
        }
        PsiClass psiClass2 = psiClass;
        return RSUtils.isResourceClass(psiClass2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<OpenApiSpecification> getOpenAPISpecifications(UMethod uMethod) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getHttpMappingInfos(uMethod.getJavaPsi());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            OpenApiSpecification it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            RSHttpMappingInfo it = (RSHttpMappingInfo)element$iv$iv;
            boolean bl2 = false;
            if (RSServerOasConvertersKt.getRSOpenApiSpecification(it, this.getUrlTargetInfo(it)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<RSHttpMappingInfo> getHttpMappingInfos(PsiMethod psiMethod) {
        void $this$filterTo$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Collection destination$iv$iv;
        List list;
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)psiMethod), PsiClass.class);
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass psiClass2 = psiClass;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiMethod));
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        Project project = psiMethod.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleScope((Module)module2);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleScope(...)");
        List applicationPaths = SequencesKt.toList(RSJamModel.getApplicationPaths(project, globalSearchScope));
        if (applicationPaths.isEmpty()) {
            list = RSJamModel.getHttpMappings$default(psiClass2, null, 2, null);
        } else {
            Iterable $this$flatMap$iv = applicationPaths;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (RSApplicationPath)((Object)element$iv$iv);
                boolean bl = false;
                Iterable list$iv$iv = RSJamModel.getHttpMappings(psiClass2, (PsiClass)it.getPsiElement());
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List httpMappingInfos = list;
        Iterable $this$filter$iv = httpMappingInfos;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (RSHttpMappingInfo)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((RSHttpMappingInfo)it).getMapping().getPsiElement(), (Object)psiMethod)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final RSUrlTargetInfo getUrlTargetInfo(RSHttpMappingInfo info) {
        UrlPath urlPath = RsUrlPathSpecification.INSTANCE.parsePath(RSUtils.getResourcePath(info));
        return new RSUrlTargetInfo(UrlConstants.HTTP_SCHEMES, urlPath, info, CollectionsKt.listOf((Object)RSGenerateOASUrlInlayActionKt.access$getLOCALHOST_AUTHORITY$p()));
    }

    private final UElement getMappingElement(PsiFile file, Editor editor) {
        PsiElement psiElement = file.findElementAt(editor.getCaretModel().getOffset());
        if (psiElement == null) {
            return null;
        }
        PsiElement psiElement2 = psiElement;
        Class[] classArray = new Class[]{UMethod.class, UClass.class};
        return UastContextKt.getUastParentOfTypes$default((PsiElement)psiElement2, (Class[])classArray, (boolean)false, (int)2, null);
    }
}

