/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.providers;

import com.intellij.ide.presentation.Presentation;
import com.intellij.microservices.url.HttpUrlResolver;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolver;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.ws.rest.model.jam.RSHttpMappingInfo;
import com.intellij.ws.rest.model.jam.RSJamModel;
import com.intellij.ws.rest.model.jam.RsUrlPathSpecification;
import com.intellij.ws.rest.providers.RSHttpUrlResolver;
import com.intellij.ws.rest.providers.RSUrlTargetInfo;
import com.intellij.ws.rest.utils.RSUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(icon="com.intellij.java.ultimate.icons.JavaUltimateIcons.Web.RequestMapping", typeName="JEE RESTful WS Server")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ws/rest/providers/RSHttpUrlResolver;", "Lcom/intellij/microservices/url/HttpUrlResolver;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "resolve", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "getVariants", "Factory", "intellij.javaee.jax.rs"})
public final class RSHttpUrlResolver
extends HttpUrlResolver {
    @NotNull
    private final Project myProject;

    public RSHttpUrlResolver(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])ModuleManager.Companion.getInstance(this.myProject).getModules()), (Function1)resolve.1.INSTANCE), arg_0 -> RSHttpUrlResolver.resolve$lambda$1(request, arg_0)), arg_0 -> RSHttpUrlResolver.resolve$lambda$2(this, arg_0)));
    }

    @NotNull
    public Iterable<UrlTargetInfo> getVariants() {
        return SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])ModuleManager.Companion.getInstance(this.myProject).getModules()), (Function1)getVariants.1.INSTANCE), (Function1)((Function1)new Function1<Module, List<? extends RSHttpMappingInfo>>((Object)RSJamModel.INSTANCE){

            public final List<RSHttpMappingInfo> invoke(Module p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RSJamModel.getAllServerPathsVariants(p0);
            }
        })), arg_0 -> RSHttpUrlResolver.getVariants$lambda$3(this, arg_0)));
    }

    private static final Sequence resolve$lambda$1$lambda$0(Module $module, UrlPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return RSJamModel.resolvePaths($module, path);
    }

    private static final Sequence resolve$lambda$1(UrlResolveRequest $request, Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return SequencesKt.flatMap((Sequence)UrlPath.Companion.combinations($request.getPath()), arg_0 -> RSHttpUrlResolver.resolve$lambda$1$lambda$0(module, arg_0));
    }

    private static final RSUrlTargetInfo resolve$lambda$2(RSHttpUrlResolver this$0, RSHttpMappingInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        UrlPath urlPath = RsUrlPathSpecification.INSTANCE.parsePath(RSUtils.getResourcePath(it.getMapping()));
        return new RSUrlTargetInfo(this$0.getSupportedSchemes(), urlPath, it, null, 8, null);
    }

    private static final RSUrlTargetInfo getVariants$lambda$3(RSHttpUrlResolver this$0, RSHttpMappingInfo rsHttpMethod) {
        Intrinsics.checkNotNullParameter((Object)rsHttpMethod, (String)"rsHttpMethod");
        UrlPath urlPath = RsUrlPathSpecification.INSTANCE.parsePath(RSUtils.getResourcePath(rsHttpMethod));
        return new RSUrlTargetInfo(this$0.getSupportedSchemes(), urlPath, rsHttpMethod, null, 8, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ws/rest/providers/RSHttpUrlResolver$Factory;", "Lcom/intellij/microservices/url/UrlResolverFactory;", "<init>", "()V", "forProject", "Lcom/intellij/microservices/url/UrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javaee.jax.rs"})
    public static final class Factory
    implements UrlResolverFactory {
        @Nullable
        public UrlResolver forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return RSUtils.hasRestLibrary(project) ? (UrlResolver)new RSHttpUrlResolver(project) : null;
        }
    }
}

