/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.providers;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.ws.rest.constants.RSAnnotations;
import com.intellij.ws.rest.model.jam.httpMethods.RSCustomHttpMethod;
import com.intellij.ws.rest.utils.RSUtils;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

final class RSImplicitUsageProvider
implements ImplicitUsageProvider {
    private static final Collection<String> myImplicitClassAnnotations = Arrays.asList(RSAnnotations.APPLICATION_PATH.javax(), RSAnnotations.APPLICATION_PATH.jakarta(), RSAnnotations.PROVIDER.javax(), RSAnnotations.PROVIDER.jakarta());
    private static final Collection<String> myImplicitWriteAnnotations = Arrays.asList(RSAnnotations.CONTEXT.javax(), RSAnnotations.PATH_PARAM.javax(), RSAnnotations.CONTEXT.jakarta(), RSAnnotations.PATH_PARAM.jakarta());
    private static final Collection<String> myImplicitReadAnnotations = Arrays.asList(RSAnnotations.PATH.javax(), RSAnnotations.GET.javax(), RSAnnotations.PUT.javax(), RSAnnotations.DELETE.javax(), RSAnnotations.POST.javax(), RSAnnotations.HEAD.javax(), RSAnnotations.PATCH.javax(), RSAnnotations.OPTIONS.javax(), RSAnnotations.PATH.jakarta(), RSAnnotations.GET.jakarta(), RSAnnotations.PUT.jakarta(), RSAnnotations.DELETE.jakarta(), RSAnnotations.POST.jakarta(), RSAnnotations.HEAD.jakarta(), RSAnnotations.PATCH.jakarta(), RSAnnotations.OPTIONS.jakarta());

    RSImplicitUsageProvider() {
    }

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            RSImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            if (RSImplicitUsageProvider.isAnnotated((PsiMember)psiClass, myImplicitClassAnnotations)) {
                return true;
            }
            if (RSImplicitUsageProvider.canBeResourceClass(psiClass) && (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)RSAnnotations.PATH.javax(), (int)1) || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)RSAnnotations.PATH.jakarta(), (int)1))) {
                return true;
            }
        }
        return this.isImplicitRead(element) || this.isImplicitWrite(element);
    }

    private static boolean canBeResourceClass(PsiClass element) {
        return !element.isAnnotationType() && !element.isEnum() && !element.isRecord() && !element.isInterface();
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            RSImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiMember)) {
            return false;
        }
        if (RSImplicitUsageProvider.isAnnotated((PsiMember)element, myImplicitReadAnnotations)) {
            return true;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return false;
        }
        if (!RSUtils.hasRestLibrary(module)) {
            return false;
        }
        return MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiMember)element), RSCustomHttpMethod.getMetaAnnotations(module));
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            RSImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        return element instanceof PsiMember && RSImplicitUsageProvider.isAnnotated((PsiMember)element, myImplicitWriteAnnotations);
    }

    public static boolean isAnnotated(PsiMember member, Collection<String> strings) {
        if (strings.isEmpty()) {
            return false;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)member, strings, (int)0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/ws/rest/providers/RSImplicitUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRead";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

