/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.highlighting.fixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.MacroFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.thymeleaf.resources.ThymeleafBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclareThymeleafVarInCommentFix
implements LocalQuickFix {
    protected String myVarId;

    public DeclareThymeleafVarInCommentFix(String varId) {
        this.myVarId = varId;
    }

    @NotNull
    public String getName() {
        String string = ThymeleafBundle.message("thymeleaf.el.declare.variable.comment.annotation.intention.name", new Object[0]);
        if (string == null) {
            DeclareThymeleafVarInCommentFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = ThymeleafBundle.message("thymeleaf.el.declare.variable.intention.family", new Object[0]);
        if (string == null) {
            DeclareThymeleafVarInCommentFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    protected PsiElement getContextElement(PsiElement psiElement) {
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile != null) {
            return containingFile.getContext();
        }
        return null;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            DeclareThymeleafVarInCommentFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            DeclareThymeleafVarInCommentFix.$$$reportNull$$$0(3);
        }
        PsiElement psiElement = descriptor.getPsiElement();
        PsiFile file = psiElement.getContainingFile();
        Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file.getVirtualFile()), false);
        if (editor == null) {
            return;
        }
        int templateStartOffset = -1;
        PsiElement contextElement = this.getContextElement(psiElement);
        if (contextElement instanceof XmlAttributeValue) {
            templateStartOffset = contextElement.getParent().getParent().getTextOffset();
        } else if (contextElement instanceof XmlTag) {
            templateStartOffset = ((XmlTag)contextElement).getValue().getTextRange().getStartOffset();
        }
        if (templateStartOffset != -1) {
            TemplateManager manager = TemplateManager.getInstance((Project)editor.getProject());
            Template template = manager.createTemplate("", "");
            template.addTextSegment("<!--/*");
            template.addTextSegment("@thymesVar");
            template.addTextSegment(" id=\"" + this.myVarId + "\"");
            template.addTextSegment(" type=\"");
            template.addVariable("type", (Expression)new MacroCallNode(MacroFactory.createMacro((String)"complete")), true);
            template.addTextSegment("\"");
            template.addEndVariable();
            template.addTextSegment("*/-->");
            CharSequence sequence = editor.getDocument().getCharsSequence();
            if (sequence.length() < templateStartOffset) {
                return;
            }
            if (sequence.charAt(templateStartOffset) != '\n') {
                template.addTextSegment("\n");
            }
            editor.getCaretModel().moveToOffset(templateStartOffset);
            manager.startTemplate(editor, template);
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            DeclareThymeleafVarInCommentFix.$$$reportNull$$$0(4);
        }
        if (previewDescriptor == null) {
            DeclareThymeleafVarInCommentFix.$$$reportNull$$$0(5);
        }
        return new IntentionPreviewInfo.CustomDiff((FileType)XmlFileType.INSTANCE, "", "<!--/*@thymesVar id=\"" + this.myVarId + "\" type=\"TYPE\"*/-->");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/highlighting/fixes/DeclareThymeleafVarInCommentFix";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/highlighting/fixes/DeclareThymeleafVarInCommentFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

