/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.html5;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.thymeleaf.dialects.ThymeleafDialect;
import com.intellij.thymeleaf.dialects.ThymeleafDialects;
import com.intellij.thymeleaf.dialects.ThymeleafElementProcessor;
import com.intellij.thymeleaf.html5.ThymeleafXmlElementDescriptor;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafCommonUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafNamespaceDescriptor
extends XmlNSDescriptorImpl {
    @Nullable
    private final PsiFile myFile;

    public ThymeleafNamespaceDescriptor(@Nullable PsiFile file) {
        this.myFile = file;
    }

    public XmlElementDescriptor @NotNull [] getRootElementsDescriptors(@Nullable XmlDocument doc) {
        XmlTag tag = null;
        if (doc != null) {
            tag = doc.getRootTag();
        }
        if (tag == null && this.myFile instanceof XmlFile) {
            tag = ((XmlFile)this.myFile).getRootTag();
        }
        Set<XmlElementDescriptor> descriptors = this.getAllDescriptors(tag);
        XmlElementDescriptor[] xmlElementDescriptorArray = descriptors.toArray(XmlElementDescriptor.EMPTY_ARRAY);
        if (xmlElementDescriptorArray == null) {
            ThymeleafNamespaceDescriptor.$$$reportNull$$$0(0);
        }
        return xmlElementDescriptorArray;
    }

    @NotNull
    public Set<XmlElementDescriptor> getAllDescriptors(@Nullable XmlTag tag) {
        HashSet<XmlElementDescriptor> descriptors = new HashSet<XmlElementDescriptor>();
        if (tag != null) {
            final PsiFile containingFile = tag.getContainingFile();
            for (ThymeleafDialect dialect : ThymeleafDialects.getDialects(tag.getProject())) {
                String prefix;
                if (!dialect.isSupported(tag.getProject()) || (prefix = ThymeleafCommonUtil.getPrefixByThymeleafNamespace(tag, dialect.getNamespaces())) == null) continue;
                for (ThymeleafElementProcessor elementProcessor : dialect.getElementProcessors()) {
                    String name = elementProcessor.getName();
                    if (!StringUtil.isNotEmpty((String)name)) continue;
                    descriptors.add((XmlElementDescriptor)new ThymeleafXmlElementDescriptor((XmlNSDescriptor)this, prefix, name){

                        @Override
                        public PsiElement getDeclaration() {
                            return containingFile;
                        }
                    });
                }
            }
        }
        HashSet<XmlElementDescriptor> hashSet = descriptors;
        if (hashSet == null) {
            ThymeleafNamespaceDescriptor.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        String ns;
        if (tag == null) {
            ThymeleafNamespaceDescriptor.$$$reportNull$$$0(2);
        }
        if (ThymeleafCommonUtil.isThymeleafNamespace(ns = tag.getNamespace(), tag.getProject())) {
            Set<XmlElementDescriptor> descriptors = this.getAllDescriptors(tag);
            for (XmlElementDescriptor descriptor : descriptors) {
                if (!tag.getName().equals(descriptor.getDefaultName())) continue;
                return descriptor;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/html5/ThymeleafNamespaceDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElementsDescriptors";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/html5/ThymeleafNamespaceDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

