/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.html5;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.thymeleaf.html5.ThymeleafHtmlElementDescriptor;
import com.intellij.thymeleaf.html5.ThymeleafNamespaceDescriptor;
import com.intellij.thymeleaf.html5.ThymeleafXmlElementDescriptor;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafCommonUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafXmlElementDescriptorProvider
implements XmlElementDescriptorProvider {
    @Nullable
    public XmlElementDescriptor getDescriptor(XmlTag tag) {
        String namespacePrefix = tag.getNamespacePrefix();
        if ("th".equals(namespacePrefix) && StringUtil.isEmptyOrSpaces((String)tag.getNamespace()) && ThymeleafCommonUtil.hasThymeleafLibrary(tag.getProject())) {
            return ThymeleafXmlElementDescriptorProvider.createDescriptor(tag, new ThymeleafNamespaceDescriptor(tag.getContainingFile()), "th", tag.getLocalName());
        }
        if (tag.getLocalName().startsWith("th-") && StringUtil.isEmptyOrSpaces((String)namespacePrefix) && ThymeleafCommonUtil.hasThymeleafLibrary(tag.getProject())) {
            ThymeleafNamespaceDescriptor namespaceDescriptor = new ThymeleafNamespaceDescriptor(tag.getContainingFile());
            return ThymeleafXmlElementDescriptorProvider.createDescriptor(tag, namespaceDescriptor, "", tag.getLocalName());
        }
        return null;
    }

    private static ThymeleafHtmlElementDescriptor createDescriptor(final @NotNull XmlTag tag, ThymeleafNamespaceDescriptor namespaceDescriptor, @NonNls String prefix, @NotNull @NlsSafe String tagName) {
        if (tag == null) {
            ThymeleafXmlElementDescriptorProvider.$$$reportNull$$$0(0);
        }
        if (tagName == null) {
            ThymeleafXmlElementDescriptorProvider.$$$reportNull$$$0(1);
        }
        ThymeleafXmlElementDescriptor descriptor = new ThymeleafXmlElementDescriptor((XmlNSDescriptor)namespaceDescriptor, prefix, tagName){

            @Override
            public PsiElement getDeclaration() {
                return tag.getContainingFile();
            }
        };
        return new ThymeleafHtmlElementDescriptor((XmlElementDescriptor)descriptor, false, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "tag";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "tagName";
                break;
            }
        }
        objectArray[1] = "com/intellij/thymeleaf/html5/ThymeleafXmlElementDescriptorProvider";
        objectArray[2] = "createDescriptor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

