/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.highlight;

import com.intellij.javaee.el.impl.ELHighlighter;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.thymeleaf.lang.lexer.ThymeleafLexer;
import com.intellij.thymeleaf.lang.lexer.ThymeleafTokenTypeSets;
import com.intellij.thymeleaf.lang.lexer.ThymesElementTypes;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ThymeleafSyntaxHighlighter
extends SyntaxHighlighterBase {
    private final Map<IElementType, TextAttributesKey> keys1 = new HashMap<IElementType, TextAttributesKey>();
    private final Map<IElementType, TextAttributesKey> keys2 = new HashMap<IElementType, TextAttributesKey>();

    protected ThymeleafSyntaxHighlighter() {
        this.fillMap(ThymeleafTokenTypeSets.KEYWORDS);
        this.fillMap(ThymeleafTokenTypeSets.UNARY_OPERATIONS);
        this.fillMap(ThymeleafTokenTypeSets.BINARY_OPERATIONS);
        this.fillMap(ThymeleafTokenTypeSets.BINARY_OPERATIONS);
        this.putTokenType(ThymesElementTypes.URL_EXPR_START, ELHighlighter.EL_BOUNDS);
        this.putTokenType(ThymesElementTypes.SELECTIONS_EXPR_START, ELHighlighter.EL_BOUNDS);
        this.putTokenType(ThymesElementTypes.MESSAGE_EXPR_START, ELHighlighter.EL_BOUNDS);
        this.putTokenType(ThymesElementTypes.FRAGMENT_EXPR_START, ELHighlighter.EL_BOUNDS);
        this.putTokenType(ThymesElementTypes.EXPR_END, ELHighlighter.EL_BOUNDS);
        this.putTokenType(ThymesElementTypes.OGNL_PREPROCESSING_START, ELHighlighter.EL_BOUNDS);
        this.putTokenType(ThymesElementTypes.MESSAGE_PREPROCESSING_START, ELHighlighter.EL_BOUNDS);
        this.putTokenType(ThymesElementTypes.SELECTIONS_PREPROCESSING_START, ELHighlighter.EL_BOUNDS);
        this.putTokenType(ThymesElementTypes.PREPROCESSING_END, ELHighlighter.EL_BOUNDS);
        this.putTokenType(ThymesElementTypes.IDENTIFIER, ELHighlighter.EL_IDENT);
        this.putTokenType(ThymesElementTypes.STRING_IDENTIFIER, ELHighlighter.EL_IDENT);
        this.putTokenType(ThymesElementTypes.DOT, ELHighlighter.EL_DOT);
        this.putTokenType(ThymesElementTypes.COMMA, ELHighlighter.EL_COMMA);
        this.putTokenType(ThymesElementTypes.SELECTOR, ELHighlighter.EL_COMMA);
        this.putTokenType(ThymesElementTypes.SEMICOLON, ELHighlighter.EL_COMMA);
        this.putTokenType(ThymesElementTypes.TILDE, ELHighlighter.EL_COMMA);
        this.putTokenType(ThymesElementTypes.SHARP, ELHighlighter.EL_COMMA);
        this.putTokenType(ThymesElementTypes.INTEGER_LITERAL, ELHighlighter.EL_NUMBER);
        this.putTokenType(ThymesElementTypes.HTML_ENTITY_REF, ELHighlighter.EL_NUMBER);
        this.putTokenType(ThymesElementTypes.FLOATING_POINT_LITERAL, ELHighlighter.EL_NUMBER);
        this.putTokenType(ThymesElementTypes.STRING_LITERAL, ELHighlighter.EL_STRING);
        this.putTokenType(ThymesElementTypes.LPARENTH, ELHighlighter.EL_PARENTHS);
        this.putTokenType(ThymesElementTypes.RPARENTH, ELHighlighter.EL_PARENTHS);
        this.putTokenType(ThymesElementTypes.LBRACKET, ELHighlighter.EL_BRACKETS);
        this.putTokenType(ThymesElementTypes.RBRACKET, ELHighlighter.EL_BRACKETS);
        this.putTokenType(ThymesElementTypes.OGNL_EXPR_START, ELHighlighter.EL_BOUNDS);
        this.keys2.put(TokenType.WHITE_SPACE, ELHighlighter.EL_BACKGROUND);
    }

    private void fillMap(@NotNull TokenSet tokenSet) {
        if (tokenSet == null) {
            ThymeleafSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        SyntaxHighlighterBase.fillMap(this.keys1, (TokenSet)tokenSet, (TextAttributesKey)ELHighlighter.EL_KEYWORD);
        SyntaxHighlighterBase.fillMap(this.keys2, (TokenSet)tokenSet, (TextAttributesKey)ELHighlighter.EL_BACKGROUND);
    }

    private void putTokenType(@NotNull IElementType elementType, @NotNull TextAttributesKey key) {
        if (elementType == null) {
            ThymeleafSyntaxHighlighter.$$$reportNull$$$0(1);
        }
        if (key == null) {
            ThymeleafSyntaxHighlighter.$$$reportNull$$$0(2);
        }
        this.keys1.put(elementType, key);
        this.keys2.put(elementType, ELHighlighter.EL_BACKGROUND);
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = ThymeleafSyntaxHighlighter.pack((TextAttributesKey)this.keys2.get(tokenType), (TextAttributesKey)this.keys1.get(tokenType));
        if (textAttributesKeyArray == null) {
            ThymeleafSyntaxHighlighter.$$$reportNull$$$0(3);
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new ThymeleafLexer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/lang/highlight/ThymeleafSyntaxHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/lang/highlight/ThymeleafSyntaxHighlighter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillMap";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putTokenType";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

