/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.psi.impl;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.javaee.web.WebDirectoryElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.thymeleaf.lang.ThymeleafExpressionsFileType;
import com.intellij.thymeleaf.lang.ThymeleafPsiFile;
import com.intellij.thymeleaf.lang.psi.ThymeleafTemplateNameReference;
import com.intellij.thymeleaf.lang.psi.impl.ThymeleafPsiCompositeElementImpl;
import com.intellij.thymeleaf.references.paths.ThymeleafPathPsiReferenceProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThymeleafTemplateNameReferenceImpl
extends ThymeleafPsiCompositeElementImpl
implements ThymeleafTemplateNameReference {
    public ThymeleafTemplateNameReferenceImpl(@NotNull ASTNode node) {
        if (node == null) {
            ThymeleafTemplateNameReferenceImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @NotNull
    public PsiElement getElement() {
        ThymeleafTemplateNameReferenceImpl thymeleafTemplateNameReferenceImpl = this;
        if (thymeleafTemplateNameReferenceImpl == null) {
            ThymeleafTemplateNameReferenceImpl.$$$reportNull$$$0(1);
        }
        return thymeleafTemplateNameReferenceImpl;
    }

    public PsiReference getReference() {
        return this;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.getTextRange();
        return new TextRange(0, textRange.getEndOffset() - textRange.getStartOffset());
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            ThymeleafTemplateNameReferenceImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        ThymeleafTemplateNameReferenceImpl newTemplateNameElement;
        String name;
        if (newElementName == null) {
            ThymeleafTemplateNameReferenceImpl.$$$reportNull$$$0(3);
        }
        if ((name = this.getText()).equals(FileUtilRt.getNameWithoutExtension((String)name))) {
            newElementName = FileUtilRt.getNameWithoutExtension((String)newElementName);
        }
        if ((newTemplateNameElement = ThymeleafTemplateNameReferenceImpl.createTemplateNameReference(newElementName, this.getProject())) != null) {
            this.replace(newTemplateNameElement);
        }
        return this;
    }

    @Nullable
    public static ThymeleafTemplateNameReferenceImpl createTemplateNameReference(@NotNull String name, @NotNull Project project) {
        PsiElement element;
        ThymeleafPsiFile psiFile;
        PsiElement deepestElement;
        if (name == null) {
            ThymeleafTemplateNameReferenceImpl.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ThymeleafTemplateNameReferenceImpl.$$$reportNull$$$0(5);
        }
        if ((deepestElement = (psiFile = (ThymeleafPsiFile)PsiFileFactory.getInstance((Project)project).createFileFromText("_dummy.thymes", (FileType)ThymeleafExpressionsFileType.TEMPLATES_EXPRESSIONS, (CharSequence)name)).findElementAt(1)) != null && (element = deepestElement.getParent()) instanceof ThymeleafTemplateNameReferenceImpl) {
            return (ThymeleafTemplateNameReferenceImpl)element;
        }
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ThymeleafTemplateNameReferenceImpl.$$$reportNull$$$0(6);
        }
        if (element instanceof PsiFile) {
            return this.handleElementRename(((PsiFile)element).getName());
        }
        return element;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        PsiElement resolve;
        if (element == null) {
            ThymeleafTemplateNameReferenceImpl.$$$reportNull$$$0(7);
        }
        if ((resolve = this.resolve()) instanceof PsiFile && FileUtilRt.getNameWithoutExtension((String)((PsiFile)resolve).getName()).equals(element.getText())) {
            return true;
        }
        return element.equals(resolve);
    }

    public Object @NotNull [] getVariants() {
        HashSet<LookupElementBuilder> results = new HashSet<LookupElementBuilder>();
        for (PsiDirectory contextDirectory : this.getContextDirectories()) {
            for (PsiDirectory psiDirectory : contextDirectory.getSubdirectories()) {
                results.add(LookupElementBuilder.create((PsiNamedElement)psiDirectory).withIcon(psiDirectory.getIcon(0)));
            }
            for (PsiDirectory psiDirectory : contextDirectory.getFiles()) {
                if (psiDirectory.getFileType() != HtmlFileType.INSTANCE) continue;
                results.add(LookupElementBuilder.create((PsiNamedElement)psiDirectory).withIcon(psiDirectory.getIcon(0)));
                results.add(LookupElementBuilder.create((Object)psiDirectory, (String)FileUtilRt.getNameWithoutExtension((String)psiDirectory.getName())).withIcon(psiDirectory.getIcon(0)));
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray(results);
        if (objectArray == null) {
            ThymeleafTemplateNameReferenceImpl.$$$reportNull$$$0(8);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }

    public PsiElement resolve() {
        String name = this.getText();
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return null;
        }
        if ("this".equals(name) && ThymeleafTemplateNameReferenceImpl.getLeftReference(this) == null) {
            return ThymeleafTemplateNameReferenceImpl.getOriginalContainingFile(this.getContainingFile());
        }
        for (PsiDirectory context : this.getContextDirectories()) {
            PsiFile[] files;
            for (PsiDirectory subdirectory : context.getSubdirectories()) {
                if (!name.equals(subdirectory.getName())) continue;
                return subdirectory;
            }
            for (PsiFile file : files = context.getFiles()) {
                String fileName = file.getName();
                if (!name.equals(fileName) && !name.equals(FileUtilRt.getNameWithoutExtension((String)fileName))) continue;
                return file;
            }
        }
        return null;
    }

    @NotNull
    public Set<PsiDirectory> getContextDirectories() {
        LinkedHashSet<PsiDirectory> contexts = new LinkedHashSet<PsiDirectory>();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this);
        if (module != null) {
            ThymeleafTemplateNameReference leftReference = ThymeleafTemplateNameReferenceImpl.getLeftReference(this);
            if (leftReference == null) {
                for (PsiFileSystemItem contextPath : ThymeleafPathPsiReferenceProvider.getPrefixedContextPaths(module)) {
                    VirtualFile file;
                    if (contextPath instanceof PsiDirectory) {
                        contexts.add((PsiDirectory)contextPath);
                    }
                    if (!(contextPath instanceof WebDirectoryElement) || (file = ((WebDirectoryElement)contextPath).getOriginalVirtualFile()) == null || !file.isDirectory()) continue;
                    ContainerUtil.addIfNotNull(contexts, (Object)PsiManager.getInstance((Project)module.getProject()).findDirectory(file));
                }
                ContainerUtil.addIfNotNull(contexts, (Object)ThymeleafTemplateNameReferenceImpl.getCurrentFileContextDirectory(this.getContainingFile()));
            } else {
                PsiElement resolve = leftReference.resolve();
                if (resolve instanceof PsiDirectory) {
                    contexts.add((PsiDirectory)resolve);
                }
            }
        }
        LinkedHashSet<PsiDirectory> linkedHashSet = contexts;
        if (linkedHashSet == null) {
            ThymeleafTemplateNameReferenceImpl.$$$reportNull$$$0(9);
        }
        return linkedHashSet;
    }

    @Nullable
    public static ThymeleafTemplateNameReference getLeftReference(@Nullable PsiElement node) {
        if (node == null) {
            return null;
        }
        PsiElement sibling = ThymeleafTemplateNameReferenceImpl.getPrevSiblingSkipWhiteSpaces(node, true);
        while (sibling != null) {
            if (!"/".equals(sibling.getText())) {
                return sibling instanceof ThymeleafTemplateNameReference && sibling != node ? (ThymeleafTemplateNameReference)sibling : null;
            }
            sibling = ThymeleafTemplateNameReferenceImpl.getPrevSiblingSkipWhiteSpaces(sibling, true);
        }
        return null;
    }

    @Nullable
    public static PsiElement getPrevSiblingSkipWhiteSpaces(@Nullable PsiElement sibling, boolean strictly) {
        return ThymeleafTemplateNameReferenceImpl.getPrevSiblingSkipingCondition(sibling, (Condition<? super PsiElement>)((Condition)element -> element instanceof PsiWhiteSpace), strictly);
    }

    @Nullable
    public static PsiElement getPrevSiblingSkipingCondition(@Nullable PsiElement sibling, Condition<? super PsiElement> condition, boolean strictly) {
        PsiElement result;
        if (sibling == null) {
            return null;
        }
        PsiElement psiElement = result = strictly ? sibling.getPrevSibling() : sibling;
        while (result != null && condition.value((Object)result)) {
            result = result.getPrevSibling();
        }
        return result;
    }

    @Nullable
    public static PsiDirectory getCurrentFileContextDirectory(PsiFile thFile) {
        PsiFile originalContainingFile = ThymeleafTemplateNameReferenceImpl.getOriginalContainingFile(thFile);
        return originalContainingFile != null ? originalContainingFile.getContainingDirectory() : null;
    }

    @Nullable
    public static PsiFile getOriginalContainingFile(@Nullable PsiFile thFile) {
        PsiFile containingFile;
        PsiElement context;
        if (thFile != null && (context = thFile.getContext()) != null && (containingFile = context.getContainingFile()) != null) {
            return containingFile.getOriginalFile();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/lang/psi/impl/ThymeleafTemplateNameReferenceImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/lang/psi/impl/ThymeleafTemplateNameReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateNameReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 8, 9 -> new IllegalStateException(string);
        };
    }
}

