/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.references.paths;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.psi.jsp.WebDirectoryUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.thymeleaf.references.paths.ThymeleafViewResolverHelper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafPathPsiReferenceProvider
extends PsiReferenceProvider {
    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            ThymeleafPathPsiReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ThymeleafPathPsiReferenceProvider.$$$reportNull$$$0(1);
        }
        LinkedHashSet references = new LinkedHashSet();
        Collections.addAll(references, PathReferenceManager.getInstance().createReferences(element, true, false, true, new PathReferenceProvider[0]));
        FileReferenceSet set = new FileReferenceSet(element.getText(), element, 0, null, true);
        set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, file -> {
            HashSet<PsiDirectory> roots = new HashSet<PsiDirectory>();
            PsiDirectory containingDirectory = file.getContainingDirectory();
            if (containingDirectory != null) {
                roots.add(containingDirectory);
            } else {
                PsiFile containingFile;
                PsiElement fileContext = file.getContext();
                if (fileContext != null && (containingFile = fileContext.getContainingFile()) != null) {
                    ContainerUtil.addIfNotNull(roots, (Object)containingFile.getContainingDirectory());
                }
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (module != null) {
                ContainerUtil.addAllNotNull(roots, ThymeleafPathPsiReferenceProvider.getPrefixedContextPaths(module));
            }
            return roots;
        });
        Collections.addAll(references, set.getAllReferences());
        PsiReference[] psiReferenceArray = references.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            ThymeleafPathPsiReferenceProvider.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    @NotNull
    public static Collection<PsiFileSystemItem> getPrefixedContextPaths(@NotNull Module module) {
        if (module == null) {
            ThymeleafPathPsiReferenceProvider.$$$reportNull$$$0(3);
        }
        HashSet<PsiFileSystemItem> items = new HashSet<PsiFileSystemItem>(ThymeleafPathPsiReferenceProvider.getWebRootContextPaths(module));
        for (ThymeleafViewResolverHelper helper : ThymeleafViewResolverHelper.EP_NAME.getExtensionList()) {
            items.addAll(helper.getResourcesContextPaths(module));
        }
        HashSet<PsiFileSystemItem> hashSet = items;
        if (hashSet == null) {
            ThymeleafPathPsiReferenceProvider.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    protected static Collection<PsiFileSystemItem> getWebRootContextPaths(@NotNull Module module) {
        Collection facets;
        if (module == null) {
            ThymeleafPathPsiReferenceProvider.$$$reportNull$$$0(5);
        }
        if ((facets = WebFacet.getInstances((Module)module)).isEmpty()) {
            return Collections.emptySet();
        }
        String[] prefixes = ArrayUtil.toStringArray(ThymeleafPathPsiReferenceProvider.getTemplateResolverPrefixes(module));
        if (prefixes.length == 0) {
            return Collections.emptySet();
        }
        HashSet<PsiFileSystemItem> items = new HashSet<PsiFileSystemItem>();
        WebDirectoryUtil directoryUtil = WebDirectoryUtil.getWebDirectoryUtil((Project)module.getProject());
        for (WebFacet webFacet : facets) {
            for (String prefix : prefixes) {
                ContainerUtil.addIfNotNull(items, (Object)directoryUtil.findWebDirectoryElementByPath(prefix, webFacet));
            }
        }
        return items;
    }

    @NotNull
    public static Set<String> getTemplateResolverPrefixes(@Nullable Module module) {
        if (module == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                ThymeleafPathPsiReferenceProvider.$$$reportNull$$$0(6);
            }
            return set;
        }
        HashSet<String> strings = new HashSet<String>();
        for (ThymeleafViewResolverHelper helper : ThymeleafViewResolverHelper.EP_NAME.getExtensionList()) {
            strings.addAll(helper.getTemplateResolverPrefixes(module));
        }
        HashSet<String> hashSet = strings;
        if (hashSet == null) {
            ThymeleafPathPsiReferenceProvider.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/references/paths/ThymeleafPathPsiReferenceProvider";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/references/paths/ThymeleafPathPsiReferenceProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefixedContextPaths";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateResolverPrefixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixedContextPaths";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getWebRootContextPaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

