/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.Content;
import com.intellij.history.core.HistoryPathFilter;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public abstract class Change {
    private final long myId;

    protected Change(long id) {
        this.myId = id;
    }

    protected Change(DataInput in) throws IOException {
        this.myId = DataInputOutputUtil.readLONG((DataInput)in);
    }

    public void write(DataOutput out) throws IOException {
        DataInputOutputUtil.writeLONG((DataOutput)out, (long)this.myId);
    }

    public long getId() {
        return this.myId;
    }

    public abstract boolean affectsPath(String var1);

    public abstract boolean affectsProject(String var1);

    @Deprecated
    public abstract boolean affectsMatching(@NotNull Pattern var1);

    public abstract boolean affectsMatching(@NotNull HistoryPathFilter var1);

    public abstract boolean isCreationalFor(String var1);

    public abstract List<Content> getContentsToPurge();

    public void accept(ChangeVisitor v) throws ChangeVisitor.StopVisitingException {
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Change change = (Change)o;
        return this.myId == change.myId;
    }

    public final int hashCode() {
        return Long.hashCode(this.myId);
    }
}

