/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.beans;

import com.intellij.microservices.jvm.MicroservicesJvmBundle;
import com.intellij.microservices.jvm.beans.ActivateToolWindowByProviderAction;
import com.intellij.microservices.jvm.beans.BeanStereotype;
import com.intellij.microservices.jvm.beans.BeansProvider;
import com.intellij.microservices.jvm.beans.BeansView;
import com.intellij.microservices.jvm.beans.BeansViewService;
import com.intellij.microservices.jvm.beans.FrameworkBeansPresentation;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003H\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00052\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003H\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000fH\u0000\u00a8\u0006\u0010"}, d2={"getActivateByProviderActionId", "", "provider", "Lcom/intellij/microservices/jvm/beans/BeansProvider;", "registerActivateByProviderAction", "", "unregisterActivateByProviderAction", "getActiveBeansView", "Lcom/intellij/microservices/jvm/beans/BeansView;", "project", "Lcom/intellij/openapi/project/Project;", "getAvailableBeanStereotypes", "Lkotlin/sequences/Sequence;", "Lcom/intellij/microservices/jvm/beans/BeanStereotype;", "frameworks", "", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nBeansViewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BeansViewManager.kt\ncom/intellij/microservices/jvm/beans/BeansViewManagerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,255:1\n774#2:256\n865#2:257\n1761#2,3:258\n866#2:261\n1374#2:262\n1460#2,5:263\n1669#2,8:268\n*S KotlinDebug\n*F\n+ 1 BeansViewManager.kt\ncom/intellij/microservices/jvm/beans/BeansViewManagerKt\n*L\n248#1:256\n248#1:257\n250#1:258,3\n248#1:261\n252#1:262\n252#1:263,5\n253#1:268,8\n*E\n"})
public final class BeansViewManagerKt {
    private static final String getActivateByProviderActionId(BeansProvider<?, ?> provider) {
        String name = provider.getClass().getSimpleName();
        Intrinsics.checkNotNull((Object)name);
        return ((CharSequence)name).length() == 0 ? null : "ServiceView.Activate" + name;
    }

    private static final void registerActivateByProviderAction(BeansProvider<?, ?> provider) {
        ActionManager actionManager = ActionManager.getInstance();
        String actionId = BeansViewManagerKt.getActivateByProviderActionId(provider);
        if (actionId == null) {
            return;
        }
        FrameworkBeansPresentation presentation2 = provider.getPresentation();
        if (Intrinsics.areEqual((Object)presentation2.getToolWindowTitle(), (Object)MicroservicesJvmBundle.message("beans.tool.window.title", new Object[0]))) {
            return;
        }
        AnAction action2 = actionManager.getAction(actionId);
        if (action2 == null) {
            action2 = (AnAction)new ActivateToolWindowByProviderAction(presentation2);
            actionManager.registerAction(actionId, action2);
        }
    }

    private static final void unregisterActivateByProviderAction(BeansProvider<?, ?> provider) {
        ActionManager actionManager;
        AnAction action2;
        String actionId = BeansViewManagerKt.getActivateByProviderActionId(provider);
        if (actionId != null && (action2 = (actionManager = ActionManager.getInstance()).getAction(actionId)) != null) {
            actionManager.unregisterAction(actionId);
        }
    }

    @Nullable
    public static final BeansView getActiveBeansView(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Beans");
        if (toolWindow == null) {
            return null;
        }
        ToolWindow toolWindow2 = toolWindow;
        if (!toolWindow2.isAvailable() || !toolWindow2.isVisible()) {
            return null;
        }
        Content content = toolWindow2.getContentManager().getContent(0);
        JComponent jComponent = content != null ? content.getComponent() : null;
        return jComponent instanceof BeansView ? (BeansView)((Object)jComponent) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Sequence<BeanStereotype> getAvailableBeanStereotypes(@NotNull Project project, @NotNull List<String> frameworks) {
        void $this$flatMapTo$iv$iv;
        BeansProvider it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(frameworks, (String)"frameworks");
        Iterable $this$filter$iv = BeansViewService.Companion.getInstance(project).getAvailableProviders();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block8: {
                it = (BeansProvider)element$iv$iv;
                boolean bl2 = false;
                if (frameworks.isEmpty()) {
                    bl = true;
                } else {
                    Iterable $this$any$iv = frameworks;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String framework = (String)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getPresentation().getQueryTag(), (Object)framework)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (BeansProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getStereotypes();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            BeanStereotype it2 = (BeanStereotype)e$iv;
            boolean bl = false;
            String key$iv = it2.getQueryTag();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return CollectionsKt.asSequence((Iterable)list$iv);
    }

    public static /* synthetic */ Sequence getAvailableBeanStereotypes$default(Project project, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return BeansViewManagerKt.getAvailableBeanStereotypes(project, list2);
    }

    public static final /* synthetic */ void access$unregisterActivateByProviderAction(BeansProvider provider) {
        BeansViewManagerKt.unregisterActivateByProviderAction(provider);
    }

    public static final /* synthetic */ void access$registerActivateByProviderAction(BeansProvider provider) {
        BeansViewManagerKt.registerActivateByProviderAction(provider);
    }
}

