/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.mq.references;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.highlighting.HighlightedReference;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.microservices.jvm.mq.MQDestination;
import com.intellij.microservices.jvm.mq.MQModelKt;
import com.intellij.microservices.jvm.mq.MQTargetInfo;
import com.intellij.microservices.jvm.mq.MQType;
import com.intellij.microservices.jvm.mq.references.MQReferenceContext;
import com.intellij.microservices.jvm.mq.references.MQReferenceUnifiedPomTarget;
import com.intellij.microservices.utils.CommonFakeNavigatablePomTarget;
import com.intellij.microservices.utils.MicroservicesUsageCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import java.util.Iterator;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\"#B+\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB!\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\u000fB\u0019\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0010J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0004J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u0013\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0000\u00a2\u0006\u0002\b\u001fJ\b\u0010 \u001a\u00020!H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0013\u001a\u0004\u0018\u00010\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/intellij/microservices/jvm/mq/references/MQReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/highlighting/HighlightedReference;", "referenceContext", "Lcom/intellij/microservices/jvm/mq/references/MQReferenceContext;", "host", "range", "Lcom/intellij/openapi/util/TextRange;", "soft", "", "<init>", "(Lcom/intellij/microservices/jvm/mq/references/MQReferenceContext;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Z)V", "type", "Lcom/intellij/microservices/jvm/mq/MQType;", "(Lcom/intellij/microservices/jvm/mq/MQType;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)V", "(Lcom/intellij/microservices/jvm/mq/MQType;Lcom/intellij/psi/PsiElement;)V", "getReferenceContext", "()Lcom/intellij/microservices/jvm/mq/references/MQReferenceContext;", "unifiedPomTarget", "Lcom/intellij/microservices/jvm/mq/references/MQReferenceUnifiedPomTarget;", "getUnifiedPomTarget", "()Lcom/intellij/microservices/jvm/mq/references/MQReferenceUnifiedPomTarget;", "unifiedPomTarget$delegate", "Lkotlin/Lazy;", "resolve", "isReferenceTo", "element", "getVariantsIterator", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "getVariantsIterator$intellij_microservices_jvm", "toString", "", "MQTargetInfoFakeElement", "Companion", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nMQReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MQReference.kt\ncom/intellij/microservices/jvm/mq/references/MQReference\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public class MQReference
extends PsiReferenceBase<PsiElement>
implements HighlightedReference {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MQReferenceContext referenceContext;
    @NotNull
    private final Lazy unifiedPomTarget$delegate;

    @JvmOverloads
    public MQReference(@NotNull MQReferenceContext referenceContext, @NotNull PsiElement host, @NotNull TextRange range, boolean soft) {
        Intrinsics.checkNotNullParameter((Object)referenceContext, (String)"referenceContext");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        super(host, range, soft);
        this.referenceContext = referenceContext;
        this.unifiedPomTarget$delegate = LazyKt.lazy(() -> MQReference.unifiedPomTarget_delegate$lambda$0(this));
    }

    public /* synthetic */ MQReference(MQReferenceContext mQReferenceContext, PsiElement psiElement, TextRange textRange, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(mQReferenceContext, psiElement, textRange, bl);
    }

    @NotNull
    public final MQReferenceContext getReferenceContext() {
        return this.referenceContext;
    }

    public MQReference(@NotNull MQType type, @NotNull PsiElement host, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this(new MQReferenceContext(type), host, range, false, 8, null);
    }

    public MQReference(@NotNull MQType type, @NotNull PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        MQReferenceContext mQReferenceContext = new MQReferenceContext(type);
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)host);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
        this(mQReferenceContext, host, textRange, false, 8, null);
    }

    private final MQReferenceUnifiedPomTarget getUnifiedPomTarget() {
        Lazy lazy = this.unifiedPomTarget$delegate;
        return (MQReferenceUnifiedPomTarget)lazy.getValue();
    }

    @Nullable
    public PsiElement resolve() {
        MQTargetInfoFakeElement mQTargetInfoFakeElement;
        MQReferenceUnifiedPomTarget mQReferenceUnifiedPomTarget = this.getUnifiedPomTarget();
        if (mQReferenceUnifiedPomTarget != null) {
            MQReferenceUnifiedPomTarget it = mQReferenceUnifiedPomTarget;
            boolean bl = false;
            Project project = this.getElement().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            mQTargetInfoFakeElement = new MQTargetInfoFakeElement(project, it);
        } else {
            mQTargetInfoFakeElement = null;
        }
        return (PsiElement)mQTargetInfoFakeElement;
    }

    @NotNull
    protected final PsiElement resolve(@NotNull MQReferenceContext referenceContext) {
        Intrinsics.checkNotNullParameter((Object)referenceContext, (String)"referenceContext");
        String string = this.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        Project project = this.getElement().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        MQReferenceUnifiedPomTarget target = new MQReferenceUnifiedPomTarget(referenceContext, string, project);
        Project project2 = this.getElement().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        return (PsiElement)new MQTargetInfoFakeElement(project2, target);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof MQTargetInfoFakeElement)) {
            return false;
        }
        return super.isReferenceTo(element);
    }

    @NotNull
    public final Iterator<LookupElement> getVariantsIterator$intellij_microservices_jvm() {
        MQReferenceUnifiedPomTarget resolved;
        MicroservicesUsageCollector.INSTANCE.getMQ_ID_VARIANTS_EVENT().log(this.myElement.getProject());
        PsiElement psiElement = this.resolve();
        MQTargetInfoFakeElement mQTargetInfoFakeElement = psiElement instanceof MQTargetInfoFakeElement ? (MQTargetInfoFakeElement)psiElement : null;
        MQReferenceUnifiedPomTarget mQReferenceUnifiedPomTarget = resolved = mQTargetInfoFakeElement != null ? mQTargetInfoFakeElement.getUnifiedPomTarget() : null;
        Object object = mQReferenceUnifiedPomTarget != null ? mQReferenceUnifiedPomTarget.getAllVariants() : null;
        if (object == null) {
            object = SequencesKt.emptySequence();
        }
        return SequencesKt.mapNotNull((Sequence)object, MQReference::getVariantsIterator$lambda$2).iterator();
    }

    @NotNull
    public String toString() {
        return "MQReference(" + this.getValue() + ", " + this.getRangeInElement() + ", types = " + this.referenceContext.getTypes() + "})";
    }

    @JvmOverloads
    public MQReference(@NotNull MQReferenceContext referenceContext, @NotNull PsiElement host, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)referenceContext, (String)"referenceContext");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this(referenceContext, host, range, false, 8, null);
    }

    private static final MQReferenceUnifiedPomTarget unifiedPomTarget_delegate$lambda$0(MQReference this$0) {
        if (this$0.referenceContext.getTypes().isEmpty()) {
            return null;
        }
        MQReferenceContext mQReferenceContext = this$0.referenceContext;
        String string = this$0.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        Project project = this$0.getElement().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new MQReferenceUnifiedPomTarget(mQReferenceContext, string, project);
    }

    private static final LookupElement getVariantsIterator$lambda$2(MQTargetInfo variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        MQDestination destination = variant.getDestination();
        String lookUp = destination.getName();
        if (StringsKt.isBlank((CharSequence)lookUp)) {
            return null;
        }
        return PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)LookupElementBuilder.create((String)lookUp).withIcon(MQModelKt.getMqIconOrDefault(destination.getType())).withTypeText(destination.getType().getLocalizedTypeName())), (double)1000.0);
    }

    @JvmStatic
    @NotNull
    public static final PsiElement createSearchableElement(@NotNull Project project, @NotNull MQDestination mqId) {
        return Companion.createSearchableElement(project, mqId);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/microservices/jvm/mq/references/MQReference$Companion;", "", "<init>", "()V", "createSearchableElement", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "mqId", "Lcom/intellij/microservices/jvm/mq/MQDestination;", "getTargetClass", "Ljava/lang/Class;", "intellij.microservices.jvm"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PsiElement createSearchableElement(@NotNull Project project, @NotNull MQDestination mqId) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)mqId, (String)"mqId");
            MQReferenceUnifiedPomTarget pomTarget = new MQReferenceUnifiedPomTarget(mqId, project);
            return (PsiElement)new MQTargetInfoFakeElement(project, pomTarget);
        }

        @NotNull
        public final Class<? extends PsiElement> getTargetClass() {
            return MQTargetInfoFakeElement.class;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/microservices/jvm/mq/references/MQReference$MQTargetInfoFakeElement;", "Lcom/intellij/microservices/utils/CommonFakeNavigatablePomTarget;", "project", "Lcom/intellij/openapi/project/Project;", "unifiedPomTarget", "Lcom/intellij/microservices/jvm/mq/references/MQReferenceUnifiedPomTarget;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/microservices/jvm/mq/references/MQReferenceUnifiedPomTarget;)V", "getUnifiedPomTarget", "()Lcom/intellij/microservices/jvm/mq/references/MQReferenceUnifiedPomTarget;", "navigate", "", "requestFocus", "", "getIcon", "Ljavax/swing/Icon;", "intellij.microservices.jvm"})
    private static class MQTargetInfoFakeElement
    extends CommonFakeNavigatablePomTarget {
        @NotNull
        private final MQReferenceUnifiedPomTarget unifiedPomTarget;

        public MQTargetInfoFakeElement(@NotNull Project project, @NotNull MQReferenceUnifiedPomTarget unifiedPomTarget) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)unifiedPomTarget, (String)"unifiedPomTarget");
            super(project, (PomRenameableTarget)unifiedPomTarget);
            this.unifiedPomTarget = unifiedPomTarget;
        }

        @NotNull
        public final MQReferenceUnifiedPomTarget getUnifiedPomTarget() {
            return this.unifiedPomTarget;
        }

        public void navigate(boolean requestFocus) {
            MicroservicesUsageCollector.INSTANCE.getMQ_ID_NAVIGATE_EVENT().log(this.getProject());
            super.navigate(requestFocus);
        }

        @Nullable
        public Icon getIcon() {
            return MQModelKt.getMqIconOrDefault(this.unifiedPomTarget.getSingleMQType$intellij_microservices_jvm());
        }
    }
}

