/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.okhttp;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PartiallyKnownString;
import com.intellij.psi.util.StringEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006H\u0000\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0003H\u0000\u00a8\u0006\n"}, d2={"endpointsPksPresentation", "", "url", "Lcom/intellij/psi/util/PartiallyKnownString;", "methodsPresentation", "methods", "", "extractPsiFromPks", "Lcom/intellij/psi/PsiElement;", "pks", "intellij.microservices.jvm.okhttp"})
@SourceDebugExtension(value={"SMAP\nokHttpUrlUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 okHttpUrlUtils.kt\ncom/intellij/microservices/jvm/okhttp/OkHttpUrlUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,25:1\n1617#2,9:26\n1869#2:35\n1870#2:37\n1626#2:38\n1#3:36\n*S KotlinDebug\n*F\n+ 1 okHttpUrlUtils.kt\ncom/intellij/microservices/jvm/okhttp/OkHttpUrlUtilsKt\n*L\n25#1:26,9\n25#1:35\n25#1:37\n25#1:38\n25#1:36\n*E\n"})
public final class OkHttpUrlUtilsKt {
    @NotNull
    public static final String endpointsPksPresentation(@NotNull PartiallyKnownString url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return CollectionsKt.joinToString$default((Iterable)url.getSegments(), (CharSequence)"", null, null, (int)0, null, OkHttpUrlUtilsKt::endpointsPksPresentation$lambda$0, (int)30, null);
    }

    @NotNull
    public static final String methodsPresentation(@NotNull Set<String> methods) {
        Intrinsics.checkNotNullParameter(methods, (String)"methods");
        if (!((Collection)methods).isEmpty()) {
            return CollectionsKt.joinToString$default((Iterable)methods, (CharSequence)"|", null, null, (int)0, null, OkHttpUrlUtilsKt::methodsPresentation$lambda$1, (int)30, null);
        }
        return "GET";
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final PsiElement extractPsiFromPks(@NotNull PartiallyKnownString pks) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pks, (String)"pks");
        Iterable $this$mapNotNull$iv = pks.getSegments();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PsiElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            StringEntry it = (StringEntry)element$iv$iv;
            boolean bl2 = false;
            if (it.getSourcePsi() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (PsiElement)CollectionsKt.lastOrNull((List)((List)destination$iv$iv));
    }

    private static final CharSequence endpointsPksPresentation$lambda$0(StringEntry segment) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        StringEntry stringEntry = segment;
        if (stringEntry instanceof StringEntry.Known) {
            charSequence = ((StringEntry.Known)segment).getValue();
        } else if (stringEntry instanceof StringEntry.Unknown) {
            charSequence = "${..}";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return charSequence;
    }

    private static final CharSequence methodsPresentation$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }
}

