/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.restassured;

import com.intellij.microservices.jvm.url.UastReferenceInjectorUtils;
import com.intellij.microservices.jvm.url.UastUrlPathReferenceProvider;
import com.intellij.microservices.mime.MimeTypeReference;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPathReferenceInjector;
import com.intellij.microservices.url.references.UrlPksParser;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.uast.UCallExpressionPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiType;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a-\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u001c\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"REST_ASSURED", "", "REQUEST_SENDER_OPTIONS", "REQUEST_SENDER", "REQUEST_SPECIFICATION", "FILTERABLE_REQUEST_SPECIFICATION", "VALIDATABLE_RESPONSE_OPTIONS", "REQUEST_SPEC_BUILDER", "registerRestAssuredReferenceProviders", "", "registrar", "Lcom/intellij/psi/PsiReferenceRegistrar;", "inferRequestMethod", "uElement", "Lorg/jetbrains/uast/UExpression;", "hasRequestReceiver", "", "call", "Lorg/jetbrains/uast/UCallExpression;", "isRestAssuredBaseUriAssign", "leftOperand", "Lorg/jetbrains/uast/UQualifiedReferenceExpression;", "buildReferences", "", "Lcom/intellij/psi/PsiReference;", "host", "Lcom/intellij/psi/PsiElement;", "method", "(Lorg/jetbrains/uast/UExpression;Lcom/intellij/psi/PsiElement;Ljava/lang/String;)[Lcom/intellij/psi/PsiReference;", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nRestAssuredReferencesContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestAssuredReferencesContributor.kt\ncom/intellij/microservices/jvm/restassured/RestAssuredReferencesContributorKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,158:1\n183#2,2:159\n*S KotlinDebug\n*F\n+ 1 RestAssuredReferencesContributor.kt\ncom/intellij/microservices/jvm/restassured/RestAssuredReferencesContributorKt\n*L\n123#1:159,2\n*E\n"})
public final class RestAssuredReferencesContributorKt {
    @NotNull
    private static final String REST_ASSURED = "io.restassured.RestAssured";
    @NotNull
    private static final String REQUEST_SENDER_OPTIONS = "io.restassured.specification.RequestSenderOptions";
    @NotNull
    private static final String REQUEST_SENDER = "io.restassured.specification.RequestSender";
    @NotNull
    private static final String REQUEST_SPECIFICATION = "io.restassured.specification.RequestSpecification";
    @NotNull
    private static final String FILTERABLE_REQUEST_SPECIFICATION = "io.restassured.specification.FilterableRequestSpecification";
    @NotNull
    private static final String VALIDATABLE_RESPONSE_OPTIONS = "io.restassured.response.ValidatableResponseOptions";
    @NotNull
    private static final String REQUEST_SPEC_BUILDER = "io.restassured.builder.RequestSpecBuilder";

    public static final void registerRestAssuredReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"head", (Object)"HEAD"), TuplesKt.to((Object)"get", (Object)"GET"), TuplesKt.to((Object)"post", (Object)"POST"), TuplesKt.to((Object)"put", (Object)"PUT"), TuplesKt.to((Object)"patch", (Object)"PATCH"), TuplesKt.to((Object)"delete", (Object)"DELETE"), TuplesKt.to((Object)"options", (Object)"OPTIONS")};
        Map methodMapping = MapsKt.mapOf((Pair[])pairArray);
        Object object = new String[]{REST_ASSURED, REQUEST_SENDER_OPTIONS, REQUEST_SENDER, REQUEST_SPECIFICATION};
        PsiMethodPattern psiMethodPattern = PsiJavaPatterns.psiMethod().definedInClass((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName((ElementPattern)StandardPatterns.string().oneOf((String[])object)));
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodPattern, (String)"definedInClass(...)");
        PsiMethodPattern methodOfRestAssured = psiMethodPattern;
        UExpressionPattern.Capture uExpr = UastPatterns.uExpression();
        for (Map.Entry elementPatternArray2 : methodMapping.entrySet()) {
            String methodName = (String)elementPatternArray2.getKey();
            String httpVerb = (String)elementPatternArray2.getValue();
            UastReferenceRegistrar.registerUastReferenceProvider$default((PsiReferenceRegistrar)registrar, (ElementPattern)((ElementPattern)uExpr.withStringRoomExpression((ElementPattern)uExpr.callParameter(0, (ElementPattern)UastPatterns.callExpression().withMethodName(methodName).withAnyResolvedMethod((ElementPattern)methodOfRestAssured)))), (UastReferenceProvider)((UastReferenceProvider)new UastUrlPathReferenceProvider((arg_0, arg_1) -> RestAssuredReferencesContributorKt.registerRestAssuredReferenceProviders$lambda$0(httpVerb, arg_0, arg_1))), (double)0.0, (int)4, null);
        }
        UastReferenceRegistrar.registerUastReferenceProvider$default((PsiReferenceRegistrar)registrar, (ElementPattern)((ElementPattern)uExpr.withUastParent((ElementPattern)UastPatterns.capture(UBinaryExpression.class).filter(RestAssuredReferencesContributorKt::registerRestAssuredReferenceProviders$lambda$1))), (UastReferenceProvider)((UastReferenceProvider)new UastUrlPathReferenceProvider(RestAssuredReferencesContributorKt::registerRestAssuredReferenceProviders$lambda$2)), (double)0.0, (int)4, null);
        ElementPattern[] elementPatternArray = new ElementPattern[2];
        UCallExpressionPattern uCallExpressionPattern = UastPatterns.callExpression().withMethodName("baseUri");
        PsiMethodPattern psiMethodPattern2 = PsiJavaPatterns.psiMethod().definedInClass(REQUEST_SPECIFICATION);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodPattern2, (String)"definedInClass(...)");
        elementPatternArray[0] = uExpr.callParameter(0, (ElementPattern)uCallExpressionPattern.withAnyResolvedMethod((ElementPattern)psiMethodPattern2));
        UCallExpressionPattern uCallExpressionPattern2 = UastPatterns.callExpression().withMethodName("setBaseUri");
        PsiMethodPattern psiMethodPattern3 = PsiJavaPatterns.psiMethod().definedInClass(REQUEST_SPEC_BUILDER);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodPattern3, (String)"definedInClass(...)");
        elementPatternArray[1] = uExpr.callParameter(0, (ElementPattern)uCallExpressionPattern2.withAnyResolvedMethod((ElementPattern)psiMethodPattern3));
        object = StandardPatterns.or((ElementPattern[])elementPatternArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"or(...)");
        UastReferenceRegistrar.registerUastReferenceProvider$default((PsiReferenceRegistrar)registrar, (ElementPattern)((ElementPattern)uExpr.withStringRoomExpression((ElementPattern)object)), (UastReferenceProvider)((UastReferenceProvider)new UastUrlPathReferenceProvider(RestAssuredReferencesContributorKt::registerRestAssuredReferenceProviders$lambda$3)), (double)0.0, (int)4, null);
        UastReferenceRegistrar.registerUastReferenceProvider$default((PsiReferenceRegistrar)registrar, (ElementPattern)((ElementPattern)uExpr.withStringRoomExpression((ElementPattern)uExpr.callParameter(1, (ElementPattern)UastPatterns.callExpression().withMethodName("request").withAnyResolvedMethod((ElementPattern)methodOfRestAssured)))), (UastReferenceProvider)((UastReferenceProvider)new UastUrlPathReferenceProvider(RestAssuredReferencesContributorKt::registerRestAssuredReferenceProviders$lambda$4)), (double)0.0, (int)4, null);
        UExpressionPattern uExpressionPattern = UastPatterns.injectionHostUExpression$default((boolean)false, (int)1, null);
        ElementPattern[] elementPatternArray2 = new ElementPattern[2];
        UCallExpressionPattern uCallExpressionPattern3 = UastPatterns.callExpression().withMethodName("contentType");
        String[] stringArray = new String[]{VALIDATABLE_RESPONSE_OPTIONS, REQUEST_SPECIFICATION, REQUEST_SPEC_BUILDER};
        PsiMethodPattern psiMethodPattern4 = PsiJavaPatterns.psiMethod().definedInClass((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName((ElementPattern)StandardPatterns.string().oneOf(stringArray)));
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodPattern4, (String)"definedInClass(...)");
        elementPatternArray2[0] = uCallExpressionPattern3.withAnyResolvedMethod((ElementPattern)psiMethodPattern4);
        UCallExpressionPattern uCallExpressionPattern4 = UastPatterns.callExpression().withMethodName("setContentType");
        PsiMethodPattern psiMethodPattern5 = PsiJavaPatterns.psiMethod().definedInClass((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName(REQUEST_SPEC_BUILDER));
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodPattern5, (String)"definedInClass(...)");
        elementPatternArray2[1] = uCallExpressionPattern4.withAnyResolvedMethod((ElementPattern)psiMethodPattern5);
        object = StandardPatterns.or((ElementPattern[])elementPatternArray2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"or(...)");
        UastReferenceRegistrar.registerUastReferenceProvider$default((PsiReferenceRegistrar)registrar, (ElementPattern)((ElementPattern)uExpressionPattern.callParameter(0, (ElementPattern)object)), (UastReferenceProvider)((UastReferenceProvider)new UastUrlPathReferenceProvider(RestAssuredReferencesContributorKt::registerRestAssuredReferenceProviders$lambda$5)), (double)0.0, (int)4, null);
    }

    private static final String inferRequestMethod(UExpression uElement) {
        UExpression parameter;
        Object v0;
        block2: {
            Sequence $this$firstOrNull$iv = SequencesKt.take((Sequence)UElementKt.getWithContainingElements((UElement)((UElement)uElement)), (int)2);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                UElement it = (UElement)element$iv;
                boolean bl = false;
                if (!(it instanceof UCallExpression && ((UCallExpression)it).isMethodNameOneOf((Collection)CollectionsKt.listOf((Object)"request")) && RestAssuredReferencesContributorKt.hasRequestReceiver((UCallExpression)it))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Object var3_7 = v0;
        UCallExpression uCallExpression = var3_7 instanceof UCallExpression ? (UCallExpression)var3_7 : null;
        if (uCallExpression == null) {
            return null;
        }
        UCallExpression call = uCallExpression;
        UExpression uExpression = parameter = call.getArgumentForParameter(0);
        return uExpression != null ? UastUtils.evaluateString((UExpression)uExpression) : null;
    }

    private static final boolean hasRequestReceiver(UCallExpression call) {
        PsiType psiType = call.getReceiverType();
        if (psiType == null) {
            return false;
        }
        PsiType type = psiType;
        return type.equalsToText(REST_ASSURED) || type.equalsToText(REQUEST_SENDER_OPTIONS) || type.equalsToText(REQUEST_SENDER) || type.equalsToText(REQUEST_SPECIFICATION) || type.equalsToText(FILTERABLE_REQUEST_SPECIFICATION);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isRestAssuredBaseUriAssign(UQualifiedReferenceExpression leftOperand) {
        PsiElement resolved = leftOperand.resolve();
        if (resolved == null) {
            return false;
        }
        if (!(resolved instanceof PsiField)) return false;
        PsiClass psiClass = ((PsiField)resolved).getContainingClass();
        if (!Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)REST_ASSURED)) return false;
        if (!Intrinsics.areEqual((Object)((PsiField)resolved).getName(), (Object)"baseURI")) return false;
        return true;
    }

    private static final PsiReference[] buildReferences(UExpression uElement, PsiElement host, String method) {
        UrlPathReferenceInjector injector = UastReferenceInjectorUtils.uastUrlPathReferenceInjectorForScheme((List)UrlConstants.HTTP_SCHEMES, (UrlPksParser)new UrlPksParser(null, null, false, 7, null)).withDefaultRootContextProviderFactory(arg_0 -> RestAssuredReferencesContributorKt.buildReferences$lambda$7(method, arg_0));
        return injector.buildAbsoluteOrRelativeReferences((Object)uElement, host);
    }

    private static final PsiReference[] registerRestAssuredReferenceProviders$lambda$0(String $httpVerb, UExpression uElement, PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)uElement, (String)"uElement");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return RestAssuredReferencesContributorKt.buildReferences(uElement, host, $httpVerb);
    }

    private static final boolean registerRestAssuredReferenceProviders$lambda$1(UBinaryExpression expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        UExpression leftOperand = expr.getLeftOperand();
        return Intrinsics.areEqual((Object)expr.getOperator(), (Object)UastBinaryOperator.ASSIGN) && leftOperand instanceof UQualifiedReferenceExpression && RestAssuredReferencesContributorKt.isRestAssuredBaseUriAssign((UQualifiedReferenceExpression)leftOperand);
    }

    private static final PsiReference[] registerRestAssuredReferenceProviders$lambda$2(UExpression uElement, PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)uElement, (String)"uElement");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        UrlPksParser parser = new UrlPksParser(null, null, false, 3, null);
        UrlPathReferenceInjector injector = UastReferenceInjectorUtils.uastUrlPathReferenceInjectorForScheme((List)UrlConstants.HTTP_SCHEMES, (UrlPksParser)parser);
        return injector.buildFullUrlReference((Object)uElement, host);
    }

    private static final PsiReference[] registerRestAssuredReferenceProviders$lambda$3(UExpression uElement, PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)uElement, (String)"uElement");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        UrlPksParser parser = new UrlPksParser(null, null, false, 3, null);
        UrlPathReferenceInjector injector = UastReferenceInjectorUtils.uastUrlPathReferenceInjectorForScheme((List)UrlConstants.HTTP_SCHEMES, (UrlPksParser)parser);
        return injector.buildFullUrlReference((Object)uElement, host);
    }

    private static final PsiReference[] registerRestAssuredReferenceProviders$lambda$4(UExpression uElement, PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)uElement, (String)"uElement");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        String httpVerb = RestAssuredReferencesContributorKt.inferRequestMethod(uElement);
        return RestAssuredReferencesContributorKt.buildReferences(uElement, host, httpVerb);
    }

    private static final PsiReference[] registerRestAssuredReferenceProviders$lambda$5(UExpression uExpression, PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)uExpression, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return MimeTypeReference.Companion.forElement(host);
    }

    private static final UrlPathContext buildReferences$lambda$7(String $method, UExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UrlPathContext.Companion.supportingSchemes(UrlConstants.HTTP_SCHEMES, $method);
    }
}

