# Package com.intellij.clouds.docker.gateway.ui

This package contains classes that describe the UI flow for running Dev Containers. The flow can be initiated from several entry points:

* _Gateway_
* _Welcome Screen_ via the _Remote Development / Dev Containers_ menu item
* _Show Dev Containers_ action
* Dev Containers actions in the _Services_ tool window

## Implementation Notes

Let's examine one of the typical scenarios:

### Prerequisites

- `open.docker.projects.using.eel` is set to `false` (default value at the time of writing)
- `devcontainers.use.separate.project.panel` feature flag is enabled. While this flag is disabled by default, it is commonly required for
  testing purposes or recommended to users with specific IDE backend version requirements.

### Scenario Flow

1. The IDE starts
2. A project opens
3. `MODAL` _Show Dev Containers_ action is triggered:
    - Executes `com.intellij.clouds.docker.gateway.actions.ShowRecentDevcontainersAction`
    - Displays `com.jetbrains.gateway.actions.OpenRemoteDevelopmentWelcomeScreenAction.RemoteDevelopmentWelcomeScreen`
4. `MODAL` _New Dev Container_ button is clicked:
    - Creates `com.intellij.clouds.docker.gateway.ui.DevcontainerGatewayDeployView` with a single panel:
        - `com.intellij.clouds.docker.gateway.ui.stages.setup.DevcontainerSetupBuildContextStagePanel`
    - Replaces the current `RemoteDevelopmentWelcomeScreen` dialog content with
      `com.intellij.clouds.docker.gateway.ui.DevcontainerGatewayDeployView.component`
5. `ASYNC` Dev Container builds in the _Services_ tool window via
   `com.intellij.clouds.docker.gateway.deploy.DevcontainerInServiceViewGatewayBuilder`
6. Displays the `com.intellij.clouds.docker.gateway.ui.utils.DevcontainersMultistagePanelDialog.DevcontainersMultistagePanelDialog` with
   a single panel for IDE backend selection:
   - `com.intellij.clouds.docker.gateway.ui.stages.DevcontainerLocateRemoteProjectPanel`
7. User clicks _Start IDE and Connect_
8. `ASYNC` IDE deploys to the Dev Container with progress shown in the _Services_ tool window
9. Shows notification: _Dev Container build is finished..._ with a _Connect_ link
10. When the _Connect_ link is clicked, executes the `createConnectionNotificationIfNeededOrConnect` function
    in [DevcontainerInServiceViewBuilder.kt](../deploy/DevcontainerInServiceViewBuilder.kt)