"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Schemas = void 0;
var react_1 = __importDefault(require("react"));
var Schema_1 = require("./Schema");
var contexts_1 = require("../../contexts");
var helpers_1 = require("../../helpers");
var constants_1 = require("../../constants");
var Schemas = function () {
    var asyncapi = (0, contexts_1.useSpec)();
    var config = (0, contexts_1.useConfig)();
    var schemas = !asyncapi.components().isEmpty() && asyncapi.components().schemas().all();
    if (!schemas || schemas.length === 0) {
        return null;
    }
    return (react_1.default.createElement("section", { id: "".concat(helpers_1.CommonHelpers.getIdentifier('schemas', config)), className: "mt-16" },
        react_1.default.createElement("h2", { className: "2xl:w-7/12 text-3xl font-light mb-4 px-8" }, constants_1.SCHEMAS_TEXT),
        react_1.default.createElement("ul", null, schemas.map(function (schema) { return (react_1.default.createElement("li", { className: "mb-4", key: schema.id(), id: helpers_1.CommonHelpers.getIdentifier("schema-".concat(schema.id()), config) },
            react_1.default.createElement(Schema_1.Schema, { schemaName: schema.id(), schema: schema }))); }))));
};
exports.Schemas = Schemas;
//# sourceMappingURL=Schemas.js.map