/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.requests;

import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutor;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutorHelper;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResult;
import com.jetbrains.rdclient.requests.FrontendRebaseSession;
import com.jetbrains.rdclient.requests.SpeculativeRequest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0004H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0007\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0013R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rdclient/requests/SpeculativeRequestWrapper;", "Lcom/jetbrains/rdclient/requests/SpeculativeRequest;", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "uniqueId", "", "request", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "backendChangeMarker", "sendDelegate", "Lkotlin/Function1;", "", "<init>", "(JLcom/jetbrains/rdclient/requests/FrontendAsyncRequest;JLkotlin/jvm/functions/Function1;)V", "getUniqueId", "()J", "getRequest", "()Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "getBackendChangeMarker", "setBackendChangeMarker", "(J)V", "getSendDelegate", "()Lkotlin/jvm/functions/Function1;", "rollback", "virtually", "", "context", "replay", "send", "globalRetryTimestamp", "toString", "", "intellij.rd.client"})
public final class SpeculativeRequestWrapper
implements SpeculativeRequest<FrontendRebaseSession> {
    private final long uniqueId;
    @NotNull
    private final FrontendAsyncRequest request;
    private long backendChangeMarker;
    @NotNull
    private final Function1<Long, Unit> sendDelegate;

    public SpeculativeRequestWrapper(long uniqueId, @NotNull FrontendAsyncRequest request, long backendChangeMarker, @NotNull Function1<? super Long, Unit> sendDelegate) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(sendDelegate, (String)"sendDelegate");
        this.uniqueId = uniqueId;
        this.request = request;
        this.backendChangeMarker = backendChangeMarker;
        this.sendDelegate = sendDelegate;
        boolean bl2 = bl = this.getUniqueId() == this.request.getId();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Expected id: " + this.getUniqueId() + ", got " + this.request.getId();
            throw new AssertionError((Object)string);
        }
    }

    @Override
    public long getUniqueId() {
        return this.uniqueId;
    }

    @NotNull
    public final FrontendAsyncRequest getRequest() {
        return this.request;
    }

    public final long getBackendChangeMarker() {
        return this.backendChangeMarker;
    }

    public final void setBackendChangeMarker(long l) {
        this.backendChangeMarker = l;
    }

    @NotNull
    public final Function1<Long, Unit> getSendDelegate() {
        return this.sendDelegate;
    }

    @Override
    public void rollback(boolean virtually, @NotNull FrontendRebaseSession context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!virtually) {
            FrontendAsyncRequestExecutor.RebaseListener rebaseListener = FrontendAsyncRequestExecutorHelper.INSTANCE.getRebaseListener();
            if (rebaseListener != null) {
                rebaseListener.undo(this.request);
            }
        }
        if (this.request instanceof FrontendAsyncRequestWithImmediateResult) {
            ((FrontendAsyncRequestWithImmediateResult)this.request).undo(context, virtually);
        } else {
            this.request.undo(context);
        }
    }

    @Override
    public void replay(boolean virtually, @NotNull FrontendRebaseSession context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!virtually) {
            FrontendAsyncRequestExecutor.RebaseListener rebaseListener = FrontendAsyncRequestExecutorHelper.INSTANCE.getRebaseListener();
            if (rebaseListener != null) {
                rebaseListener.redo();
            }
        }
        if (this.request instanceof FrontendAsyncRequestWithImmediateResult) {
            ((FrontendAsyncRequestWithImmediateResult)this.request).redo(context, virtually);
        } else {
            this.request.redo(context);
        }
    }

    @Override
    public void send(long globalRetryTimestamp) {
        this.sendDelegate.invoke((Object)globalRetryTimestamp);
    }

    @NotNull
    public String toString() {
        return "SpeculativeRequestWrapper#" + this.getUniqueId() + "(request=" + this.request + ", backendChangeMarker=" + this.backendChangeMarker + ")";
    }
}

