/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.connectivity.ex.dataSource.artifacts;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.ui.DriverEelOptionProvider;
import com.intellij.platform.eel.path.EelPath;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/connectivity/ex/dataSource/artifacts/DatabaseArtifactDriverContext;", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactContext;", "delegate", "driver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "<init>", "(Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactContext;Lcom/intellij/database/dataSource/DatabaseDriver;)V", "useEelForDriver", "", "createContextForDriver", "getDownloadPath", "Ljava/nio/file/Path;", "useEel", "isApplicable", "item", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$Item;", "arch", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$Item$Arch;", "os", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$Item$OS;", "getUserHome", "Lcom/intellij/platform/eel/path/EelPath;", "getNativeLibsRoot", "intellij.database.connectivity.ex"})
public final class DatabaseArtifactDriverContext
implements DatabaseArtifactContext {
    @NotNull
    private final DatabaseArtifactContext delegate;
    private final boolean useEelForDriver;

    public DatabaseArtifactDriverContext(@NotNull DatabaseArtifactContext delegate, @NotNull DatabaseDriver driver) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        this.delegate = delegate;
        Boolean bl = (Boolean)DbOptionProvider.getOptionValue((Object)driver, DriverEelOptionProvider.class);
        this.useEelForDriver = bl != null ? bl : true;
    }

    @NotNull
    public DatabaseArtifactContext createContextForDriver(@NotNull DatabaseDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return new DatabaseArtifactDriverContext(this.delegate, driver);
    }

    @NotNull
    public Path getDownloadPath() {
        return this.delegate.getDownloadPath();
    }

    public boolean useEel() {
        return this.delegate.useEel() && this.useEelForDriver;
    }

    public boolean isApplicable(@NotNull DatabaseArtifactList.Item item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return this.delegate.isApplicable(item);
    }

    public boolean isApplicable(@NotNull DatabaseArtifactList.Item.Arch arch) {
        Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
        return this.delegate.isApplicable(arch);
    }

    public boolean isApplicable(@NotNull DatabaseArtifactList.Item.OS os) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        return this.delegate.isApplicable(os);
    }

    @Nullable
    public EelPath getUserHome() {
        return this.delegate.getUserHome();
    }

    @NotNull
    public Path getNativeLibsRoot() {
        return this.delegate.getNativeLibsRoot();
    }
}

