/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.connectivity.ex.dataSource.artifacts;

import com.intellij.database.connectivity.ex.dataSource.artifacts.DatabaseArtifactDriverContext;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactDefaultContext;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.run.EelDatabaseHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0007H\u0016J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000b\u001a\u0004\b\u0011\u0010\u0012R#\u0010\u0014\u001a\n \u0010*\u0004\u0018\u00010\u00150\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000b\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Lcom/intellij/database/connectivity/ex/dataSource/artifacts/DatabaseArtifactProjectContext;", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactDefaultContext;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "eelDownloadPath", "Ljava/nio/file/Path;", "getEelDownloadPath", "()Ljava/nio/file/Path;", "eelDownloadPath$delegate", "Lkotlin/Lazy;", "eelDescriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "eelPlatform", "Lcom/intellij/platform/eel/EelPlatform;", "kotlin.jvm.PlatformType", "getEelPlatform", "()Lcom/intellij/platform/eel/EelPlatform;", "eelPlatform$delegate", "home", "Lcom/intellij/platform/eel/path/EelPath;", "getHome", "()Lcom/intellij/platform/eel/path/EelPath;", "home$delegate", "createContextForDriver", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactContext;", "driver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "getUserHome", "useEel", "", "getDownloadPath", "isApplicable", "arch", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$Item$Arch;", "os", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$Item$OS;", "getNativeLibsRoot", "intellij.database.connectivity.ex"})
@SourceDebugExtension(value={"SMAP\nDatabaseArtifactProjectContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseArtifactProjectContext.kt\ncom/intellij/database/connectivity/ex/dataSource/artifacts/DatabaseArtifactProjectContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public class DatabaseArtifactProjectContext
extends DatabaseArtifactDefaultContext {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy eelDownloadPath$delegate;
    @NotNull
    private final EelDescriptor eelDescriptor;
    @NotNull
    private final Lazy eelPlatform$delegate;
    @NotNull
    private final Lazy home$delegate;

    public DatabaseArtifactProjectContext(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.eelDownloadPath$delegate = LazyKt.lazy(() -> DatabaseArtifactProjectContext.eelDownloadPath_delegate$lambda$0(this));
        this.eelDescriptor = EelProviderUtil.getEelDescriptor((Project)this.project);
        this.eelPlatform$delegate = LazyKt.lazy(() -> DatabaseArtifactProjectContext.eelPlatform_delegate$lambda$0(this));
        this.home$delegate = LazyKt.lazy(() -> DatabaseArtifactProjectContext.home_delegate$lambda$0(this));
    }

    private final Path getEelDownloadPath() {
        Lazy lazy = this.eelDownloadPath$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Path)object;
    }

    private final EelPlatform getEelPlatform() {
        Lazy lazy = this.eelPlatform$delegate;
        return (EelPlatform)lazy.getValue();
    }

    private final EelPath getHome() {
        Lazy lazy = this.home$delegate;
        return (EelPath)lazy.getValue();
    }

    @NotNull
    public DatabaseArtifactContext createContextForDriver(@NotNull DatabaseDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return new DatabaseArtifactDriverContext((DatabaseArtifactContext)this, driver);
    }

    @Nullable
    public EelPath getUserHome() {
        return this.getHome();
    }

    public boolean useEel() {
        return Registry.Companion.is("databases.use.eel") && !(this.eelDescriptor instanceof LocalEelDescriptor);
    }

    @NotNull
    public Path getDownloadPath() {
        return this.useEel() ? this.getEelDownloadPath() : super.getDownloadPath();
    }

    public boolean isApplicable(@NotNull DatabaseArtifactList.Item.Arch arch) {
        Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
        if (!this.useEel()) {
            return super.isApplicable(arch);
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[arch.ordinal()]) {
            case 1 -> Intrinsics.areEqual((Object)this.getEelPlatform().getArch(), (Object)EelPlatform.Arch.ARM_32.INSTANCE);
            case 2 -> Intrinsics.areEqual((Object)this.getEelPlatform().getArch(), (Object)EelPlatform.Arch.ARM_64.INSTANCE);
            case 3 -> Intrinsics.areEqual((Object)this.getEelPlatform().getArch(), (Object)EelPlatform.Arch.X86_64.INSTANCE);
            case 4 -> Intrinsics.areEqual((Object)this.getEelPlatform().getArch(), (Object)EelPlatform.Arch.X86.INSTANCE);
            case 5 -> true;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public boolean isApplicable(@NotNull DatabaseArtifactList.Item.OS os) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        if (!this.useEel()) {
            return super.isApplicable(os);
        }
        return switch (WhenMappings.$EnumSwitchMapping$1[os.ordinal()]) {
            case 1 -> {
                EelPlatform v0 = this.getEelPlatform();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"<get-eelPlatform>(...)");
                yield EelPlatformKt.isMac((EelPlatform)v0);
            }
            case 2 -> {
                EelPlatform v2 = this.getEelPlatform();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"<get-eelPlatform>(...)");
                yield EelPlatformKt.isLinux((EelPlatform)v2);
            }
            case 3 -> {
                EelPlatform v3 = this.getEelPlatform();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"<get-eelPlatform>(...)");
                yield EelPlatformKt.isWindows((EelPlatform)v3);
            }
            case 4 -> true;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public Path getNativeLibsRoot() {
        return EelDatabaseHelper.INSTANCE.getNativeLibsRoot(this.project);
    }

    private static final Path eelDownloadPath_delegate$lambda$0(DatabaseArtifactProjectContext this$0) {
        return (Path)ApplicationManager.getApplication().executeOnPooledThread(() -> DatabaseArtifactProjectContext.eelDownloadPath_delegate$lambda$0$0(this$0)).get();
    }

    private static final Path eelDownloadPath_delegate$lambda$0$0(DatabaseArtifactProjectContext this$0) {
        Path path;
        Path it = path = EelPathUtils.getSystemFolder((Project)this$0.project).resolve("jdbc-drivers");
        boolean bl = false;
        if (Files.notExists(it, new LinkOption[0])) {
            Files.createDirectories(it, new FileAttribute[0]);
        }
        return path;
    }

    private static final EelPlatform eelPlatform_delegate$lambda$0(DatabaseArtifactProjectContext this$0) {
        return (EelPlatform)ApplicationManager.getApplication().executeOnPooledThread(() -> DatabaseArtifactProjectContext.eelPlatform_delegate$lambda$0$0(this$0)).get();
    }

    private static final EelPlatform eelPlatform_delegate$lambda$0$0(DatabaseArtifactProjectContext this$0) {
        return EelProviderUtil.toEelApiBlocking((EelDescriptor)this$0.eelDescriptor).getPlatform();
    }

    private static final EelPath home_delegate$lambda$0(DatabaseArtifactProjectContext this$0) {
        return (EelPath)ApplicationManager.getApplication().executeOnPooledThread(() -> DatabaseArtifactProjectContext.home_delegate$lambda$0$0(this$0)).get();
    }

    private static final EelPath home_delegate$lambda$0$0(DatabaseArtifactProjectContext this$0) {
        return EelProviderUtil.toEelApiBlocking((EelDescriptor)this$0.eelDescriptor).getUserInfo().getHome();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DatabaseArtifactList.Item.Arch.values().length];
            try {
                nArray[DatabaseArtifactList.Item.Arch.ARM32.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseArtifactList.Item.Arch.ARM64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseArtifactList.Item.Arch.X86_64.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseArtifactList.Item.Arch.X86.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseArtifactList.Item.Arch.ANY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DatabaseArtifactList.Item.OS.values().length];
            try {
                nArray[DatabaseArtifactList.Item.OS.MAC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseArtifactList.Item.OS.LINUX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseArtifactList.Item.OS.WIN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseArtifactList.Item.OS.ANY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

