/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath.ui;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.find.FindBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.json.JsonFileType;
import com.intellij.json.psi.JsonFile;
import com.intellij.jsonpath.JsonPathBundle;
import com.intellij.jsonpath.JsonPathFileType;
import com.intellij.jsonpath.ui.EvaluateResult;
import com.intellij.jsonpath.ui.IncorrectDocument;
import com.intellij.jsonpath.ui.IncorrectExpression;
import com.intellij.jsonpath.ui.JsonPathEvaluateManager;
import com.intellij.jsonpath.ui.JsonPathEvaluator;
import com.intellij.jsonpath.ui.ResultNotFound;
import com.intellij.jsonpath.ui.ResultString;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\b\b \u0018\u0000 B2\u00020\u00012\u00020\u0002:\u0005BCDEFB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010$\u001a\u00020%H\u0004J\n\u0010&\u001a\u0004\u0018\u00010'H$J\b\u0010(\u001a\u00020%H\u0004J\u0010\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020+H\u0002J \u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0004J\u000e\u00103\u001a\u00020%2\u0006\u00104\u001a\u00020.J\u0010\u00105\u001a\u00020%2\u0006\u00106\u001a\u00020.H\u0002J\u0010\u00107\u001a\u00020%2\u0006\u00108\u001a\u00020.H\u0002J\b\u00109\u001a\u00020%H\u0002J\b\u0010:\u001a\u00020%H\u0016J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020.0<H\u0002J\u0016\u0010=\u001a\u00020%2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020.0?H\u0002J\u0010\u0010@\u001a\u00020%2\u0006\u0010A\u001a\u00020.H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/intellij/jsonpath/ui/JsonPathEvaluateView;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "searchTextField", "Lcom/intellij/ui/EditorTextField;", "getSearchTextField", "()Lcom/intellij/ui/EditorTextField;", "searchWrapper", "Ljavax/swing/JPanel;", "getSearchWrapper", "()Ljavax/swing/JPanel;", "searchComponent", "Ljavax/swing/JComponent;", "getSearchComponent", "()Ljavax/swing/JComponent;", "resultWrapper", "Lcom/intellij/ui/components/JBPanelWithEmptyText;", "getResultWrapper", "()Lcom/intellij/ui/components/JBPanelWithEmptyText;", "resultLabel", "Lcom/intellij/ui/components/JBLabel;", "resultEditor", "Lcom/intellij/openapi/editor/Editor;", "errorOutputArea", "Lcom/intellij/ui/components/JBTextArea;", "errorOutputContainer", "Ljavax/swing/JScrollPane;", "evalOptions", "", "Lcom/jayway/jsonpath/Option;", "initToolbar", "", "getJsonFile", "Lcom/intellij/json/psi/JsonFile;", "resetExpressionHighlighting", "fillToolbarOptions", "group", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "initJsonEditor", "fileName", "", "isViewer", "", "kind", "Lcom/intellij/openapi/editor/EditorKind;", "setExpression", "jsonPathExpr", "setResult", "result", "setError", "error", "evaluate", "dispose", "getExpressionHistory", "", "setExpressionHistory", "history", "", "addJSONPathToHistory", "path", "Companion", "OutputOptionAction", "OptionToggleAction", "SearchHistoryButton", "ShowHistoryAction", "intellij.jsonpath"})
public abstract class JsonPathEvaluateView
extends SimpleToolWindowPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final EditorTextField searchTextField;
    @NotNull
    private final JPanel searchWrapper;
    @NotNull
    private final JBPanelWithEmptyText resultWrapper;
    @NotNull
    private final JBLabel resultLabel;
    @NotNull
    private final Editor resultEditor;
    @NotNull
    private final JBTextArea errorOutputArea;
    @NotNull
    private final JScrollPane errorOutputContainer;
    @NotNull
    private final Set<Option> evalOptions;

    public JsonPathEvaluateView(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(true, true);
        Object object = this.project = project;
        JsonPathFileType jsonPathFileType = JsonPathFileType.INSTANCE;
        this.searchTextField = new EditorTextField(this, (Project)object, jsonPathFileType){
            final /* synthetic */ JsonPathEvaluateView this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, (FileType)$super_call_param$2);
            }

            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                KeyEvent keyEvent = e;
                boolean bl = keyEvent != null ? keyEvent.getKeyCode() == 10 : false;
                if (bl && pressed) {
                    JsonPathEvaluateView.access$evaluate(this.this$0);
                    return true;
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }

            protected EditorEx createEditor() {
                EditorEx editorEx = super.createEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"createEditor(...)");
                EditorEx editor = editorEx;
                editor.setBorder((Border)JBUI.Borders.empty());
                editor.getComponent().setBorder((Border)JBUI.Borders.empty((int)4, (int)0, (int)3, (int)6));
                editor.getComponent().setOpaque(false);
                editor.setBackgroundColor(UIUtil.getTextFieldBackground());
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile((Document)editor.getDocument());
                if (psiFile != null) {
                    psiFile.putUserData(JsonPathEvaluateManager.JSON_PATH_EVALUATE_EXPRESSION_KEY, (Object)true);
                    psiFile.putUserData(JsonPathEvaluateManager.JSON_PATH_EVALUATE_SOURCE_KEY, () -> JsonPathEvaluateView.access$getJsonFile(this.this$0));
                }
                return editor;
            }
        };
        object = new BorderLayout();
        this.searchWrapper = (JPanel)new NonOpaquePanel((BorderLayout)object){

            public void updateUI() {
                super.updateUI();
                this.setBackground(UIUtil.getTextFieldBackground());
            }
        };
        this.resultWrapper = new JBPanelWithEmptyText((LayoutManager)new BorderLayout());
        this.resultLabel = new JBLabel(JsonPathBundle.message("jsonpath.evaluate.result", new Object[0]));
        this.resultEditor = this.initJsonEditor("result.json", true, EditorKind.PREVIEW);
        this.errorOutputArea = new JBTextArea();
        this.errorOutputContainer = (JScrollPane)new JBScrollPane((Component)this.errorOutputArea);
        this.evalOptions = new LinkedHashSet();
        this.resultEditor.putUserData(JsonPathEvaluateManager.JSON_PATH_EVALUATE_RESULT_KEY, (Object)true);
        this.resultEditor.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)0, (int)0));
        this.resultLabel.setBorder((Border)JBUI.Borders.empty((int)3, (int)6));
        this.resultWrapper.getEmptyText().setText(JsonPathBundle.message("jsonpath.evaluate.no.result", new Object[0]));
        this.errorOutputContainer.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)0, (int)0));
        SearchHistoryButton historyButton = new SearchHistoryButton((AnAction)new ShowHistoryAction(), false);
        NonOpaquePanel historyButtonWrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
        historyButtonWrapper.setBorder((Border)JBUI.Borders.empty((int)3, (int)6));
        historyButtonWrapper.add((Component)((Object)historyButton), (Object)"North");
        this.searchTextField.setFontInheritedFromLAF(false);
        this.searchWrapper.add((Component)historyButtonWrapper, "West");
        this.searchWrapper.add((Component)this.searchTextField, "Center");
        this.searchWrapper.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
        this.searchWrapper.setOpaque(true);
        this.errorOutputArea.setEditable(false);
        this.errorOutputArea.setWrapStyleWord(true);
        this.errorOutputArea.setLineWrap(true);
        this.errorOutputArea.setBorder(JBUI.Borders.empty((int)10));
        this.setExpression("$..*");
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final EditorTextField getSearchTextField() {
        return this.searchTextField;
    }

    @NotNull
    protected final JPanel getSearchWrapper() {
        return this.searchWrapper;
    }

    @NotNull
    public final JComponent getSearchComponent() {
        return (JComponent)this.searchTextField;
    }

    @NotNull
    protected final JBPanelWithEmptyText getResultWrapper() {
        return this.resultWrapper;
    }

    protected final void initToolbar() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        this.fillToolbarOptions(actionGroup);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("JsonPathEvaluateToolbar", (ActionGroup)actionGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setTargetComponent((JComponent)((Object)this));
        this.setToolbar(toolbar.getComponent());
    }

    @Nullable
    protected abstract JsonFile getJsonFile();

    protected final void resetExpressionHighlighting() {
        PsiFile jsonPathFile = PsiDocumentManager.getInstance((Project)this.project).getPsiFile(this.searchTextField.getDocument());
        if (jsonPathFile != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.project).restart(jsonPathFile, (Object)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void fillToolbarOptions(DefaultActionGroup group) {
        void $this$fillToolbarOptions_u24lambda_u240;
        DefaultActionGroup defaultActionGroup;
        ComboBoxAction outputComboBox2 = new ComboBoxAction(this){
            final /* synthetic */ JsonPathEvaluateView this$0;
            {
                this.this$0 = $receiver;
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            protected DefaultActionGroup createPopupActionGroup(JComponent button, DataContext context) {
                Intrinsics.checkNotNullParameter((Object)button, (String)"button");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                DefaultActionGroup outputItems = new DefaultActionGroup();
                String string = JsonPathBundle.message("jsonpath.evaluate.output.values", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                outputItems.add((AnAction)this.this$0.new OutputOptionAction(false, string));
                String string2 = JsonPathBundle.message("jsonpath.evaluate.output.paths", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                outputItems.add((AnAction)this.this$0.new OutputOptionAction(true, string2));
                return outputItems;
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
                Presentation presentation2 = presentation;
                if (e.getProject() == null) {
                    return;
                }
                presentation2.setText(JsonPathEvaluateView.access$getEvalOptions$p(this.this$0).contains((Object)((Object)Option.AS_PATH_LIST)) ? JsonPathBundle.message("jsonpath.evaluate.output.paths", new Object[0]) : JsonPathBundle.message("jsonpath.evaluate.output.values", new Object[0]));
            }

            public JComponent createCustomComponent(Presentation presentation, String place) {
                Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
                Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                JPanel panel = new JPanel(new GridBagLayout());
                panel.add((Component)new JLabel(JsonPathBundle.message("jsonpath.evaluate.output.option", new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, (Insets)JBUI.insetsLeft((int)5), 0, 0));
                panel.add((Component)super.createCustomComponent(presentation, place), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, (Insets)JBInsets.emptyInsets(), 0, 0));
                return panel;
            }
        };
        group.add((AnAction)outputComboBox2);
        DefaultActionGroup defaultActionGroup2 = defaultActionGroup = new DefaultActionGroup(JsonPathBundle.message("jsonpath.evaluate.options", new Object[0]), true);
        DefaultActionGroup defaultActionGroup3 = group;
        boolean bl = false;
        $this$fillToolbarOptions_u24lambda_u240.getTemplatePresentation().setIcon(AllIcons.General.Settings);
        String string = JsonPathBundle.message("jsonpath.evaluate.suppress.exceptions", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$fillToolbarOptions_u24lambda_u240.add((AnAction)new OptionToggleAction(Option.SUPPRESS_EXCEPTIONS, string));
        String string2 = JsonPathBundle.message("jsonpath.evaluate.return.list", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$fillToolbarOptions_u24lambda_u240.add((AnAction)new OptionToggleAction(Option.ALWAYS_RETURN_LIST, string2));
        String string3 = JsonPathBundle.message("jsonpath.evaluate.nullize.missing.leaf", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$fillToolbarOptions_u24lambda_u240.add((AnAction)new OptionToggleAction(Option.DEFAULT_PATH_LEAF_TO_NULL, string3));
        String string4 = JsonPathBundle.message("jsonpath.evaluate.require.all.properties", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        $this$fillToolbarOptions_u24lambda_u240.add((AnAction)new OptionToggleAction(Option.REQUIRE_PROPERTIES, string4));
        defaultActionGroup3.add((AnAction)defaultActionGroup);
    }

    @NotNull
    protected final Editor initJsonEditor(@NotNull String fileName, boolean isViewer, @NotNull EditorKind kind) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        LightVirtualFile sourceVirtualFile = new LightVirtualFile(fileName, (FileType)JsonFileType.INSTANCE, (CharSequence)"");
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile((VirtualFile)sourceVirtualFile);
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile sourceFile = psiFile;
        Document document = PsiDocumentManager.getInstance((Project)this.project).getDocument(sourceFile);
        Intrinsics.checkNotNull((Object)document);
        Document document2 = document;
        Editor editor = EditorFactory.getInstance().createEditor(document2, this.project, (VirtualFile)sourceVirtualFile, isViewer, kind);
        editor.getSettings().setLineNumbersShown(false);
        Intrinsics.checkNotNull((Object)editor);
        return editor;
    }

    public final void setExpression(@NotNull String jsonPathExpr) {
        Intrinsics.checkNotNullParameter((Object)jsonPathExpr, (String)"jsonPathExpr");
        this.searchTextField.setText(jsonPathExpr);
    }

    private final void setResult(String result) {
        WriteAction.run(() -> JsonPathEvaluateView.setResult$lambda$0(this, result));
        Component[] componentArray = this.resultWrapper.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        if (!ArraysKt.contains((Object[])componentArray, (Object)this.resultEditor.getComponent())) {
            this.resultWrapper.removeAll();
            this.resultWrapper.add((Component)this.resultLabel, (Object)"North");
            this.resultWrapper.add((Component)this.resultEditor.getComponent(), (Object)"Center");
            this.resultWrapper.revalidate();
            this.resultWrapper.repaint();
        }
        this.resultEditor.getCaretModel().moveToOffset(0);
    }

    private final void setError(String error) {
        this.errorOutputArea.setText(error);
        Component[] componentArray = this.resultWrapper.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        if (!ArraysKt.contains((Object[])componentArray, (Object)this.errorOutputArea)) {
            this.resultWrapper.removeAll();
            this.resultWrapper.add((Component)this.resultLabel, (Object)"North");
            this.resultWrapper.add((Component)this.errorOutputContainer, (Object)"Center");
            this.resultWrapper.revalidate();
            this.resultWrapper.repaint();
        }
    }

    private final void evaluate() {
        EvaluateResult result;
        JsonFile jsonFile = this.getJsonFile();
        String string = this.searchTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        JsonPathEvaluator evaluator = new JsonPathEvaluator(jsonFile, string, this.evalOptions);
        EvaluateResult evaluateResult = result = evaluator.evaluate();
        if (evaluateResult instanceof IncorrectExpression) {
            this.setError(((IncorrectExpression)result).getMessage());
        } else if (evaluateResult instanceof IncorrectDocument) {
            this.setError(((IncorrectDocument)result).getMessage());
        } else if (evaluateResult instanceof ResultNotFound) {
            this.setError(((ResultNotFound)result).getMessage());
        } else if (evaluateResult instanceof ResultString) {
            this.setResult(((ResultString)result).getValue());
        }
        if (result != null && !(result instanceof IncorrectExpression)) {
            String string2 = this.searchTextField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            this.addJSONPathToHistory(((Object)StringsKt.trim((CharSequence)string2)).toString());
        }
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor(this.resultEditor);
    }

    private final List<String> getExpressionHistory() {
        char[] cArray;
        Object object = PropertiesComponent.getInstance().getValue("JSONPathEvaluateHistory");
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])(cArray = new char[]{'\n'}), (boolean)false, (int)0, (int)6, null)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final void setExpressionHistory(Collection<String> history) {
        PropertiesComponent.getInstance().setValue("JSONPathEvaluateHistory", CollectionsKt.joinToString$default((Iterable)history, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
    }

    private final void addJSONPathToHistory(String path) {
        if (StringsKt.isBlank((CharSequence)path)) {
            return;
        }
        ArrayDeque history = new ArrayDeque((Collection)this.getExpressionHistory());
        if (!history.contains((Object)path)) {
            history.addFirst((Object)path);
            if (history.size() > 10) {
                history.removeLast();
            }
            this.setExpressionHistory((Collection)history);
        } else {
            if (Intrinsics.areEqual((Object)history.firstOrNull(), (Object)path)) {
                return;
            }
            history.remove((Object)path);
            history.addFirst((Object)path);
            this.setExpressionHistory((Collection)history);
        }
    }

    private static final void setResult$lambda$0(JsonPathEvaluateView this$0, String $result) {
        this$0.resultEditor.getDocument().setText((CharSequence)$result);
        PsiDocumentManager.getInstance((Project)this$0.project).commitDocument(this$0.resultEditor.getDocument());
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this$0.project).getPsiFile(this$0.resultEditor.getDocument());
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile psiFile2 = psiFile;
        new ReformatCodeProcessor(psiFile2, false).run();
    }

    public static final /* synthetic */ JsonFile access$getJsonFile(JsonPathEvaluateView $this) {
        return $this.getJsonFile();
    }

    static {
        Configuration.setDefaults(new Configuration.Defaults(){
            private final JacksonJsonProvider jsonProvider;
            private final JacksonMappingProvider mappingProvider;
            {
                this.jsonProvider = new JacksonJsonProvider();
                this.mappingProvider = new JacksonMappingProvider();
            }

            public JacksonJsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            public JacksonMappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            public EnumSet<Option> options() {
                EnumSet<Option> enumSet = EnumSet.noneOf(Option.class);
                Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(...)");
                return enumSet;
            }
        });
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/jsonpath/ui/JsonPathEvaluateView$Companion;", "", "<init>", "()V", "intellij.jsonpath"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jsonpath/ui/JsonPathEvaluateView$OptionToggleAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "option", "Lcom/jayway/jsonpath/Option;", "message", "", "<init>", "(Lcom/intellij/jsonpath/ui/JsonPathEvaluateView;Lcom/jayway/jsonpath/Option;Ljava/lang/String;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.jsonpath"})
    private final class OptionToggleAction
    extends ToggleAction {
        @NotNull
        private final Option option;

        public OptionToggleAction(@NlsActions.ActionText @NotNull Option option, String message) {
            Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
            this.option = option;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return JsonPathEvaluateView.this.evalOptions.contains((Object)this.option);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            boolean bl = state ? JsonPathEvaluateView.this.evalOptions.add(this.option) : JsonPathEvaluateView.this.evalOptions.remove((Object)this.option);
            JsonPathEvaluateView.this.evaluate();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/jsonpath/ui/JsonPathEvaluateView$OutputOptionAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "enablePaths", "", "message", "", "<init>", "(Lcom/intellij/jsonpath/ui/JsonPathEvaluateView;ZLjava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.jsonpath"})
    private final class OutputOptionAction
    extends DumbAwareAction {
        private final boolean enablePaths;

        public OutputOptionAction(@NlsActions.ActionText @NotNull boolean enablePaths, String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
            this.enablePaths = enablePaths;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            boolean bl = this.enablePaths ? JsonPathEvaluateView.this.evalOptions.add(Option.AS_PATH_LIST) : JsonPathEvaluateView.this.evalOptions.remove((Object)Option.AS_PATH_LIST);
            JsonPathEvaluateView.this.evaluate();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jsonpath/ui/JsonPathEvaluateView$SearchHistoryButton;", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "focusable", "", "<init>", "(Lcom/intellij/openapi/actionSystem/AnAction;Z)V", "getDataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getPopState", "", "getIcon", "Ljavax/swing/Icon;", "intellij.jsonpath"})
    private static final class SearchHistoryButton
    extends ActionButton {
        public SearchHistoryButton(@NotNull AnAction action, boolean focusable) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            super(action, action.getTemplatePresentation().clone(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            this.setLook(ActionButtonLook.INPLACE_LOOK);
            this.setFocusable(focusable);
            this.updateIcon();
        }

        @NotNull
        protected DataContext getDataContext() {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            return dataContext;
        }

        public int getPopState() {
            return this.isSelected() ? 2 : super.getPopState();
        }

        @NotNull
        public Icon getIcon() {
            Icon selectedIcon;
            if (this.isEnabled() && this.isSelected() && (selectedIcon = this.myPresentation.getSelectedIcon()) != null) {
                return selectedIcon;
            }
            Icon icon = super.getIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
            return icon;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J(\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jsonpath/ui/JsonPathEvaluateView$ShowHistoryAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/intellij/jsonpath/ui/JsonPathEvaluateView;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "showCompletionPopup", "toolbarComponent", "Ljavax/swing/JComponent;", "list", "Ljavax/swing/JList;", "", "textField", "Lcom/intellij/ui/EditorTextField;", "intellij.jsonpath"})
    private final class ShowHistoryAction
    extends DumbAwareAction {
        public ShowHistoryAction() {
            super(FindBundle.message((String)"find.search.history", (Object[])new Object[0]), null, AllIcons.Actions.SearchWithHistory);
            this.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"ShowSearchHistory"), (JComponent)JsonPathEvaluateView.this.getSearchTextField());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            JBList historyList = new JBList((Collection)JsonPathEvaluateView.this.getExpressionHistory());
            this.showCompletionPopup(JsonPathEvaluateView.this.getSearchWrapper(), (JList)historyList, JsonPathEvaluateView.this.getSearchTextField());
        }

        private final void showCompletionPopup(JComponent toolbarComponent, JList<String> list, EditorTextField textField) {
            PopupChooserBuilder popupChooserBuilder = JBPopupFactory.getInstance().createListPopupBuilder(list);
            Intrinsics.checkNotNullExpressionValue((Object)popupChooserBuilder, (String)"createListPopupBuilder(...)");
            PopupChooserBuilder builder = popupChooserBuilder;
            JBPopup jBPopup = builder.setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(() -> ShowHistoryAction.showCompletionPopup$lambda$0(list, textField)).createPopup();
            Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
            JBPopup popup = jBPopup;
            if (toolbarComponent != null) {
                popup.showUnderneathOf((Component)toolbarComponent);
            } else {
                popup.showUnderneathOf((Component)textField);
            }
        }

        private static final void showCompletionPopup$lambda$0(JList $list, EditorTextField $textField) {
            String selectedValue = (String)$list.getSelectedValue();
            if (selectedValue != null) {
                $textField.setText(selectedValue);
                IdeFocusManager.getGlobalInstance().requestFocus((Component)$textField, false);
            }
        }
    }
}

