/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.externalSystem.MavenRepositoryData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.MavenRepositoryModel;
import org.jetbrains.plugins.gradle.model.RepositoryModels;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u001e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u001e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\nH\u0016J\u0012\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016H\u0016J \u0010\u0018\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/MavenRepositoriesProjectResolver;", "Lorg/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension;", "<init>", "()V", "processedRepositoryModels", "Ljava/util/IdentityHashMap;", "Lorg/jetbrains/plugins/gradle/model/RepositoryModels;", "", "resolveFinished", "projectDataNode", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "populateProjectExtraModels", "gradleProject", "Lorg/gradle/tooling/model/idea/IdeaProject;", "ideProject", "populateModuleExtraModels", "gradleModule", "Lorg/gradle/tooling/model/idea/IdeaModule;", "ideModule", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "getExtraProjectModelClasses", "", "Ljava/lang/Class;", "addRepositoriesToProject", "repositories", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nMavenRepositoriesProjectResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenRepositoriesProjectResolver.kt\norg/jetbrains/plugins/gradle/service/project/MavenRepositoriesProjectResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,60:1\n1#2:61\n1321#3,2:62\n*S KotlinDebug\n*F\n+ 1 MavenRepositoriesProjectResolver.kt\norg/jetbrains/plugins/gradle/service/project/MavenRepositoriesProjectResolver\n*L\n56#1:62,2\n*E\n"})
public final class MavenRepositoriesProjectResolver
extends AbstractProjectResolverExtension {
    @NotNull
    private final IdentityHashMap<RepositoryModels, Unit> processedRepositoryModels = new IdentityHashMap();

    public void resolveFinished(@NotNull DataNode<ProjectData> projectDataNode) {
        Intrinsics.checkNotNullParameter(projectDataNode, (String)"projectDataNode");
        this.processedRepositoryModels.clear();
    }

    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> ideProject) {
        Intrinsics.checkNotNullParameter((Object)gradleProject, (String)"gradleProject");
        Intrinsics.checkNotNullParameter(ideProject, (String)"ideProject");
        RepositoryModels repositories = (RepositoryModels)this.resolverCtx.getRootModel(RepositoryModels.class);
        this.addRepositoriesToProject(ideProject, repositories);
        super.populateProjectExtraModels(gradleProject, ideProject);
    }

    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        DataNode ideProject;
        Intrinsics.checkNotNullParameter((Object)gradleModule, (String)"gradleModule");
        Intrinsics.checkNotNullParameter(ideModule, (String)"ideModule");
        RepositoryModels repositories = (RepositoryModels)this.resolverCtx.getExtraProject(gradleModule, RepositoryModels.class);
        DataNode dataNode = ideProject = ExternalSystemApiUtil.findParent(ideModule, (Key)ProjectKeys.PROJECT);
        if (dataNode != null) {
            DataNode it = dataNode;
            boolean bl = false;
            this.addRepositoriesToProject((DataNode<ProjectData>)it, repositories);
        }
        super.populateModuleExtraModels(gradleModule, ideModule);
    }

    @NotNull
    public Set<Class<?>> getExtraProjectModelClasses() {
        Set<Class<?>> set = Collections.singleton(RepositoryModels.class);
        Intrinsics.checkNotNullExpressionValue(set, (String)"singleton(...)");
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private final void addRepositoriesToProject(DataNode<ProjectData> ideProject, RepositoryModels repositories) {
        if (repositories != null && !this.processedRepositoryModels.containsKey(repositories)) {
            void $this$forEach$iv;
            Collection collection = ExternalSystemApiUtil.getChildren(ideProject, (Key)MavenRepositoryData.KEY);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChildren(...)");
            Set knownRepositories = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), MavenRepositoriesProjectResolver::addRepositoriesToProject$lambda$0));
            List list = repositories.getRepositories();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRepositories(...)");
            Sequence sequence = SequencesKt.distinct((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), MavenRepositoriesProjectResolver::addRepositoriesToProject$lambda$1), arg_0 -> MavenRepositoriesProjectResolver.addRepositoriesToProject$lambda$2(knownRepositories, arg_0)));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MavenRepositoryData it = (MavenRepositoryData)element$iv;
                boolean bl = false;
                ideProject.addChild(new DataNode(MavenRepositoryData.KEY, (Object)it, ideProject));
            }
            ((Map)this.processedRepositoryModels).put(repositories, Unit.INSTANCE);
        }
    }

    private static final MavenRepositoryData addRepositoriesToProject$lambda$0(DataNode it) {
        return (MavenRepositoryData)it.getData();
    }

    private static final MavenRepositoryData addRepositoriesToProject$lambda$1(MavenRepositoryModel it) {
        return new MavenRepositoryData(GradleConstants.SYSTEM_ID, it.getName(), it.getUrl());
    }

    private static final boolean addRepositoriesToProject$lambda$2(Set $knownRepositories, MavenRepositoryData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$knownRepositories.contains(it);
    }
}

