/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.repo.GitProjectConfigurationCache;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitConfigUtil {
    private static final Logger LOG = Logger.getInstance(GitConfigUtil.class);
    private static final Set<String> REPORTED_CUSTOM_ENCODINGS = new CopyOnWriteArraySet<String>();
    @NlsSafe
    public static final String UPDATE_REFS = "rebase.updateRefs";
    @NlsSafe
    public static final String USER_NAME = "user.name";
    @NlsSafe
    public static final String USER_EMAIL = "user.email";
    @NlsSafe
    public static final String CORE_AUTOCRLF = "core.autocrlf";
    @NlsSafe
    public static final String CREDENTIAL_HELPER = "credential.helper";
    @NlsSafe
    public static final String CORE_SSH_COMMAND = "core.sshCommand";
    @NlsSafe
    public static final String CORE_COMMENT_CHAR = "core.commentChar";
    @NlsSafe
    public static final String LOG_OUTPUT_ENCODING = "i18n.logoutputencoding";
    @NlsSafe
    public static final String COMMIT_ENCODING = "i18n.commitencoding";
    @NlsSafe
    public static final String COMMIT_TEMPLATE = "commit.template";
    @NlsSafe
    public static final String GPG_PROGRAM = "gpg.program";
    @NlsSafe
    public static final String GPG_COMMIT_SIGN = "commit.gpgSign";
    @NlsSafe
    public static final String GPG_COMMIT_SIGN_KEY = "user.signingkey";

    private GitConfigUtil() {
    }

    @NotNull
    public static @NotNull Map<@NotNull String, @NotNull String> getValues(@NotNull Project project, @NotNull VirtualFile root, @Nullable @NonNls String keyMask) throws VcsException {
        int pos;
        if (project == null) {
            GitConfigUtil.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitConfigUtil.$$$reportNull$$$0(1);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.CONFIG);
        h.setEnableInteractiveCallbacks(false);
        h.setSilent(true);
        h.addParameters("--null");
        if (keyMask != null) {
            h.addParameters("--get-regexp", keyMask);
        } else {
            h.addParameters("-l");
        }
        String output2 = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        int start = 0;
        HashMap<String, String> result2 = new HashMap<String, String>();
        while ((pos = output2.indexOf(10, start)) != -1) {
            String key = output2.substring(start, pos);
            start = pos + 1;
            if ((pos = output2.indexOf(0, start)) == -1) break;
            String value = output2.substring(start, pos);
            start = pos + 1;
            result2.put(key, value);
        }
        HashMap<String, String> hashMap = result2;
        if (hashMap == null) {
            GitConfigUtil.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    @Nullable
    public static String getValue(@NotNull Project project, @NotNull VirtualFile root, @NotNull @NonNls String key) throws VcsException {
        if (project == null) {
            GitConfigUtil.$$$reportNull$$$0(3);
        }
        if (root == null) {
            GitConfigUtil.$$$reportNull$$$0(4);
        }
        if (key == null) {
            GitConfigUtil.$$$reportNull$$$0(5);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.CONFIG);
        return GitConfigUtil.getValue(h, key);
    }

    @Nullable
    public static String getValue(@NotNull Project project, @NotNull File root, @NotNull @NonNls String key) throws VcsException {
        if (project == null) {
            GitConfigUtil.$$$reportNull$$$0(6);
        }
        if (root == null) {
            GitConfigUtil.$$$reportNull$$$0(7);
        }
        if (key == null) {
            GitConfigUtil.$$$reportNull$$$0(8);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.CONFIG);
        return GitConfigUtil.getValue(h, key);
    }

    @Nullable
    private static String getValue(@NotNull GitLineHandler h, @NotNull @NonNls String key) throws VcsException {
        if (h == null) {
            GitConfigUtil.$$$reportNull$$$0(9);
        }
        if (key == null) {
            GitConfigUtil.$$$reportNull$$$0(10);
        }
        h.setEnableInteractiveCallbacks(false);
        h.setSilent(true);
        h.addParameters("--null", "--get", key);
        GitCommandResult result2 = Git.getInstance().runCommand(h);
        String output2 = result2.getOutputOrThrow(1);
        int pos = output2.indexOf(0);
        if (result2.getExitCode() != 0 || pos == -1) {
            return null;
        }
        return output2.substring(0, pos);
    }

    @Nullable
    public static Boolean getBooleanValue(@Nullable @NonNls String value) {
        if (value == null) {
            return null;
        }
        value = StringUtil.toLowerCase((String)value);
        if (ContainerUtil.newHashSet((Object[])new String[]{"true", "yes", "on", "1"}).contains(value)) {
            return true;
        }
        if (ContainerUtil.newHashSet((Object[])new String[]{"false", "no", "off", "0", ""}).contains(value)) {
            return false;
        }
        return null;
    }

    @Deprecated
    @NotNull
    public static String getCommitEncoding(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitConfigUtil.$$$reportNull$$$0(11);
        }
        if (root == null) {
            GitConfigUtil.$$$reportNull$$$0(12);
        }
        String string = GitConfigUtil.getCommitEncodingCharset(project, root).name();
        if (string == null) {
            GitConfigUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Deprecated
    public static String getLogEncoding(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitConfigUtil.$$$reportNull$$$0(14);
        }
        if (root == null) {
            GitConfigUtil.$$$reportNull$$$0(15);
        }
        return GitConfigUtil.getLogEncodingCharset(project, root).name();
    }

    @NotNull
    public static Charset getCommitEncodingCharset(@NotNull Project project, @NotNull VirtualFile root) {
        block6: {
            Charset charset;
            if (project == null) {
                GitConfigUtil.$$$reportNull$$$0(16);
            }
            if (root == null) {
                GitConfigUtil.$$$reportNull$$$0(17);
            }
            try {
                String encoding = GitConfigUtil.getValue(project, root, COMMIT_ENCODING);
                Charset charset2 = GitConfigUtil.tryParseEncoding(encoding);
                if (charset2 == null) break block6;
                charset = charset2;
            }
            catch (VcsException vcsException) {
                // empty catch block
            }
            if (charset == null) {
                GitConfigUtil.$$$reportNull$$$0(18);
            }
            return charset;
        }
        Charset charset = StandardCharsets.UTF_8;
        if (charset == null) {
            GitConfigUtil.$$$reportNull$$$0(19);
        }
        return charset;
    }

    @NotNull
    public static Charset getCommitEncodingCharsetCached(@NotNull Project project, @NotNull VirtualFile root) {
        String encoding;
        Charset charset;
        if (project == null) {
            GitConfigUtil.$$$reportNull$$$0(20);
        }
        if (root == null) {
            GitConfigUtil.$$$reportNull$$$0(21);
        }
        if ((charset = GitConfigUtil.tryParseEncoding(encoding = GitProjectConfigurationCache.getInstance(project).readRepositoryConfig(root, COMMIT_ENCODING))) != null) {
            Charset charset2 = charset;
            if (charset2 == null) {
                GitConfigUtil.$$$reportNull$$$0(22);
            }
            return charset2;
        }
        Charset charset3 = StandardCharsets.UTF_8;
        if (charset3 == null) {
            GitConfigUtil.$$$reportNull$$$0(23);
        }
        return charset3;
    }

    @RequiresBackgroundThread
    public static boolean isRebaseUpdateRefsEnabledCached(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitConfigUtil.$$$reportNull$$$0(24);
        }
        if (root == null) {
            GitConfigUtil.$$$reportNull$$$0(25);
        }
        ThreadingAssertions.assertBackgroundThread();
        return Boolean.TRUE.equals(GitConfigUtil.getBooleanValue(GitProjectConfigurationCache.getInstance(project).readRepositoryConfig(root, UPDATE_REFS)));
    }

    @NotNull
    public static Charset getLogEncodingCharset(@NotNull Project project, @NotNull VirtualFile root) {
        block5: {
            Charset charset;
            if (project == null) {
                GitConfigUtil.$$$reportNull$$$0(26);
            }
            if (root == null) {
                GitConfigUtil.$$$reportNull$$$0(27);
            }
            try {
                String encoding = GitConfigUtil.getValue(project, root, LOG_OUTPUT_ENCODING);
                Charset charset2 = GitConfigUtil.tryParseEncoding(encoding);
                if (charset2 == null) break block5;
                charset = charset2;
            }
            catch (VcsException vcsException) {
                // empty catch block
            }
            if (charset == null) {
                GitConfigUtil.$$$reportNull$$$0(28);
            }
            return charset;
        }
        return GitConfigUtil.getCommitEncodingCharset(project, root);
    }

    @Nullable
    private static Charset tryParseEncoding(@Nullable String encodingName) {
        if (StringUtil.isEmpty((String)encodingName)) {
            return null;
        }
        try {
            Charset charset = Charset.forName(encodingName);
            if (REPORTED_CUSTOM_ENCODINGS.add(encodingName)) {
                LOG.info("Using a custom encoding " + encodingName);
            }
            return charset;
        }
        catch (IllegalArgumentException ignore) {
            if (REPORTED_CUSTOM_ENCODINGS.add(encodingName)) {
                LOG.warn("Custom encoding " + encodingName + " is not supported, using UTF-8 instead");
            }
            return null;
        }
    }

    public static void setValue(@NotNull Project project, @NotNull VirtualFile root, @NotNull @NonNls String key, @NotNull @NonNls String value, String ... additionalParameters) throws VcsException {
        if (project == null) {
            GitConfigUtil.$$$reportNull$$$0(29);
        }
        if (root == null) {
            GitConfigUtil.$$$reportNull$$$0(30);
        }
        if (key == null) {
            GitConfigUtil.$$$reportNull$$$0(31);
        }
        if (value == null) {
            GitConfigUtil.$$$reportNull$$$0(32);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.CONFIG);
        h.setSilent(false);
        h.addParameters(additionalParameters);
        h.addParameters(key, value);
        Git.getInstance().runCommand(h).throwOnError(1);
    }

    public static boolean isCredentialHelperUsed(@NotNull Project project, @NotNull File workingDirectory) {
        if (project == null) {
            GitConfigUtil.$$$reportNull$$$0(33);
        }
        if (workingDirectory == null) {
            GitConfigUtil.$$$reportNull$$$0(34);
        }
        try {
            GitLineHandler handler = new GitLineHandler(project, workingDirectory, GitCommand.CONFIG);
            String value = GitConfigUtil.getValue(handler, CREDENTIAL_HELPER);
            return StringUtil.isNotEmpty((String)value);
        }
        catch (VcsException ignored) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 13, 18, 19, 22, 23, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 17: 
            case 21: 
            case 25: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 13: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitConfigUtil";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitConfigUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitEncoding";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitEncodingCharset";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitEncodingCharsetCached";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogEncodingCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 2: 
            case 13: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 28: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCommitEncoding";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLogEncoding";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCommitEncodingCharset";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCommitEncodingCharsetCached";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isRebaseUpdateRefsEnabledCached";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLogEncodingCharset";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isCredentialHelperUsed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 13, 18, 19, 22, 23, 28 -> new IllegalStateException(string);
        };
    }
}

