/*
 * Decompiled with CFR 0.152.
 */
package git4idea.inMemory.rebase.log;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsShortCommitDetails;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.inMemory.GitObjectRepository;
import git4idea.inMemory.GitObjectRepositoryExtensionsKt;
import git4idea.inMemory.objects.GitObject;
import git4idea.inMemory.objects.Oid;
import git4idea.inMemory.objects.OidKt;
import git4idea.inMemory.rebase.log.GitInMemoryCommitEditingOperation;
import git4idea.rebase.interactive.GitInteractiveRebaseUsingLogKt;
import git4idea.rebase.log.GitCommitEditingOperationResult;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u0000 *2\u00020\u0001:\u0002*+B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0086@\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u001dH\u00a4@\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0012\u0010(\u001a\u00020%2\b\b\u0002\u0010)\u001a\u00020\u001aH\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u001f\u001a\u00070\u000b\u00a2\u0006\u0002\b X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\rR\u0017\u0010\"\u001a\u00070\u000b\u00a2\u0006\u0002\b X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\r\u00a8\u0006,"}, d2={"Lgit4idea/inMemory/rebase/log/GitInMemoryCommitEditingOperation;", "", "objectRepo", "Lgit4idea/inMemory/GitObjectRepository;", "baseCommitMetadata", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "<init>", "(Lgit4idea/inMemory/GitObjectRepository;Lcom/intellij/vcs/log/VcsCommitMetadata;)V", "getObjectRepo", "()Lgit4idea/inMemory/GitObjectRepository;", "initialHeadPosition", "", "getInitialHeadPosition", "()Ljava/lang/String;", "setInitialHeadPosition", "(Ljava/lang/String;)V", "baseToHeadCommitsRange", "", "Lgit4idea/inMemory/objects/GitObject$Commit;", "getBaseToHeadCommitsRange", "()Ljava/util/List;", "baseToHeadCommitsRange$delegate", "Lkotlin/Lazy;", "execute", "Lgit4idea/rebase/log/GitCommitEditingOperationResult;", "showFailureNotification", "", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "editCommits", "Lgit4idea/inMemory/rebase/log/GitInMemoryCommitEditingOperation$CommitEditingResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reflogMessage", "Lorg/jetbrains/annotations/NonNls;", "getReflogMessage", "failureTitle", "getFailureTitle", "notifyOperationFailed", "", "exception", "Lcom/intellij/openapi/vcs/VcsException;", "assertCurrentRevMatchesInitialHead", "performUpdate", "Companion", "CommitEditingResult", "intellij.vcs.git"})
public abstract class GitInMemoryCommitEditingOperation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitObjectRepository objectRepo;
    @NotNull
    private final VcsCommitMetadata baseCommitMetadata;
    protected String initialHeadPosition;
    @NotNull
    private final Lazy baseToHeadCommitsRange$delegate;
    @NonNls
    @NotNull
    private static final String REFLOG_MESSAGE_SUFFIX = "by " + ApplicationNamesInfo.getInstance().getFullProductName() + " Git plugin";

    public GitInMemoryCommitEditingOperation(@NotNull GitObjectRepository objectRepo, @NotNull VcsCommitMetadata baseCommitMetadata) {
        Intrinsics.checkNotNullParameter((Object)objectRepo, (String)"objectRepo");
        Intrinsics.checkNotNullParameter((Object)baseCommitMetadata, (String)"baseCommitMetadata");
        this.objectRepo = objectRepo;
        this.baseCommitMetadata = baseCommitMetadata;
        this.baseToHeadCommitsRange$delegate = LazyKt.lazy(() -> GitInMemoryCommitEditingOperation.baseToHeadCommitsRange_delegate$lambda$0(this));
    }

    @NotNull
    protected final GitObjectRepository getObjectRepo() {
        return this.objectRepo;
    }

    @NotNull
    protected final String getInitialHeadPosition() {
        String string = this.initialHeadPosition;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"initialHeadPosition");
        return null;
    }

    protected final void setInitialHeadPosition(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.initialHeadPosition = string;
    }

    @NotNull
    protected final List<GitObject.Commit> getBaseToHeadCommitsRange() {
        Lazy lazy = this.baseToHeadCommitsRange$delegate;
        return (List)lazy.getValue();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object execute(boolean showFailureNotification, @NotNull Continuation<? super GitCommitEditingOperationResult> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ GitInMemoryCommitEditingOperation this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute(false, (Continuation<? super GitCommitEditingOperationResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.objectRepo.getRepository().update();
                v0 = this.objectRepo.getRepository().getCurrentRevision();
                Intrinsics.checkNotNull((Object)v0);
                this.setInitialHeadPosition(v0);
                $continuation.Z$0 = showFailureNotification;
                $continuation.label = 1;
                v1 = this.editCommits((Continuation<? super CommitEditingResult>)$continuation);
                ** if (v1 != var7_5) goto lbl23
lbl22:
                // 1 sources

                return var7_5;
lbl23:
                // 1 sources

                ** GOTO lbl30
            }
            case 1: {
                showFailureNotification = $continuation.Z$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl30:
                    // 2 sources

                    result = (CommitEditingResult)v1;
                    GitInMemoryCommitEditingOperation.assertCurrentRevMatchesInitialHead$default(this, false, 1, null);
                    GitUtil.updateHead(this.objectRepo.getRepository(), OidKt.toHash(result.getNewHead()), this.getReflogMessage() + " " + GitInMemoryCommitEditingOperation.REFLOG_MESSAGE_SUFFIX);
                    this.objectRepo.getRepository().update();
                    upstream = GitInteractiveRebaseUsingLogKt.getRebaseUpstreamFor((VcsShortCommitDetails)this.baseCommitMetadata);
                    v2 = result.getCommitToFocus();
                    v3 = result.getCommitToFocusOnUndo();
                    return new GitCommitEditingOperationResult.Complete(this.objectRepo.getRepository(), upstream, this.getInitialHeadPosition(), result.getNewHead().hex(), (Hash)(v2 != null ? OidKt.toHash(v2) : null), (Hash)(v3 != null ? OidKt.toHash(v3) : null));
                }
                catch (VcsException e) {
                    if (showFailureNotification) {
                        this.notifyOperationFailed(e);
                    }
                    return GitCommitEditingOperationResult.Incomplete.INSTANCE;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object execute$default(GitInMemoryCommitEditingOperation gitInMemoryCommitEditingOperation, boolean bl, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: execute");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return gitInMemoryCommitEditingOperation.execute(bl, (Continuation<? super GitCommitEditingOperationResult>)continuation);
    }

    @Nullable
    protected abstract Object editCommits(@NotNull Continuation<? super CommitEditingResult> var1);

    @NotNull
    protected abstract String getReflogMessage();

    @NotNull
    protected abstract String getFailureTitle();

    private final void notifyOperationFailed(VcsException exception) {
        VcsNotifier.getInstance((Project)this.objectRepo.getRepository().getProject()).notifyError("git.in.memory.operation.failed", this.getFailureTitle(), exception.getMessage());
    }

    protected final void assertCurrentRevMatchesInitialHead(boolean performUpdate) {
        if (performUpdate) {
            this.objectRepo.getRepository().update();
        }
        String string = this.objectRepo.getRepository().getCurrentRevision();
        Intrinsics.checkNotNull((Object)string);
        if (!Intrinsics.areEqual((Object)string, (Object)this.getInitialHeadPosition())) {
            throw new VcsException(GitBundle.message((String)"in.memory.rebase.fail.head.move", (Object[])new Object[0]));
        }
    }

    public static /* synthetic */ void assertCurrentRevMatchesInitialHead$default(GitInMemoryCommitEditingOperation gitInMemoryCommitEditingOperation, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assertCurrentRevMatchesInitialHead");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        gitInMemoryCommitEditingOperation.assertCurrentRevMatchesInitialHead(bl);
    }

    private static final List baseToHeadCommitsRange_delegate$lambda$0(GitInMemoryCommitEditingOperation this$0) {
        GitObjectRepository gitObjectRepository = this$0.objectRepo;
        String string = ((Hash)this$0.baseCommitMetadata.getId()).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return GitObjectRepositoryExtensionsKt.findCommitsRange(gitObjectRepository, string, this$0.getInitialHeadPosition());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J+\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lgit4idea/inMemory/rebase/log/GitInMemoryCommitEditingOperation$CommitEditingResult;", "", "newHead", "Lgit4idea/inMemory/objects/Oid;", "commitToFocus", "commitToFocusOnUndo", "<init>", "(Lgit4idea/inMemory/objects/Oid;Lgit4idea/inMemory/objects/Oid;Lgit4idea/inMemory/objects/Oid;)V", "getNewHead", "()Lgit4idea/inMemory/objects/Oid;", "getCommitToFocus", "getCommitToFocusOnUndo", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.vcs.git"})
    protected static final class CommitEditingResult {
        @NotNull
        private final Oid newHead;
        @Nullable
        private final Oid commitToFocus;
        @Nullable
        private final Oid commitToFocusOnUndo;

        public CommitEditingResult(@NotNull Oid newHead, @Nullable Oid commitToFocus, @Nullable Oid commitToFocusOnUndo) {
            Intrinsics.checkNotNullParameter((Object)newHead, (String)"newHead");
            this.newHead = newHead;
            this.commitToFocus = commitToFocus;
            this.commitToFocusOnUndo = commitToFocusOnUndo;
        }

        public /* synthetic */ CommitEditingResult(Oid oid, Oid oid2, Oid oid3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                oid2 = null;
            }
            if ((n & 4) != 0) {
                oid3 = null;
            }
            this(oid, oid2, oid3);
        }

        @NotNull
        public final Oid getNewHead() {
            return this.newHead;
        }

        @Nullable
        public final Oid getCommitToFocus() {
            return this.commitToFocus;
        }

        @Nullable
        public final Oid getCommitToFocusOnUndo() {
            return this.commitToFocusOnUndo;
        }

        @NotNull
        public final Oid component1() {
            return this.newHead;
        }

        @Nullable
        public final Oid component2() {
            return this.commitToFocus;
        }

        @Nullable
        public final Oid component3() {
            return this.commitToFocusOnUndo;
        }

        @NotNull
        public final CommitEditingResult copy(@NotNull Oid newHead, @Nullable Oid commitToFocus, @Nullable Oid commitToFocusOnUndo) {
            Intrinsics.checkNotNullParameter((Object)newHead, (String)"newHead");
            return new CommitEditingResult(newHead, commitToFocus, commitToFocusOnUndo);
        }

        public static /* synthetic */ CommitEditingResult copy$default(CommitEditingResult commitEditingResult, Oid oid, Oid oid2, Oid oid3, int n, Object object) {
            if ((n & 1) != 0) {
                oid = commitEditingResult.newHead;
            }
            if ((n & 2) != 0) {
                oid2 = commitEditingResult.commitToFocus;
            }
            if ((n & 4) != 0) {
                oid3 = commitEditingResult.commitToFocusOnUndo;
            }
            return commitEditingResult.copy(oid, oid2, oid3);
        }

        @NotNull
        public String toString() {
            return "CommitEditingResult(newHead=" + this.newHead + ", commitToFocus=" + this.commitToFocus + ", commitToFocusOnUndo=" + this.commitToFocusOnUndo + ")";
        }

        public int hashCode() {
            int result2 = this.newHead.hashCode();
            result2 = result2 * 31 + (this.commitToFocus == null ? 0 : this.commitToFocus.hashCode());
            result2 = result2 * 31 + (this.commitToFocusOnUndo == null ? 0 : this.commitToFocusOnUndo.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommitEditingResult)) {
                return false;
            }
            CommitEditingResult commitEditingResult = (CommitEditingResult)other;
            if (!Intrinsics.areEqual((Object)this.newHead, (Object)commitEditingResult.newHead)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.commitToFocus, (Object)commitEditingResult.commitToFocus)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.commitToFocusOnUndo, (Object)commitEditingResult.commitToFocusOnUndo);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/inMemory/rebase/log/GitInMemoryCommitEditingOperation$Companion;", "", "<init>", "()V", "REFLOG_MESSAGE_SUFFIX", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

