/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerListener;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchPresentation;
import com.intellij.vcs.commit.CommitTabTitleUpdater;
import com.intellij.vcs.log.BaseSingleTaskControllerKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H&J\u0006\u0010\u001b\u001a\u00020\u0017J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\n\u0010 \u001a\u0004\u0018\u00010!H\u0002J\b\u0010\"\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000f\u0010\u0010R)\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lgit4idea/index/ui/SimpleTabTitleUpdater;", "Lcom/intellij/openapi/Disposable;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "tabName", "", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Ljava/lang/String;)V", "disposableFlag", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lorg/jetbrains/annotations/NotNull;", "value", "", "Lcom/intellij/vcs/branch/BranchData;", "branches", "setBranches", "(Ljava/util/Set;)V", "groupingListener", "Lkotlin/Function1;", "Ljava/beans/PropertyChangeEvent;", "Lkotlin/ParameterName;", "name", "evt", "", "getRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "refresh", "updatePresentation", "getBranches", "shouldShowBranches", "", "getTab", "Lcom/intellij/ui/content/Content;", "dispose", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nSimpleTabTitleUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleTabTitleUpdater.kt\ngit4idea/index/ui/SimpleTabTitleUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1617#2,9:78\n1869#2:87\n1870#2:89\n1626#2:90\n1#3:88\n*S KotlinDebug\n*F\n+ 1 SimpleTabTitleUpdater.kt\ngit4idea/index/ui/SimpleTabTitleUpdater\n*L\n60#1:78,9\n60#1:87\n60#1:89\n60#1:90\n60#1:88\n*E\n"})
public abstract class SimpleTabTitleUpdater
implements Disposable {
    @NotNull
    private final ChangesTree tree;
    @NotNull
    private final String tabName;
    @NotNull
    private final CheckedDisposable disposableFlag;
    @NotNull
    private Set<? extends BranchData> branches;
    @NotNull
    private final Function1<PropertyChangeEvent, Unit> groupingListener;

    public SimpleTabTitleUpdater(@NotNull ChangesTree tree, @NotNull String tabName) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        this.tree = tree;
        this.tabName = tabName;
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
        this.disposableFlag = checkedDisposable;
        this.branches = SetsKt.emptySet();
        this.groupingListener = arg_0 -> SimpleTabTitleUpdater.groupingListener$lambda$0(this, arg_0);
        UiNotifyConnector.Companion.doWhenFirstShown((JComponent)this.tree, () -> SimpleTabTitleUpdater._init_$lambda$0(this));
        this.tree.addGroupingChangeListener(arg_0 -> SimpleTabTitleUpdater._init_$lambda$1(this.groupingListener, arg_0));
        MessageBusConnection busConnection = this.tree.getProject().getMessageBus().connect((Disposable)this);
        Topic<GitRepositoryChangeListener> topic = GitRepository.GIT_REPO_CHANGE;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"GIT_REPO_CHANGE");
        busConnection.subscribe(topic, arg_0 -> SimpleTabTitleUpdater._init_$lambda$2(this, arg_0));
        busConnection.subscribe(ChangesViewContentManagerListener.TOPIC, (Object)new ChangesViewContentManagerListener(){

            public void toolWindowMappingChanged() {
                this.updatePresentation();
            }
        });
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.disposableFlag));
    }

    private final void setBranches(Set<? extends BranchData> value) {
        if (Intrinsics.areEqual(this.branches, value)) {
            return;
        }
        this.branches = value;
        this.updatePresentation();
    }

    @NotNull
    public abstract Collection<VirtualFile> getRoots();

    public final void refresh() {
        this.setBranches(this.getBranches());
    }

    private final void updatePresentation() {
        if (this.disposableFlag.isDisposed()) {
            return;
        }
        Content content = this.getTab();
        if (content == null) {
            return;
        }
        Content tab = content;
        Project project = this.tree.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        tab.setDisplayName(CommitTabTitleUpdater.Companion.getDisplayTabName(project, this.tabName, BranchPresentation.INSTANCE.getText((Collection)this.branches)));
        tab.setDescription(BranchPresentation.INSTANCE.getTooltip((Collection)this.branches));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<BranchData> getBranches() {
        void $this$mapNotNullTo$iv$iv;
        if (!this.shouldShowBranches()) {
            return SetsKt.emptySet();
        }
        Iterable $this$mapNotNull$iv = this.getRoots();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BranchData it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            Project project = this.tree.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (CurrentBranchComponent.Companion.getCurrentBranch(project, it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    protected boolean shouldShowBranches() {
        ChangesGroupingSupport changesGroupingSupport = this.tree.getGroupingSupport();
        Intrinsics.checkNotNullExpressionValue((Object)changesGroupingSupport, (String)"getGroupingSupport(...)");
        ChangesGroupingSupport groupingSupport = changesGroupingSupport;
        return !groupingSupport.isAvailable("repository") || !groupingSupport.get("repository");
    }

    private final Content getTab() {
        Project project = this.tree.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return ChangesViewContentManager.Companion.getInstance(project).findContent(this.tabName);
    }

    public void dispose() {
        this.tree.removeGroupingChangeListener(arg_0 -> SimpleTabTitleUpdater.dispose$lambda$0(this.groupingListener, arg_0));
        this.setBranches(SetsKt.emptySet());
    }

    private static final Unit groupingListener$lambda$0(SimpleTabTitleUpdater this$0, PropertyChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.refresh();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$0(SimpleTabTitleUpdater this$0) {
        this$0.refresh();
    }

    private static final void _init_$lambda$1(Function1 $tmp0, PropertyChangeEvent p0) {
        $tmp0.invoke((Object)p0);
    }

    private static final void _init_$lambda$2(SimpleTabTitleUpdater this$0, GitRepository it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BaseSingleTaskControllerKt.runInEdt((CheckedDisposable)this$0.disposableFlag, () -> SimpleTabTitleUpdater.lambda$2$0(this$0));
    }

    private static final Unit lambda$2$0(SimpleTabTitleUpdater this$0) {
        this$0.refresh();
        return Unit.INSTANCE;
    }

    private static final void dispose$lambda$0(Function1 $tmp0, PropertyChangeEvent p0) {
        $tmp0.invoke((Object)p0);
    }
}

