/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.export;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.awt.canvas.CanvasPane;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.geometry.Rectangle;
import org.jetbrains.letsPlot.commons.geometry.Vector;
import org.jetbrains.letsPlot.core.canvasFigure.CanvasFigure;
import org.jetbrains.letsPlot.core.plot.export.PlotImageExport;
import org.jetbrains.letsPlot.core.util.PlotExportCommon;
import org.jetbrains.letsPlot.core.util.sizing.SizingPolicy;
import org.jetbrains.letsPlot.raster.builder.MonolithicCanvas;
import org.jetbrains.letsPlot.raster.view.PlotCanvasFigure;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JR\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport;", "", "()V", "buildImageFromRawSpecs", "Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$ImageData;", "plotSpec", "", "", "format", "Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format;", "scalingFactor", "", "targetDPI", "plotSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "unit", "Lorg/jetbrains/letsPlot/core/util/PlotExportCommon$SizeUnit;", "Format", "ImageData", "plot-image-export"})
@SourceDebugExtension(value={"SMAP\nPlotImageExport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotImageExport.kt\norg/jetbrains/letsPlot/core/plot/export/PlotImageExport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public final class PlotImageExport {
    @NotNull
    public static final PlotImageExport INSTANCE = new PlotImageExport();

    private PlotImageExport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ImageData buildImageFromRawSpecs(@NotNull Map<String, Object> plotSpec, @NotNull Format format2, @Nullable Number scalingFactor2, @Nullable Number targetDPI2, @Nullable DoubleVector plotSize, @Nullable PlotExportCommon.SizeUnit unit) {
        int n;
        Double d;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        Number number = targetDPI2;
        if (number != null) {
            Double d2 = number.doubleValue();
            double it = ((Number)d2).doubleValue();
            boolean bl = false;
            double d3 = it;
            d = !Double.isInfinite(d3) && !Double.isNaN(d3) ? d2 : null;
        } else {
            d = null;
        }
        Double targetDPI3 = d;
        PlotExportCommon.ExportParameters exportParameters = PlotExportCommon.INSTANCE.computeExportParameters(plotSize, (Number)targetDPI3, unit, scalingFactor2);
        SizingPolicy sizingPolicy = exportParameters.component1();
        double scaleFactor = exportParameters.component2();
        PlotCanvasFigure plotFigure2 = MonolithicCanvas.INSTANCE.buildPlotFigureFromRawSpec(plotSpec, sizingPolicy, (Function1)buildImageFromRawSpecs.plotFigure.1.INSTANCE);
        Vector plotComponentSize = ((Rectangle)plotFigure2.bounds().get()).getDimension();
        int n2 = MathKt.roundToInt((double)((double)plotComponentSize.getX() * scaleFactor));
        int n3 = MathKt.roundToInt((double)((double)plotComponentSize.getY() * scaleFactor));
        Format format3 = format2;
        if (format3 instanceof Format.PNG) {
            n = 2;
        } else if (format3 instanceof Format.TIFF) {
            n = 2;
        } else if (format3 instanceof Format.JPEG) {
            n = 1;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        BufferedImage image = new BufferedImage(n2, n3, n);
        Graphics2D graphics = image.createGraphics();
        graphics.scale(scaleFactor, scaleFactor);
        try {
            CanvasFigure canvasFigure = (CanvasFigure)plotFigure2;
            Intrinsics.checkNotNull((Object)graphics);
            CanvasPane.Companion.paint(canvasFigure, scaleFactor, graphics);
        }
        finally {
            graphics.dispose();
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, format2.getDefFileExt(), outputStream);
        byte[] byArray = outputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return new ImageData(byArray, new DoubleVector((double)image.getWidth(), (double)image.getHeight()));
    }

    public static /* synthetic */ ImageData buildImageFromRawSpecs$default(PlotImageExport plotImageExport, Map map, Format format2, Number number, Number number2, DoubleVector doubleVector, PlotExportCommon.SizeUnit sizeUnit, int n, Object object) {
        if ((n & 4) != 0) {
            number = null;
        }
        if ((n & 8) != 0) {
            number2 = null;
        }
        if ((n & 0x10) != 0) {
            doubleVector = null;
        }
        if ((n & 0x20) != 0) {
            sizeUnit = null;
        }
        return plotImageExport.buildImageFromRawSpecs(map, format2, number, number2, doubleVector, sizeUnit);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\b\t\nB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format;", "", "()V", "defFileExt", "", "getDefFileExt", "()Ljava/lang/String;", "toString", "JPEG", "PNG", "TIFF", "Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format$JPEG;", "Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format$PNG;", "Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format$TIFF;", "plot-image-export"})
    public static abstract class Format {
        private Format() {
        }

        @NotNull
        public final String getDefFileExt() {
            String string;
            Format format2 = this;
            if (format2 instanceof PNG) {
                string = "png";
            } else if (format2 instanceof TIFF) {
                string = "tiff";
            } else if (format2 instanceof JPEG) {
                string = "jpg";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        @NotNull
        public String toString() {
            String string;
            Format format2 = this;
            if (format2 instanceof PNG) {
                string = "PNG";
            } else if (format2 instanceof TIFF) {
                string = "TIFF";
            } else if (format2 instanceof JPEG) {
                string = "JPG(quality=" + ((JPEG)this).getQuality() + ')';
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        public /* synthetic */ Format(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format$JPEG;", "Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format;", "quality", "", "(D)V", "getQuality", "()D", "plot-image-export"})
        public static final class JPEG
        extends Format {
            private final double quality;

            public JPEG(double quality) {
                super(null);
                this.quality = quality;
            }

            public /* synthetic */ JPEG(double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    d = 0.8;
                }
                this(d);
            }

            public final double getQuality() {
                return this.quality;
            }

            public JPEG() {
                this(0.0, 1, null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format$PNG;", "Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format;", "()V", "plot-image-export"})
        public static final class PNG
        extends Format {
            @NotNull
            public static final PNG INSTANCE = new PNG();

            private PNG() {
                super(null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format$TIFF;", "Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$Format;", "()V", "plot-image-export"})
        public static final class TIFF
        extends Format {
            @NotNull
            public static final TIFF INSTANCE = new TIFF();

            private TIFF() {
                super(null);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/export/PlotImageExport$ImageData;", "", "bytes", "", "plotSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "([BLorg/jetbrains/letsPlot/commons/geometry/DoubleVector;)V", "getBytes", "()[B", "getPlotSize", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-image-export"})
    public static final class ImageData {
        @NotNull
        private final byte[] bytes;
        @NotNull
        private final DoubleVector plotSize;

        public ImageData(@NotNull byte[] bytes, @NotNull DoubleVector plotSize) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)plotSize, (String)"plotSize");
            this.bytes = bytes;
            this.plotSize = plotSize;
        }

        @NotNull
        public final byte[] getBytes() {
            return this.bytes;
        }

        @NotNull
        public final DoubleVector getPlotSize() {
            return this.plotSize;
        }
    }
}

