/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.database.BasicModelRegistry;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.redis.RedisDvStructureExtensionKt;
import com.intellij.database.dialects.redis.RedisFamilyTree;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.util.sequences.SequenceFun;
import com.intellij.database.view.structure.DvFamilyHierarchyDescriptor;
import com.intellij.database.view.structure.DvFamilyRelocationDescriptor;
import com.intellij.database.view.structure.DvStructureExtension;
import com.intellij.database.view.structure.DvTransformDescriptor;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.database.view.structure.HostFamilyKin;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00120\u0012j\u0002`\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u0018\u0010\u001f\u001a\u00020\t2\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\bH\u0002J\u0014\u0010 \u001a\u00020\f2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u001cH\u0002J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001cH\u0002J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\bH\u0002J&\u0010'\u001a\b\u0012\u0004\u0012\u00020&0%2\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\b2\u0006\u0010(\u001a\u00020&H\u0002J \u0010)\u001a\u00020*2\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\b2\u0006\u0010(\u001a\u00020&H\u0002J\"\u0010+\u001a\u0004\u0018\u00010&2\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\b2\u0006\u0010(\u001a\u00020&H\u0002J\u0010\u0010,\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u001cH\u0002J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010\u001e\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/database/dialects/redis/RedisDvStructureExtension;", "Lcom/intellij/database/view/structure/DvStructureExtension;", "<init>", "()V", "modelRegistry", "Lcom/intellij/database/BasicModelRegistry;", "forest", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lcom/intellij/database/model/families/Family;", "Lcom/intellij/database/dialects/redis/RedisFamilyTree;", "modelDelimiters", "Lcom/intellij/database/model/basic/BasicModel;", "", "keyHierarchyDescriptor", "Lcom/intellij/database/view/structure/DvFamilyHierarchyDescriptor;", "schemaKeyRelocationDescriptor", "Lcom/intellij/database/view/structure/DvFamilyRelocationDescriptor;", "getTransformDescriptors", "", "Lcom/intellij/database/model/ObjectKind;", "Lcom/intellij/database/view/structure/DvTransformDescriptor;", "Lcom/intellij/database/view/structure/DvTransformDescriptors;", "viewOptions", "Lcom/intellij/database/view/structure/DvViewOptions;", "enableTransformationForFamily", "", "family", "Lcom/intellij/database/model/families/HostFamily;", "Lcom/intellij/database/model/basic/BasicElement;", "obtainModelDelimiter", "model", "growRedisFamilyTree", "getFamilyDelimiter", "getElementDelimiter", "element", "hasElementParent", "fetchTopNodes", "Lkotlin/sequences/Sequence;", "Lcom/intellij/database/model/basic/BasicNode;", "fetchChildren", "node", "countChildren", "", "getParent", "getPresentableName", "clearCachesForDataSource", "", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "intellij.database.dialects.redis"})
final class RedisDvStructureExtension
implements DvStructureExtension {
    private BasicModelRegistry modelRegistry;
    @NotNull
    private final LoadingCache<Family<?>, RedisFamilyTree> forest;
    @NotNull
    private final LoadingCache<BasicModel, String> modelDelimiters;
    @NotNull
    private final DvFamilyHierarchyDescriptor keyHierarchyDescriptor;
    @NotNull
    private final DvFamilyRelocationDescriptor schemaKeyRelocationDescriptor;

    public RedisDvStructureExtension() {
        LoadingCache loadingCache = Caffeine.newBuilder().weakKeys().build(new CacheLoader(this){
            final /* synthetic */ RedisDvStructureExtension $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final RedisFamilyTree load(Family<? extends BasicElement> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return RedisDvStructureExtension.access$growRedisFamilyTree(this.$tmp0, p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.forest = loadingCache;
        LoadingCache loadingCache2 = Caffeine.newBuilder().weakKeys().build(new CacheLoader(this){
            final /* synthetic */ RedisDvStructureExtension $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final String load(BasicModel p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RedisDvStructureExtension.access$obtainModelDelimiter(this.$tmp0, p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache2, (String)"build(...)");
        this.modelDelimiters = loadingCache2;
        ObjectKind objectKind = ObjectKind.COLUMN;
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
        this.keyHierarchyDescriptor = new DvFamilyHierarchyDescriptor(objectKind, (Function1)new Function1<Family<? extends BasicElement>, Sequence<? extends BasicNode>>((Object)this){

            public final Sequence<BasicNode> invoke(Family<? extends BasicElement> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return RedisDvStructureExtension.access$fetchTopNodes((RedisDvStructureExtension)this.receiver, p0);
            }
        }, (Function2)new Function2<Family<? extends BasicElement>, BasicNode, Sequence<? extends BasicNode>>((Object)this){

            public final Sequence<BasicNode> invoke(Family<? extends BasicElement> p0, BasicNode p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return RedisDvStructureExtension.access$fetchChildren((RedisDvStructureExtension)this.receiver, p0, p1);
            }
        }, (Function2)new Function2<Family<? extends BasicElement>, BasicNode, Integer>((Object)this){

            public final Integer invoke(Family<? extends BasicElement> p0, BasicNode p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return RedisDvStructureExtension.access$countChildren((RedisDvStructureExtension)this.receiver, p0, p1);
            }
        }, (Function2)new Function2<Family<? extends BasicElement>, BasicNode, BasicNode>((Object)this){

            public final BasicNode invoke(Family<? extends BasicElement> p0, BasicNode p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return RedisDvStructureExtension.access$getParent((RedisDvStructureExtension)this.receiver, p0, p1);
            }
        }, (Function1)new Function1<BasicElement, String>((Object)this){

            public final String invoke(BasicElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RedisDvStructureExtension.access$getPresentableName((RedisDvStructureExtension)this.receiver, p0);
            }
        });
        ObjectKind objectKind2 = ObjectKind.SCHEMA;
        Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"SCHEMA");
        ObjectKind objectKind3 = ObjectKind.COLLECTION;
        Intrinsics.checkNotNullExpressionValue((Object)objectKind3, (String)"COLLECTION");
        this.schemaKeyRelocationDescriptor = new DvFamilyRelocationDescriptor(new HostFamilyKin(objectKind2, objectKind3), (DvTransformDescriptor)this.keyHierarchyDescriptor, arg_0 -> RedisDvStructureExtension.schemaKeyRelocationDescriptor$lambda$0((Function1)new Function1<HostFamily<? extends BasicElement>, Boolean>((Object)this){

            public final Boolean invoke(HostFamily<? extends BasicElement> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return RedisDvStructureExtension.access$enableTransformationForFamily((RedisDvStructureExtension)this.receiver, p0);
            }
        }, arg_0), arg_0 -> RedisDvStructureExtension.schemaKeyRelocationDescriptor$lambda$1((Function1)new Function1<BasicElement, Boolean>((Object)this){

            public final Boolean invoke(BasicElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RedisDvStructureExtension.access$hasElementParent((RedisDvStructureExtension)this.receiver, p0);
            }
        }, arg_0));
    }

    @NotNull
    public Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> getTransformDescriptors(@NotNull DvViewOptions viewOptions) {
        Intrinsics.checkNotNullParameter((Object)viewOptions, (String)"viewOptions");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ObjectKind.SCHEMA, (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)ObjectKind.COLLECTION, (Object)this.schemaKeyRelocationDescriptor))), TuplesKt.to((Object)ObjectKind.COLLECTION, (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)ObjectKind.COLLECTION, (Object)this.keyHierarchyDescriptor)))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final boolean enableTransformationForFamily(HostFamily<? extends BasicElement> family) {
        BasicModel basicModel = family.getModel();
        if (basicModel == null) {
            return false;
        }
        BasicModel model = basicModel;
        Object object = this.modelDelimiters.get((Object)model);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String delimiter = (String)object;
        return !Intrinsics.areEqual((Object)delimiter, (Object)RedisDvStructureExtensionKt.access$getNoDelimiter$p());
    }

    private final String obtainModelDelimiter(BasicModel model) {
        BasicModelRegistry basicModelRegistry;
        if (this.modelRegistry == null) {
            this.modelRegistry = BasicModelRegistry.Companion.instance();
        }
        if ((basicModelRegistry = this.modelRegistry) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modelRegistry");
            basicModelRegistry = null;
        }
        LocalDataSource localDataSource = basicModelRegistry.getLocalDataSource(model);
        if (localDataSource == null) {
            return RedisDvStructureExtensionKt.access$getNoDelimiter$p();
        }
        LocalDataSource dataSource = localDataSource;
        String string = dataSource.getAdditionalProperty("database.redis.view.hierarchy.delimiter");
        if (string == null) {
            string = RedisDvStructureExtensionKt.access$getNoDelimiter$p();
        }
        String delimiter = string;
        return delimiter;
    }

    private final RedisFamilyTree growRedisFamilyTree(Family<? extends BasicElement> family) {
        String delimiter = this.getFamilyDelimiter(family);
        return new RedisFamilyTree(family, delimiter);
    }

    private final String getFamilyDelimiter(Family<?> family) {
        BasicModel basicModel = family.getModel();
        if (basicModel == null) {
            return RedisDvStructureExtensionKt.access$getNoDelimiter$p();
        }
        BasicModel model = basicModel;
        Object object = this.modelDelimiters.get((Object)model);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (String)object;
    }

    private final String getElementDelimiter(BasicElement element) {
        Family family = element.getParentFamily();
        if (family == null) {
            return RedisDvStructureExtensionKt.access$getNoDelimiter$p();
        }
        Family family2 = family;
        return this.getFamilyDelimiter(family2);
    }

    private final boolean hasElementParent(BasicElement element) {
        String delimiter = this.getElementDelimiter(element);
        String string = element.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)delimiter, (boolean)false, (int)2, null);
    }

    private final Sequence<BasicNode> fetchTopNodes(Family<? extends BasicElement> family) {
        if (family.isEmpty()) {
            return (Sequence)RedisDvStructureExtensionKt.access$getNoElements$p();
        }
        Object object = this.forest.get(family);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        RedisFamilyTree tree2 = (RedisFamilyTree)object;
        return (Sequence)SequenceFun.asSequence((Collection)tree2.getTopNodes());
    }

    private final Sequence<BasicNode> fetchChildren(Family<? extends BasicElement> family, BasicNode node) {
        if (family.isEmpty()) {
            return (Sequence)RedisDvStructureExtensionKt.access$getNoElements$p();
        }
        Object object = this.forest.get(family);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        RedisFamilyTree tree2 = (RedisFamilyTree)object;
        if (tree2.getTree().getNodeChildrenCount(node) == 0) {
            return (Sequence)RedisDvStructureExtensionKt.access$getNoElements$p();
        }
        return (Sequence)SequenceFun.asSequence((Collection)tree2.getTree().getNodeChildren(node));
    }

    private final int countChildren(Family<? extends BasicElement> family, BasicNode node) {
        if (family.isEmpty()) {
            return 0;
        }
        Object object = this.forest.get(family);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        RedisFamilyTree tree2 = (RedisFamilyTree)object;
        return tree2.getTree().getNodeChildrenCount(node);
    }

    private final BasicNode getParent(Family<? extends BasicElement> family, BasicNode node) {
        Object object = this.forest.get(family);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        RedisFamilyTree tree2 = (RedisFamilyTree)object;
        return tree2.getTree().getNodeParent(node);
    }

    private final String getPresentableName(BasicElement element) {
        String delimiter = this.getElementDelimiter(element);
        String string = element.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String s = StringsKt.substringAfterLast$default((String)string, (String)delimiter, null, (int)2, null);
        if (((CharSequence)s).length() == 0) {
            s = "(unnamed)";
        }
        return s;
    }

    public void clearCachesForDataSource(@NotNull RawDataSource dataSource, @NotNull BasicModel model) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.forest.asMap().keySet().removeIf(arg_0 -> RedisDvStructureExtension.clearCachesForDataSource$lambda$1(arg_0 -> RedisDvStructureExtension.clearCachesForDataSource$lambda$0(model, arg_0), arg_0));
        this.modelDelimiters.invalidate((Object)model);
    }

    private static final boolean schemaKeyRelocationDescriptor$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean schemaKeyRelocationDescriptor$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean clearCachesForDataSource$lambda$0(BasicModel $model, Family it) {
        return it.getModel() == $model;
    }

    private static final boolean clearCachesForDataSource$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ RedisFamilyTree access$growRedisFamilyTree(RedisDvStructureExtension $this, Family family) {
        return $this.growRedisFamilyTree((Family<? extends BasicElement>)family);
    }

    public static final /* synthetic */ String access$obtainModelDelimiter(RedisDvStructureExtension $this, BasicModel model) {
        return $this.obtainModelDelimiter(model);
    }

    public static final /* synthetic */ Sequence access$fetchTopNodes(RedisDvStructureExtension $this, Family family) {
        return $this.fetchTopNodes((Family<? extends BasicElement>)family);
    }

    public static final /* synthetic */ Sequence access$fetchChildren(RedisDvStructureExtension $this, Family family, BasicNode node) {
        return $this.fetchChildren((Family<? extends BasicElement>)family, node);
    }

    public static final /* synthetic */ int access$countChildren(RedisDvStructureExtension $this, Family family, BasicNode node) {
        return $this.countChildren((Family<? extends BasicElement>)family, node);
    }

    public static final /* synthetic */ BasicNode access$getParent(RedisDvStructureExtension $this, Family family, BasicNode node) {
        return $this.getParent((Family<? extends BasicElement>)family, node);
    }

    public static final /* synthetic */ String access$getPresentableName(RedisDvStructureExtension $this, BasicElement element) {
        return $this.getPresentableName(element);
    }

    public static final /* synthetic */ boolean access$enableTransformationForFamily(RedisDvStructureExtension $this, HostFamily family) {
        return $this.enableTransformationForFamily((HostFamily<? extends BasicElement>)family);
    }

    public static final /* synthetic */ boolean access$hasElementParent(RedisDvStructureExtension $this, BasicElement element) {
        return $this.hasElementParent(element);
    }
}

