/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.redis;

import com.google.common.collect.ImmutableSet;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.redis.RedisDbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.redis.RedisTokens;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.psi.SqlCommonTokens;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RedisDialect
extends SqlLanguageDialectBase {
    public static final RedisDialect INSTANCE = new RedisDialect();

    private RedisDialect() {
        super("Redis");
    }

    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(RedisTokens.class);
        if (tokensHelper == null) {
            RedisDialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = RedisDbms.REDIS;
        if (dbms == null) {
            RedisDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            RedisDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public ObjectKind getSuperKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            RedisDialect.$$$reportNull$$$0(3);
        }
        if (LazyData.ourKnownKeyTypes.contains(kind)) {
            ObjectKind objectKind = ObjectKind.COLLECTION;
            if (objectKind == null) {
                RedisDialect.$$$reportNull$$$0(4);
            }
            return objectKind;
        }
        ObjectKind objectKind = super.getSuperKind(kind);
        if (objectKind == null) {
            RedisDialect.$$$reportNull$$$0(5);
        }
        return objectKind;
    }

    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    public SqlCloseBlockProcessor[] getEnterHandlerBlockProcessors() {
        return SqlCloseBlockProcessor.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/redis/RedisDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/redis/RedisDialect";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperKind";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSuperKind";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars((SqlLanguageDialect)INSTANCE));
        static final Set<IElementType> ourSupportedOperators = Collections.emptySet();
        static final TokenSet ourClosingTokens = TokenSet.create((IElementType[])new IElementType[]{SqlCommonTokens.SQL_EOL});
        static final Set<ObjectKind> ourKnownKeyTypes = ImmutableSet.of((Object)ObjectKind.STRING, (Object)ObjectKind.LIST, (Object)ObjectKind.SET, (Object)ObjectKind.SORTED_SET, (Object)ObjectKind.HASH_TABLE, (Object)ObjectKind.STREAM, (Object[])new ObjectKind[]{ObjectKind.JSON_DOCUMENT, ObjectKind.DATA_STRUCTURE});

        LazyData() {
        }
    }
}

