/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.hunspell;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.langs.LanguageISO;
import ai.grazie.nlp.langs.alphabet.Alphabet;
import ai.grazie.spell.dictionary.RuleDictionary;
import ai.grazie.spell.dictionary.rule.ReplacingRuleDictionary;
import ai.grazie.spell.lists.hunspell.HunspellWordList;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.hunspell.HunspellBundle;
import com.intellij.util.Consumer;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 02\u00020\u0001:\u00010B)\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bBC\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\u000eJ\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003J\b\u0010\u001d\u001a\u00020\u0003H\u0016J\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010!J\u001e\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020\u00032\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'H\u0016J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003H\u0002J\u0010\u0010)\u001a\u00020#2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u000e\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u0003J!\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030-*\u00020\u00032\b\b\u0002\u0010.\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010/R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/spellchecker/hunspell/HunspellDictionary;", "Lcom/intellij/spellchecker/dictionary/Dictionary;", "path", "", "name", "language", "Lai/grazie/nlp/langs/LanguageISO;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lai/grazie/nlp/langs/LanguageISO;)V", "dic", "aff", "trigrams", "", "replacingRules", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Lai/grazie/nlp/langs/LanguageISO;Ljava/lang/String;)V", "dict", "Lai/grazie/spell/lists/hunspell/HunspellWordList;", "getDict", "()Lai/grazie/spell/lists/hunspell/HunspellWordList;", "ruleDictionary", "Lai/grazie/spell/dictionary/RuleDictionary;", "getRuleDictionary", "()Lai/grazie/spell/dictionary/RuleDictionary;", "letters", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "alphabet", "Lai/grazie/nlp/langs/alphabet/Alphabet;", "getName", "contains", "", "word", "(Ljava/lang/String;)Ljava/lang/Boolean;", "consumeSuggestions", "", "consumer", "Lcom/intellij/util/Consumer;", "getWords", "", "isAlien", "buildAlphabet", "parseReplacingRules", "datRule", "splitByDelimiter", "", "delimiter", "(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "Companion", "intellij.spellchecker"})
@SourceDebugExtension(value={"SMAP\nHunspellDictionary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HunspellDictionary.kt\ncom/intellij/spellchecker/hunspell/HunspellDictionary\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,123:1\n1#2:124\n295#3,2:125\n295#3,2:127\n1869#3:129\n1870#3:135\n774#3:136\n865#3,2:137\n1563#3:139\n1634#3,3:140\n648#4,5:130\n37#5,2:143\n*S KotlinDebug\n*F\n+ 1 HunspellDictionary.kt\ncom/intellij/spellchecker/hunspell/HunspellDictionary\n*L\n48#1:125,2\n64#1:127,2\n103#1:129\n103#1:135\n113#1:136\n113#1:137,2\n121#1:139\n121#1:140,3\n104#1:130,5\n121#1:143,2\n*E\n"})
public final class HunspellDictionary
implements Dictionary {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final HunspellWordList dict;
    @Nullable
    private final RuleDictionary ruleDictionary;
    @NotNull
    private final HashSet<Integer> letters;
    @Nullable
    private final Alphabet alphabet;
    @Nullable
    private final LanguageISO language;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public HunspellDictionary(@NotNull String path, @Nullable String name, @Nullable LanguageISO language) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.letters = new HashSet();
        HunspellBundle paths = Companion.getHunspellBundle(path);
        if (!paths.dictionaryExists()) {
            boolean $i$a$-check-HunspellDictionary$22 = false;
            String $i$a$-check-HunspellDictionary$22 = "File '" + path + "' not found";
            throw new IllegalStateException($i$a$-check-HunspellDictionary$22.toString());
        }
        File dic = paths.component1();
        File aff = paths.component2();
        File trigrams = paths.component3();
        File replacingRules = paths.component4();
        String string = name;
        if (string == null) {
            string = path;
        }
        this.name = string;
        this.language = language;
        HunspellDictionary hunspellDictionary = this;
        if (this.language == null) {
            object = null;
        } else {
            Object v3;
            HunspellDictionary hunspellDictionary2;
            block5: {
                void $this$firstOrNull$iv;
                Iterable iterable = (Iterable)Language.getEntries();
                hunspellDictionary2 = hunspellDictionary;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Language it = (Language)element$iv;
                    boolean bl = false;
                    if (!(it.getIso() == this.language)) continue;
                    v3 = element$iv;
                    break block5;
                }
                v3 = null;
            }
            hunspellDictionary = hunspellDictionary2;
            Language language2 = v3;
            object = language2 != null ? language2.getAlphabet() : null;
        }
        hunspellDictionary.alphabet = object;
        this.dict = HunspellWordList.Companion.create(FilesKt.readText$default((File)aff, null, (int)1, null), FilesKt.readText$default((File)dic, null, (int)1, null), trigrams.exists() ? FilesKt.readLines$default((File)trigrams, null, (int)1, null) : null, HunspellDictionary::_init_$lambda$2);
        File file = replacingRules;
        this.ruleDictionary = (file != null ? file.exists() : false) ? this.parseReplacingRules(FilesKt.readText$default((File)replacingRules, null, (int)1, null)) : null;
        this.buildAlphabet(FilesKt.readText$default((File)dic, null, (int)1, null));
    }

    public /* synthetic */ HunspellDictionary(String string, String string2, LanguageISO languageISO, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            languageISO = null;
        }
        this(string, string2, languageISO);
    }

    /*
     * WARNING - void declaration
     */
    public HunspellDictionary(@NotNull String dic, @NotNull String aff, @Nullable List<String> trigrams, @NotNull String name, @NotNull LanguageISO language, @Nullable String replacingRules) {
        Object v0;
        block3: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)dic, (String)"dic");
            Intrinsics.checkNotNullParameter((Object)aff, (String)"aff");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            this.letters = new HashSet();
            if (!(((CharSequence)dic).length() > 0)) {
                boolean $i$a$-check-HunspellDictionary$62 = false;
                String $i$a$-check-HunspellDictionary$62 = "Dictionary must not be empty string";
                throw new IllegalStateException($i$a$-check-HunspellDictionary$62.toString());
            }
            if (!(((CharSequence)aff).length() > 0)) {
                boolean $i$a$-check-HunspellDictionary$72 = false;
                String $i$a$-check-HunspellDictionary$72 = "Affix must not be empty string";
                throw new IllegalStateException($i$a$-check-HunspellDictionary$72.toString());
            }
            this.name = name;
            this.language = language;
            Iterable $i$a$-check-HunspellDictionary$72 = (Iterable)Language.getEntries();
            HunspellDictionary hunspellDictionary = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Language it = (Language)element$iv;
                boolean bl = false;
                if (!(it.getIso() == language)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Language language2 = v0;
        hunspellDictionary.alphabet = language2 != null ? language2.getAlphabet() : null;
        this.dict = HunspellWordList.Companion.create(aff, dic, trigrams, HunspellDictionary::_init_$lambda$6);
        String string = replacingRules;
        this.ruleDictionary = string != null ? this.parseReplacingRules(string) : null;
        this.buildAlphabet(dic);
    }

    @NotNull
    public final HunspellWordList getDict() {
        return this.dict;
    }

    @Nullable
    public final RuleDictionary getRuleDictionary() {
        return this.ruleDictionary;
    }

    @Nullable
    public final String language() {
        Object object = this.language;
        if (object == null || (object = object.name()) == null) {
            object = this.dict.language();
        }
        return object;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (this.isAlien(word)) {
            return null;
        }
        if (this.dict.contains(word, false)) {
            return true;
        }
        return false;
    }

    @Override
    public void consumeSuggestions(@NotNull String word, @NotNull Consumer<String> consumer) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Iterator iterator = this.dict.suggest(word).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            String suggestion = (String)e;
            consumer.consume((Object)suggestion);
        }
    }

    @Override
    @NotNull
    public Set<String> getWords() {
        throw new UnsupportedOperationException();
    }

    private final boolean isAlien(String word) {
        if (this.alphabet != null) {
            return !this.alphabet.matchAny((CharSequence)word);
        }
        String string = word.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string.chars().anyMatch(arg_0 -> HunspellDictionary.isAlien$lambda$0(this, arg_0));
    }

    private final void buildAlphabet(String dic) {
        if (this.alphabet == null) {
            Iterable $this$forEach$iv = StringsKt.lines((CharSequence)dic);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                block3: {
                    String line = (String)element$iv;
                    boolean bl = false;
                    String $this$takeWhile$iv = line;
                    boolean $i$f$takeWhile = false;
                    int n = $this$takeWhile$iv.length();
                    for (int index$iv = 0; index$iv < n; ++index$iv) {
                        char it = $this$takeWhile$iv.charAt(index$iv);
                        boolean bl2 = false;
                        if (it != ' ' && it != '/') continue;
                        String string2 = $this$takeWhile$iv;
                        int n2 = 0;
                        String string3 = string2.substring(n2, index$iv);
                        string = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        break block3;
                    }
                    string = $this$takeWhile$iv;
                }
                String string4 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                string4.chars().forEach(arg_0 -> HunspellDictionary.buildAlphabet$lambda$0$1(this, arg_0));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RuleDictionary parseReplacingRules(@NotNull String datRule) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)datRule, (String)"datRule");
        HashSet<ReplacingRuleDictionary.Descriptor> rules = new HashSet<ReplacingRuleDictionary.Descriptor>();
        Iterable $this$filter$iv = StringsKt.lines((CharSequence)datRule);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (String line : (List)destination$iv$iv) {
            String[] stringArray = this.splitByDelimiter(line, "->");
            String incorrect = stringArray[0];
            String correct = stringArray[1];
            rules.add(new ReplacingRuleDictionary.Descriptor(HunspellDictionary.splitByDelimiter$default(this, incorrect, null, 1, null), HunspellDictionary.splitByDelimiter$default(this, correct, null, 1, null)));
        }
        return (RuleDictionary)new ReplacingRuleDictionary((Collection)rules);
    }

    /*
     * WARNING - void declaration
     */
    private final String[] splitByDelimiter(String $this$splitByDelimiter, String delimiter) {
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{delimiter};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)$this$splitByDelimiter, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    static /* synthetic */ String[] splitByDelimiter$default(HunspellDictionary hunspellDictionary, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = ",";
        }
        return hunspellDictionary.splitByDelimiter(string, string2);
    }

    @JvmOverloads
    public HunspellDictionary(@NotNull String path, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(path, name, null, 4, null);
    }

    @JvmOverloads
    public HunspellDictionary(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(path, null, null, 6, null);
    }

    private static final void _init_$lambda$2() {
        ProgressManager.checkCanceled();
    }

    private static final void _init_$lambda$6() {
        ProgressManager.checkCanceled();
    }

    private static final boolean isAlien$lambda$0(HunspellDictionary this$0, int it) {
        return !this$0.letters.contains(it);
    }

    private static final void buildAlphabet$lambda$0$1(HunspellDictionary this$0, int it) {
        this$0.letters.add(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/spellchecker/hunspell/HunspellDictionary$Companion;", "", "<init>", "()V", "getHunspellBundle", "Lcom/intellij/spellchecker/hunspell/HunspellBundle;", "dicPath", "", "isHunspell", "", "path", "intellij.spellchecker"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HunspellBundle getHunspellBundle(@NotNull String dicPath) {
            Intrinsics.checkNotNullParameter((Object)dicPath, (String)"dicPath");
            String string = FileUtilRt.getNameWithoutExtension((String)dicPath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
            String path = string;
            Path path2 = Paths.get(path, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            String filename = ((Object)path2.getFileName()).toString();
            File file = new File(path + ".dic");
            File file2 = new File(path + ".aff");
            File file3 = new File(path + ".trigrams.txt");
            Path path3 = Paths.get(path, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            return new HunspellBundle(file, file2, file3, path3.getParent().resolve("../rule/" + filename + ".dat").toFile());
        }

        public final boolean isHunspell(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.getHunspellBundle(path).dictionaryExists();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

