/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.codeWithMe.ClientId;
import com.intellij.docker.composeFile.ComposeFileServicesIndexKt;
import com.intellij.docker.composeFile.ComposeFileUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlRecursivePsiElementVisitor;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/composeFile/ComposeFileServicesIndex;", "", "<init>", "()V", "GIST", "Lcom/intellij/util/gist/PsiFileGist;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "isDockerComposeFile", "", "yamlFile", "Lorg/jetbrains/yaml/psi/YAMLFile;", "calculateIndex", "file", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.clouds.docker.compose"})
public final class ComposeFileServicesIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiFileGist<String> GIST;

    private ComposeFileServicesIndex() {
        PsiFileGist psiFileGist = GistManager.getInstance().newPsiFileGist("docker.compose.services", 3, (DataExternalizer)EnumeratorStringDescriptor.INSTANCE, arg_0 -> ComposeFileServicesIndex.GIST$lambda$0((Function1)new Function1<PsiFile, String>((Object)this){

            public final String invoke(PsiFile p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ComposeFileServicesIndex.access$calculateIndex((ComposeFileServicesIndex)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)psiFileGist, (String)"newPsiFileGist(...)");
        this.GIST = psiFileGist;
    }

    public final boolean isDockerComposeFile(@Nullable YAMLFile yamlFile) {
        YAMLFile yAMLFile = yamlFile;
        if ((yAMLFile != null && (yAMLFile = yAMLFile.getOriginalFile()) != null ? yAMLFile.getVirtualFile() : null) == null) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            YAMLMapping yAMLMapping = ComposeFileServicesIndexKt.access$getTopLevelValue(yamlFile);
            boolean bl = yAMLMapping != null ? ComposeFileServicesIndexKt.access$contains(yAMLMapping, "x-testing-root") : false;
            if (bl) {
                return true;
            }
        }
        return Intrinsics.areEqual((Object)"type: docker-compose:", (Object)this.GIST.getFileData((PsiFile)yamlFile));
    }

    private final String calculateIndex(PsiFile file) {
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        Ref result2 = ref;
        file.accept((PsiElementVisitor)new YamlRecursivePsiElementVisitor((Ref<String>)result2){
            final /* synthetic */ Ref<String> $result;
            {
                this.$result = $result;
            }

            public void visitDocument(YAMLDocument document) {
                block11: {
                    block12: {
                        boolean bl;
                        block9: {
                            String fileName;
                            block10: {
                                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                                String string = document.getContainingFile().getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                                fileName = string;
                                if (!ComposeFileUtil.isDockerComposeYamlFileName(fileName)) break block10;
                                this.$result.set((Object)"type: docker-compose:");
                                break block11;
                            }
                            YAMLValue yAMLValue = document.getTopLevelValue();
                            YAMLMapping yAMLMapping = yAMLValue instanceof YAMLMapping ? (YAMLMapping)yAMLValue : null;
                            if (yAMLMapping == null) {
                                return;
                            }
                            YAMLMapping topMapping = yAMLMapping;
                            if (!ComposeFileServicesIndexKt.access$contains(topMapping, "services")) {
                                return;
                            }
                            boolean hasComposeName = ComposeFileUtil.isComposeYamlFileName(fileName);
                            if (hasComposeName) break block12;
                            Iterable $this$any$iv = ComposeFileServicesIndexKt.access$getOTHER_TOP_LEVEL_KEYS$p();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    String p0 = (String)element$iv;
                                    boolean bl2 = false;
                                    if (!ComposeFileServicesIndexKt.access$contains(topMapping, p0)) continue;
                                    bl = true;
                                    break block9;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) break block11;
                    }
                    this.$result.set((Object)"type: docker-compose:");
                }
            }
        });
        return (String)result2.get();
    }

    private static final String GIST$lambda$0(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final ComposeFileServicesIndex getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ String access$calculateIndex(ComposeFileServicesIndex $this, PsiFile file) {
        return $this.calculateIndex(file);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/docker/composeFile/ComposeFileServicesIndex$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/docker/composeFile/ComposeFileServicesIndex;", "intellij.clouds.docker.compose"})
    @SourceDebugExtension(value={"SMAP\nComposeFileServicesIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeFileServicesIndex.kt\ncom/intellij/docker/composeFile/ComposeFileServicesIndex$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,85:1\n42#2,3:86\n*S KotlinDebug\n*F\n+ 1 ComposeFileServicesIndex.kt\ncom/intellij/docker/composeFile/ComposeFileServicesIndex$Companion\n*L\n69#1:86,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ComposeFileServicesIndex getInstance() {
            boolean $i$f$service = false;
            Class<ComposeFileServicesIndex> serviceClass$iv = ComposeFileServicesIndex.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ComposeFileServicesIndex)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

