/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.PrettierBundle;
import com.intellij.prettierjs.PrettierUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/prettierjs/OpenConfigurationAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "icon", "Ljavax/swing/Icon;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljavax/swing/Icon;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.prettierJS"})
public final class OpenConfigurationAction
extends DumbAwareAction {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;

    public OpenConfigurationAction(@NotNull Project project, @NotNull VirtualFile file, @Nullable Icon icon) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(PrettierBundle.message("prettier.action.open.configuration.file.label", new Object[0]), null, icon);
        this.project = project;
        this.file = file;
    }

    public /* synthetic */ OpenConfigurationAction(Project project, VirtualFile virtualFile, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            icon = null;
        }
        this(project, virtualFile, icon);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile configFile = PrettierUtil.findFileConfig(this.project, this.file);
        if (configFile != null) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
            if (fileEditorManager.isFileOpen(configFile)) {
                fileEditorManager.closeFile(configFile);
            }
            FileEditor[] fileEditorArray = fileEditorManager.openFile(configFile, true);
            Intrinsics.checkNotNull((Object)fileEditorArray);
        } else {
            String string = PrettierBundle.message("prettier.formatter.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = PrettierBundle.message("prettier.notification.config.not.found", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            Notification notification = JSLinterGuesser.NOTIFICATION_GROUP.createNotification(string, string2, NotificationType.INFORMATION);
            notification.notify(this.project);
        }
    }
}

