/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.formatting.service.AsyncDocumentFormattingService;
import com.intellij.formatting.service.AsyncFormattingRequest;
import com.intellij.formatting.service.FormattingService;
import com.intellij.lang.javascript.imports.JSModuleImportOptimizerBase;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.PrettierBundle;
import com.intellij.prettierjs.PrettierConfiguration;
import com.intellij.prettierjs.PrettierFormattingServiceKt;
import com.intellij.prettierjs.PrettierLanguageService;
import com.intellij.prettierjs.PrettierUtil;
import com.intellij.prettierjs.ReformatWithPrettierAction;
import com.intellij.prettierjs.formatting.PrettierFormattingApplier;
import com.intellij.prettierjs.formatting.PrettierRangeKt;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.CoreCodeStyleUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\r\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0014J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/prettierjs/PrettierFormattingService;", "Lcom/intellij/formatting/service/AsyncDocumentFormattingService;", "<init>", "()V", "prepareForFormatting", "", "document", "Lcom/intellij/openapi/editor/Document;", "formattingContext", "Lcom/intellij/formatting/FormattingContext;", "getName", "", "Lcom/intellij/openapi/util/NlsSafe;", "getNotificationGroupId", "getFeatures", "", "Lcom/intellij/formatting/service/FormattingService$Feature;", "canFormat", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "createFormattingTask", "Lcom/intellij/formatting/service/AsyncDocumentFormattingService$FormattingTask;", "request", "Lcom/intellij/formatting/service/AsyncFormattingRequest;", "isApplicable", "PrettierFormattingTask", "intellij.prettierJS"})
@SourceDebugExtension(value={"SMAP\nPrettierFormattingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrettierFormattingService.kt\ncom/intellij/prettierjs/PrettierFormattingService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1#2:152\n*E\n"})
public final class PrettierFormattingService
extends AsyncDocumentFormattingService {
    protected void prepareForFormatting(@NotNull Document document, @NotNull FormattingContext formattingContext) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)formattingContext, (String)"formattingContext");
    }

    @NotNull
    protected String getName() {
        return "Prettier";
    }

    @NotNull
    protected String getNotificationGroupId() {
        return "Prettier";
    }

    @NotNull
    public Set<FormattingService.Feature> getFeatures() {
        return SetsKt.setOf((Object)FormattingService.Feature.FORMAT_FRAGMENTS);
    }

    public boolean canFormat(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return Registry.Companion.is("prettier.use.async.formatting.service") && this.isApplicable(psiFile);
    }

    @Nullable
    protected AsyncDocumentFormattingService.FormattingTask createFormattingTask(@NotNull AsyncFormattingRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        FormattingContext formattingContext = request.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)formattingContext, (String)"getContext(...)");
        FormattingContext context = formattingContext;
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiFile psiFile = context.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiFile file = psiFile;
        VirtualFile virtualFile = context.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        CountDownLatch formatterLatch = new CountDownLatch(1);
        file.putUserData(JSModuleImportOptimizerBase.COUNTDOWN_LATCH_KEY, (Object)formatterLatch);
        return new PrettierFormattingTask(request, file, virtualFile2, project2, formatterLatch);
    }

    private final boolean isApplicable(PsiFile psiFile) {
        Template template;
        TextEditor fileEditor;
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PrettierConfiguration prettierConfiguration = PrettierConfiguration.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)prettierConfiguration, (String)"getInstance(...)");
        PrettierConfiguration configuration = prettierConfiguration;
        if (!configuration.isRunOnReformat()) {
            return false;
        }
        FileEditor fileEditor2 = FileEditorManager.getInstance((Project)project2).getSelectedEditor(file);
        TextEditor textEditor = fileEditor = fileEditor2 instanceof TextEditor ? (TextEditor)fileEditor2 : null;
        if (textEditor != null) {
            TextEditor it = textEditor;
            boolean bl = false;
            v4 = TemplateManager.getInstance((Project)project2).getActiveTemplate(it.getEditor());
        } else {
            v4 = template = null;
        }
        if (template != null) {
            return false;
        }
        return PrettierUtil.isFormattingAllowedForFile(project2, file);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0016\u0010\u0017\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/prettierjs/PrettierFormattingService$PrettierFormattingTask;", "Lcom/intellij/formatting/service/AsyncDocumentFormattingService$FormattingTask;", "request", "Lcom/intellij/formatting/service/AsyncFormattingRequest;", "file", "Lcom/intellij/psi/PsiFile;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "formatterLatch", "Ljava/util/concurrent/CountDownLatch;", "<init>", "(Lcom/intellij/formatting/service/AsyncFormattingRequest;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;Ljava/util/concurrent/CountDownLatch;)V", "cancelled", "", "isRunUnderProgress", "cancel", "run", "", "computeExtendedRanges", "", "Lcom/intellij/openapi/util/TextRange;", "processRangesWithPrettier", "ranges", "intellij.prettierJS"})
    @SourceDebugExtension(value={"SMAP\nPrettierFormattingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrettierFormattingService.kt\ncom/intellij/prettierjs/PrettierFormattingService$PrettierFormattingTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1803#2,2:152\n1805#2:155\n1068#2:156\n1#3:154\n*S KotlinDebug\n*F\n+ 1 PrettierFormattingService.kt\ncom/intellij/prettierjs/PrettierFormattingService$PrettierFormattingTask\n*L\n101#1:152,2\n101#1:155\n111#1:156\n*E\n"})
    private static final class PrettierFormattingTask
    implements AsyncDocumentFormattingService.FormattingTask {
        @NotNull
        private final AsyncFormattingRequest request;
        @NotNull
        private final PsiFile file;
        @NotNull
        private final VirtualFile virtualFile;
        @NotNull
        private final Project project;
        @NotNull
        private final CountDownLatch formatterLatch;
        private boolean cancelled;

        public PrettierFormattingTask(@NotNull AsyncFormattingRequest request, @NotNull PsiFile file, @NotNull VirtualFile virtualFile, @NotNull Project project, @NotNull CountDownLatch formatterLatch) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)formatterLatch, (String)"formatterLatch");
            this.request = request;
            this.file = file;
            this.virtualFile = virtualFile;
            this.project = project;
            this.formatterLatch = formatterLatch;
        }

        public boolean isRunUnderProgress() {
            return true;
        }

        public boolean cancel() {
            this.cancelled = true;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                List<TextRange> extendedRanges = this.computeExtendedRanges();
                this.processRangesWithPrettier(extendedRanges);
            }
            catch (Exception e) {
                PrettierFormattingServiceKt.access$getLOG$p().warn("Error during Prettier formatting", (Throwable)e);
            }
            finally {
                this.request.onTextReady(null);
                this.formatterLatch.countDown();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<TextRange> computeExtendedRanges() {
            List sortedRanges;
            List list;
            void $this$fold$iv;
            List extendedRanges = new ArrayList();
            List list2 = this.request.getFormattingRanges();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getFormattingRanges(...)");
            Iterable iterable = list2;
            FormatTextRanges initial$iv = new FormatTextRanges();
            boolean $i$f$fold = false;
            FormatTextRanges accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void range;
                FormatTextRanges formatTextRanges;
                TextRange textRange = (TextRange)element$iv;
                FormatTextRanges acc = accumulator$iv;
                boolean bl = false;
                FormatTextRanges $this$computeExtendedRanges_u24lambda_u240_u240 = formatTextRanges = acc;
                boolean bl2 = false;
                $this$computeExtendedRanges_u24lambda_u240_u240.add((TextRange)range, true);
                accumulator$iv = formatTextRanges;
            }
            FormatTextRanges formatRanges = accumulator$iv;
            ActionsKt.runReadAction(() -> PrettierFormattingTask.computeExtendedRanges$lambda$1(this, formatRanges, extendedRanges));
            Iterable $this$sortedByDescending$iv = extendedRanges;
            boolean $i$f$sortedByDescending = false;
            List it = list = (sortedRanges = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    TextRange it = (TextRange)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getStartOffset());
                    it = (TextRange)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStartOffset()));
                }
            }));
            boolean bl = false;
            List list3 = !((Collection)it).isEmpty() ? list : null;
            if (list3 == null) {
                List list4 = this.request.getFormattingRanges();
                list3 = list4;
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getFormattingRanges(...)");
            }
            return list3;
        }

        private final void processRangesWithPrettier(List<? extends TextRange> ranges) {
            Pair pair = (Pair)ActionsKt.runReadAction(() -> PrettierFormattingTask.processRangesWithPrettier$lambda$0(this));
            Document document = (Document)pair.component1();
            Long initialModificationStamp = (Long)pair.component2();
            if (document == null || initialModificationStamp == null) {
                return;
            }
            Ref.ObjectRef text = new Ref.ObjectRef();
            String string = this.request.getDocumentText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDocumentText(...)");
            text.element = string;
            int cursorOffset = -1;
            for (TextRange psiFileArray : ranges) {
                PrettierLanguageService.FormatResult formatted;
                if (ReformatWithPrettierAction.processFileAsFormattingTask(this.file, (String)text.element, psiFileArray) == null) {
                    return;
                }
                if (this.cancelled) {
                    return;
                }
                if (formatted.result == null) {
                    Object cfr_ignored_0 = text.element;
                    return;
                }
                text.element = text.element;
                if (formatted.cursorOffset < 0 || cursorOffset >= 0) continue;
                cursorOffset = formatted.cursorOffset;
            }
            PrettierFormattingApplier strategy = (PrettierFormattingApplier)ActionsKt.runReadAction(() -> PrettierFormattingTask.processRangesWithPrettier$lambda$1(document, this, text));
            PsiFile[] psiFileArray = new PsiFile[]{this.request.getContext().getContainingFile()};
            WriteCommandAction.writeCommandAction((Project)this.project, (PsiFile[])psiFileArray).withName(PrettierBundle.message("reformat.with.prettier.command.name", new Object[0])).shouldRecordActionForActiveDocument(false).run(() -> PrettierFormattingTask.processRangesWithPrettier$lambda$2(document, initialModificationStamp, strategy, this));
        }

        private static final Unit computeExtendedRanges$lambda$1(PrettierFormattingTask this$0, FormatTextRanges $formatRanges, List $extendedRanges) {
            List infos = CoreCodeStyleUtil.getRangeFormatInfoList((PsiFile)this$0.file, (FormattingRangesInfo)((FormattingRangesInfo)$formatRanges));
            CoreCodeStyleUtil.postProcessRanges((List)infos, arg_0 -> PrettierFormattingTask.computeExtendedRanges$lambda$1$1(arg_0 -> PrettierFormattingTask.computeExtendedRanges$lambda$1$0($extendedRanges, this$0, arg_0), arg_0));
            return Unit.INSTANCE;
        }

        private static final Unit computeExtendedRanges$lambda$1$0(List $extendedRanges, PrettierFormattingTask this$0, TextRange range) {
            block0: {
                TextRange textRange = range;
                if (textRange == null) break block0;
                TextRange it = textRange;
                boolean bl = false;
                $extendedRanges.add(PrettierRangeKt.extendRange(this$0.file, it));
            }
            return Unit.INSTANCE;
        }

        private static final void computeExtendedRanges$lambda$1$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Pair processRangesWithPrettier$lambda$0(PrettierFormattingTask this$0) {
            Document document;
            Document document2 = document = FileDocumentManager.getInstance().getDocument(this$0.virtualFile);
            return new Pair((Object)document, (Object)(document2 != null ? Long.valueOf(document2.getModificationStamp()) : null));
        }

        private static final PrettierFormattingApplier processRangesWithPrettier$lambda$1(Document $document, PrettierFormattingTask this$0, Ref.ObjectRef $text) {
            return PrettierFormattingApplier.Companion.from($document, this$0.file, (String)$text.element);
        }

        private static final void processRangesWithPrettier$lambda$2(Document $document, Long $initialModificationStamp, PrettierFormattingApplier $strategy, PrettierFormattingTask this$0) {
            Long l = $initialModificationStamp;
            if (l != null && $document.getModificationStamp() == l.longValue()) {
                $strategy.apply(this$0.project, this$0.file);
            }
        }
    }
}

