/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.serviceView;

import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewUIUtils;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.platform.execution.serviceView.ServiceModel;
import com.intellij.platform.execution.serviceView.ServiceView;
import com.intellij.platform.execution.serviceView.ServiceViewDescriptorId;
import com.intellij.platform.execution.serviceView.ServiceViewDragHelper;
import com.intellij.platform.execution.serviceView.ServiceViewNavBarPanel;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServiceViewActionProvider {
    @NonNls
    private static final String SERVICE_VIEW_ITEM_TOOLBAR = "ServiceViewItemToolbar";
    @NonNls
    static final String SERVICE_VIEW_ITEM_POPUP = "ServiceViewItemPopup";
    @NonNls
    private static final String SERVICE_VIEW_TREE_TOOLBAR = "ServiceViewTreeToolbar";
    static final DataKey<List<ServiceModel.ServiceViewItem>> SERVICES_SELECTED_ITEMS = DataKey.create((String)"services.selected.items");
    static final DataKey<List<ServiceViewDescriptorId>> SERVICES_SELECTED_DESCRIPTOR_IDS = DataKey.create((String)"services.selected.descriptor.ids");
    private static final ServiceViewActionProvider ourInstance = new ServiceViewActionProvider();
    private static final AnAction EMPTY_ACTION = new DumbAwareAction(EmptyIcon.ICON_16){

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                2.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(false);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                2.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                2.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/serviceView/ServiceViewActionProvider$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceViewActionProvider$2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };

    static ServiceViewActionProvider getInstance() {
        return ourInstance;
    }

    ActionToolbar createServiceToolbar(@NotNull JComponent component, boolean horizontal) {
        if (component == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(0);
        }
        ActionGroup actions = (ActionGroup)ActionManager.getInstance().getAction(SERVICE_VIEW_ITEM_TOOLBAR);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ServicesToolbar", actions, horizontal);
        toolbar.setTargetComponent(component);
        return toolbar;
    }

    JComponent wrapServiceToolbar(@NotNull JComponent toolbarComponent, boolean horizontal) {
        if (toolbarComponent == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(1);
        }
        final JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)toolbarComponent, "Center");
        toolbarComponent.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                wrapper.setVisible(true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                wrapper.setVisible(false);
            }
        });
        wrapper.add((Component)ServiceViewActionProvider.createEmptyToolbar(horizontal, toolbarComponent), horizontal ? "East" : "South");
        return wrapper;
    }

    void installPopupHandler(@NotNull JComponent component) {
        if (component == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(2);
        }
        PopupHandler.installPopupMenu((JComponent)component, (String)SERVICE_VIEW_ITEM_POPUP, (String)"ServicesPopup");
    }

    ActionToolbar createMasterComponentToolbar(@NotNull JComponent component) {
        if (component == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(3);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        AnAction treeActions = ActionManager.getInstance().getAction(SERVICE_VIEW_TREE_TOOLBAR);
        treeActions.registerCustomShortcutSet(component, null);
        group.add(treeActions);
        if (component instanceof JTree) {
            group.addSeparator();
            ServiceViewTreeExpander treeExpander = new ServiceViewTreeExpander((JTree)component);
            AnAction expandAllAction = CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)treeExpander, component);
            group.add(expandAllAction);
            AnAction collapseAllAction = CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)treeExpander, component);
            group.add(collapseAllAction);
        }
        ActionToolbar treeActionsToolBar = ActionManager.getInstance().createActionToolbar("ServicesToolbar", (ActionGroup)group, true);
        treeActionsToolBar.setTargetComponent(component);
        return treeActionsToolBar;
    }

    List<AnAction> getAdditionalGearActions() {
        AnAction additionalActions = ActionManager.getInstance().getAction("ServiceView.Gear");
        return ContainerUtil.createMaybeSingletonList((Object)additionalActions);
    }

    @Nullable
    static ServiceView getSelectedView(@NotNull AnActionEvent e) {
        if (e == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(4);
        }
        return ServiceViewActionProvider.getSelectedView((Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT));
    }

    @Nullable
    static ServiceView getSelectedView(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(5);
        }
        return ServiceViewActionProvider.getSelectedView((Component)dataContext.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT));
    }

    @NotNull
    static List<ServiceModel.ServiceViewItem> getSelectedItems(@NotNull AnActionEvent e) {
        List<ServiceModel.ServiceViewItem> items;
        if (e == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(6);
        }
        List<ServiceModel.ServiceViewItem> list = (items = (List<ServiceModel.ServiceViewItem>)e.getData(SERVICES_SELECTED_ITEMS)) != null ? items : Collections.emptyList();
        if (list == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    static List<ServiceModel.ServiceViewItem> getSelectedItems(@NotNull DataContext dataContext) {
        List<ServiceModel.ServiceViewItem> items;
        if (dataContext == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(8);
        }
        List<ServiceModel.ServiceViewItem> list = (items = (List<ServiceModel.ServiceViewItem>)dataContext.getData(SERVICES_SELECTED_ITEMS)) != null ? items : Collections.emptyList();
        if (list == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(9);
        }
        return list;
    }

    static boolean isActionToolBarRequired(JComponent component) {
        Boolean holder = (Boolean)ClientProperty.get((Component)component, (Key)ServiceViewDescriptor.ACTION_HOLDER_KEY);
        if (Boolean.TRUE == holder) {
            return false;
        }
        while (true) {
            JComponent childComponent;
            if (component instanceof JBTabs || component instanceof JTabbedPane) {
                return false;
            }
            if (component.getComponentCount() > 1) {
                return ContainerUtil.filterIsInstance((Object[])component.getComponents(), JBTabs.class).size() != 1;
            }
            if (component.getComponentCount() != 1) {
                return true;
            }
            Component child = component.getComponent(0);
            if (!(child instanceof JComponent)) break;
            component = childComponent = (JComponent)child;
        }
        return true;
    }

    @Nullable
    private static ServiceView getSelectedView(@Nullable Component contextComponent) {
        while (contextComponent != null && !(contextComponent instanceof ServiceView)) {
            if (contextComponent instanceof ServiceViewNavBarPanel) {
                ServiceViewNavBarPanel navBarPanel = (ServiceViewNavBarPanel)((Object)contextComponent);
                return navBarPanel.getView();
            }
            contextComponent = contextComponent.getParent();
        }
        return (ServiceView)contextComponent;
    }

    private static AnAction @NotNull [] doGetActions(@Nullable AnActionEvent e, boolean toolbar) {
        AnAction[] anActionArray;
        ActionGroup group;
        ServiceViewDescriptor descriptor;
        if (e == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceViewActionProvider.$$$reportNull$$$0(10);
            }
            return AnAction.EMPTY_ARRAY;
        }
        Project project = e.getProject();
        if (project == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceViewActionProvider.$$$reportNull$$$0(11);
            }
            return AnAction.EMPTY_ARRAY;
        }
        ServiceView serviceView = ServiceViewActionProvider.getSelectedView(e);
        if (serviceView == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceViewActionProvider.$$$reportNull$$$0(12);
            }
            return AnAction.EMPTY_ARRAY;
        }
        List<ServiceModel.ServiceViewItem> selectedItems = ServiceViewActionProvider.getSelectedItems(e);
        if (selectedItems.isEmpty()) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceViewActionProvider.$$$reportNull$$$0(13);
            }
            return AnAction.EMPTY_ARRAY;
        }
        if (selectedItems.size() == 1) {
            descriptor = selectedItems.get(0).getViewDescriptor();
        } else {
            ServiceViewContributor contributor = ServiceViewDragHelper.getTheOnlyRootContributor(selectedItems);
            ServiceViewDescriptor serviceViewDescriptor = descriptor = contributor == null ? null : contributor.getViewDescriptor(project);
        }
        if (descriptor == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceViewActionProvider.$$$reportNull$$$0(14);
            }
            return AnAction.EMPTY_ARRAY;
        }
        ActionGroup actionGroup = group = toolbar ? descriptor.getToolbarActions() : descriptor.getPopupActions();
        if (group == null) {
            anActionArray = AnAction.EMPTY_ARRAY;
        } else {
            AnAction[] anActionArray2 = new AnAction[1];
            anActionArray = anActionArray2;
            anActionArray2[0] = group;
        }
        if (anActionArray == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(15);
        }
        return anActionArray;
    }

    public static JComponent createEmptyToolbar(boolean horizontal, JComponent targetComponent) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(EMPTY_ACTION);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)actionGroup, horizontal);
        toolbar.setTargetComponent(targetComponent);
        return horizontal ? ServiceViewUIUtils.wrapServicesAligned((ActionToolbar)toolbar) : toolbar.getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 10, 11, 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbarComponent";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/serviceView/ServiceViewActionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceViewActionProvider";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedItems";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createServiceToolbar";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "wrapServiceToolbar";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installPopupHandler";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createMasterComponentToolbar";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedView";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedItems";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 10, 11, 12, 13, 14, 15 -> new IllegalStateException(string);
        };
    }

    private static final class ServiceViewTreeExpander
    extends DefaultTreeExpander {
        private boolean myFlat;

        ServiceViewTreeExpander(final JTree tree) {
            super(tree);
            TreeModelAdapter listener = new TreeModelAdapter(){

                protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (type == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    myFlat = ServiceViewTreeExpander.isFlat(tree.getModel());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "type";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/platform/execution/serviceView/ServiceViewActionProvider$ServiceViewTreeExpander$1";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            tree.getModel().addTreeModelListener((TreeModelListener)listener);
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){
                final /* synthetic */ TreeModelListener val$listener;
                {
                    this.val$listener = treeModelListener;
                }

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    Object newValue;
                    Object oldValue = event.getOldValue();
                    if (oldValue instanceof TreeModel) {
                        ((TreeModel)oldValue).removeTreeModelListener(this.val$listener);
                    }
                    if ((newValue = event.getNewValue()) instanceof TreeModel) {
                        ((TreeModel)newValue).addTreeModelListener(this.val$listener);
                    }
                }
            };
            tree.addPropertyChangeListener("model", propertyChangeListener);
        }

        public boolean canExpand() {
            return super.canExpand() && !this.myFlat;
        }

        public boolean canCollapse() {
            return super.canCollapse() && !this.myFlat;
        }

        private static boolean isFlat(TreeModel treeModel) {
            Object root = treeModel.getRoot();
            if (root == null) {
                return false;
            }
            int childCount = treeModel.getChildCount(root);
            for (int i = 0; i < childCount; ++i) {
                Object child = treeModel.getChild(root, i);
                if (treeModel.isLeaf(child)) continue;
                return false;
            }
            return true;
        }
    }

    public static final class ItemPopupActionGroup
    extends ActionGroup {
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = ServiceViewActionProvider.doGetActions(e, false);
            if (anActionArray == null) {
                ItemPopupActionGroup.$$$reportNull$$$0(0);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/execution/serviceView/ServiceViewActionProvider$ItemPopupActionGroup", "getChildren"));
        }
    }

    public static final class ItemToolbarActionGroup
    extends ActionGroup
    implements ActionRemoteBehaviorSpecification.Frontend {
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = ServiceViewActionProvider.doGetActions(e, true);
            if (anActionArray == null) {
                ItemToolbarActionGroup.$$$reportNull$$$0(0);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/execution/serviceView/ServiceViewActionProvider$ItemToolbarActionGroup", "getChildren"));
        }
    }

    public static final class DefaultFrontendServiceViewActionGroup
    extends DefaultActionGroup
    implements ActionRemoteBehaviorSpecification.Frontend {
        public DefaultFrontendServiceViewActionGroup() {
        }

        public DefaultFrontendServiceViewActionGroup(AnAction ... actions) {
            if (actions == null) {
                DefaultFrontendServiceViewActionGroup.$$$reportNull$$$0(0);
            }
            super(actions);
        }

        public DefaultFrontendServiceViewActionGroup(@NotNull List<? extends AnAction> actions) {
            if (actions == null) {
                DefaultFrontendServiceViewActionGroup.$$$reportNull$$$0(1);
            }
            super(actions);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/platform/execution/serviceView/ServiceViewActionProvider$DefaultFrontendServiceViewActionGroup", "<init>"));
        }
    }
}

