/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.common.browser;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.javascript.debugger.common.browser.DevToolsUriListener;
import com.intellij.javascript.debugger.common.browser.FailedToStartSessionException;
import com.intellij.javascript.debugger.common.browser.ProcessUtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.util.Key;
import java.net.URI;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u0012\u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/javascript/debugger/common/browser/DevToolsUriListener;", "Lcom/intellij/execution/process/ProcessListener;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "<init>", "(Lcom/intellij/execution/process/ProcessHandler;)V", "getProcessHandler", "()Lcom/intellij/execution/process/ProcessHandler;", "result", "Lkotlinx/coroutines/CompletableDeferred;", "Ljava/net/URI;", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "processTerminated", "awaitDevToolsUri", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryFindUri", "text", "", "intellij.javascript.debugger.common"})
@SourceDebugExtension(value={"SMAP\nprocessUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 processUtils.kt\ncom/intellij/javascript/debugger/common/browser/DevToolsUriListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,261:1\n1#2:262\n*E\n"})
public final class DevToolsUriListener
implements ProcessListener {
    @NotNull
    private final ProcessHandler processHandler;
    @NotNull
    private final CompletableDeferred<URI> result;

    public DevToolsUriListener(@NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        this.processHandler = processHandler;
        this.result = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        if (this.processHandler.isStartNotified()) {
            ProcessUtilsKt.access$getLogger$p().warn("Process notification was started before listener is registered. Some events can be missed.");
        }
        this.processHandler.addProcessListener((ProcessListener)this);
    }

    @NotNull
    public final ProcessHandler getProcessHandler() {
        return this.processHandler;
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        if (!this.result.isCompleted() && Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDERR)) {
            Object object;
            DevToolsUriListener devToolsUriListener = this;
            try {
                DevToolsUriListener $this$onTextAvailable_u24lambda_u240 = devToolsUriListener;
                boolean bl = false;
                String string = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                object = Result.constructor-impl((Object)$this$onTextAvailable_u24lambda_u240.tryFindUri(string));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            URI devToolsUri = (URI)LoggerKt.getOrLogException((Object)object, (Logger)ProcessUtilsKt.access$getLogger$p());
            if (devToolsUri != null) {
                this.result.complete((Object)devToolsUri);
                this.processHandler.removeProcessListener((ProcessListener)this);
            }
        }
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.result.completeExceptionally((Throwable)new FailedToStartSessionException("Browser process terminated before sending DevTools URI.\n Please check that the user directory specified in <a href=\"jetbrains://idea/settings?name=Tools--Web+Browsers+and+Preview\">Browser Settings</a> isn't used by another process.", null, 2, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object awaitDevToolsUri(@NotNull Continuation<? super URI> $completion) {
        if (!($completion instanceof awaitDevToolsUri.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ DevToolsUriListener this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.awaitDevToolsUri((Continuation<? super URI>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.result.await((Continuation)$continuation);
                ** if (v0 != var6_4) goto lbl18
lbl17:
                // 1 sources

                return var6_4;
lbl18:
                // 1 sources

                ** GOTO lbl24
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    var2_5 = (URI)v0;
                }
                catch (Throwable var3_6) {
                    throw var3_6;
                }
                finally {
                    this.processHandler.removeProcessListener((ProcessListener)this);
                }
                return var2_5;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final URI tryFindUri(String text) {
        Matcher matcher = ProcessUtilsKt.getDEV_TOOLS_URI_PATTERN().matcher(text);
        if (matcher.find()) {
            String group = matcher.group("url");
            URI uri = new URI(group);
            ProcessUtilsKt.access$getLogger$p().info("DevTools uri found: " + uri);
            return uri;
        }
        return null;
    }
}

