/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.time.ZonedDateTime;
import java.util.Calendar;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ApplicationInfo {
    public static ApplicationInfo getInstance() {
        return (ApplicationInfo)ApplicationManager.getApplication().getService(ApplicationInfo.class);
    }

    public abstract Calendar getBuildDate();

    @ApiStatus.Internal
    @ApiStatus.Experimental
    @NotNull
    public abstract ZonedDateTime getBuildTime();

    @NotNull
    public abstract BuildNumber getBuild();

    @ApiStatus.Internal
    @ApiStatus.Experimental
    @Nullable
    public String getBuildBranchName() {
        return null;
    }

    @NotNull
    public abstract String getApiVersion();

    public abstract String getMajorVersion();

    public abstract String getMinorVersion();

    public abstract String getMicroVersion();

    public abstract String getPatchVersion();

    @NlsSafe
    public abstract String getVersionName();

    @NlsSafe
    public final String getMinorVersionMainPart() {
        String value = StringUtil.substringBefore(this.getMinorVersion(), ".");
        return value == null ? this.getMinorVersion() : value;
    }

    @NlsSafe
    public abstract String getCompanyName();

    @NlsSafe
    public abstract String getShortCompanyName();

    public abstract String getCompanyURL();

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public abstract String getProductUrl();

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public abstract String getJetBrainsTvUrl();

    public abstract boolean hasHelp();

    public abstract boolean hasContextHelp();

    @NlsSafe
    @NotNull
    public abstract String getFullVersion();

    @NlsSafe
    public final String getShortVersion() {
        return this.getMajorVersion() + '.' + this.getMinorVersionMainPart();
    }

    @NlsSafe
    @NotNull
    public abstract String getStrictVersion();

    public static boolean helpAvailable() {
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            return false;
        }
        ApplicationInfo info = ApplicationInfo.getInstance();
        return info != null && info.hasHelp();
    }

    public static boolean contextHelpAvailable() {
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            return false;
        }
        ApplicationInfo info = ApplicationInfo.getInstance();
        return info != null && info.hasContextHelp();
    }

    public boolean isEAP() {
        return false;
    }

    public abstract String getFullApplicationName();

    @Nullable
    public String getSplashImageUrl() {
        return null;
    }

    @ApiStatus.Internal
    public abstract boolean isEssentialPlugin(@NotNull String var1);

    @ApiStatus.Internal
    public abstract boolean isEssentialPlugin(@NotNull PluginId var1);

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public boolean isSimplifiedSplashSupported() {
        return false;
    }
}

