/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.connection.throwable.KnownDatabaseException;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.connection.throwable.info.SimpleErrorInfo;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProvider;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.dialects.DatabaseFixFactory;
import com.intellij.database.dialects.mssql.MsAzureAuthProviderBase;
import com.intellij.database.dialects.mssql.MsUtils;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 )2\u00020\u0001:\u0006'()*+,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J.\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0096@\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\"H&J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0016\u00a8\u0006-"}, d2={"Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase;", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "<init>", "()V", "getApplicability", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel$Result;", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "level", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel;", "loadAuthConfig", "", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "external", "", "saveAuthConfig", "", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "data", "setNewPassword", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "newPass", "", "handleConnectionFailure", "e", "", "silent", "attempt", "", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;Ljava/lang/Throwable;ZILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAuthType", "Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$MsAzureAuthType;", "getRequiredArtifact", "Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact;", "target", "Lcom/intellij/database/dataSource/LocalDataSource;", "RequiredArtifact", "MsAzureAuthType", "Companion", "DriverAuthStrategy", "JbDriverAuthStrategy", "MsDriverAuthStrategy", "intellij.database.dialects.mssql"})
public abstract class MsAzureAuthProviderBase
implements DatabaseAuthProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public DatabaseAuthProvider.ApplicabilityLevel.Result getApplicability(@NotNull DatabaseConnectionPoint point, @NotNull DatabaseAuthProvider.ApplicabilityLevel level) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return !MsUtils.isMs(point.getDatabaseDriver()) ? DatabaseAuthProvider.ApplicabilityLevel.Result.NOT_APPLICABLE : DatabaseAuthProvider.ApplicabilityLevel.Result.DEFAULT.clamp(level);
    }

    @Nullable
    public Object loadAuthConfig(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials, boolean external) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return DatabaseCredentialsAuthProvider.Companion.loadCredentialsConfig(point, credentials, external);
    }

    public void saveAuthConfig(@NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials, @Nullable Object data, boolean external) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        DatabaseCredentialsAuthProvider.Companion.saveCredentialsConfig(config, credentials, data instanceof DatabaseCredentialsAuthProvider.UserPassCredentials ? (DatabaseCredentialsAuthProvider.UserPassCredentials)data : null, external);
    }

    public void setNewPassword(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, @Nullable String newPass) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        DatabaseCredentialsAuthProvider.Companion.applyNewPassword(proto, newPass);
    }

    @Nullable
    public Object handleConnectionFailure(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, @NotNull Throwable e, boolean silent, int attempt, @NotNull Continuation<? super Boolean> $completion) {
        return MsAzureAuthProviderBase.handleConnectionFailure$suspendImpl(this, proto, e, silent, attempt, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object handleConnectionFailure$suspendImpl(MsAzureAuthProviderBase $this, DatabaseConnectionInterceptor.ProtoConnection proto, Throwable e, boolean silent, int attempt, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof handleConnectionFailure.1)) ** GOTO lbl-1000
        var7_6 = $completion;
        if ((var7_6.label & -2147483648) != 0) {
            var7_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                boolean Z$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ MsAzureAuthProviderBase this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MsAzureAuthProviderBase.handleConnectionFailure$suspendImpl(this.this$0, null, null, false, 0, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $this;
                $continuation.L$1 = proto;
                $continuation.L$2 = e;
                $continuation.Z$0 = silent;
                $continuation.I$0 = attempt;
                $continuation.label = 1;
                v0 = com.intellij.database.dialects.mssql.MsAzureAuthProviderBase$Companion.access$getAuthStrategy(MsAzureAuthProviderBase.Companion, proto.getConnectionPoint().getDatabaseDriver()).handleConnectionFailure(proto, e, silent != false, attempt, (Continuation<? super Unit>)$continuation);
                if (v0 == var8_8) {
                    return var8_8;
                }
                ** GOTO lbl30
            }
            case 1: {
                attempt = $continuation.I$0;
                silent = $continuation.Z$0;
                e = (Throwable)$continuation.L$2;
                proto = (DatabaseConnectionInterceptor.ProtoConnection)$continuation.L$1;
                $this = (MsAzureAuthProviderBase)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)proto);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)e);
                $continuation.Z$0 = silent;
                $continuation.I$0 = attempt;
                $continuation.label = 2;
                v1 = super.handleConnectionFailure(proto, e, silent != false, attempt, (Continuation)$continuation);
                if (v1 == var8_8) {
                    return var8_8;
                }
                ** GOTO lbl48
            }
            case 2: {
                attempt = $continuation.I$0;
                silent = $continuation.Z$0;
                e = (Throwable)$continuation.L$2;
                proto = (DatabaseConnectionInterceptor.ProtoConnection)$continuation.L$1;
                $this = (MsAzureAuthProviderBase)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl48:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public abstract MsAzureAuthType getAuthType();

    @Nullable
    public RequiredArtifact getRequiredArtifact(@NotNull LocalDataSource target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return Companion.guessRequired(target, this.getAuthType());
    }

    @JvmStatic
    @Nullable
    public static final String setAuthentication(@NotNull DatabaseConnectionInterceptor.ProtoConnection p, @NotNull MsAzureAuthType authentication) {
        return Companion.setAuthentication(p, authentication);
    }

    @JvmStatic
    @Nullable
    public static final RequiredArtifact guessRequired(@NotNull LocalDataSource target, @NotNull MsAzureAuthType authType) {
        return Companion.guessRequired(target, authType);
    }

    static {
        Logger logger = Logger.getInstance(MsAzureAuthProviderBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0007J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "setAuthentication", "", "p", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "authentication", "Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$MsAzureAuthType;", "guessRequired", "Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact;", "target", "Lcom/intellij/database/dataSource/LocalDataSource;", "authType", "getAuthStrategy", "Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$DriverAuthStrategy;", "driver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "intellij.database.dialects.mssql"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final String setAuthentication(@NotNull DatabaseConnectionInterceptor.ProtoConnection p, @NotNull MsAzureAuthType authentication) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)((Object)authentication), (String)"authentication");
            String propertyName = this.getAuthStrategy(p.getConnectionPoint().getDatabaseDriver()).getPropertyForAuth(authentication);
            return (String)DbImplUtilCore.putOrRemove((Map)p.getConnectionProperties(), (Object)"authentication", (Object)propertyName);
        }

        @JvmStatic
        @Nullable
        public final RequiredArtifact guessRequired(@NotNull LocalDataSource target, @NotNull MsAzureAuthType authType) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)((Object)authType), (String)"authType");
            return this.getAuthStrategy(target.getDatabaseDriver()).getRequiredArtifact(target, authType);
        }

        private final DriverAuthStrategy getAuthStrategy(DatabaseDriver driver) {
            DriverAuthStrategy driverAuthStrategy;
            if (MsUtils.isJbMsDriver(driver)) {
                driverAuthStrategy = JbDriverAuthStrategy.INSTANCE;
            } else if (MsUtils.isMs(driver)) {
                driverAuthStrategy = MsDriverAuthStrategy.INSTANCE;
            } else if (driver == null) {
                driverAuthStrategy = MsDriverAuthStrategy.INSTANCE;
            } else {
                throw new IllegalArgumentException("Unsupported driver: " + driver);
            }
            return driverAuthStrategy;
        }

        public static final /* synthetic */ DriverAuthStrategy access$getAuthStrategy(Companion $this, DatabaseDriver driver) {
            return $this.getAuthStrategy(driver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H&J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u00a6@\u00a2\u0006\u0002\u0010\u0014\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$DriverAuthStrategy;", "", "getRequiredArtifact", "Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact;", "target", "Lcom/intellij/database/dataSource/LocalDataSource;", "authType", "Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$MsAzureAuthType;", "getPropertyForAuth", "", "handleConnectionFailure", "", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "e", "", "silent", "", "attempt", "", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;Ljava/lang/Throwable;ZILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.database.dialects.mssql"})
    public static interface DriverAuthStrategy {
        @Nullable
        public RequiredArtifact getRequiredArtifact(@NotNull LocalDataSource var1, @NotNull MsAzureAuthType var2);

        @Nullable
        public String getPropertyForAuth(@NotNull MsAzureAuthType var1);

        @Nullable
        public Object handleConnectionFailure(@NotNull DatabaseConnectionInterceptor.ProtoConnection var1, @NotNull Throwable var2, boolean var3, int var4, @NotNull Continuation<? super Unit> var5);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$JbDriverAuthStrategy;", "Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$DriverAuthStrategy;", "<init>", "()V", "getRequiredArtifact", "Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact;", "target", "Lcom/intellij/database/dataSource/LocalDataSource;", "authType", "Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$MsAzureAuthType;", "getPropertyForAuth", "", "handleConnectionFailure", "", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "e", "", "silent", "", "attempt", "", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;Ljava/lang/Throwable;ZILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.database.dialects.mssql"})
    public static final class JbDriverAuthStrategy
    implements DriverAuthStrategy {
        @NotNull
        public static final JbDriverAuthStrategy INSTANCE = new JbDriverAuthStrategy();

        private JbDriverAuthStrategy() {
        }

        @Override
        @Nullable
        public RequiredArtifact getRequiredArtifact(@NotNull LocalDataSource target, @NotNull MsAzureAuthType authType) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)((Object)authType), (String)"authType");
            return null;
        }

        @Override
        @Nullable
        public String getPropertyForAuth(@NotNull MsAzureAuthType authType) {
            Intrinsics.checkNotNullParameter((Object)((Object)authType), (String)"authType");
            return switch (WhenMappings.$EnumSwitchMapping$0[authType.ordinal()]) {
                case 1 -> "Active Directory Integrated";
                case 2 -> "Active Directory Interactive";
                case 3 -> "Active Directory Password";
                default -> null;
            };
        }

        @Override
        @Nullable
        public Object handleConnectionFailure(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, @NotNull Throwable e, boolean silent, int attempt, @NotNull Continuation<? super Unit> $completion) {
            return Unit.INSTANCE;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[MsAzureAuthType.values().length];
                try {
                    nArray[MsAzureAuthType.AD_INTEGRATED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MsAzureAuthType.AD_INTERACTIVE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MsAzureAuthType.AD_PASSWORD.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$MsAzureAuthType;", "", "<init>", "(Ljava/lang/String;I)V", "AD_INTEGRATED", "AD_INTERACTIVE", "AD_PASSWORD", "AD_MSI", "AD_DEFAULT", "intellij.database.dialects.mssql"})
    public static final class MsAzureAuthType
    extends Enum<MsAzureAuthType> {
        public static final /* enum */ MsAzureAuthType AD_INTEGRATED = new MsAzureAuthType();
        public static final /* enum */ MsAzureAuthType AD_INTERACTIVE = new MsAzureAuthType();
        public static final /* enum */ MsAzureAuthType AD_PASSWORD = new MsAzureAuthType();
        public static final /* enum */ MsAzureAuthType AD_MSI = new MsAzureAuthType();
        public static final /* enum */ MsAzureAuthType AD_DEFAULT = new MsAzureAuthType();
        private static final /* synthetic */ MsAzureAuthType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MsAzureAuthType[] values() {
            return (MsAzureAuthType[])$VALUES.clone();
        }

        public static MsAzureAuthType valueOf(String value) {
            return Enum.valueOf(MsAzureAuthType.class, value);
        }

        @NotNull
        public static EnumEntries<MsAzureAuthType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = msAzureAuthTypeArray = new MsAzureAuthType[]{MsAzureAuthType.AD_INTEGRATED, MsAzureAuthType.AD_INTERACTIVE, MsAzureAuthType.AD_PASSWORD, MsAzureAuthType.AD_MSI, MsAzureAuthType.AD_DEFAULT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$MsDriverAuthStrategy;", "Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$DriverAuthStrategy;", "<init>", "()V", "getRequiredArtifact", "Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact;", "target", "Lcom/intellij/database/dataSource/LocalDataSource;", "authType", "Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$MsAzureAuthType;", "getPropertyForAuth", "", "handleConnectionFailure", "", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "e", "", "silent", "", "attempt", "", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;Ljava/lang/Throwable;ZILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isRequiredAzureIdentity", "ADAL4J", "MSAL4J", "AZURE_IDENTITY", "intellij.database.dialects.mssql"})
    public static final class MsDriverAuthStrategy
    implements DriverAuthStrategy {
        @NotNull
        public static final MsDriverAuthStrategy INSTANCE = new MsDriverAuthStrategy();
        @NotNull
        private static final RequiredArtifact ADAL4J = new RequiredArtifact(){

            public boolean checkFile(String u) {
                Intrinsics.checkNotNullParameter((Object)u, (String)"u");
                return StringsKt.contains$default((CharSequence)u, (CharSequence)"adal4j", (boolean)false, (int)2, null);
            }
        };
        @NotNull
        private static final RequiredArtifact MSAL4J = new RequiredArtifact(){

            public boolean checkFile(String u) {
                Intrinsics.checkNotNullParameter((Object)u, (String)"u");
                return StringsKt.contains$default((CharSequence)u, (CharSequence)"msal4j", (boolean)false, (int)2, null);
            }
        };
        @NotNull
        private static final RequiredArtifact AZURE_IDENTITY = new RequiredArtifact(){

            public boolean checkFile(String u) {
                Intrinsics.checkNotNullParameter((Object)u, (String)"u");
                return StringsKt.contains$default((CharSequence)u, (CharSequence)"azure-identity", (boolean)false, (int)2, null);
            }
        };

        private MsDriverAuthStrategy() {
        }

        @Override
        @Nullable
        public RequiredArtifact getRequiredArtifact(@NotNull LocalDataSource target, @NotNull MsAzureAuthType authType) {
            int[] nArray;
            Version version;
            DatabaseDriver.ArtifactRef artifact;
            DatabaseDriver driver;
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)((Object)authType), (String)"authType");
            DatabaseDriver databaseDriver = driver = target.getDatabaseDriver();
            DatabaseDriver.ArtifactRef artifactRef = artifact = databaseDriver == null ? null : RequiredArtifact.Companion.findArtifact(databaseDriver, "SQL Server");
            Version version2 = version = artifactRef == null ? Version.parse((String)target.getDriverVersion().version) : artifactRef.getArtifactVersion();
            if (version != null && version.less(nArray = new int[]{9})) {
                return ADAL4J;
            }
            return this.isRequiredAzureIdentity(authType) ? AZURE_IDENTITY : MSAL4J;
        }

        @Override
        @Nullable
        public String getPropertyForAuth(@NotNull MsAzureAuthType authType) {
            Intrinsics.checkNotNullParameter((Object)((Object)authType), (String)"authType");
            return switch (WhenMappings.$EnumSwitchMapping$0[authType.ordinal()]) {
                case 1 -> "ActiveDirectoryIntegrated";
                case 2 -> "ActiveDirectoryInteractive";
                case 3 -> "ActiveDirectoryPassword";
                case 4 -> "ActiveDirectoryMSI";
                case 5 -> "ActiveDirectoryDefault";
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @Override
        @Nullable
        public Object handleConnectionFailure(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, @NotNull Throwable e, boolean silent, int attempt, @NotNull Continuation<? super Unit> $completion) {
            String message = e.getMessage();
            DatabaseDriver driver = proto.getConnectionPoint().getDatabaseDriver();
            if (driver != null && message != null) {
                RequiredArtifact ra;
                RequiredArtifact requiredArtifact = StringsKt.contains$default((CharSequence)message, (CharSequence)"Failed to load ADAL4J", (boolean)false, (int)2, null) ? ADAL4J : (StringsKt.contains$default((CharSequence)message, (CharSequence)"Failed to load MSAL4J", (boolean)false, (int)2, null) ? MSAL4J : (ra = StringsKt.contains$default((CharSequence)message, (CharSequence)"class 'com.azure.identity.ManagedIdentityCredential' not found", (boolean)false, (int)2, null) ? AZURE_IDENTITY : null));
                if (ra != null) {
                    ErrorInfo info = SimpleErrorInfo.create((String)message, (Throwable)e, (List)CollectionsKt.listOf((Object)ra.createSetUpFix(driver, true)));
                    throw new KnownDatabaseException(info);
                }
            }
            return Unit.INSTANCE;
        }

        public final boolean isRequiredAzureIdentity(@NotNull MsAzureAuthType authType) {
            Intrinsics.checkNotNullParameter((Object)((Object)authType), (String)"authType");
            return switch (WhenMappings.$EnumSwitchMapping$0[authType.ordinal()]) {
                case 4, 5 -> true;
                default -> false;
            };
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[MsAzureAuthType.values().length];
                try {
                    nArray[MsAzureAuthType.AD_INTEGRATED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MsAzureAuthType.AD_INTERACTIVE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MsAzureAuthType.AD_PASSWORD.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MsAzureAuthType.AD_MSI.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MsAzureAuthType.AD_DEFAULT.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H&J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact;", "", "artifactId", "", "<init>", "(Ljava/lang/String;)V", "getArtifactId", "()Ljava/lang/String;", "findArtifact", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$ArtifactVersion;", "checkFile", "", "u", "createSetUpFix", "Lcom/intellij/database/connection/throwable/info/ErrorInfo$Fix;", "driver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "navigate", "Companion", "intellij.database.dialects.mssql"})
    public static abstract class RequiredArtifact {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String artifactId;

        public RequiredArtifact(@NotNull String artifactId) {
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            this.artifactId = artifactId;
        }

        @NotNull
        public final String getArtifactId() {
            return this.artifactId;
        }

        private final DatabaseArtifactList.ArtifactVersion findArtifact() {
            return DatabaseArtifactManager.getArtifacts().resolveVersion(this.artifactId, null, "stable", null);
        }

        public abstract boolean checkFile(@NotNull String var1);

        @Nullable
        public final ErrorInfo.Fix createSetUpFix(@Nullable DatabaseDriver driver, boolean navigate) {
            DatabaseFixFactory fixFactory;
            DatabaseFixFactory databaseFixFactory = fixFactory = DatabaseFixFactory.getInstance();
            return databaseFixFactory != null ? databaseFixFactory.setUpArtifact(driver, navigate, () -> RequiredArtifact.createSetUpFix$lambda$0(this)) : null;
        }

        private static final DatabaseArtifactList.ArtifactVersion createSetUpFix$lambda$0(RequiredArtifact this$0) {
            DatabaseArtifactList.ArtifactVersion adal = this$0.findArtifact();
            if (adal == null) {
                LOG.error(this$0.artifactId + " artifact not found");
                return null;
            }
            return adal;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact$Companion;", "", "<init>", "()V", "findArtifact", "Lcom/intellij/database/dataSource/DatabaseDriver$ArtifactRef;", "driver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "artifactId", "", "intellij.database.dialects.mssql"})
        @SourceDebugExtension(value={"SMAP\nMsAzureAuthProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsAzureAuthProviderBase.kt\ncom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n1#2:209\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final DatabaseDriver.ArtifactRef findArtifact(@NotNull DatabaseDriver driver, @NotNull String artifactId) {
                Object v1;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                    Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
                    List list = driver.getArtifacts();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArtifacts(...)");
                    Iterable iterable = list;
                    for (Object t : iterable) {
                        DatabaseDriver.ArtifactRef it = (DatabaseDriver.ArtifactRef)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)artifactId)) continue;
                        v1 = t;
                        break block1;
                    }
                    v1 = null;
                }
                return v1;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

