/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.annotation.IntRange;
import androidx.collection.ObjectList;
import androidx.collection.ScatterMap;
import androidx.collection.ScatterMapKt;
import androidx.collection.ScatterSet;
import androidx.collection.SieveCacheKt;
import androidx.collection.internal.ContainerHelpersKt;
import androidx.collection.internal.RuntimeHelpersKt;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.PublishedApi;
import kotlin.ULong;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u001d\n\u0002\u0010\u0015\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B\u00e0\u0001\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0005\u00128\b\u0002\u0010\u0007\u001a2\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00050\b\u0012%\b\u0002\u0010\r\u001a\u001f\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u000e\u0012d\b\u0002\u0010\u000f\u001a^\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00018\u0001\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u0010\u00a2\u0006\u0002\u0010\u0016J\r\u00103\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b4J&\u00105\u001a\u00020\u00132\u0018\u00106\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00130\bH\u0086\b\u00f8\u0001\u0000J\u0006\u00107\u001a\u00020\u0013J&\u00107\u001a\u00020\u00132\u0018\u00106\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00130\bH\u0086\b\u00f8\u0001\u0000J\u0016\u00108\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u00109J\u0013\u0010:\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u00109J\u0013\u0010;\u001a\u00020\u00132\u0006\u0010\f\u001a\u00028\u0001\u00a2\u0006\u0002\u00109J\u0006\u0010\u001e\u001a\u00020\u0005J&\u0010\u001e\u001a\u00020\u00052\u0018\u00106\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00130\bH\u0086\b\u00f8\u0001\u0000J\r\u0010<\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b=J\u0013\u0010>\u001a\u00020\u00132\b\u0010?\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u0006\u0010@\u001a\u00020\u0015J\b\u0010A\u001a\u00020\u0005H\u0002J\u0010\u0010B\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u0005H\u0002J\u0015\u0010D\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010EJ\u0015\u0010F\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010EJ\u0010\u0010G\u001a\u00020\u00152\u0006\u0010H\u001a\u00020IH\u0002J\u0010\u0010G\u001a\u00020\u00152\u0006\u0010H\u001a\u00020+H\u0002JD\u0010J\u001a\u00020\u001526\u0010K\u001a2\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00150\bH\u0086\b\u00f8\u0001\u0000J/\u0010L\u001a\u00020\u00152!\u0010K\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(M\u0012\u0004\u0012\u00020\u00150\u000eH\u0081\b\u00f8\u0001\u0000J/\u0010N\u001a\u00020\u00152!\u0010K\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u00150\u000eH\u0086\b\u00f8\u0001\u0000J/\u0010O\u001a\u00020\u00152!\u0010K\u001a\u001d\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00150\u000eH\u0086\b\u00f8\u0001\u0000J\u0018\u0010P\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000b\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010QJ\b\u0010R\u001a\u00020\u0005H\u0016J\b\u0010S\u001a\u00020\u0015H\u0002J\u0010\u0010T\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0010\u0010U\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0006\u0010V\u001a\u00020\u0013J\u0006\u0010W\u001a\u00020\u0013J\u0011\u0010X\u001a\u00020\u00152\u0006\u0010M\u001a\u00020\u0005H\u0082\bJ\u0016\u0010Y\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00028\u0000H\u0086\n\u00a2\u0006\u0002\u0010ZJ\u0017\u0010Y\u001a\u00020\u00152\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000[H\u0086\nJ\u0017\u0010Y\u001a\u00020\u00152\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\\H\u0086\nJ\u001e\u0010Y\u001a\u00020\u00152\u000e\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000&H\u0086\n\u00a2\u0006\u0002\u0010]J\u0017\u0010Y\u001a\u00020\u00152\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000^H\u0086\nJ\u0017\u0010Y\u001a\u00020\u00152\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000_H\u0086\nJ\u0011\u0010`\u001a\u00020\u00152\u0006\u0010M\u001a\u00020\u0005H\u0082\bJ\u0006\u0010a\u001a\u00020\u0013J\u001d\u0010b\u001a\u00020\u00152\u0012\u0010c\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010dH\u0086\nJ\u001d\u0010b\u001a\u00020\u00152\u0012\u0010c\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0086\nJ*\u0010b\u001a\u00020\u00152\u001a\u0010e\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010f0&H\u0086\n\u00a2\u0006\u0002\u0010gJ\u001d\u0010b\u001a\u00020\u00152\u0012\u0010h\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010fH\u0086\nJ#\u0010b\u001a\u00020\u00152\u0018\u0010e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010f0^H\u0086\nJ\u001d\u0010b\u001a\u00020\u00152\u0012\u0010c\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010iH\u0086\nJ#\u0010b\u001a\u00020\u00152\u0018\u0010e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010f0_H\u0086\nJ\u001d\u0010j\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010kJ\u001a\u0010l\u001a\u00020\u00152\u0012\u0010c\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010dJ\u001a\u0010l\u001a\u00020\u00152\u0012\u0010c\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J'\u0010l\u001a\u00020\u00152\u001a\u0010e\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010f0&\u00a2\u0006\u0002\u0010gJ \u0010l\u001a\u00020\u00152\u0018\u0010e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010f0^J\u001a\u0010l\u001a\u00020\u00152\u0012\u0010c\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010iJ \u0010l\u001a\u00020\u00152\u0018\u0010e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010f0_J\u0015\u0010m\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010QJ\u001b\u0010m\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010nJ \u0010o\u001a\u00020\u00152\u0018\u00106\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00130\bJ\u0011\u0010p\u001a\u00020\u00152\u0006\u0010M\u001a\u00020\u0005H\u0082\bJ\u0017\u0010q\u001a\u0004\u0018\u00018\u00012\u0006\u0010M\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010rJ\u0010\u0010s\u001a\u00020\u00152\b\b\u0001\u0010\u0004\u001a\u00020\u0005J\u0015\u0010t\u001a\u00020\u00152\u0006\u0010u\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bvJ\u001e\u0010w\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0001H\u0086\n\u00a2\u0006\u0002\u0010xJ\b\u0010y\u001a\u00020zH\u0016J\u000e\u0010{\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\u001dR+\u0010\r\u001a\u001f\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020&8\u0000@\u0000X\u0081\u000e\u00a2\u0006\n\n\u0002\u0010(\u0012\u0004\b'\u0010 R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001dR\u0018\u0010*\u001a\u00020+8\u0000@\u0000X\u0081\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b,\u0010 R\u000e\u0010-\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000Rj\u0010\u000f\u001a^\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00018\u0001\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010.\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u001dR>\u0010\u0007\u001a2\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020&8\u0000@\u0000X\u0081\u000e\u00a2\u0006\n\n\u0002\u0010(\u0012\u0004\b2\u0010 \u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006|"}, d2={"Landroidx/collection/SieveCache;", "K", "", "V", "maxSize", "", "initialCapacity", "sizeOf", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "key", "value", "createValueFromKey", "Lkotlin/Function1;", "onEntryRemoved", "Lkotlin/Function4;", "oldValue", "newValue", "", "evicted", "", "(IILkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function4;)V", "_capacity", "_count", "_maxSize", "_size", "capacity", "getCapacity", "()I", "count", "getCount$annotations", "()V", "getCount", "growthLimit", "hand", "head", "keys", "", "getKeys$annotations", "[Ljava/lang/Object;", "getMaxSize", "metadata", "", "getMetadata$annotations", "nodes", "size", "getSize", "tail", "values", "getValues$annotations", "adjustStorage", "adjustStorage$collection", "all", "predicate", "any", "contains", "(Ljava/lang/Object;)Z", "containsKey", "containsValue", "dropDeletes", "dropDeletes$collection", "equals", "other", "evictAll", "findEvictionCandidate", "findFirstAvailableSlot", "hash1", "findInsertIndex", "(Ljava/lang/Object;)I", "findKeyIndex", "fixupNodes", "mapping", "", "forEach", "block", "forEachIndexed", "index", "forEachKey", "forEachValue", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "hashCode", "initializeGrowth", "initializeMetadata", "initializeStorage", "isEmpty", "isNotEmpty", "markNodeVisited", "minusAssign", "(Ljava/lang/Object;)V", "Landroidx/collection/ObjectList;", "Landroidx/collection/ScatterSet;", "([Ljava/lang/Object;)V", "", "Lkotlin/sequences/Sequence;", "moveNodeToHead", "none", "plusAssign", "from", "Landroidx/collection/ScatterMap;", "pairs", "Lkotlin/Pair;", "([Lkotlin/Pair;)V", "pair", "", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "putAll", "remove", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "removeIf", "removeNode", "removeValueAt", "(I)Ljava/lang/Object;", "resize", "resizeStorage", "newCapacity", "resizeStorage$collection", "set", "(Ljava/lang/Object;Ljava/lang/Object;)V", "toString", "", "trimToSize", "collection"})
@SourceDebugExtension(value={"SMAP\nSieveCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SieveCache.kt\nandroidx/collection/SieveCache\n+ 2 RuntimeHelpers.kt\nandroidx/collection/internal/RuntimeHelpersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n+ 5 SieveCache.kt\nandroidx/collection/SieveCacheKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 ScatterMap.kt\nandroidx/collection/ScatterMap\n+ 8 ScatterSet.kt\nandroidx/collection/ScatterSet\n+ 9 ObjectList.kt\nandroidx/collection/ObjectList\n*L\n1#1,1148:1\n684#1,2:1161\n633#1:1163\n635#1,2:1165\n638#1,6:1168\n251#1,2:1174\n251#1,2:1176\n251#1,2:1178\n251#1,2:1181\n251#1,2:1201\n548#1,4:1210\n1025#1,6:1214\n1035#1,3:1221\n1038#1,2:1225\n251#1,2:1227\n1041#1,6:1229\n552#1:1235\n251#1,2:1236\n1025#1,6:1238\n1035#1,3:1245\n1038#1,9:1249\n1025#1,6:1289\n1035#1,3:1296\n1038#1,9:1300\n1025#1,6:1309\n1035#1,3:1316\n1038#1,9:1320\n1025#1,6:1329\n1035#1,3:1336\n1038#1,9:1340\n548#1,4:1349\n1025#1,6:1353\n1035#1,3:1360\n1038#1,9:1364\n552#1:1373\n548#1,4:1374\n1025#1,6:1378\n1035#1,3:1385\n1038#1,9:1389\n552#1:1398\n548#1,4:1399\n1025#1,6:1403\n1035#1,3:1410\n1038#1,9:1414\n552#1:1423\n1025#1,6:1424\n1035#1,3:1431\n1038#1,9:1435\n660#1,3:1462\n663#1:1466\n665#1,2:1468\n668#1,5:1471\n674#1,8:1477\n548#1,4:1638\n1025#1,6:1642\n1035#1,3:1649\n1038#1,9:1653\n552#1:1662\n548#1,4:1663\n1025#1,6:1667\n1035#1,3:1674\n1038#1,9:1678\n552#1:1687\n59#2,5:1149\n1#3:1154\n1254#4,6:1155\n1399#4:1194\n1270#4:1198\n1399#4:1220\n1270#4:1224\n1399#4:1244\n1270#4:1248\n1399#4:1268\n1270#4:1272\n1399#4:1295\n1270#4:1299\n1399#4:1315\n1270#4:1319\n1399#4:1335\n1270#4:1339\n1399#4:1359\n1270#4:1363\n1399#4:1384\n1270#4:1388\n1399#4:1409\n1270#4:1413\n1399#4:1430\n1270#4:1434\n1230#4:1450\n1254#4,6:1451\n1242#4:1457\n1241#4,4:1458\n1165#4,3:1489\n1179#4:1492\n1175#4:1493\n1372#4,3:1494\n1386#4,3:1497\n1312#4:1500\n1303#4:1501\n1297#4:1502\n1309#4:1503\n1393#4:1504\n1165#4,3:1505\n1175#4:1508\n1179#4:1509\n1372#4,3:1510\n1386#4,3:1513\n1312#4:1516\n1303#4:1517\n1297#4:1518\n1309#4:1519\n1393#4:1520\n1265#4:1521\n1220#4:1522\n1262#4:1523\n1220#4:1524\n1230#4:1525\n1254#4,6:1526\n1242#4:1532\n1241#4,4:1533\n1372#4,3:1537\n1399#4:1540\n1297#4:1541\n1144#4,14:1542\n1220#4:1556\n1165#4,3:1557\n1175#4:1560\n1179#4:1561\n1254#4,6:1562\n1220#4:1569\n1179#4:1570\n1254#4,6:1571\n1254#4,6:1577\n1179#4:1588\n1254#4,6:1589\n1268#4:1600\n1220#4:1601\n1165#4,3:1602\n1175#4:1605\n1179#4:1606\n1230#4:1607\n1254#4,6:1608\n1242#4:1614\n1241#4,4:1615\n1399#4:1636\n1270#4:1637\n1399#4:1648\n1270#4:1652\n1399#4:1673\n1270#4:1677\n1111#5:1164\n1114#5:1167\n1130#5:1444\n1123#5:1445\n1119#5:1446\n1123#5:1447\n1111#5:1448\n1114#5:1449\n1123#5:1465\n1127#5:1467\n1117#5:1470\n1114#5:1476\n1123#5:1485\n1127#5:1486\n1117#5:1487\n1114#5:1488\n1132#5:1568\n1144#5:1583\n1138#5:1584\n1141#5:1585\n1132#5:1586\n1132#5:1587\n1144#5:1595\n1138#5:1596\n1135#5:1597\n1132#5:1598\n1132#5:1599\n1123#5:1619\n1127#5:1620\n1096#5,2:1621\n1147#5:1623\n1098#5,2:1624\n1147#5:1626\n1147#5:1627\n1147#5:1628\n1147#5:1629\n1123#5:1630\n1127#5:1631\n1103#5,4:1632\n215#6:1180\n216#6:1183\n357#7,4:1184\n329#7,6:1188\n339#7,3:1195\n342#7,2:1199\n345#7,6:1203\n361#7:1209\n231#8,3:1258\n200#8,7:1261\n211#8,3:1269\n214#8,9:1273\n234#8:1282\n287#9,6:1283\n*S KotlinDebug\n*F\n+ 1 SieveCache.kt\nandroidx/collection/SieveCache\n*L\n229#1:1161,2\n288#1:1163\n288#1:1165,2\n288#1:1168,6\n300#1:1174,2\n311#1:1176,2\n322#1:1178,2\n332#1:1181,2\n341#1:1201,2\n350#1:1210,4\n350#1:1214,6\n350#1:1221,3\n350#1:1225,2\n350#1:1227,2\n350#1:1229,6\n350#1:1235\n358#1:1236,2\n447#1:1238,6\n447#1:1245,3\n447#1:1249,9\n551#1:1289,6\n551#1:1296,3\n551#1:1300,9\n563#1:1309,6\n563#1:1316,3\n563#1:1320,9\n575#1:1329,6\n575#1:1336,3\n575#1:1340,9\n580#1:1349,4\n580#1:1353,6\n580#1:1360,3\n580#1:1364,9\n580#1:1373\n586#1:1374,4\n586#1:1378,6\n586#1:1385,3\n586#1:1389,9\n586#1:1398\n596#1:1399,4\n596#1:1403,6\n596#1:1410,3\n596#1:1414,9\n596#1:1423\n609#1:1424,6\n609#1:1431,3\n609#1:1435,9\n654#1:1462,3\n654#1:1466\n654#1:1468,2\n654#1:1471,5\n654#1:1477,8\n1055#1:1638,4\n1055#1:1642,6\n1055#1:1649,3\n1055#1:1653,9\n1055#1:1662\n1081#1:1663,4\n1081#1:1667,6\n1081#1:1674,3\n1081#1:1678,9\n1081#1:1687\n131#1:1149,5\n211#1:1155,6\n341#1:1194\n341#1:1198\n350#1:1220\n350#1:1224\n447#1:1244\n447#1:1248\n486#1:1268\n486#1:1272\n551#1:1295\n551#1:1299\n563#1:1315\n563#1:1319\n575#1:1335\n575#1:1339\n580#1:1359\n580#1:1363\n586#1:1384\n586#1:1388\n596#1:1409\n596#1:1413\n609#1:1430\n609#1:1434\n648#1:1450\n648#1:1451,6\n648#1:1457\n648#1:1458,4\n688#1:1489,3\n689#1:1492\n692#1:1493\n696#1:1494,3\n697#1:1497,3\n698#1:1500\n699#1:1501\n699#1:1502\n703#1:1503\n706#1:1504\n718#1:1505,3\n719#1:1508\n720#1:1509\n727#1:1510,3\n728#1:1513,3\n729#1:1516\n730#1:1517\n730#1:1518\n734#1:1519\n737#1:1520\n746#1:1521\n746#1:1522\n752#1:1523\n752#1:1524\n753#1:1525\n753#1:1526,6\n753#1:1532\n753#1:1533,4\n764#1:1537,3\n765#1:1540\n767#1:1541\n841#1:1542,14\n847#1:1556\n861#1:1557,3\n862#1:1560\n873#1:1561\n874#1:1562,6\n888#1:1569\n891#1:1570\n892#1:1571,6\n893#1:1577,6\n915#1:1588\n916#1:1589,6\n980#1:1600\n980#1:1601\n982#1:1602,3\n983#1:1605\n985#1:1606\n985#1:1607\n985#1:1608,6\n985#1:1614\n985#1:1615,4\n1030#1:1636\n1037#1:1637\n1055#1:1648\n1055#1:1652\n1081#1:1673\n1081#1:1677\n288#1:1164\n288#1:1167\n619#1:1444\n621#1:1445\n622#1:1446\n626#1:1447\n633#1:1448\n636#1:1449\n654#1:1465\n654#1:1467\n654#1:1470\n654#1:1476\n662#1:1485\n663#1:1486\n666#1:1487\n672#1:1488\n878#1:1568\n905#1:1583\n907#1:1584\n908#1:1585\n910#1:1586\n912#1:1587\n931#1:1595\n933#1:1596\n934#1:1597\n936#1:1598\n940#1:1599\n1001#1:1619\n1002#1:1620\n1003#1:1621,2\n1003#1:1623\n1003#1:1624,2\n1003#1:1626\n1005#1:1627\n1006#1:1628\n1007#1:1629\n1014#1:1630\n1015#1:1631\n1016#1:1632,4\n332#1:1180\n332#1:1183\n341#1:1184,4\n341#1:1188,6\n341#1:1195,3\n341#1:1199,2\n341#1:1203,6\n341#1:1209\n486#1:1258,3\n486#1:1261,7\n486#1:1269,3\n486#1:1273,9\n486#1:1282\n491#1:1283,6\n*E\n"})
public final class SieveCache<K, V> {
    @NotNull
    private final Function2<K, V, Integer> sizeOf;
    @NotNull
    private final Function1<K, V> createValueFromKey;
    @NotNull
    private final Function4<K, V, V, Boolean, Unit> onEntryRemoved;
    @JvmField
    @NotNull
    public long[] metadata;
    @JvmField
    @NotNull
    public Object[] keys;
    @JvmField
    @NotNull
    public Object[] values;
    @NotNull
    private long[] nodes;
    private int _capacity;
    private int growthLimit;
    private int _count;
    private int _maxSize;
    private int _size;
    private int head;
    private int tail;
    private int hand;

    public SieveCache(@IntRange(from=1L, to=0x7FFFFFFEL) int maxSize, @IntRange(from=0L, to=0x7FFFFFFEL) int initialCapacity, @NotNull Function2<? super K, ? super V, Integer> sizeOf, @NotNull Function1<? super K, ? extends V> createValueFromKey, @NotNull Function4<? super K, ? super V, ? super V, ? super Boolean, Unit> onEntryRemoved) {
        Intrinsics.checkNotNullParameter(sizeOf, (String)"sizeOf");
        Intrinsics.checkNotNullParameter(createValueFromKey, (String)"createValueFromKey");
        Intrinsics.checkNotNullParameter(onEntryRemoved, (String)"onEntryRemoved");
        this.sizeOf = sizeOf;
        this.createValueFromKey = createValueFromKey;
        this.onEntryRemoved = onEntryRemoved;
        this.metadata = ScatterMapKt.EmptyGroup;
        this.keys = ContainerHelpersKt.EMPTY_OBJECTS;
        this.values = ContainerHelpersKt.EMPTY_OBJECTS;
        this.nodes = SieveCacheKt.getEmptyNodes();
        this.head = Integer.MAX_VALUE;
        this.tail = Integer.MAX_VALUE;
        this.hand = Integer.MAX_VALUE;
        boolean value$iv = maxSize > 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            RuntimeHelpersKt.throwIllegalArgumentException("maxSize must be > 0");
        }
        this._maxSize = maxSize;
        this.initializeStorage(ScatterMapKt.unloadedCapacity(initialCapacity));
    }

    public /* synthetic */ SieveCache(int n, int n2, Function2 function2, Function1 function1, Function4 function4, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n2 = 6;
        }
        if ((n3 & 4) != 0) {
            function2 = 1.INSTANCE;
        }
        if ((n3 & 8) != 0) {
            function1 = 2.INSTANCE;
        }
        if ((n3 & 0x10) != 0) {
            function4 = 3.INSTANCE;
        }
        this(n, n2, function2, function1, function4);
    }

    @PublishedApi
    public static /* synthetic */ void getMetadata$annotations() {
    }

    @PublishedApi
    public static /* synthetic */ void getKeys$annotations() {
    }

    @PublishedApi
    public static /* synthetic */ void getValues$annotations() {
    }

    public final int getSize() {
        return this._size;
    }

    public final int getMaxSize() {
        return this._maxSize;
    }

    public final int getCount() {
        return this._count;
    }

    public static /* synthetic */ void getCount$annotations() {
    }

    public final int getCapacity() {
        return this._capacity;
    }

    public final boolean any() {
        return this._count != 0;
    }

    public final boolean none() {
        return this._count == 0;
    }

    public final boolean isEmpty() {
        return this._count == 0;
    }

    public final boolean isNotEmpty() {
        return this._count != 0;
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeStorage(int initialCapacity) {
        long[] lArray;
        int newCapacity;
        this._capacity = newCapacity = initialCapacity > 0 ? Math.max(7, ScatterMapKt.normalizeCapacity(initialCapacity)) : 0;
        this.initializeMetadata(newCapacity);
        this.keys = newCapacity == 0 ? ContainerHelpersKt.EMPTY_OBJECTS : new Object[newCapacity];
        this.values = newCapacity == 0 ? ContainerHelpersKt.EMPTY_OBJECTS : new Object[newCapacity];
        SieveCache sieveCache = this;
        if (newCapacity == 0) {
            lArray = SieveCacheKt.getEmptyNodes();
        } else {
            void $this$initializeStorage_u24lambda_u241;
            long[] lArray2;
            long[] lArray3 = lArray2 = new long[newCapacity];
            SieveCache sieveCache2 = sieveCache;
            boolean bl = false;
            ArraysKt.fill$default((long[])$this$initializeStorage_u24lambda_u241, (long)0x3FFFFFFFFFFFFFFFL, (int)0, (int)0, (int)6, null);
            sieveCache = sieveCache2;
            lArray = lArray2;
        }
        sieveCache.nodes = lArray;
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeMetadata(int capacity) {
        long[] lArray;
        SieveCache sieveCache = this;
        if (capacity == 0) {
            lArray = ScatterMapKt.EmptyGroup;
        } else {
            void $this$initializeMetadata_u24lambda_u242;
            long[] lArray2;
            int size = (capacity + 1 + 7 + 7 & 0xFFFFFFF8) >> 3;
            long[] lArray3 = lArray2 = new long[size];
            SieveCache sieveCache2 = sieveCache;
            boolean bl = false;
            ArraysKt.fill$default((long[])$this$initializeMetadata_u24lambda_u242, (long)-9187201950435737472L, (int)0, (int)0, (int)6, null);
            long value$iv = 255L;
            boolean $i$f$writeRawMetadata = false;
            int i$iv = capacity >> 3;
            int b$iv = (capacity & 7) << 3;
            $this$initializeMetadata_u24lambda_u242[i$iv] = $this$initializeMetadata_u24lambda_u242[i$iv] & (255L << b$iv ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv;
            sieveCache = sieveCache2;
            lArray = lArray2;
        }
        sieveCache.metadata = lArray;
        this.initializeGrowth();
    }

    private final void initializeGrowth() {
        this.growthLimit = ScatterMapKt.loadedCapacity(this._capacity) - this.getCount();
    }

    @Nullable
    public final V get(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int index2 = this.findKeyIndex(key);
        if (index2 >= 0) {
            SieveCache this_$iv = this;
            boolean $i$f$markNodeVisited = false;
            this_$iv.nodes[index2] = this_$iv.nodes[index2] & 0x3FFFFFFFFFFFFFFFL | 0x4000000000000000L;
            return (V)this.values[index2];
        }
        Object object = this.createValueFromKey.invoke(key);
        if (object == null) {
            return null;
        }
        Object createdValue = object;
        this.put(key, createdValue);
        return (V)createdValue;
    }

    public final void set(@NotNull K key, @NotNull V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        boolean $i$f$set = false;
        this.put(key, value);
    }

    @Nullable
    public final V put(@NotNull K key, @NotNull V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        int index2 = this.findInsertIndex(key);
        boolean bl = false;
        int index3 = index2 < 0 ? ~index2 : index2;
        Object previousValue = this.values[index3];
        this.values[index3] = value;
        this.keys[index3] = key;
        this._size += ((Number)this.sizeOf.invoke(key, value)).intValue();
        if (previousValue != null) {
            this._size -= ((Number)this.sizeOf.invoke(key, previousValue)).intValue();
            this.onEntryRemoved.invoke(key, previousValue, value, (Object)false);
            this.trimToSize(this._maxSize);
            return (V)previousValue;
        }
        this.trimToSize(this._maxSize);
        SieveCache this_$iv = this;
        boolean $i$f$moveNodeToHead = false;
        int next$iv$iv = this_$iv.head;
        boolean $i$f$createLinkToNext = false;
        this_$iv.nodes[index3] = 0x3FFFFFFF80000000L | (long)next$iv$iv & Integer.MAX_VALUE;
        if (this_$iv.head != Integer.MAX_VALUE) {
            long node$iv$iv = this_$iv.nodes[this_$iv.head];
            boolean $i$f$setLinkToPrevious = false;
            this_$iv.nodes[this_$iv.head] = node$iv$iv & 0xC00000007FFFFFFFL | ((long)index3 & Integer.MAX_VALUE) << 31;
        }
        this_$iv.head = index3;
        if (this_$iv.tail == Integer.MAX_VALUE) {
            this_$iv.tail = index3;
        }
        return (V)previousValue;
    }

    public final void putAll(@NotNull Pair<? extends K, ? extends V>[] pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        for (Pair<? extends K, ? extends V> pair : pairs) {
            Object key = pair.component1();
            Object value = pair.component2();
            SieveCache this_$iv = this;
            boolean $i$f$set = false;
            this_$iv.put(key, value);
        }
    }

    public final void putAll(@NotNull Iterable<? extends Pair<? extends K, ? extends V>> pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        for (Pair<K, V> pair : pairs) {
            Object key = pair.component1();
            Object value = pair.component2();
            SieveCache this_$iv = this;
            boolean $i$f$set = false;
            this_$iv.put(key, value);
        }
    }

    public final void putAll(@NotNull Sequence<? extends Pair<? extends K, ? extends V>> pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        for (Pair pair : pairs) {
            Object key = pair.component1();
            Object value = pair.component2();
            SieveCache this_$iv = this;
            boolean $i$f$set = false;
            this_$iv.put(key, value);
        }
    }

    public final void putAll(@NotNull Map<K, ? extends V> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        Map<K, V> $this$forEach$iv = from;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<K, V>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<K, V> element$iv;
            Map.Entry<K, V> entry = element$iv = iterator2.next();
            boolean bl = false;
            K key = entry.getKey();
            V value = entry.getValue();
            SieveCache this_$iv = this;
            boolean $i$f$set = false;
            this_$iv.put(key, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void putAll(@NotNull ScatterMap<K, V> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        ScatterMap<K, V> this_$iv = from;
        boolean $i$f$forEach = false;
        Object[] k$iv = this_$iv.keys;
        Object[] v$iv = this_$iv.values;
        ScatterMap<K, V> this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        int i$iv$iv = 0;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            void value;
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            Object object = v$iv[index$iv];
                            Object key = k$iv[index$iv];
                            boolean bl2 = false;
                            SieveCache this_$iv2 = this;
                            boolean $i$f$set = false;
                            this_$iv2.put(key, value);
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void putAll(@NotNull SieveCache<K, V> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        SieveCache<K, V> this_$iv = from;
        boolean $i$f$forEach = false;
        Object[] k$iv = this_$iv.keys;
        Object[] v$iv = this_$iv.values;
        SieveCache<K, V> this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        int i$iv$iv = 0;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            void value;
                            Object key;
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)k$iv[index$iv], (String)"null cannot be cast to non-null type K of androidx.collection.SieveCache");
                            Intrinsics.checkNotNull((Object)v$iv[index$iv], (String)"null cannot be cast to non-null type V of androidx.collection.SieveCache");
                            boolean bl2 = false;
                            SieveCache this_$iv2 = this;
                            boolean $i$f$set = false;
                            this_$iv2.put(key, value);
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void plusAssign(@NotNull Pair<? extends K, ? extends V> pair) {
        void key$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter(pair, (String)"pair");
        boolean $i$f$plusAssign = false;
        SieveCache sieveCache = this;
        Object object = pair.getFirst();
        Object value$iv = pair.getSecond();
        boolean $i$f$set = false;
        this_$iv.put(key$iv, value$iv);
    }

    public final void plusAssign(@NotNull Pair<? extends K, ? extends V>[] pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        boolean $i$f$plusAssign = false;
        this.putAll(pairs);
    }

    public final void plusAssign(@NotNull Iterable<? extends Pair<? extends K, ? extends V>> pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        boolean $i$f$plusAssign = false;
        this.putAll(pairs);
    }

    public final void plusAssign(@NotNull Sequence<? extends Pair<? extends K, ? extends V>> pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        boolean $i$f$plusAssign = false;
        this.putAll(pairs);
    }

    public final void plusAssign(@NotNull Map<K, ? extends V> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        boolean $i$f$plusAssign = false;
        this.putAll(from);
    }

    public final void plusAssign(@NotNull ScatterMap<K, V> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        boolean $i$f$plusAssign = false;
        this.putAll(from);
    }

    public final void plusAssign(@NotNull SieveCache<K, V> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        boolean $i$f$plusAssign = false;
        this.putAll(from);
    }

    @Nullable
    public final V remove(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int index2 = this.findKeyIndex(key);
        if (index2 >= 0) {
            V v = this.removeValueAt(index2);
            if (v == null) {
                return null;
            }
            V previousValue = v;
            this._size -= ((Number)this.sizeOf.invoke(key, previousValue)).intValue();
            this.onEntryRemoved.invoke(key, previousValue, null, (Object)false);
            return previousValue;
        }
        return null;
    }

    public final boolean remove(@NotNull K key, @NotNull V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        int index2 = this.findKeyIndex(key);
        if (index2 >= 0 && Intrinsics.areEqual((Object)this.values[index2], value)) {
            V v = this.removeValueAt(index2);
            if (v == null) {
                return false;
            }
            V previousValue = v;
            this._size -= ((Number)this.sizeOf.invoke(key, previousValue)).intValue();
            this.onEntryRemoved.invoke(key, previousValue, null, (Object)false);
            return true;
        }
        return false;
    }

    public final void removeIf(@NotNull Function2<? super K, ? super V, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        SieveCache this_$iv = this;
        boolean $i$f$forEachIndexed = false;
        long[] m$iv = this_$iv.metadata;
        int lastIndex$iv = m$iv.length - 2;
        int i$iv = 0;
        if (i$iv <= lastIndex$iv) {
            while (true) {
                long slot$iv;
                long $this$maskEmptyOrDeleted$iv$iv = slot$iv = m$iv[i$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv & ($this$maskEmptyOrDeleted$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv = 8 - (~(i$iv - lastIndex$iv) >>> 31);
                    for (int j$iv = 0; j$iv < bitCount$iv; ++j$iv) {
                        long value$iv$iv = slot$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv < 128L) {
                            int index$iv;
                            int index2 = index$iv = (i$iv << 3) + j$iv;
                            boolean bl = false;
                            Object key = this.keys[index2];
                            Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type K of androidx.collection.SieveCache");
                            Object object = this.values[index2];
                            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type V of androidx.collection.SieveCache");
                            if (((Boolean)predicate.invoke(key, object)).booleanValue()) {
                                V previousValue;
                                if (this.removeValueAt(index2) == null) {
                                    return;
                                }
                                this._size -= ((Number)this.sizeOf.invoke(key, previousValue)).intValue();
                                this.onEntryRemoved.invoke(key, previousValue, null, (Object)false);
                            }
                        }
                        slot$iv >>= 8;
                    }
                    if (bitCount$iv != 8) break;
                }
                if (i$iv == lastIndex$iv) break;
                ++i$iv;
            }
        }
    }

    public final void minusAssign(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        boolean $i$f$minusAssign = false;
        this.remove(key);
    }

    public final void minusAssign(@NotNull K[] keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        boolean $i$f$minusAssign = false;
        for (K key : keys) {
            this.remove(key);
        }
    }

    public final void minusAssign(@NotNull Iterable<? extends K> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        boolean $i$f$minusAssign = false;
        for (K key : keys) {
            this.remove(key);
        }
    }

    public final void minusAssign(@NotNull Sequence<? extends K> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        boolean $i$f$minusAssign = false;
        for (Object key : keys) {
            this.remove(key);
        }
    }

    public final void minusAssign(@NotNull ScatterSet<K> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        boolean $i$f$minusAssign = false;
        ScatterSet<K> this_$iv = keys;
        boolean $i$f$forEach = false;
        Object[] elements$iv = this_$iv.elements;
        ScatterSet<K> this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndex = false;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        int i$iv$iv = 0;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            Object key = elements$iv[index$iv];
                            boolean bl2 = false;
                            this.remove(key);
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
    }

    public final void minusAssign(@NotNull ObjectList<K> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        boolean $i$f$minusAssign = false;
        ObjectList<K> this_$iv = keys;
        boolean $i$f$forEach = false;
        Object[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            Object key = content$iv[i$iv];
            boolean bl = false;
            this.remove(key);
        }
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    public final void resize(@IntRange(from=1L, to=0x7FFFFFFEL) int maxSize) {
        this._maxSize = maxSize;
        this.trimToSize(maxSize);
    }

    public final void trimToSize(int maxSize) {
        while (this._size > maxSize && this.getCount() != 0) {
            V value;
            Object key;
            int candidate = this.findEvictionCandidate();
            if (candidate == Integer.MAX_VALUE) {
                return;
            }
            Intrinsics.checkNotNull((Object)this.keys[candidate], (String)"null cannot be cast to non-null type K of androidx.collection.SieveCache");
            if (this.removeValueAt(candidate) == null) continue;
            this._size -= ((Number)this.sizeOf.invoke(key, value)).intValue();
            this.onEntryRemoved.invoke(key, value, null, (Object)true);
        }
        return;
    }

    public final void forEach(@NotNull Function2<? super K, ? super V, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$forEach = false;
        Object[] k = this.keys;
        Object[] v = this.values;
        SieveCache this_$iv = this;
        boolean $i$f$forEachIndexed = false;
        long[] m$iv = this_$iv.metadata;
        int lastIndex$iv = m$iv.length - 2;
        int i$iv = 0;
        if (i$iv <= lastIndex$iv) {
            while (true) {
                long slot$iv;
                long $this$maskEmptyOrDeleted$iv$iv = slot$iv = m$iv[i$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv & ($this$maskEmptyOrDeleted$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv = 8 - (~(i$iv - lastIndex$iv) >>> 31);
                    for (int j$iv = 0; j$iv < bitCount$iv; ++j$iv) {
                        long value$iv$iv = slot$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv < 128L) {
                            int index$iv;
                            int index2 = index$iv = (i$iv << 3) + j$iv;
                            boolean bl = false;
                            Object object = k[index2];
                            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type K of androidx.collection.SieveCache");
                            Object object2 = v[index2];
                            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type V of androidx.collection.SieveCache");
                            block.invoke(object, object2);
                        }
                        slot$iv >>= 8;
                    }
                    if (bitCount$iv != 8) break;
                }
                if (i$iv == lastIndex$iv) break;
                ++i$iv;
            }
        }
    }

    public final void forEachKey(@NotNull Function1<? super K, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$forEachKey = false;
        Object[] k = this.keys;
        SieveCache this_$iv = this;
        boolean $i$f$forEachIndexed = false;
        long[] m$iv = this_$iv.metadata;
        int lastIndex$iv = m$iv.length - 2;
        int i$iv = 0;
        if (i$iv <= lastIndex$iv) {
            while (true) {
                long slot$iv;
                long $this$maskEmptyOrDeleted$iv$iv = slot$iv = m$iv[i$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv & ($this$maskEmptyOrDeleted$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv = 8 - (~(i$iv - lastIndex$iv) >>> 31);
                    for (int j$iv = 0; j$iv < bitCount$iv; ++j$iv) {
                        long value$iv$iv = slot$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv < 128L) {
                            int index$iv;
                            int index2 = index$iv = (i$iv << 3) + j$iv;
                            boolean bl = false;
                            Object object = k[index2];
                            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type K of androidx.collection.SieveCache");
                            block.invoke(object);
                        }
                        slot$iv >>= 8;
                    }
                    if (bitCount$iv != 8) break;
                }
                if (i$iv == lastIndex$iv) break;
                ++i$iv;
            }
        }
    }

    public final void forEachValue(@NotNull Function1<? super V, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$forEachValue = false;
        Object[] v = this.values;
        SieveCache this_$iv = this;
        boolean $i$f$forEachIndexed = false;
        long[] m$iv = this_$iv.metadata;
        int lastIndex$iv = m$iv.length - 2;
        int i$iv = 0;
        if (i$iv <= lastIndex$iv) {
            while (true) {
                long slot$iv;
                long $this$maskEmptyOrDeleted$iv$iv = slot$iv = m$iv[i$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv & ($this$maskEmptyOrDeleted$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv = 8 - (~(i$iv - lastIndex$iv) >>> 31);
                    for (int j$iv = 0; j$iv < bitCount$iv; ++j$iv) {
                        long value$iv$iv = slot$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv < 128L) {
                            int index$iv;
                            int index2 = index$iv = (i$iv << 3) + j$iv;
                            boolean bl = false;
                            Object object = v[index2];
                            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type V of androidx.collection.SieveCache");
                            block.invoke(object);
                        }
                        slot$iv >>= 8;
                    }
                    if (bitCount$iv != 8) break;
                }
                if (i$iv == lastIndex$iv) break;
                ++i$iv;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean all(@NotNull Function2<? super K, ? super V, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$all = false;
        SieveCache this_$iv = this;
        boolean $i$f$forEach = false;
        Object[] k$iv = this_$iv.keys;
        Object[] v$iv = this_$iv.values;
        SieveCache this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        int i$iv$iv = 0;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            void value;
                            Object key;
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)k$iv[index$iv], (String)"null cannot be cast to non-null type K of androidx.collection.SieveCache");
                            Intrinsics.checkNotNull((Object)v$iv[index$iv], (String)"null cannot be cast to non-null type V of androidx.collection.SieveCache");
                            boolean bl2 = false;
                            if (!((Boolean)predicate.invoke(key, (Object)value)).booleanValue()) {
                                return false;
                            }
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean any(@NotNull Function2<? super K, ? super V, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$any = false;
        SieveCache this_$iv = this;
        boolean $i$f$forEach = false;
        Object[] k$iv = this_$iv.keys;
        Object[] v$iv = this_$iv.values;
        SieveCache this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        int i$iv$iv = 0;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            void value;
                            Object key;
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)k$iv[index$iv], (String)"null cannot be cast to non-null type K of androidx.collection.SieveCache");
                            Intrinsics.checkNotNull((Object)v$iv[index$iv], (String)"null cannot be cast to non-null type V of androidx.collection.SieveCache");
                            boolean bl2 = false;
                            if (((Boolean)predicate.invoke(key, (Object)value)).booleanValue()) {
                                return true;
                            }
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        return false;
    }

    public final int count() {
        return this.getSize();
    }

    /*
     * WARNING - void declaration
     */
    public final int count(@NotNull Function2<? super K, ? super V, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$count = false;
        int count = 0;
        SieveCache this_$iv = this;
        boolean $i$f$forEach = false;
        Object[] k$iv = this_$iv.keys;
        Object[] v$iv = this_$iv.values;
        SieveCache this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        int i$iv$iv = 0;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            void value;
                            Object key;
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)k$iv[index$iv], (String)"null cannot be cast to non-null type K of androidx.collection.SieveCache");
                            Intrinsics.checkNotNull((Object)v$iv[index$iv], (String)"null cannot be cast to non-null type V of androidx.collection.SieveCache");
                            boolean bl2 = false;
                            if (((Boolean)predicate.invoke(key, (Object)value)).booleanValue()) {
                                ++count;
                            }
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        return count;
    }

    public final boolean contains(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.findKeyIndex(key) >= 0;
    }

    public final boolean containsKey(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.findKeyIndex(key) >= 0;
    }

    public final boolean containsValue(@NotNull V value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Object[] v = this.values;
        SieveCache this_$iv = this;
        boolean $i$f$forEachIndexed = false;
        long[] m$iv = this_$iv.metadata;
        int lastIndex$iv = m$iv.length - 2;
        int i$iv = 0;
        if (i$iv <= lastIndex$iv) {
            while (true) {
                long slot$iv;
                long $this$maskEmptyOrDeleted$iv$iv = slot$iv = m$iv[i$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv & ($this$maskEmptyOrDeleted$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv = 8 - (~(i$iv - lastIndex$iv) >>> 31);
                    for (int j$iv = 0; j$iv < bitCount$iv; ++j$iv) {
                        long value$iv$iv = slot$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv < 128L) {
                            int index$iv;
                            int index2 = index$iv = (i$iv << 3) + j$iv;
                            boolean bl = false;
                            Object object = v[index2];
                            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type V of androidx.collection.SieveCache");
                            if (Intrinsics.areEqual(value, (Object)object)) {
                                return true;
                            }
                        }
                        slot$iv >>= 8;
                    }
                    if (bitCount$iv != 8) break;
                }
                if (i$iv == lastIndex$iv) break;
                ++i$iv;
            }
        }
        return false;
    }

    private final int findEvictionCandidate() {
        int candidate;
        long[] nodes = this.nodes;
        int n = candidate = this.hand != Integer.MAX_VALUE ? this.hand : this.tail;
        while (candidate != Integer.MAX_VALUE) {
            long node2;
            long $this$visited$iv = nodes[candidate];
            boolean $i$f$getVisited = false;
            if ((int)($this$visited$iv >> 62 & 1L) == 0) break;
            long $this$previousNode$iv = node2 = nodes[candidate];
            boolean $i$f$getPreviousNode = false;
            int previousIndex = (int)($this$previousNode$iv >> 31 & Integer.MAX_VALUE);
            boolean $i$f$clearVisitedBit = false;
            nodes[candidate] = node2 & 0x3FFFFFFFFFFFFFFFL;
            candidate = previousIndex != Integer.MAX_VALUE ? previousIndex : this.tail;
        }
        long $this$previousNode$iv = nodes[candidate];
        boolean $i$f$getPreviousNode = false;
        int previousIndex = (int)($this$previousNode$iv >> 31 & Integer.MAX_VALUE);
        this.hand = previousIndex != Integer.MAX_VALUE ? previousIndex : Integer.MAX_VALUE;
        return candidate;
    }

    private final void moveNodeToHead(int index2) {
        boolean $i$f$moveNodeToHead = false;
        int next$iv = this.head;
        boolean $i$f$createLinkToNext = false;
        this.nodes[index2] = 0x3FFFFFFF80000000L | (long)next$iv & Integer.MAX_VALUE;
        if (this.head != Integer.MAX_VALUE) {
            long node$iv = this.nodes[this.head];
            boolean $i$f$setLinkToPrevious = false;
            this.nodes[this.head] = node$iv & 0xC00000007FFFFFFFL | ((long)index2 & Integer.MAX_VALUE) << 31;
        }
        this.head = index2;
        if (this.tail == Integer.MAX_VALUE) {
            this.tail = index2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final V removeValueAt(int index2) {
        long node$iv$iv;
        long node$iv;
        void capacity$iv;
        void data$iv;
        --this._count;
        long[] lArray = this.metadata;
        int n = this._capacity;
        long value$iv = 254L;
        boolean $i$f$writeMetadata = false;
        boolean $i$f$writeRawMetadata = false;
        int i$iv$iv = index2 >> 3;
        int b$iv$iv = (index2 & 7) << 3;
        data$iv[i$iv$iv] = data$iv[i$iv$iv] & (255L << b$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv$iv;
        int cloneIndex$iv = (index2 - 7 & capacity$iv) + (7 & capacity$iv);
        data$iv[cloneIndex$iv >> 3] = data$iv[index2 >> 3];
        this.keys[index2] = null;
        Object previousValue = this.values[index2];
        this.values[index2] = null;
        SieveCache this_$iv = this;
        boolean $i$f$removeNode = false;
        long[] nodes$iv = this_$iv.nodes;
        long $this$previousNode$iv$iv = node$iv = nodes$iv[index2];
        boolean $i$f$getPreviousNode = false;
        int previousIndex$iv = (int)($this$previousNode$iv$iv >> 31 & Integer.MAX_VALUE);
        long $this$nextNode$iv$iv = node$iv;
        boolean $i$f$getNextNode = false;
        int nextIndex$iv = (int)($this$nextNode$iv$iv & Integer.MAX_VALUE);
        if (previousIndex$iv != Integer.MAX_VALUE) {
            node$iv$iv = nodes$iv[previousIndex$iv];
            boolean $i$f$setLinkToNext = false;
            nodes$iv[previousIndex$iv] = node$iv$iv & Integer.MIN_VALUE | (long)nextIndex$iv & Integer.MAX_VALUE;
        } else {
            this_$iv.head = nextIndex$iv;
        }
        if (nextIndex$iv != Integer.MAX_VALUE) {
            node$iv$iv = nodes$iv[nextIndex$iv];
            boolean $i$f$setLinkToPrevious = false;
            nodes$iv[nextIndex$iv] = node$iv$iv & 0xC00000007FFFFFFFL | ((long)previousIndex$iv & Integer.MAX_VALUE) << 31;
        } else {
            this_$iv.tail = previousIndex$iv;
        }
        if (this_$iv.hand == index2) {
            this_$iv.hand = previousIndex$iv;
        }
        nodes$iv[index2] = 0x3FFFFFFFFFFFFFFFL;
        return (V)previousValue;
    }

    private final void removeNode(int index2) {
        long node$iv;
        long node2;
        boolean $i$f$removeNode = false;
        long[] nodes = this.nodes;
        long $this$previousNode$iv = node2 = nodes[index2];
        boolean $i$f$getPreviousNode = false;
        int previousIndex = (int)($this$previousNode$iv >> 31 & Integer.MAX_VALUE);
        long $this$nextNode$iv = node2;
        boolean $i$f$getNextNode = false;
        int nextIndex = (int)($this$nextNode$iv & Integer.MAX_VALUE);
        if (previousIndex != Integer.MAX_VALUE) {
            node$iv = nodes[previousIndex];
            boolean $i$f$setLinkToNext = false;
            nodes[previousIndex] = node$iv & Integer.MIN_VALUE | (long)nextIndex & Integer.MAX_VALUE;
        } else {
            this.head = nextIndex;
        }
        if (nextIndex != Integer.MAX_VALUE) {
            node$iv = nodes[nextIndex];
            boolean $i$f$setLinkToPrevious = false;
            nodes[nextIndex] = node$iv & 0xC00000007FFFFFFFL | ((long)previousIndex & Integer.MAX_VALUE) << 31;
        } else {
            this.tail = previousIndex;
        }
        if (this.hand == index2) {
            this.hand = previousIndex;
        }
        nodes[index2] = 0x3FFFFFFFFFFFFFFFL;
    }

    private final void markNodeVisited(int index2) {
        boolean $i$f$markNodeVisited = false;
        this.nodes[index2] = this.nodes[index2] & 0x3FFFFFFFFFFFFFFFL | 0x4000000000000000L;
    }

    private final int findKeyIndex(K key) {
        boolean $i$f$hash = false;
        K k = key;
        int hash$iv = (k != null ? k.hashCode() : 0) * -862048943;
        int hash = hash$iv ^ hash$iv << 16;
        boolean $i$f$h2 = false;
        int hash2 = hash & 0x7F;
        int probeMask = this._capacity;
        boolean $i$f$h1 = false;
        int probeOffset = hash >>> 7 & probeMask;
        int probeIndex = 0;
        while (true) {
            long g;
            long[] metadata$iv = this.metadata;
            boolean $i$f$group = false;
            int i$iv = probeOffset >> 3;
            int b$iv = (probeOffset & 7) << 3;
            long $this$match$iv = g = metadata$iv[i$iv] >>> b$iv | metadata$iv[i$iv + 1] << 64 - b$iv & -((long)b$iv) >> 63;
            boolean $i$f$match = false;
            long x$iv = $this$match$iv ^ 0x101010101010101L * (long)hash2;
            long m = x$iv - 0x101010101010101L & (x$iv ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L;
            while (true) {
                long $this$hasNext$iv = m;
                boolean $i$f$hasNext = false;
                if (!($this$hasNext$iv != 0L)) break;
                long $this$get$iv = m;
                boolean $i$f$get = false;
                long $this$lowestBitSet$iv$iv = $this$get$iv;
                boolean $i$f$lowestBitSet = false;
                int index2 = probeOffset + (Long.numberOfTrailingZeros($this$lowestBitSet$iv$iv) >> 3) & probeMask;
                if (Intrinsics.areEqual((Object)this.keys[index2], key)) {
                    return index2;
                }
                long $this$next$iv = m;
                boolean $i$f$next = false;
                m = $this$next$iv & $this$next$iv - 1L;
            }
            long $this$maskEmpty$iv = g;
            boolean $i$f$maskEmpty = false;
            if (($this$maskEmpty$iv & ($this$maskEmpty$iv ^ 0xFFFFFFFFFFFFFFFFL) << 6 & 0x8080808080808080L) != 0L) break;
            probeOffset = probeOffset + (probeIndex += 8) & probeMask;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private final int findInsertIndex(K key) {
        void capacity$iv;
        void data$iv;
        boolean $i$f$readRawMetadata;
        long[] metadata$iv;
        boolean $i$f$hash = false;
        K k = key;
        int hash$iv = (k != null ? k.hashCode() : 0) * -862048943;
        int hash = hash$iv ^ hash$iv << 16;
        boolean $i$f$h1 = false;
        int hash1 = hash >>> 7;
        boolean $i$f$h2 = false;
        int hash2 = hash & 0x7F;
        int probeMask = this._capacity;
        int probeOffset = hash1 & probeMask;
        int probeIndex = 0;
        while (true) {
            long g;
            long[] metadata$iv2 = this.metadata;
            boolean $i$f$group = false;
            int i$iv = probeOffset >> 3;
            int b$iv = (probeOffset & 7) << 3;
            long $this$match$iv = g = metadata$iv2[i$iv] >>> b$iv | metadata$iv2[i$iv + 1] << 64 - b$iv & -((long)b$iv) >> 63;
            boolean $i$f$match = false;
            long x$iv = $this$match$iv ^ 0x101010101010101L * (long)hash2;
            long m = x$iv - 0x101010101010101L & (x$iv ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L;
            while (true) {
                long $this$hasNext$iv = m;
                boolean $i$f$hasNext = false;
                if (!($this$hasNext$iv != 0L)) break;
                long $this$get$iv = m;
                boolean $i$f$get = false;
                long $this$lowestBitSet$iv$iv = $this$get$iv;
                boolean $i$f$lowestBitSet = false;
                int index2 = probeOffset + (Long.numberOfTrailingZeros($this$lowestBitSet$iv$iv) >> 3) & probeMask;
                if (Intrinsics.areEqual((Object)this.keys[index2], key)) {
                    return index2;
                }
                long $this$next$iv = m;
                boolean $i$f$next = false;
                m = $this$next$iv & $this$next$iv - 1L;
            }
            long $this$maskEmpty$iv = g;
            boolean $i$f$maskEmpty = false;
            if (($this$maskEmpty$iv & ($this$maskEmpty$iv ^ 0xFFFFFFFFFFFFFFFFL) << 6 & 0x8080808080808080L) != 0L) break;
            probeOffset = probeOffset + (probeIndex += 8) & probeMask;
        }
        int index3 = this.findFirstAvailableSlot(hash1);
        if (this.growthLimit == 0) {
            metadata$iv = this.metadata;
            boolean $i$f$isDeleted = false;
            $i$f$readRawMetadata = false;
            if (!((metadata$iv[index3 >> 3] >> ((index3 & 7) << 3) & 0xFFL) == 254L)) {
                this.adjustStorage$collection();
                index3 = this.findFirstAvailableSlot(hash1);
            }
        }
        ++this._count;
        metadata$iv = this.metadata;
        int $i$f$isEmpty = 0;
        $i$f$readRawMetadata = false;
        this.growthLimit -= (metadata$iv[index3 >> 3] >> ((index3 & 7) << 3) & 0xFFL) == 128L ? 1 : 0;
        metadata$iv = this.metadata;
        $i$f$isEmpty = this._capacity;
        long value$iv = hash2;
        boolean $i$f$writeMetadata = false;
        boolean $i$f$writeRawMetadata = false;
        int i$iv$iv = index3 >> 3;
        int b$iv$iv = (index3 & 7) << 3;
        data$iv[i$iv$iv] = data$iv[i$iv$iv] & (255L << b$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv$iv;
        int cloneIndex$iv = (index3 - 7 & capacity$iv) + (7 & capacity$iv);
        data$iv[cloneIndex$iv >> 3] = data$iv[index3 >> 3];
        return ~index3;
    }

    private final int findFirstAvailableSlot(int hash1) {
        int probeMask = this._capacity;
        int probeOffset = hash1 & probeMask;
        int probeIndex = 0;
        while (true) {
            long g;
            long[] metadata$iv = this.metadata;
            boolean $i$f$group = false;
            int i$iv = probeOffset >> 3;
            int b$iv = (probeOffset & 7) << 3;
            long $this$maskEmptyOrDeleted$iv = g = metadata$iv[i$iv] >>> b$iv | metadata$iv[i$iv + 1] << 64 - b$iv & -((long)b$iv) >> 63;
            boolean $i$f$maskEmptyOrDeleted = false;
            long m = $this$maskEmptyOrDeleted$iv & ($this$maskEmptyOrDeleted$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L;
            if (m != 0L) {
                long $this$lowestBitSet$iv = m;
                boolean $i$f$lowestBitSet = false;
                return probeOffset + (Long.numberOfTrailingZeros($this$lowestBitSet$iv) >> 3) & probeMask;
            }
            probeOffset = probeOffset + (probeIndex += 8) & probeMask;
        }
    }

    public final void adjustStorage$collection() {
        if (this._capacity > 8 && Long.compareUnsigned(ULong.constructor-impl((long)(ULong.constructor-impl((long)this.getCount()) * 32L)), ULong.constructor-impl((long)(ULong.constructor-impl((long)this._capacity) * 25L))) <= 0) {
            this.dropDeletes$collection();
        } else {
            this.resizeStorage$collection(ScatterMapKt.nextCapacity(this._capacity));
        }
    }

    public final void dropDeletes$collection() {
        long[] metadata = this.metadata;
        if (metadata == null) {
            return;
        }
        int capacity = this._capacity;
        Object[] keys = this.keys;
        Object[] values = this.values;
        long[] nodes = this.nodes;
        long[] indexMapping = new long[capacity];
        ArraysKt.fill((long[])indexMapping, (long)0x7FFFFFFF7FFFFFFFL, (int)0, (int)capacity);
        boolean $i$f$convertMetadataForCleanup = false;
        int end$iv = capacity + 7 >> 3;
        for (int i$iv = 0; i$iv < end$iv; ++i$iv) {
            long maskedGroup$iv = metadata[i$iv] & 0x8080808080808080L;
            metadata[i$iv] = (maskedGroup$iv ^ 0xFFFFFFFFFFFFFFFFL) + (maskedGroup$iv >>> 7) & 0xFEFEFEFEFEFEFEFEL;
        }
        int lastIndex$iv = ArraysKt.getLastIndex((long[])metadata);
        metadata[lastIndex$iv - 1] = 0xFF00000000000000L | metadata[lastIndex$iv - 1] & 0xFFFFFFFFFFFFFFL;
        metadata[lastIndex$iv] = metadata[0];
        int index2 = 0;
        while (index2 != capacity) {
            int b$iv;
            int i$iv;
            boolean $i$f$writeRawMetadata;
            int hash2;
            int oldProbeIndex;
            int probeOffset;
            boolean $i$f$readRawMetadata = false;
            long m = metadata[index2 >> 3] >> ((index2 & 7) << 3) & 0xFFL;
            if (m == 128L) {
                ++index2;
                continue;
            }
            if (m != 254L) {
                ++index2;
                continue;
            }
            Object k$iv = keys[index2];
            boolean $i$f$hash = false;
            Object object = k$iv;
            int hash$iv = (object != null ? object.hashCode() : 0) * -862048943;
            int hash = hash$iv ^ hash$iv << 16;
            boolean $i$f$h1 = false;
            int hash1 = hash >>> 7;
            int targetIndex = this.findFirstAvailableSlot(hash1);
            int newProbeIndex = (targetIndex - (probeOffset = hash1 & capacity) & capacity) / 8;
            if (newProbeIndex == (oldProbeIndex = (index2 - probeOffset & capacity) / 8)) {
                boolean $i$f$h2 = false;
                hash2 = hash & 0x7F;
                long value$iv = hash2;
                $i$f$writeRawMetadata = false;
                i$iv = index2 >> 3;
                b$iv = (index2 & 7) << 3;
                metadata[i$iv] = metadata[i$iv] & (255L << b$iv ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv;
                if (indexMapping[index2] == 0x7FFFFFFF7FFFFFFFL) {
                    boolean $i$f$createMapping = false;
                    indexMapping[index2] = (long)index2 << 32 | (long)index2;
                }
                metadata[metadata.length - 1] = metadata[0];
                ++index2;
                continue;
            }
            boolean $i$f$readRawMetadata2 = false;
            m = metadata[targetIndex >> 3] >> ((targetIndex & 7) << 3) & 0xFFL;
            if (m == 128L) {
                boolean $i$f$createMapping;
                long mapping;
                boolean $i$f$h2 = false;
                hash2 = hash & 0x7F;
                long value$iv = hash2;
                $i$f$writeRawMetadata = false;
                i$iv = targetIndex >> 3;
                b$iv = (targetIndex & 7) << 3;
                metadata[i$iv] = metadata[i$iv] & (255L << b$iv ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv;
                value$iv = 128L;
                $i$f$writeRawMetadata = false;
                i$iv = index2 >> 3;
                b$iv = (index2 & 7) << 3;
                metadata[i$iv] = metadata[i$iv] & (255L << b$iv ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv;
                keys[targetIndex] = keys[index2];
                keys[index2] = null;
                values[targetIndex] = values[index2];
                values[index2] = null;
                nodes[targetIndex] = nodes[index2];
                nodes[index2] = 0x3FFFFFFFFFFFFFFFL;
                long $this$src$iv = mapping = indexMapping[index2];
                boolean $i$f$getSrc = false;
                int src = (int)($this$src$iv >> 32 & 0xFFFFFFFFL);
                if (src != Integer.MAX_VALUE) {
                    long mapping$iv = indexMapping[src];
                    boolean $i$f$createDstMapping = false;
                    indexMapping[src] = mapping$iv & 0xFFFFFFFF00000000L | (long)targetIndex;
                    mapping$iv = indexMapping[index2];
                    boolean $i$f$eraseSrcMapping = false;
                    indexMapping[index2] = 0xFFFFFFFF00000000L | mapping$iv & 0xFFFFFFFFL;
                } else {
                    int src$iv = Integer.MAX_VALUE;
                    $i$f$createMapping = false;
                    indexMapping[index2] = (long)src$iv << 32 | (long)targetIndex;
                }
                int dst$iv = Integer.MAX_VALUE;
                $i$f$createMapping = false;
                indexMapping[targetIndex] = (long)index2 << 32 | (long)dst$iv;
            } else {
                long mapping;
                boolean $i$f$h2 = false;
                hash2 = hash & 0x7F;
                long value$iv = hash2;
                $i$f$writeRawMetadata = false;
                i$iv = targetIndex >> 3;
                b$iv = (targetIndex & 7) << 3;
                metadata[i$iv] = metadata[i$iv] & (255L << b$iv ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv;
                Object oldKey = keys[targetIndex];
                keys[targetIndex] = keys[index2];
                keys[index2] = oldKey;
                Object oldValue = values[targetIndex];
                values[targetIndex] = values[index2];
                values[index2] = oldValue;
                long oldNode = nodes[targetIndex];
                nodes[targetIndex] = nodes[index2];
                nodes[index2] = oldNode;
                long $this$src$iv = mapping = indexMapping[index2];
                boolean $i$f$getSrc = false;
                int src = (int)($this$src$iv >> 32 & 0xFFFFFFFFL);
                if (src != Integer.MAX_VALUE) {
                    long mapping$iv = indexMapping[src];
                    boolean $i$f$createDstMapping = false;
                    indexMapping[src] = mapping$iv & 0xFFFFFFFF00000000L | (long)targetIndex;
                    mapping$iv = indexMapping[index2];
                    boolean $i$f$createSrcMapping = false;
                    indexMapping[index2] = (long)targetIndex << 32 | mapping$iv & 0xFFFFFFFFL;
                } else {
                    boolean $i$f$createMapping = false;
                    indexMapping[index2] = (long)targetIndex << 32 | (long)targetIndex;
                    src = index2;
                }
                boolean $i$f$createMapping = false;
                indexMapping[targetIndex] = (long)src << 32 | (long)index2;
                --index2;
            }
            metadata[metadata.length - 1] = metadata[0];
            ++index2;
        }
        this.initializeGrowth();
        this.fixupNodes(indexMapping);
    }

    public final void resizeStorage$collection(int newCapacity) {
        long[] previousMetadata = this.metadata;
        Object[] previousKeys = this.keys;
        Object[] previousValues = this.values;
        long[] previousNodes = this.nodes;
        int previousCapacity = this._capacity;
        int[] indexMapping = new int[previousCapacity];
        this.initializeStorage(newCapacity);
        long[] newMetadata = this.metadata;
        Object[] newKeys = this.keys;
        Object[] newValues = this.values;
        long[] newNodes = this.nodes;
        int capacity = this._capacity;
        for (int i = 0; i < previousCapacity; ++i) {
            boolean $i$f$isFull = false;
            boolean $i$f$readRawMetadata = false;
            if (!((previousMetadata[i >> 3] >> ((i & 7) << 3) & 0xFFL) < 128L)) continue;
            Object previousKey = previousKeys[i];
            boolean $i$f$hash = false;
            Object object = previousKey;
            int hash$iv = (object != null ? object.hashCode() : 0) * -862048943;
            int hash = hash$iv ^ hash$iv << 16;
            boolean $i$f$h1 = false;
            int index2 = this.findFirstAvailableSlot(hash >>> 7);
            boolean $i$f$h2 = false;
            long value$iv = hash & 0x7F;
            boolean $i$f$writeMetadata = false;
            boolean $i$f$writeRawMetadata = false;
            int i$iv$iv = index2 >> 3;
            int b$iv$iv = (index2 & 7) << 3;
            newMetadata[i$iv$iv] = newMetadata[i$iv$iv] & (255L << b$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) | value$iv << b$iv$iv;
            int cloneIndex$iv = (index2 - 7 & capacity) + (7 & capacity);
            newMetadata[cloneIndex$iv >> 3] = newMetadata[index2 >> 3];
            newKeys[index2] = previousKey;
            newValues[index2] = previousValues[i];
            newNodes[index2] = previousNodes[i];
            indexMapping[i] = index2;
        }
        this.fixupNodes(indexMapping);
    }

    private final void fixupNodes(long[] mapping) {
        long[] nodes = this.nodes;
        int n = nodes.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            boolean $i$f$getDst;
            int n3;
            long node2;
            long $this$previousNode$iv = node2 = nodes[i];
            boolean $i$f$getPreviousNode = false;
            int previous = (int)($this$previousNode$iv >> 31 & Integer.MAX_VALUE);
            long $this$nextNode$iv = node2;
            boolean $i$f$getNextNode = false;
            int next = (int)($this$nextNode$iv & Integer.MAX_VALUE);
            boolean $i$f$createLinks = false;
            if (previous == Integer.MAX_VALUE) {
                n3 = Integer.MAX_VALUE;
            } else {
                long $this$dst$iv$iv = mapping[previous];
                $i$f$getDst = false;
                n3 = (int)($this$dst$iv$iv & 0xFFFFFFFFL);
            }
            long l = (node2 & 0xC000000000000000L | (long)n3) << 31;
            if (next == Integer.MAX_VALUE) {
                n2 = Integer.MAX_VALUE;
            } else {
                long $this$dst$iv$iv = mapping[next];
                $i$f$getDst = false;
                n2 = (int)($this$dst$iv$iv & 0xFFFFFFFFL);
            }
            nodes[i] = l | (long)n2;
        }
        if (this.head != Integer.MAX_VALUE) {
            long $this$dst$iv = mapping[this.head];
            boolean $i$f$getDst = false;
            this.head = (int)($this$dst$iv & 0xFFFFFFFFL);
        }
        if (this.tail != Integer.MAX_VALUE) {
            long $this$dst$iv = mapping[this.tail];
            boolean $i$f$getDst = false;
            this.tail = (int)($this$dst$iv & 0xFFFFFFFFL);
        }
        if (this.hand != Integer.MAX_VALUE) {
            long $this$dst$iv = mapping[this.hand];
            boolean $i$f$getDst = false;
            this.hand = (int)($this$dst$iv & 0xFFFFFFFFL);
        }
    }

    private final void fixupNodes(int[] mapping) {
        long[] nodes = this.nodes;
        int n = nodes.length;
        for (int i = 0; i < n; ++i) {
            long node2;
            long $this$previousNode$iv = node2 = nodes[i];
            boolean $i$f$getPreviousNode = false;
            int previous = (int)($this$previousNode$iv >> 31 & Integer.MAX_VALUE);
            long $this$nextNode$iv = node2;
            boolean $i$f$getNextNode = false;
            int next = (int)($this$nextNode$iv & Integer.MAX_VALUE);
            boolean $i$f$createLinks = false;
            nodes[i] = (node2 & 0xC000000000000000L | (long)(previous == Integer.MAX_VALUE ? Integer.MAX_VALUE : mapping[previous])) << 31 | (long)(next == Integer.MAX_VALUE ? Integer.MAX_VALUE : mapping[next]);
        }
        if (this.head != Integer.MAX_VALUE) {
            this.head = mapping[this.head];
        }
        if (this.tail != Integer.MAX_VALUE) {
            this.tail = mapping[this.tail];
        }
        if (this.hand != Integer.MAX_VALUE) {
            this.hand = mapping[this.hand];
        }
    }

    @PublishedApi
    public final void forEachIndexed(@NotNull Function1<? super Integer, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$forEachIndexed = false;
        long[] m = this.metadata;
        int lastIndex = m.length - 2;
        int i = 0;
        if (i <= lastIndex) {
            while (true) {
                long slot;
                long $this$maskEmptyOrDeleted$iv = slot = m[i];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv & ($this$maskEmptyOrDeleted$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount = 8 - (~(i - lastIndex) >>> 31);
                    for (int j = 0; j < bitCount; ++j) {
                        long value$iv = slot & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv < 128L) {
                            int index2 = (i << 3) + j;
                            block.invoke((Object)index2);
                        }
                        slot >>= 8;
                    }
                    if (bitCount != 8) {
                        return;
                    }
                }
                if (i == lastIndex) break;
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        int hash = 0;
        SieveCache this_$iv = this;
        boolean $i$f$forEach = false;
        Object[] k$iv = this_$iv.keys;
        Object[] v$iv = this_$iv.values;
        SieveCache this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        int i$iv$iv = 0;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            void value;
                            Object key;
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)k$iv[index$iv], (String)"null cannot be cast to non-null type K of androidx.collection.SieveCache");
                            Intrinsics.checkNotNull((Object)v$iv[index$iv], (String)"null cannot be cast to non-null type V of androidx.collection.SieveCache");
                            boolean bl2 = false;
                            hash += key.hashCode() ^ value.hashCode();
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        return hash;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SieveCache)) {
            return false;
        }
        if (((SieveCache)other).getSize() != this.getSize() || ((SieveCache)other)._count != this._count) {
            return false;
        }
        SieveCache o = (SieveCache)other;
        SieveCache this_$iv = this;
        boolean $i$f$forEach = false;
        Object[] k$iv = this_$iv.keys;
        Object[] v$iv = this_$iv.values;
        SieveCache this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        int i$iv$iv = 0;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            Object key;
                            void value;
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)k$iv[index$iv], (String)"null cannot be cast to non-null type K of androidx.collection.SieveCache");
                            Intrinsics.checkNotNull((Object)v$iv[index$iv], (String)"null cannot be cast to non-null type V of androidx.collection.SieveCache");
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)value, o.get(key))) {
                                return false;
                            }
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        return true;
    }

    @NotNull
    public String toString() {
        return "SieveCache[maxSize=" + this._maxSize + ", size=" + this._size + ", capacity=" + this._capacity + ", count=" + this._count + ']';
    }
}

