/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.BoundsAnimationKt;
import androidx.compose.animation.BoundsTransform;
import androidx.compose.animation.ExperimentalSharedTransitionApi;
import androidx.compose.animation.SharedTransitionScope;
import androidx.compose.animation.core.AnimationVector4D;
import androidx.compose.animation.core.FiniteAnimationSpec;
import androidx.compose.animation.core.Transition;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Rect;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0001\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u001c\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bR\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ,\u0010\u001a\u001a\u00020\u001b2\u001c\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bR\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\t2\u0006\u00105\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012RW\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bR\b\u0012\u0004\u0012\u00020\u00060\u00052\u001c\u0010\u0013\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bR\b\u0012\u0004\u0012\u00020\u00060\u00058F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R+\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b \u0010\u0019\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010!\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R \u0010#\u001a\b\u0012\u0004\u0012\u00020\t0$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R;\u0010*\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010)2\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010)8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b/\u0010\u0019\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0013\u00100\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0011\u00106\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\"\u00a8\u0006\u0007"}, d2={"Landroidx/compose/animation/BoundsAnimation;", "", "transitionScope", "Landroidx/compose/animation/SharedTransitionScope;", "transition", "Landroidx/compose/animation/core/Transition;", "", "animation", "Landroidx/compose/animation/core/Transition$DeferredAnimation;", "Landroidx/compose/ui/geometry/Rect;", "Landroidx/compose/animation/core/AnimationVector4D;", "boundsTransform", "Landroidx/compose/animation/BoundsTransform;", "<init>", "(Landroidx/compose/animation/SharedTransitionScope;Landroidx/compose/animation/core/Transition;Landroidx/compose/animation/core/Transition$DeferredAnimation;Landroidx/compose/animation/BoundsTransform;)V", "getTransitionScope", "()Landroidx/compose/animation/SharedTransitionScope;", "getTransition", "()Landroidx/compose/animation/core/Transition;", "<set-?>", "getAnimation", "()Landroidx/compose/animation/core/Transition$DeferredAnimation;", "setAnimation", "(Landroidx/compose/animation/core/Transition$DeferredAnimation;)V", "animation$delegate", "Landroidx/compose/runtime/MutableState;", "updateAnimation", "", "getBoundsTransform", "()Landroidx/compose/animation/BoundsTransform;", "setBoundsTransform", "(Landroidx/compose/animation/BoundsTransform;)V", "boundsTransform$delegate", "isRunning", "()Z", "animationSpec", "Landroidx/compose/animation/core/FiniteAnimationSpec;", "getAnimationSpec", "()Landroidx/compose/animation/core/FiniteAnimationSpec;", "setAnimationSpec", "(Landroidx/compose/animation/core/FiniteAnimationSpec;)V", "Landroidx/compose/runtime/State;", "animationState", "getAnimationState", "()Landroidx/compose/runtime/State;", "setAnimationState", "(Landroidx/compose/runtime/State;)V", "animationState$delegate", "value", "getValue", "()Landroidx/compose/ui/geometry/Rect;", "animate", "currentBounds", "targetBounds", "target", "getTarget"})
@ExperimentalSharedTransitionApi
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nBoundsAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoundsAnimation.kt\nandroidx/compose/animation/BoundsAnimation\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,103:1\n85#2:104\n117#2,2:105\n85#2:107\n117#2,2:108\n85#2:110\n117#2,2:111\n*S KotlinDebug\n*F\n+ 1 BoundsAnimation.kt\nandroidx/compose/animation/BoundsAnimation\n*L\n39#1:104\n39#1:105,2\n54#1:107\n54#1:108,2\n69#1:110\n69#1:111,2\n*E\n"})
public final class BoundsAnimation {
    @NotNull
    private final SharedTransitionScope transitionScope;
    @NotNull
    private final Transition<Boolean> transition;
    @NotNull
    private final MutableState animation$delegate;
    @NotNull
    private final MutableState boundsTransform$delegate;
    @NotNull
    private FiniteAnimationSpec<Rect> animationSpec;
    @NotNull
    private final MutableState animationState$delegate;
    public static final int $stable = 8;

    public BoundsAnimation(@NotNull SharedTransitionScope transitionScope, @NotNull Transition<Boolean> transition, @NotNull Transition.DeferredAnimation<Rect, AnimationVector4D> animation, @NotNull BoundsTransform boundsTransform) {
        Intrinsics.checkNotNullParameter((Object)transitionScope, (String)"transitionScope");
        Intrinsics.checkNotNullParameter(transition, (String)"transition");
        Intrinsics.checkNotNullParameter(animation, (String)"animation");
        Intrinsics.checkNotNullParameter((Object)boundsTransform, (String)"boundsTransform");
        this.transitionScope = transitionScope;
        this.transition = transition;
        this.animation$delegate = SnapshotStateKt.mutableStateOf$default(animation, null, (int)2, null);
        this.boundsTransform$delegate = SnapshotStateKt.mutableStateOf$default((Object)boundsTransform, null, (int)2, null);
        this.animationSpec = BoundsAnimationKt.access$getDefaultBoundsAnimation$p();
        this.animationState$delegate = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
    }

    @NotNull
    public final SharedTransitionScope getTransitionScope() {
        return this.transitionScope;
    }

    @NotNull
    public final Transition<Boolean> getTransition() {
        return this.transition;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Transition.DeferredAnimation<Rect, AnimationVector4D> getAnimation() {
        void $this$getValue$iv;
        State state = (State)this.animation$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Transition.DeferredAnimation)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setAnimation(Transition.DeferredAnimation<Rect, AnimationVector4D> deferredAnimation) {
        void $this$setValue$iv;
        MutableState mutableState = this.animation$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(deferredAnimation);
    }

    public final void updateAnimation(@NotNull Transition.DeferredAnimation<Rect, AnimationVector4D> animation, @NotNull BoundsTransform boundsTransform) {
        Intrinsics.checkNotNullParameter(animation, (String)"animation");
        Intrinsics.checkNotNullParameter((Object)boundsTransform, (String)"boundsTransform");
        if (!Intrinsics.areEqual(this.getAnimation(), animation)) {
            this.setAnimation(animation);
            this.setAnimationState(null);
            this.animationSpec = BoundsAnimationKt.access$getDefaultBoundsAnimation$p();
        }
        this.setBoundsTransform(boundsTransform);
    }

    /*
     * WARNING - void declaration
     */
    private final BoundsTransform getBoundsTransform() {
        void $this$getValue$iv;
        State state = (State)this.boundsTransform$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (BoundsTransform)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setBoundsTransform(BoundsTransform boundsTransform) {
        void $this$setValue$iv;
        MutableState mutableState = this.boundsTransform$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)boundsTransform);
    }

    public final boolean isRunning() {
        Transition<Boolean> parent = this.transition;
        while (parent.getParentTransition() != null) {
            Intrinsics.checkNotNull(parent.getParentTransition());
        }
        return !Intrinsics.areEqual((Object)parent.getCurrentState(), (Object)parent.getTargetState());
    }

    @NotNull
    public final FiniteAnimationSpec<Rect> getAnimationSpec() {
        return this.animationSpec;
    }

    public final void setAnimationSpec(@NotNull FiniteAnimationSpec<Rect> finiteAnimationSpec) {
        Intrinsics.checkNotNullParameter(finiteAnimationSpec, (String)"<set-?>");
        this.animationSpec = finiteAnimationSpec;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final State<Rect> getAnimationState() {
        void $this$getValue$iv;
        State state = (State)this.animationState$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (State)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setAnimationState(@Nullable State<Rect> state) {
        void $this$setValue$iv;
        MutableState mutableState = this.animationState$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(state);
    }

    @Nullable
    public final Rect getValue() {
        Rect rect;
        if (this.transitionScope.isTransitionActive()) {
            State<Rect> state = this.getAnimationState();
            rect = state != null ? (Rect)state.getValue() : null;
        } else {
            rect = null;
        }
        return rect;
    }

    public final void animate(@NotNull Rect currentBounds, @NotNull Rect targetBounds) {
        Intrinsics.checkNotNullParameter((Object)currentBounds, (String)"currentBounds");
        Intrinsics.checkNotNullParameter((Object)targetBounds, (String)"targetBounds");
        if (this.transitionScope.isTransitionActive()) {
            if (this.getAnimationState() == null) {
                this.animationSpec = this.getBoundsTransform().transform(currentBounds, targetBounds);
            }
            this.setAnimationState(this.getAnimation().animate(arg_0 -> BoundsAnimation.animate$lambda$0(this, arg_0), arg_0 -> BoundsAnimation.animate$lambda$1(this, targetBounds, currentBounds, arg_0)));
        }
    }

    public final boolean getTarget() {
        return this.transition.getTargetState();
    }

    private static final FiniteAnimationSpec animate$lambda$0(BoundsAnimation this$0, Transition.Segment $this$animate) {
        Intrinsics.checkNotNullParameter((Object)$this$animate, (String)"$this$animate");
        return this$0.animationSpec;
    }

    private static final Rect animate$lambda$1(BoundsAnimation this$0, Rect $targetBounds, Rect $currentBounds, boolean it) {
        return it == this$0.transition.getTargetState() ? $targetBounds : $currentBounds;
    }
}

