/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.annotation.FloatRange;
import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.foundation.MutatePriority;
import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.ScrollExtensionsKt;
import androidx.compose.foundation.gestures.ScrollScope;
import androidx.compose.foundation.gestures.ScrollableState;
import androidx.compose.foundation.gestures.ScrollableStateKt;
import androidx.compose.foundation.interaction.InteractionSource;
import androidx.compose.foundation.interaction.InteractionSourceKt;
import androidx.compose.foundation.interaction.MutableInteractionSource;
import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.lazy.layout.AwaitFirstLayoutModifier;
import androidx.compose.foundation.lazy.layout.LazyLayoutBeyondBoundsInfo;
import androidx.compose.foundation.lazy.layout.LazyLayoutPinnedItemList;
import androidx.compose.foundation.lazy.layout.LazyLayoutPrefetchState;
import androidx.compose.foundation.lazy.layout.NestedPrefetchScope;
import androidx.compose.foundation.lazy.layout.ObservableScopeInvalidator;
import androidx.compose.foundation.lazy.layout.PrefetchScheduler;
import androidx.compose.foundation.pager.MeasuredPage;
import androidx.compose.foundation.pager.PageInfo;
import androidx.compose.foundation.pager.PagerLayoutInfo;
import androidx.compose.foundation.pager.PagerLazyLayoutItemProvider;
import androidx.compose.foundation.pager.PagerMeasureResult;
import androidx.compose.foundation.pager.PagerScrollPosition;
import androidx.compose.foundation.pager.PagerScrollPositionKt;
import androidx.compose.foundation.pager.PagerScrollScopeKt;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.foundation.pager.PagerStateKt;
import androidx.compose.runtime.IntState;
import androidx.compose.runtime.MutableIntState;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotIntStateKt;
import androidx.compose.runtime.SnapshotMutationPolicy;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.State;
import androidx.compose.runtime.snapshots.Snapshot;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.layout.Remeasurement;
import androidx.compose.ui.layout.RemeasurementModifier;
import androidx.compose.ui.unit.ConstraintsKt;
import androidx.compose.ui.unit.Density;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00f6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b$\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B)\b\u0000\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u001d\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nJ\u0010\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005H\u0002J%\u0010\u0099\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u009b\u0001\u001a\u00020\u00032\t\b\u0003\u0010\u009c\u0001\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0003\u0010\u009d\u0001J!\u0010\u009e\u0001\u001a\u00030\u009a\u0001*\u00030\u009f\u00012\u0007\u0010\u009b\u0001\u001a\u00020\u00032\t\b\u0003\u0010\u009c\u0001\u001a\u00020\u0005J\u0015\u0010\u00a0\u0001\u001a\u00030\u009a\u0001*\u00030\u009f\u00012\u0006\u0010k\u001a\u00020\u0003J+\u0010\u00a1\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u009b\u0001\u001a\u00020\u00032\u0007\u0010\u00a2\u0001\u001a\u00020\u00052\u0007\u0010\u00a3\u0001\u001a\u00020\fH\u0000\u00a2\u0006\u0003\b\u00a4\u0001J\u001e\u0010\u00a7\u0001\u001a\u00030\u009a\u00012\t\b\u0001\u0010\u009b\u0001\u001a\u00020\u00032\t\b\u0003\u0010\u009c\u0001\u001a\u00020\u0005J7\u0010\u00a8\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u009b\u0001\u001a\u00020\u00032\t\b\u0003\u0010\u009c\u0001\u001a\u00020\u00052\u0010\b\u0002\u0010\u00a9\u0001\u001a\t\u0012\u0004\u0012\u00020\u00050\u00aa\u0001H\u0086@\u00a2\u0006\u0003\u0010\u00ab\u0001J\u0011\u0010\u00ac\u0001\u001a\u00030\u009a\u0001H\u0082@\u00a2\u0006\u0003\u0010\u00ad\u0001JK\u0010\u00ae\u0001\u001a\u00030\u009a\u00012\b\u0010\u00af\u0001\u001a\u00030\u00b0\u00012.\u0010\u00b1\u0001\u001a)\b\u0001\u0012\u0005\u0012\u00030\u009f\u0001\u0012\f\u0012\n\u0012\u0005\u0012\u00030\u009a\u00010\u00b3\u0001\u0012\u0007\u0012\u0005\u0018\u00010\u00b4\u00010\u00b2\u0001\u00a2\u0006\u0003\b\u00b5\u0001H\u0096@\u00a2\u0006\u0003\u0010\u00b6\u0001J\u0011\u0010\u00b7\u0001\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005H\u0016J-\u0010\u00c7\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00c8\u0001\u001a\u00020\u00102\u0007\u0010\u00c9\u0001\u001a\u00020\f2\t\b\u0002\u0010\u00ca\u0001\u001a\u00020\fH\u0000\u00a2\u0006\u0003\b\u00cb\u0001J\u0013\u0010\u00cc\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00c8\u0001\u001a\u00020\u0010H\u0002J\r\u0010\u00cd\u0001\u001a\u00020\u0003*\u00020\u0003H\u0002J\u0012\u0010\u00ce\u0001\u001a\u00020\f2\u0007\u0010\u00cf\u0001\u001a\u00020\u0005H\u0002J\u000f\u0010\u00d0\u0001\u001a\u00020\fH\u0000\u00a2\u0006\u0003\b\u00d1\u0001J\u001b\u0010\u00d2\u0001\u001a\u00030\u009a\u00012\u0006\u00101\u001a\u00020\u00052\u0007\u0010\u00d3\u0001\u001a\u00020BH\u0002J\u0013\u0010\u00d4\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u00d3\u0001\u001a\u00020BH\u0002J\u001b\u0010\u00d5\u0001\u001a\u00020\u00032\u0007\u0010\u00d6\u0001\u001a\u00020\f2\u0007\u0010\u00d3\u0001\u001a\u00020BH\u0002J\u0010\u0010\u00d7\u0001\u001a\u00020\u00052\u0007\u0010\u009b\u0001\u001a\u00020\u0003J#\u0010\u00d8\u0001\u001a\u00020\u00032\b\u0010\u00d9\u0001\u001a\u00030\u00da\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u0000\u00a2\u0006\u0003\b\u00db\u0001R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u0010@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R+\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00188@@@X\u0080\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0016R\u001e\u0010$\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0016R\u001a\u0010&\u001a\u00020'X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u001b\"\u0004\b)\u0010\u001dR\u001a\u0010*\u001a\u00020'X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001b\"\u0004\b,\u0010\u001dR\u000e\u0010-\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0016R\u001e\u00104\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0016R\u000e\u00106\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00107\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u000f\"\u0004\b9\u0010:R\u000e\u0010;\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010<\u001a\u0004\u0018\u00010=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00100@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010A\u001a\u00020B8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0014\u0010E\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u0016R\u0014\u0010G\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u0016R\u001a\u0010I\u001a\u00020JX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u0014\u0010O\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010\u0016R\u0014\u0010Q\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010SR\u0014\u0010T\u001a\u00020UX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010WR\u0011\u0010X\u001a\u00020Y8F\u00a2\u0006\u0006\u001a\u0004\bZ\u0010[R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\\\u0010\u0016R+\u0010]\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00038B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\ba\u0010b\u001a\u0004\b^\u0010\u0016\"\u0004\b_\u0010`R+\u0010c\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00038B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\bf\u0010b\u001a\u0004\bd\u0010\u0016\"\u0004\be\u0010`R\u001b\u0010g\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bi\u0010j\u001a\u0004\bh\u0010\u0016R\u001b\u0010k\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bm\u0010j\u001a\u0004\bl\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bn\u0010SR\u0014\u0010o\u001a\u00020pX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bq\u0010rR\u0014\u0010s\u001a\u00020tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bu\u0010vR\u0014\u0010w\u001a\u00020xX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\by\u0010zR1\u0010|\u001a\u0004\u0018\u00010{2\b\u0010\u0017\u001a\u0004\u0018\u00010{8@@BX\u0080\u008e\u0002\u00a2\u0006\u0014\n\u0005\b\u0081\u0001\u0010\u001f\u001a\u0004\b}\u0010~\"\u0005\b\u007f\u0010\u0080\u0001R\u0018\u0010\u0082\u0001\u001a\u00030\u0083\u0001X\u0080\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0084\u0001\u0010\u0085\u0001R!\u0010\u0086\u0001\u001a\u00030\u0087\u0001X\u0080\u000e\u00a2\u0006\u0013\n\u0003\u0010\u008a\u0001\u001a\u0005\b\u0088\u0001\u0010\u001b\"\u0005\b\u0089\u0001\u0010\u001dR\u0018\u0010\u008b\u0001\u001a\u00030\u008c\u0001X\u0080\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u008d\u0001\u0010\u008e\u0001R!\u0010\u008f\u0001\u001a\u00030\u0090\u00018@X\u0080\u0084\u0002\u00a2\u0006\u0010\u001a\u0006\b\u0093\u0001\u0010\u0094\u0001*\u0006\b\u0091\u0001\u0010\u0092\u0001R\u001a\u0010\u0095\u0001\u001a\u00030\u0096\u0001X\u0080\u0004\u00a2\u0006\f\n\u0002\u0010\u001f\u001a\u0006\b\u0097\u0001\u0010\u0098\u0001R\u001a\u0010\u00a5\u0001\u001a\u00030\u0096\u0001X\u0080\u0004\u00a2\u0006\f\n\u0002\u0010\u001f\u001a\u0006\b\u00a6\u0001\u0010\u0098\u0001R\u0016\u0010\u00b8\u0001\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u00b8\u0001\u0010\u000fR/\u0010\u00b9\u0001\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f8F@BX\u0086\u008e\u0002\u00a2\u0006\u0015\n\u0005\b\u00bc\u0001\u0010\u001f\u001a\u0005\b\u00ba\u0001\u0010\u000f\"\u0005\b\u00bb\u0001\u0010:R/\u0010\u00bd\u0001\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f8F@BX\u0086\u008e\u0002\u00a2\u0006\u0015\n\u0005\b\u00c0\u0001\u0010\u001f\u001a\u0005\b\u00be\u0001\u0010\u000f\"\u0005\b\u00bf\u0001\u0010:R\u0015\u0010\u00c1\u0001\u001a\b\u0012\u0004\u0012\u00020\f0@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u00c2\u0001\u001a\b\u0012\u0004\u0012\u00020\f0@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u00c3\u0001\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u00c4\u0001\u0010\u000fR\u0016\u0010\u00c5\u0001\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u00c6\u0001\u0010\u000f\u00a8\u0006\u00dc\u0001"}, d2={"Landroidx/compose/foundation/pager/PagerState;", "Landroidx/compose/foundation/gestures/ScrollableState;", "currentPage", "", "currentPageOffsetFraction", "", "prefetchScheduler", "Landroidx/compose/foundation/lazy/layout/PrefetchScheduler;", "<init>", "(IFLandroidx/compose/foundation/lazy/layout/PrefetchScheduler;)V", "(IF)V", "value", "", "hasLookaheadOccurred", "getHasLookaheadOccurred$foundation", "()Z", "Landroidx/compose/foundation/pager/PagerMeasureResult;", "approachLayoutInfo", "getApproachLayoutInfo$foundation", "()Landroidx/compose/foundation/pager/PagerMeasureResult;", "pageCount", "getPageCount", "()I", "<set-?>", "Landroidx/compose/ui/geometry/Offset;", "upDownDifference", "getUpDownDifference-F1C5BW0$foundation", "()J", "setUpDownDifference-k-4lQ0M$foundation", "(J)V", "upDownDifference$delegate", "Landroidx/compose/runtime/MutableState;", "scrollPosition", "Landroidx/compose/foundation/pager/PagerScrollPosition;", "firstVisiblePage", "getFirstVisiblePage$foundation", "firstVisiblePageOffset", "getFirstVisiblePageOffset$foundation", "maxScrollOffset", "", "getMaxScrollOffset$foundation", "setMaxScrollOffset$foundation", "minScrollOffset", "getMinScrollOffset$foundation", "setMinScrollOffset$foundation", "accumulator", "previousPassDelta", "scrollableState", "performScroll", "delta", "numMeasurePasses", "getNumMeasurePasses$foundation", "layoutWithMeasurement", "getLayoutWithMeasurement$foundation", "layoutWithoutMeasurement", "prefetchingEnabled", "getPrefetchingEnabled$foundation", "setPrefetchingEnabled$foundation", "(Z)V", "indexToPrefetch", "currentPrefetchHandle", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState$PrefetchHandle;", "wasPrefetchingForward", "pagerLayoutInfoState", "Landroidx/compose/runtime/MutableState;", "layoutInfo", "Landroidx/compose/foundation/pager/PagerLayoutInfo;", "getLayoutInfo", "()Landroidx/compose/foundation/pager/PagerLayoutInfo;", "pageSpacing", "getPageSpacing$foundation", "pageSize", "getPageSize$foundation", "density", "Landroidx/compose/ui/unit/Density;", "getDensity$foundation", "()Landroidx/compose/ui/unit/Density;", "setDensity$foundation", "(Landroidx/compose/ui/unit/Density;)V", "pageSizeWithSpacing", "getPageSizeWithSpacing$foundation", "positionThresholdFraction", "getPositionThresholdFraction$foundation", "()F", "internalInteractionSource", "Landroidx/compose/foundation/interaction/MutableInteractionSource;", "getInternalInteractionSource$foundation", "()Landroidx/compose/foundation/interaction/MutableInteractionSource;", "interactionSource", "Landroidx/compose/foundation/interaction/InteractionSource;", "getInteractionSource", "()Landroidx/compose/foundation/interaction/InteractionSource;", "getCurrentPage", "programmaticScrollTargetPage", "getProgrammaticScrollTargetPage", "setProgrammaticScrollTargetPage", "(I)V", "programmaticScrollTargetPage$delegate", "Landroidx/compose/runtime/MutableIntState;", "settledPageState", "getSettledPageState", "setSettledPageState", "settledPageState$delegate", "settledPage", "getSettledPage", "settledPage$delegate", "Landroidx/compose/runtime/State;", "targetPage", "getTargetPage", "targetPage$delegate", "getCurrentPageOffsetFraction", "prefetchState", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState;", "getPrefetchState$foundation", "()Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState;", "beyondBoundsInfo", "Landroidx/compose/foundation/lazy/layout/LazyLayoutBeyondBoundsInfo;", "getBeyondBoundsInfo$foundation", "()Landroidx/compose/foundation/lazy/layout/LazyLayoutBeyondBoundsInfo;", "awaitLayoutModifier", "Landroidx/compose/foundation/lazy/layout/AwaitFirstLayoutModifier;", "getAwaitLayoutModifier$foundation", "()Landroidx/compose/foundation/lazy/layout/AwaitFirstLayoutModifier;", "Landroidx/compose/ui/layout/Remeasurement;", "remeasurement", "getRemeasurement$foundation", "()Landroidx/compose/ui/layout/Remeasurement;", "setRemeasurement", "(Landroidx/compose/ui/layout/Remeasurement;)V", "remeasurement$delegate", "remeasurementModifier", "Landroidx/compose/ui/layout/RemeasurementModifier;", "getRemeasurementModifier$foundation", "()Landroidx/compose/ui/layout/RemeasurementModifier;", "premeasureConstraints", "Landroidx/compose/ui/unit/Constraints;", "getPremeasureConstraints-msEJaDk$foundation", "setPremeasureConstraints-BRTryo0$foundation", "J", "pinnedPages", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPinnedItemList;", "getPinnedPages$foundation", "()Landroidx/compose/foundation/lazy/layout/LazyLayoutPinnedItemList;", "nearestRange", "Lkotlin/ranges/IntRange;", "getNearestRange$foundation$delegate", "(Landroidx/compose/foundation/pager/PagerState;)Ljava/lang/Object;", "getNearestRange$foundation", "()Lkotlin/ranges/IntRange;", "placementScopeInvalidator", "Landroidx/compose/foundation/lazy/layout/ObservableScopeInvalidator;", "getPlacementScopeInvalidator-zYiylxw$foundation", "()Landroidx/compose/runtime/MutableState;", "scrollToPage", "", "page", "pageOffsetFraction", "(IFLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateCurrentPage", "Landroidx/compose/foundation/gestures/ScrollScope;", "updateTargetPage", "snapToItem", "offsetFraction", "forceRemeasure", "snapToItem$foundation", "measurementScopeInvalidator", "getMeasurementScopeInvalidator-zYiylxw$foundation", "requestScrollToPage", "animateScrollToPage", "animationSpec", "Landroidx/compose/animation/core/AnimationSpec;", "(IFLandroidx/compose/animation/core/AnimationSpec;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awaitScrollDependencies", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "scroll", "scrollPriority", "Landroidx/compose/foundation/MutatePriority;", "block", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Landroidx/compose/foundation/MutatePriority;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispatchRawDelta", "isScrollInProgress", "canScrollForward", "getCanScrollForward", "setCanScrollForward", "canScrollForward$delegate", "canScrollBackward", "getCanScrollBackward", "setCanScrollBackward", "canScrollBackward$delegate", "isLastScrollForwardState", "isLastScrollBackwardState", "lastScrolledForward", "getLastScrolledForward", "lastScrolledBackward", "getLastScrolledBackward", "applyMeasureResult", "result", "isLookingAhead", "visibleItemsStayedTheSame", "applyMeasureResult$foundation", "tryRunPrefetch", "coerceInPageRange", "isGestureActionMatchesScroll", "scrollDelta", "isNotGestureAction", "isNotGestureAction$foundation", "notifyPrefetch", "info", "cancelPrefetchIfVisibleItemsChanged", "calculatePrefetchIndex", "forward", "getOffsetDistanceInPages", "matchScrollPositionWithKey", "itemProvider", "Landroidx/compose/foundation/pager/PagerLazyLayoutItemProvider;", "matchScrollPositionWithKey$foundation", "foundation"})
@Stable
@SourceDebugExtension(value={"SMAP\nPagerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagerState.kt\nandroidx/compose/foundation/pager/PagerState\n+ 2 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n+ 3 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 4 PagerState.kt\nandroidx/compose/foundation/pager/PagerStateKt\n+ 5 SnapshotIntState.kt\nandroidx/compose/runtime/SnapshotIntStateKt__SnapshotIntStateKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 Snapshot.kt\nandroidx/compose/runtime/snapshots/Snapshot$Companion\n+ 8 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 9 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 10 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,999:1\n97#2,4:1000\n97#2,4:1031\n97#2,4:1072\n85#3:1004\n117#3,2:1005\n85#3:1025\n85#3:1026\n85#3:1027\n117#3,2:1028\n85#3:1030\n85#3:1035\n117#3,2:1036\n85#3:1038\n117#3,2:1039\n902#4,4:1007\n902#4,4:1011\n902#4,4:1015\n902#4,4:1041\n902#4,4:1045\n902#4,4:1050\n78#5:1019\n111#5,2:1020\n78#5:1022\n111#5,2:1023\n1#6:1049\n604#7,7:1054\n604#7,7:1076\n604#7,7:1083\n69#8:1061\n65#8:1064\n65#8:1067\n69#8:1070\n70#9:1062\n60#9:1065\n60#9:1068\n70#9:1071\n22#10:1063\n22#10:1066\n22#10:1069\n*S KotlinDebug\n*F\n+ 1 PagerState.kt\nandroidx/compose/foundation/pager/PagerState\n*L\n180#1:1000,4\n613#1:1031,4\n834#1:1072,4\n187#1:1004\n187#1:1005,2\n400#1:1025\n418#1:1026\n473#1:1027\n473#1:1028,2\n490#1:1030\n654#1:1035\n654#1:1036,2\n657#1:1038\n657#1:1039,2\n221#1:1007,4\n278#1:1011,4\n288#1:1015,4\n682#1:1041,4\n686#1:1045,4\n704#1:1050,4\n386#1:1019\n386#1:1020,2\n388#1:1022\n388#1:1023,2\n711#1:1054,7\n847#1:1076,7\n458#1:1083,7\n731#1:1061\n733#1:1064\n737#1:1067\n737#1:1070\n731#1:1062\n733#1:1065\n737#1:1068\n737#1:1071\n731#1:1063\n733#1:1066\n737#1:1069\n*E\n"})
public abstract class PagerState
implements ScrollableState {
    private boolean hasLookaheadOccurred;
    @Nullable
    private PagerMeasureResult approachLayoutInfo;
    @NotNull
    private final MutableState upDownDifference$delegate;
    @NotNull
    private final PagerScrollPosition scrollPosition;
    private int firstVisiblePage;
    private int firstVisiblePageOffset;
    private long maxScrollOffset;
    private long minScrollOffset;
    private float accumulator;
    private float previousPassDelta;
    @NotNull
    private final ScrollableState scrollableState;
    private int layoutWithMeasurement;
    private int layoutWithoutMeasurement;
    private boolean prefetchingEnabled;
    private int indexToPrefetch;
    @Nullable
    private LazyLayoutPrefetchState.PrefetchHandle currentPrefetchHandle;
    private boolean wasPrefetchingForward;
    @NotNull
    private MutableState<PagerMeasureResult> pagerLayoutInfoState;
    @NotNull
    private Density density;
    @NotNull
    private final MutableInteractionSource internalInteractionSource;
    @NotNull
    private final MutableIntState programmaticScrollTargetPage$delegate;
    @NotNull
    private final MutableIntState settledPageState$delegate;
    @NotNull
    private final State settledPage$delegate;
    @NotNull
    private final State targetPage$delegate;
    @NotNull
    private final LazyLayoutPrefetchState prefetchState;
    @NotNull
    private final LazyLayoutBeyondBoundsInfo beyondBoundsInfo;
    @NotNull
    private final AwaitFirstLayoutModifier awaitLayoutModifier;
    @NotNull
    private final MutableState remeasurement$delegate;
    @NotNull
    private final RemeasurementModifier remeasurementModifier;
    private long premeasureConstraints;
    @NotNull
    private final LazyLayoutPinnedItemList pinnedPages;
    @NotNull
    private final MutableState<Unit> placementScopeInvalidator;
    @NotNull
    private final MutableState<Unit> measurementScopeInvalidator;
    @NotNull
    private final MutableState canScrollForward$delegate;
    @NotNull
    private final MutableState canScrollBackward$delegate;
    @NotNull
    private final MutableState<Boolean> isLastScrollForwardState;
    @NotNull
    private final MutableState<Boolean> isLastScrollBackwardState;
    public static final int $stable;

    public PagerState(int currentPage, @FloatRange(from=-0.5, to=0.5) float currentPageOffsetFraction, @Nullable PrefetchScheduler prefetchScheduler) {
        double d = currentPageOffsetFraction;
        boolean value$iv = -0.5 <= d ? d <= 0.5 : false;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("currentPageOffsetFraction " + currentPageOffsetFraction + " is not within the range -0.5 to 0.5");
        }
        this.upDownDifference$delegate = SnapshotStateKt.mutableStateOf$default((Object)Offset.box-impl(Offset.Companion.getZero-F1C5BW0()), null, (int)2, null);
        this.scrollPosition = new PagerScrollPosition(currentPage, currentPageOffsetFraction, this);
        this.firstVisiblePage = currentPage;
        this.maxScrollOffset = Long.MAX_VALUE;
        this.scrollableState = ScrollableStateKt.ScrollableState((Function1<? super Float, Float>)((Function1)arg_0 -> PagerState.scrollableState$lambda$1(this, arg_0)));
        this.prefetchingEnabled = true;
        this.indexToPrefetch = -1;
        this.pagerLayoutInfoState = SnapshotStateKt.mutableStateOf((Object)PagerStateKt.getEmptyLayoutInfo(), (SnapshotMutationPolicy)SnapshotStateKt.neverEqualPolicy());
        this.density = PagerStateKt.access$getUnitDensity$p();
        this.internalInteractionSource = InteractionSourceKt.MutableInteractionSource();
        this.programmaticScrollTargetPage$delegate = SnapshotIntStateKt.mutableIntStateOf((int)-1);
        this.settledPageState$delegate = SnapshotIntStateKt.mutableIntStateOf((int)currentPage);
        this.settledPage$delegate = SnapshotStateKt.derivedStateOf((SnapshotMutationPolicy)SnapshotStateKt.structuralEqualityPolicy(), () -> PagerState.settledPage_delegate$lambda$6(this));
        this.targetPage$delegate = SnapshotStateKt.derivedStateOf((SnapshotMutationPolicy)SnapshotStateKt.structuralEqualityPolicy(), () -> PagerState.targetPage_delegate$lambda$7(this));
        this.prefetchState = new LazyLayoutPrefetchState(prefetchScheduler, (Function1<? super NestedPrefetchScope, Unit>)((Function1)arg_0 -> PagerState.prefetchState$lambda$9(this, arg_0)));
        this.beyondBoundsInfo = new LazyLayoutBeyondBoundsInfo();
        this.awaitLayoutModifier = new AwaitFirstLayoutModifier();
        this.remeasurement$delegate = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
        this.remeasurementModifier = new RemeasurementModifier(this){
            final /* synthetic */ PagerState this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRemeasurementAvailable(Remeasurement remeasurement) {
                Intrinsics.checkNotNullParameter((Object)remeasurement, (String)"remeasurement");
                PagerState.access$setRemeasurement(this.this$0, remeasurement);
            }
        };
        this.premeasureConstraints = ConstraintsKt.Constraints$default(0, 0, 0, 0, 15, null);
        this.pinnedPages = new LazyLayoutPinnedItemList();
        this.scrollPosition.getNearestRangeState();
        this.placementScopeInvalidator = ObservableScopeInvalidator.constructor-impl$default(null, 1, null);
        this.measurementScopeInvalidator = ObservableScopeInvalidator.constructor-impl$default(null, 1, null);
        this.canScrollForward$delegate = SnapshotStateKt.mutableStateOf$default((Object)false, null, (int)2, null);
        this.canScrollBackward$delegate = SnapshotStateKt.mutableStateOf$default((Object)false, null, (int)2, null);
        this.isLastScrollForwardState = SnapshotStateKt.mutableStateOf$default((Object)false, null, (int)2, null);
        this.isLastScrollBackwardState = SnapshotStateKt.mutableStateOf$default((Object)false, null, (int)2, null);
    }

    public /* synthetic */ PagerState(int n, float f, PrefetchScheduler prefetchScheduler, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            f = 0.0f;
        }
        if ((n2 & 4) != 0) {
            prefetchScheduler = null;
        }
        this(n, f, prefetchScheduler);
    }

    public PagerState(int currentPage, @FloatRange(from=-0.5, to=0.5) float currentPageOffsetFraction) {
        this(currentPage, currentPageOffsetFraction, null);
    }

    public /* synthetic */ PagerState(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            f = 0.0f;
        }
        this(n, f);
    }

    public final boolean getHasLookaheadOccurred$foundation() {
        return this.hasLookaheadOccurred;
    }

    @Nullable
    public final PagerMeasureResult getApproachLayoutInfo$foundation() {
        return this.approachLayoutInfo;
    }

    public abstract int getPageCount();

    /*
     * WARNING - void declaration
     */
    public final long getUpDownDifference-F1C5BW0$foundation() {
        void $this$getValue$iv;
        State state = (State)this.upDownDifference$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Offset)$this$getValue$iv.getValue()).unbox-impl();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUpDownDifference-k-4lQ0M$foundation(long l) {
        void $this$setValue$iv;
        MutableState mutableState = this.upDownDifference$delegate;
        Object var4_3 = null;
        Offset value$iv = Offset.box-impl(l);
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    public final int getFirstVisiblePage$foundation() {
        return this.firstVisiblePage;
    }

    public final int getFirstVisiblePageOffset$foundation() {
        return this.firstVisiblePageOffset;
    }

    public final long getMaxScrollOffset$foundation() {
        return this.maxScrollOffset;
    }

    public final void setMaxScrollOffset$foundation(long l) {
        this.maxScrollOffset = l;
    }

    public final long getMinScrollOffset$foundation() {
        return this.minScrollOffset;
    }

    public final void setMinScrollOffset$foundation(long l) {
        this.minScrollOffset = l;
    }

    private final float performScroll(float delta) {
        PagerMeasureResult scrolledLayoutInfo;
        long currentScrollPosition = PagerScrollPositionKt.currentAbsoluteScrollOffset(this);
        boolean $i$f$debugLog = false;
        float decimalAccumulation = delta + this.accumulator;
        long decimalAccumulationInt = MathKt.roundToLong((float)decimalAccumulation);
        this.accumulator = decimalAccumulation - (float)decimalAccumulationInt;
        if (Math.abs(delta) < 1.0E-4f) {
            return delta;
        }
        long updatedScrollPosition = currentScrollPosition + decimalAccumulationInt;
        long coercedScrollPosition = RangesKt.coerceIn((long)updatedScrollPosition, (long)this.minScrollOffset, (long)this.maxScrollOffset);
        boolean changed = updatedScrollPosition != coercedScrollPosition;
        long scrollDelta = coercedScrollPosition - currentScrollPosition;
        this.previousPassDelta = scrollDelta;
        if (Math.abs(scrollDelta) != 0L) {
            this.isLastScrollForwardState.setValue((Object)((float)scrollDelta > 0.0f ? 1 : 0));
            this.isLastScrollBackwardState.setValue((Object)((float)scrollDelta < 0.0f ? 1 : 0));
        }
        if ((scrolledLayoutInfo = ((PagerMeasureResult)this.pagerLayoutInfoState.getValue()).copyWithScrollDeltaWithoutRemeasure(-((int)scrollDelta))) != null && this.approachLayoutInfo != null) {
            PagerMeasureResult scrolledApproachLayoutInfo;
            PagerMeasureResult pagerMeasureResult = this.approachLayoutInfo;
            PagerMeasureResult pagerMeasureResult2 = scrolledApproachLayoutInfo = pagerMeasureResult != null ? pagerMeasureResult.copyWithScrollDeltaWithoutRemeasure(-((int)scrollDelta)) : null;
            if (scrolledApproachLayoutInfo != null) {
                this.approachLayoutInfo = scrolledApproachLayoutInfo;
            } else {
                scrolledLayoutInfo = null;
            }
        }
        if (scrolledLayoutInfo != null) {
            int $i$f$debugLog2 = 0;
            this.applyMeasureResult$foundation(scrolledLayoutInfo, this.hasLookaheadOccurred, true);
            ObservableScopeInvalidator.invalidateScope-impl(this.placementScopeInvalidator);
            $i$f$debugLog2 = this.layoutWithoutMeasurement;
            this.layoutWithoutMeasurement = $i$f$debugLog2 + 1;
        } else {
            boolean $i$f$debugLog3 = false;
            this.scrollPosition.applyScrollDelta((int)scrollDelta);
            Remeasurement remeasurement = this.getRemeasurement$foundation();
            if (remeasurement != null) {
                remeasurement.forceRemeasure();
            }
            int n = this.layoutWithMeasurement;
            this.layoutWithMeasurement = n + 1;
        }
        return ((Number)(changed ? (Number)scrollDelta : (Number)Float.valueOf(delta))).floatValue();
    }

    public final int getNumMeasurePasses$foundation() {
        return this.layoutWithMeasurement + this.layoutWithoutMeasurement;
    }

    public final int getLayoutWithMeasurement$foundation() {
        return this.layoutWithMeasurement;
    }

    public final boolean getPrefetchingEnabled$foundation() {
        return this.prefetchingEnabled;
    }

    public final void setPrefetchingEnabled$foundation(boolean bl) {
        this.prefetchingEnabled = bl;
    }

    @NotNull
    public final PagerLayoutInfo getLayoutInfo() {
        return (PagerLayoutInfo)this.pagerLayoutInfoState.getValue();
    }

    public final int getPageSpacing$foundation() {
        return ((PagerMeasureResult)this.pagerLayoutInfoState.getValue()).getPageSpacing();
    }

    public final int getPageSize$foundation() {
        return ((PagerMeasureResult)this.pagerLayoutInfoState.getValue()).getPageSize();
    }

    @NotNull
    public final Density getDensity$foundation() {
        return this.density;
    }

    public final void setDensity$foundation(@NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"<set-?>");
        this.density = density;
    }

    public final int getPageSizeWithSpacing$foundation() {
        return this.getPageSize$foundation() + this.getPageSpacing$foundation();
    }

    public final float getPositionThresholdFraction$foundation() {
        Density $this$_get_positionThresholdFraction__u24lambda_u245 = this.density;
        boolean bl = false;
        float minThreshold = Math.min($this$_get_positionThresholdFraction__u24lambda_u245.toPx-0680j_4(PagerStateKt.getDefaultPositionThreshold()), (float)this.getPageSize$foundation() / 2.0f);
        return minThreshold / (float)this.getPageSize$foundation();
    }

    @NotNull
    public final MutableInteractionSource getInternalInteractionSource$foundation() {
        return this.internalInteractionSource;
    }

    @NotNull
    public final InteractionSource getInteractionSource() {
        return this.internalInteractionSource;
    }

    public final int getCurrentPage() {
        return this.scrollPosition.getCurrentPage();
    }

    /*
     * WARNING - void declaration
     */
    private final int getProgrammaticScrollTargetPage() {
        void $this$getValue$iv;
        IntState intState = (IntState)this.programmaticScrollTargetPage$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getIntValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setProgrammaticScrollTargetPage(int n) {
        void $this$setValue$iv;
        MutableIntState mutableIntState = this.programmaticScrollTargetPage$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setIntValue(n);
    }

    /*
     * WARNING - void declaration
     */
    private final int getSettledPageState() {
        void $this$getValue$iv;
        IntState intState = (IntState)this.settledPageState$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getIntValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setSettledPageState(int n) {
        void $this$setValue$iv;
        MutableIntState mutableIntState = this.settledPageState$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setIntValue(n);
    }

    /*
     * WARNING - void declaration
     */
    public final int getSettledPage() {
        void $this$getValue$iv;
        State state = this.settledPage$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).intValue();
    }

    /*
     * WARNING - void declaration
     */
    public final int getTargetPage() {
        void $this$getValue$iv;
        State state = this.targetPage$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).intValue();
    }

    public final float getCurrentPageOffsetFraction() {
        return this.scrollPosition.getCurrentPageOffsetFraction();
    }

    @NotNull
    public final LazyLayoutPrefetchState getPrefetchState$foundation() {
        return this.prefetchState;
    }

    @NotNull
    public final LazyLayoutBeyondBoundsInfo getBeyondBoundsInfo$foundation() {
        return this.beyondBoundsInfo;
    }

    @NotNull
    public final AwaitFirstLayoutModifier getAwaitLayoutModifier$foundation() {
        return this.awaitLayoutModifier;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Remeasurement getRemeasurement$foundation() {
        void $this$getValue$iv;
        State state = (State)this.remeasurement$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Remeasurement)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setRemeasurement(Remeasurement remeasurement) {
        void $this$setValue$iv;
        MutableState mutableState = this.remeasurement$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)remeasurement);
    }

    @NotNull
    public final RemeasurementModifier getRemeasurementModifier$foundation() {
        return this.remeasurementModifier;
    }

    public final long getPremeasureConstraints-msEJaDk$foundation() {
        return this.premeasureConstraints;
    }

    public final void setPremeasureConstraints-BRTryo0$foundation(long l) {
        this.premeasureConstraints = l;
    }

    @NotNull
    public final LazyLayoutPinnedItemList getPinnedPages$foundation() {
        return this.pinnedPages;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IntRange getNearestRange$foundation() {
        void $this$getValue$iv;
        State state = this.scrollPosition.getNearestRangeState();
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (IntRange)$this$getValue$iv.getValue();
    }

    private static Object getNearestRange$foundation$delegate(PagerState pagerState) {
        return pagerState.scrollPosition.getNearestRangeState();
    }

    @NotNull
    public final MutableState<Unit> getPlacementScopeInvalidator-zYiylxw$foundation() {
        return this.placementScopeInvalidator;
    }

    @Nullable
    public final Object scrollToPage(int page, @FloatRange(from=-0.5, to=0.5) float pageOffsetFraction, @NotNull Continuation<? super Unit> $completion) {
        Object object = ScrollableState.scroll$default(this, null, (Function2)new Function2<ScrollScope, Continuation<? super Unit>, Object>(this, pageOffsetFraction, page, null){
            int label;
            final /* synthetic */ PagerState this$0;
            final /* synthetic */ float $pageOffsetFraction;
            final /* synthetic */ int $page;
            {
                this.this$0 = $receiver;
                this.$pageOffsetFraction = $pageOffsetFraction;
                this.$page = $page;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $i$f$debugLog = false;
                        this.label = 1;
                        v0 = PagerState.access$awaitScrollDependencies(this.this$0, (Continuation)this);
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        var2_5 = -0.5 <= (var2_4 = (double)this.$pageOffsetFraction) ? var2_4 <= 0.5 : false;
                        var3_6 = this.$pageOffsetFraction;
                        $i$f$requirePrecondition = false;
                        if (value$iv == false) {
                            $i$a$-requirePrecondition-PagerState$scrollToPage$2$2 = false;
                            InlineClassHelperKt.throwIllegalArgumentException("pageOffsetFraction " + var3_6 + " is not within the range -0.5 to 0.5");
                        }
                        targetPage = PagerState.access$coerceInPageRange(this.this$0, this.$page);
                        this.this$0.snapToItem$foundation(targetPage, this.$pageOffsetFraction, true);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(ScrollScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion, 1, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object scrollToPage$default(PagerState pagerState, int n, float f, Continuation continuation, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: scrollToPage");
        }
        if ((n2 & 2) != 0) {
            f = 0.0f;
        }
        return pagerState.scrollToPage(n, f, (Continuation<? super Unit>)continuation);
    }

    public final void updateCurrentPage(@NotNull ScrollScope $this$updateCurrentPage, int page, @FloatRange(from=-0.5, to=0.5) float pageOffsetFraction) {
        Intrinsics.checkNotNullParameter((Object)$this$updateCurrentPage, (String)"<this>");
        this.snapToItem$foundation(page, pageOffsetFraction, true);
    }

    public static /* synthetic */ void updateCurrentPage$default(PagerState pagerState, ScrollScope scrollScope2, int n, float f, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateCurrentPage");
        }
        if ((n2 & 2) != 0) {
            f = 0.0f;
        }
        pagerState.updateCurrentPage(scrollScope2, n, f);
    }

    public final void updateTargetPage(@NotNull ScrollScope $this$updateTargetPage, int targetPage) {
        Intrinsics.checkNotNullParameter((Object)$this$updateTargetPage, (String)"<this>");
        this.setProgrammaticScrollTargetPage(this.coerceInPageRange(targetPage));
    }

    public final void snapToItem$foundation(int page, float offsetFraction, boolean forceRemeasure) {
        this.scrollPosition.requestPositionAndForgetLastKnownKey(page, offsetFraction);
        if (forceRemeasure) {
            Remeasurement remeasurement = this.getRemeasurement$foundation();
            if (remeasurement != null) {
                remeasurement.forceRemeasure();
            }
        } else {
            ObservableScopeInvalidator.invalidateScope-impl(this.measurementScopeInvalidator);
        }
    }

    @NotNull
    public final MutableState<Unit> getMeasurementScopeInvalidator-zYiylxw$foundation() {
        return this.measurementScopeInvalidator;
    }

    public final void requestScrollToPage(@androidx.annotation.IntRange(from=0L) int page, @FloatRange(from=-0.5, to=0.5) float pageOffsetFraction) {
        if (this.isScrollInProgress()) {
            BuildersKt.launch$default((CoroutineScope)((PagerMeasureResult)this.pagerLayoutInfoState.getValue()).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ PagerState this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = ScrollExtensionsKt.stopScroll$default(this.this$0, null, (Continuation)this, 1, null);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        this.snapToItem$foundation(page, pageOffsetFraction, false);
    }

    public static /* synthetic */ void requestScrollToPage$default(PagerState pagerState, int n, float f, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: requestScrollToPage");
        }
        if ((n2 & 2) != 0) {
            f = 0.0f;
        }
        pagerState.requestScrollToPage(n, f);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object animateScrollToPage(int var1_1, @FloatRange(from=-0.5, to=0.5) float var2_2, @NotNull AnimationSpec<Float> var3_3, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof animateScrollToPage.1)) ** GOTO lbl-1000
        var9_5 = $completion;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                int I$0;
                float F$0;
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ PagerState this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.animateScrollToPage(0, 0.0f, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (page == this.getCurrentPage() && this.getCurrentPageOffsetFraction() == pageOffsetFraction || this.getPageCount() == 0) {
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = animationSpec;
                $continuation.I$0 = page;
                $continuation.F$0 = pageOffsetFraction;
                $continuation.label = 1;
                v0 = this.awaitScrollDependencies((Continuation<? super Unit>)$continuation);
                if (v0 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl28
            }
            case 1: {
                pageOffsetFraction = $continuation.F$0;
                page = $continuation.I$0;
                animationSpec = (AnimationSpec)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                value$iv = -0.5 <= (var5_8 = (double)pageOffsetFraction) ? var5_8 <= 0.5 : false;
                $i$f$requirePrecondition = false;
                if (!value$iv) {
                    $i$a$-requirePrecondition-PagerState$animateScrollToPage$2 = false;
                    InlineClassHelperKt.throwIllegalArgumentException("pageOffsetFraction " + pageOffsetFraction + " is not within the range -0.5 to 0.5");
                }
                targetPage = this.coerceInPageRange(page);
                targetPageOffsetToSnappedPosition = pageOffsetFraction * (float)this.getPageSizeWithSpacing$foundation();
                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = ScrollableState.scroll$default(this, null, (Function2)new Function2<ScrollScope, Continuation<? super Unit>, Object>(this, targetPage, targetPageOffsetToSnappedPosition, (AnimationSpec<Float>)animationSpec, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ PagerState this$0;
                    final /* synthetic */ int $targetPage;
                    final /* synthetic */ float $targetPageOffsetToSnappedPosition;
                    final /* synthetic */ AnimationSpec<Float> $animationSpec;
                    {
                        this.this$0 = $receiver;
                        this.$targetPage = $targetPage;
                        this.$targetPageOffsetToSnappedPosition = $targetPageOffsetToSnappedPosition;
                        this.$animationSpec = $animationSpec;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                ScrollScope $this$scroll = (ScrollScope)this.L$0;
                                this.label = 1;
                                Object object3 = PagerStateKt.access$animateScrollToPage(PagerScrollScopeKt.LazyLayoutScrollScope(this.this$0, $this$scroll), this.$targetPage, this.$targetPageOffsetToSnappedPosition, this.$animationSpec, (arg_0, arg_1) -> animateScrollToPage.3.invokeSuspend$lambda$0(this.this$0, arg_0, arg_1), (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(ScrollScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$0(PagerState this$0, ScrollScope $this$animateScrollToPage, int it) {
                        this$0.updateTargetPage($this$animateScrollToPage, it);
                        return Unit.INSTANCE;
                    }
                }, (Continuation)$continuation, 1, null);
                if (v1 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl45
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl45:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object animateScrollToPage$default(PagerState pagerState, int n, float f, AnimationSpec animationSpec2, Continuation continuation, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: animateScrollToPage");
        }
        if ((n2 & 2) != 0) {
            f = 0.0f;
        }
        if ((n2 & 4) != 0) {
            animationSpec2 = AnimationSpecKt.spring$default(0.0f, 0.0f, null, 7, null);
        }
        return pagerState.animateScrollToPage(n, f, animationSpec2, (Continuation<? super Unit>)continuation);
    }

    private final Object awaitScrollDependencies(Continuation<? super Unit> $completion) {
        Object object = this.awaitLayoutModifier.waitForFirstLayout($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object scroll(@NotNull MutatePriority scrollPriority, @NotNull Function2<? super ScrollScope, ? super Continuation<? super Unit>, ? extends Object> block, @NotNull Continuation<? super Unit> $completion) {
        return PagerState.scroll$suspendImpl(this, scrollPriority, block, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object scroll$suspendImpl(PagerState var0, MutatePriority var1_1, Function2<? super ScrollScope, ? super Continuation<? super Unit>, ? extends Object> var2_2, Continuation<? super Unit> $completion) {
        if (!($completion instanceof scroll.1)) ** GOTO lbl-1000
        var5_4 = $completion;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ PagerState this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PagerState.scroll$suspendImpl(this.this$0, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $this;
                $continuation.L$1 = scrollPriority;
                $continuation.L$2 = block;
                $continuation.label = 1;
                v0 = $this.awaitScrollDependencies((Continuation<? super Unit>)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                block = (Function2)$continuation.L$2;
                scrollPriority = (MutatePriority)$continuation.L$1;
                $this = (PagerState)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                if (!$this.isScrollInProgress()) {
                    $this.setSettledPageState($this.getCurrentPage());
                }
                $continuation.L$0 = $this;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v1 = $this.scrollableState.scroll(scrollPriority, (Function2<? super ScrollScope, ? super Continuation<? super Unit>, ? extends Object>)block, (Continuation<? super Unit>)$continuation);
                if (v1 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl40
            }
            case 2: {
                $this = (PagerState)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl40:
                // 2 sources

                $this.setProgrammaticScrollTargetPage(-1);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public float dispatchRawDelta(float delta) {
        return this.scrollableState.dispatchRawDelta(delta);
    }

    @Override
    public boolean isScrollInProgress() {
        return this.scrollableState.isScrollInProgress();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean getCanScrollForward() {
        void $this$getValue$iv;
        State state = (State)this.canScrollForward$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setCanScrollForward(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = this.canScrollForward$delegate;
        Object var3_3 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean getCanScrollBackward() {
        void $this$getValue$iv;
        State state = (State)this.canScrollBackward$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setCanScrollBackward(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = this.canScrollBackward$delegate;
        Object var3_3 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    @Override
    public boolean getLastScrolledForward() {
        return (Boolean)this.isLastScrollForwardState.getValue();
    }

    @Override
    public boolean getLastScrolledBackward() {
        return (Boolean)this.isLastScrollBackwardState.getValue();
    }

    public final void applyMeasureResult$foundation(@NotNull PagerMeasureResult result2, boolean isLookingAhead, boolean visibleItemsStayedTheSame) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.prefetchState.setIdealNestedPrefetchCount$foundation(result2.getVisiblePagesInfo().size());
        if (!isLookingAhead && this.hasLookaheadOccurred) {
            boolean $i$f$debugLog = false;
            this.approachLayoutInfo = result2;
        } else {
            boolean $i$f$debugLog = false;
            if (isLookingAhead) {
                this.hasLookaheadOccurred = true;
            }
            if (visibleItemsStayedTheSame) {
                this.scrollPosition.updateCurrentPageOffsetFraction(result2.getCurrentPageOffsetFraction());
            } else {
                this.scrollPosition.updateFromMeasureResult(result2);
                this.cancelPrefetchIfVisibleItemsChanged(result2);
            }
            this.pagerLayoutInfoState.setValue((Object)result2);
            this.setCanScrollForward(result2.getCanScrollForward());
            this.setCanScrollBackward(result2.getCanScrollBackward());
            MeasuredPage measuredPage = result2.getFirstVisiblePage();
            if (measuredPage != null) {
                MeasuredPage it = measuredPage;
                boolean bl = false;
                this.firstVisiblePage = it.getIndex();
            }
            this.firstVisiblePageOffset = result2.getFirstVisiblePageScrollOffset();
            this.tryRunPrefetch(result2);
            this.maxScrollOffset = PagerStateKt.calculateNewMaxScrollOffset(result2, this.getPageCount());
            this.minScrollOffset = PagerStateKt.access$calculateNewMinScrollOffset(result2, this.getPageCount());
            $i$f$debugLog = false;
        }
    }

    public static /* synthetic */ void applyMeasureResult$foundation$default(PagerState pagerState, PagerMeasureResult pagerMeasureResult, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: applyMeasureResult");
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        pagerState.applyMeasureResult$foundation(pagerMeasureResult, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryRunPrefetch(PagerMeasureResult result2) {
        Snapshot previousSnapshot$iv;
        Snapshot.Companion this_$iv = Snapshot.Companion;
        boolean $i$f$withoutReadObservation = false;
        Snapshot snapshot = previousSnapshot$iv = this_$iv.getCurrentThreadSnapshot();
        Function1 observer$iv = snapshot != null ? snapshot.getReadObserver() : null;
        Snapshot newSnapshot$iv = this_$iv.makeCurrentNonObservable(previousSnapshot$iv);
        try {
            boolean bl = false;
            if (!this.prefetchingEnabled) {
                return;
            }
            if (result2.getBeyondViewportPageCount() >= this.getPageCount()) {
                return;
            }
            if (Math.abs(this.previousPassDelta) <= 0.5f) {
                return;
            }
            if (!this.isGestureActionMatchesScroll(this.previousPassDelta)) {
                return;
            }
            this.notifyPrefetch(this.previousPassDelta, result2);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.restoreNonObservable(previousSnapshot$iv, newSnapshot$iv, observer$iv);
        }
    }

    private final int coerceInPageRange(int $this$coerceInPageRange) {
        return this.getPageCount() > 0 ? RangesKt.coerceIn((int)$this$coerceInPageRange, (int)0, (int)(this.getPageCount() - 1)) : 0;
    }

    private final boolean isGestureActionMatchesScroll(float scrollDelta) {
        boolean bl;
        if (this.getLayoutInfo().getOrientation() == Orientation.Vertical) {
            long arg0$iv = this.getUpDownDifference-F1C5BW0$foundation();
            boolean bl2 = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat2 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            boolean $i$f$floatFromBits = false;
            bl = Math.signum(scrollDelta) == Math.signum(-Float.intBitsToFloat(bits$iv$iv$iv));
        } else {
            long arg0$iv = this.getUpDownDifference-F1C5BW0$foundation();
            boolean bl3 = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            boolean $i$f$floatFromBits = false;
            bl = Math.signum(scrollDelta) == Math.signum(-Float.intBitsToFloat(bits$iv$iv$iv));
        }
        return bl || this.isNotGestureAction$foundation();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isNotGestureAction$foundation() {
        long arg0$iv = this.getUpDownDifference-F1C5BW0$foundation();
        boolean bl = false;
        long value$iv$iv = arg0$iv;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        if ((int)Float.intBitsToFloat(bits$iv$iv$iv) != 0) return false;
        arg0$iv = this.getUpDownDifference-F1C5BW0$foundation();
        boolean bl2 = false;
        value$iv$iv = arg0$iv;
        boolean $i$f$unpackFloat2 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        if ((int)Float.intBitsToFloat(bits$iv$iv$iv) != 0) return false;
        return true;
    }

    private final void notifyPrefetch(float delta, PagerLayoutInfo info) {
        block6: {
            block7: {
                if (!this.prefetchingEnabled) {
                    return;
                }
                if (!(!((Collection)info.getVisiblePagesInfo()).isEmpty())) break block6;
                boolean isPrefetchingForward = delta > 0.0f;
                int indexToPrefetch = this.calculatePrefetchIndex(isPrefetchingForward, info);
                boolean bl = 0 <= indexToPrefetch ? indexToPrefetch < this.getPageCount() : false;
                if (!bl) break block6;
                if (indexToPrefetch != this.indexToPrefetch) {
                    if (this.wasPrefetchingForward != isPrefetchingForward) {
                        LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = this.currentPrefetchHandle;
                        if (prefetchHandle != null) {
                            prefetchHandle.cancel();
                        }
                    }
                    this.wasPrefetchingForward = isPrefetchingForward;
                    this.indexToPrefetch = indexToPrefetch;
                    this.currentPrefetchHandle = LazyLayoutPrefetchState.schedulePrecompositionAndPremeasure-VKLhPVY$default(this.prefetchState, indexToPrefetch, this.premeasureConstraints, null, 4, null);
                }
                if (!isPrefetchingForward) break block7;
                PageInfo lastItem = (PageInfo)CollectionsKt.last(info.getVisiblePagesInfo());
                int pageSize = info.getPageSize() + info.getPageSpacing();
                int distanceToReachNextItem = lastItem.getOffset() + pageSize - info.getViewportEndOffset();
                if (!((float)distanceToReachNextItem < delta)) break block6;
                LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = this.currentPrefetchHandle;
                if (prefetchHandle != null) {
                    prefetchHandle.markAsUrgent();
                }
                break block6;
            }
            PageInfo firstItem = (PageInfo)CollectionsKt.first(info.getVisiblePagesInfo());
            int distanceToReachNextItem = info.getViewportStartOffset() - firstItem.getOffset();
            if (!((float)distanceToReachNextItem < -delta)) break block6;
            LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = this.currentPrefetchHandle;
            if (prefetchHandle != null) {
                prefetchHandle.markAsUrgent();
            }
        }
    }

    private final void cancelPrefetchIfVisibleItemsChanged(PagerLayoutInfo info) {
        int expectedPrefetchIndex;
        if (this.indexToPrefetch != -1 && !((Collection)info.getVisiblePagesInfo()).isEmpty() && this.indexToPrefetch != (expectedPrefetchIndex = this.calculatePrefetchIndex(this.wasPrefetchingForward, info))) {
            this.indexToPrefetch = -1;
            LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = this.currentPrefetchHandle;
            if (prefetchHandle != null) {
                prefetchHandle.cancel();
            }
            this.currentPrefetchHandle = null;
        }
    }

    private final int calculatePrefetchIndex(boolean forward, PagerLayoutInfo info) {
        int offset;
        return forward ? ((offset = info.getBeyondViewportPageCount() + 1) < 0 ? Integer.MAX_VALUE : ((PageInfo)CollectionsKt.last(info.getVisiblePagesInfo())).getIndex() + offset) : ((PageInfo)CollectionsKt.first(info.getVisiblePagesInfo())).getIndex() - info.getBeyondViewportPageCount() - 1;
    }

    public final float getOffsetDistanceInPages(int page) {
        boolean value$iv = 0 <= page ? page <= this.getPageCount() : false;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("page " + page + " is not within the range 0 to " + this.getPageCount());
        }
        return (float)(page - this.getCurrentPage()) - this.getCurrentPageOffsetFraction();
    }

    public final int matchScrollPositionWithKey$foundation(@NotNull PagerLazyLayoutItemProvider itemProvider, int currentPage) {
        Intrinsics.checkNotNullParameter((Object)itemProvider, (String)"itemProvider");
        return this.scrollPosition.matchPageWithKey(itemProvider, currentPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static /* synthetic */ int matchScrollPositionWithKey$foundation$default(PagerState pagerState, PagerLazyLayoutItemProvider pagerLazyLayoutItemProvider, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: matchScrollPositionWithKey");
        }
        if ((n2 & 2) != 0) {
            int n3;
            Snapshot previousSnapshot$iv;
            Snapshot.Companion this_$iv = Snapshot.Companion;
            boolean $i$f$withoutReadObservation = false;
            Snapshot snapshot = previousSnapshot$iv = this_$iv.getCurrentThreadSnapshot();
            Function1 observer$iv = snapshot != null ? snapshot.getReadObserver() : null;
            Snapshot newSnapshot$iv = this_$iv.makeCurrentNonObservable(previousSnapshot$iv);
            try {
                boolean bl = false;
                n3 = pagerState.scrollPosition.getCurrentPage();
            }
            finally {
                this_$iv.restoreNonObservable(previousSnapshot$iv, newSnapshot$iv, observer$iv);
            }
            n = n3;
        }
        return pagerState.matchScrollPositionWithKey$foundation(pagerLazyLayoutItemProvider, n);
    }

    private static final float scrollableState$lambda$1(PagerState this$0, float it) {
        return this$0.performScroll(it);
    }

    private static final int settledPage_delegate$lambda$6(PagerState this$0) {
        return this$0.isScrollInProgress() ? this$0.getSettledPageState() : this$0.getCurrentPage();
    }

    private static final int targetPage_delegate$lambda$7(PagerState this$0) {
        int finalPage = !this$0.isScrollInProgress() ? this$0.getCurrentPage() : (this$0.getProgrammaticScrollTargetPage() != -1 ? this$0.getProgrammaticScrollTargetPage() : (Math.abs(this$0.getCurrentPageOffsetFraction()) >= Math.abs(this$0.getPositionThresholdFraction$foundation()) ? (this$0.getLastScrolledForward() ? this$0.firstVisiblePage + 1 : this$0.firstVisiblePage) : this$0.getCurrentPage()));
        return this$0.coerceInPageRange(finalPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit prefetchState$lambda$9(PagerState this$0, NestedPrefetchScope $this$LazyLayoutPrefetchState) {
        Snapshot previousSnapshot$iv;
        Intrinsics.checkNotNullParameter((Object)$this$LazyLayoutPrefetchState, (String)"$this$LazyLayoutPrefetchState");
        Snapshot.Companion this_$iv = Snapshot.Companion;
        boolean $i$f$withoutReadObservation = false;
        Snapshot snapshot = previousSnapshot$iv = this_$iv.getCurrentThreadSnapshot();
        Function1 observer$iv = snapshot != null ? snapshot.getReadObserver() : null;
        Snapshot newSnapshot$iv = this_$iv.makeCurrentNonObservable(previousSnapshot$iv);
        try {
            boolean bl = false;
            $this$LazyLayoutPrefetchState.schedulePrecomposition(this$0.firstVisiblePage);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.restoreNonObservable(previousSnapshot$iv, newSnapshot$iv, observer$iv);
        }
        return Unit.INSTANCE;
    }

    public PagerState() {
        this(0, 0.0f, null, 7, null);
    }

    public static final /* synthetic */ Object access$awaitScrollDependencies(PagerState $this, Continuation $completion) {
        return $this.awaitScrollDependencies((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ int access$coerceInPageRange(PagerState $this, int $receiver) {
        return $this.coerceInPageRange($receiver);
    }

    public static final /* synthetic */ void access$setRemeasurement(PagerState $this, Remeasurement remeasurement) {
        $this.setRemeasurement(remeasurement);
    }
}

